/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.iit.mservice;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.iit.mservice.api.ITaxFileReviseService;

public class TaxFileReviseServiceImpl
implements ITaxFileReviseService {
    private static final String BTN_SAVEAFTERAUDIT = "saveafteraudit";
    private static final String BTN_SAVE = "save";

    public Map<String, Object> taxFileRevise(Map<String, Object> params) {
        List<DynamicObject> list;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        if (null == params.get("personId")) {
            resultMap.put("code", 500);
            resultMap.put("errorMsg", "personId is null");
            return resultMap;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxfile");
        Object personId = params.get("personId");
        QFilter qFilter = new QFilter("person.id", "in", personId);
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter statusFilter = new QFilter("status", "in", (Object)new String[]{"C", "A"});
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"0", "1", "-3"});
        Object[] dynamicObjects = helper.loadDynamicObjectArray(new QFilter[]{qFilter, currentVersionFilter, statusFilter, dataStatusFilter});
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            resultMap.put("code", 200);
            return resultMap;
        }
        Map<String, List<DynamicObject>> map = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dy -> dy.getString("status")));
        if (map.containsKey("C")) {
            list = map.get("C");
            this.invokeSaveOperation(BTN_SAVEAFTERAUDIT, list.toArray(new DynamicObject[0]), resultMap);
        }
        if (map.containsKey("A")) {
            list = map.get("A");
            this.invokeSaveOperation(BTN_SAVE, list.toArray(new DynamicObject[0]), resultMap);
        }
        if (null == resultMap.get("errorMsg")) {
            resultMap.put("code", 200);
        }
        return resultMap;
    }

    private void invokeSaveOperation(String operationKey, DynamicObject[] taxFileArr, Map<String, Object> resultMap) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("skipCheckDataPermission", "true");
        option.setVariableValue("skipCheckSpecialDataPermission", "true");
        OperationResult empResult = opImpl.localInvokeOperation(operationKey, taxFileArr, option);
        if (!empResult.isSuccess()) {
            StringBuilder msgSb = new StringBuilder();
            msgSb.append(empResult.getMessage());
            List allErrorOrValidateInfo = empResult.getAllErrorOrValidateInfo();
            if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                allErrorOrValidateInfo.forEach(obj -> msgSb.append(obj.getMessage()));
            }
            resultMap.put("code", 500);
            String errorMsg = (String)resultMap.get("errorMsg");
            if (null != errorMsg) {
                msgSb.append(errorMsg);
                resultMap.put("errorMsg", msgSb.toString());
            } else {
                resultMap.put("errorMsg", msgSb.toString());
            }
        }
    }
}

