/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.iit.servicehelper;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;

public class ServiceFactory {
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>();

    private ServiceFactory() {
    }

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static Object getService(String serviceName) {
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"sit-sitcs-servicehelper", (Object[])new Object[0]), serviceName));
        }
        return TypesContainer.getOrRegisterSingletonInstance((String)className);
    }

    static {
        SERVICE_MAP.put("IndividualTaxFileService", "kd.sit.iit.mservice.IndividualTaxFileServiceImpl");
        SERVICE_MAP.put("IitPersonService", "kd.sit.iit.mservice.IitPersonServiceImpl");
        SERVICE_MAP.put("TaxBaseDataApiService", "kd.sit.iit.mservice.TaxBaseDataApiServiceImpl");
        SERVICE_MAP.put("ITaxFileReviseService", "kd.sit.iit.mservice.TaxFileReviseServiceImpl");
    }
}

