/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.iit.formplugin.web.taxfile;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class IitPersonEdit
extends HRDataBaseEdit {
    public void loadData(LoadDataEventArgs event) {
        DynamicObject personObject;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object taxDataBasic = customParams.get("taxDataBasicId");
        if (null != taxDataBasic) {
            Long taxDataBasicId = (Long)BaseDataConverter.convert(taxDataBasic, Long.class);
            long taxFileVid = this.getPersonRelateIdsByTaxDataBasic(taxDataBasicId);
            personObject = this.loadPersonDataByTaxFileVid(taxFileVid);
        } else {
            personObject = this.loadPersonDataByTaxFileVid((Long)customParams.get("taxfileid"));
        }
        event.setDataEntity(personObject);
    }

    private DynamicObject loadPersonDataByTaxFileVid(long taxFileVid) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"iit_person");
        QFilter qFilter = new QFilter("id", "=", (Object)taxFileVid);
        DynamicObject taxFile = SitDataServiceHelper.commonQueryOne((PropertiesQueryInfo)new PropertiesQueryInfo("itc_taxfile"), (QFilter[])new QFilter[]{qFilter});
        dynamicObject.set("number", (Object)taxFile.getString("person.number"));
        dynamicObject.set("name", (Object)taxFile.getString("person.name"));
        dynamicObject.set("taxcrdltype", taxFile.get("taxcrdltype"));
        dynamicObject.set("credentialsnum", (Object)taxFile.getString("percre.number"));
        dynamicObject.set("nationality", taxFile.get("pernontsprop.nationality"));
        dynamicObject.set("birthday", taxFile.get("pernontsprop.birthday"));
        dynamicObject.set("gender", taxFile.get("pernontsprop.gender"));
        dynamicObject.set("education", taxFile.get("pereduexp.education"));
        dynamicObject.set("marriagestatus", taxFile.get("pertsprop.marriagestatus"));
        return dynamicObject;
    }

    private long getPersonRelateIdsByTaxDataBasic(Long taxDataBasicId) {
        QFilter qFilter = new QFilter("id", "=", (Object)taxDataBasicId);
        DynamicObject taxDataBasic = SitDataServiceHelper.commonQueryOne((PropertiesQueryInfo)new PropertiesQueryInfo("itc_taxdatabasic"), (QFilter[])new QFilter[]{qFilter});
        return taxDataBasic.getLong("taxfile.id");
    }
}

