/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.iit.formplugin.web.taxfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class PersonListPlugin
extends AbstractListPlugin {
    private static final Map<String, String> PROP_MAPPING = Maps.newLinkedHashMapWithExpectedSize((int)16);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new PersonListPluginProviderImpl());
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.getView().setVisible(Boolean.FALSE, new String[]{"isshowlogicdelete"});
    }

    static {
        PROP_MAPPING.put("id", "personversion.id");
        PROP_MAPPING.put("number", "personversion.number");
        PROP_MAPPING.put("name", "personversion.name");
        PROP_MAPPING.put("taxcrdltypename", "taxcrdltype.name");
        PROP_MAPPING.put("credentialsnum", "percre.number");
        PROP_MAPPING.put("nationality", "pernontsprop.nationality");
        PROP_MAPPING.put("birthday", "pernontsprop.birthday");
        PROP_MAPPING.put("gender", "pernontsprop.gender");
        PROP_MAPPING.put("education", "pereduexp.education");
        PROP_MAPPING.put("marriagestatus", "pertsprop.marriagestatus");
    }

    private class PersonListPluginProviderImpl
    extends ListDataProvider {
        private PersonListPluginProviderImpl() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
            Map customParams = PersonListPlugin.this.getView().getFormShowParameter().getCustomParams();
            Long taxFileBoid = (Long)BaseDataConverter.convert(customParams.get("taxfileboid"), Long.class);
            HRBaseServiceHelper taxFileHelper = new HRBaseServiceHelper("itc_taxfile");
            QFilter filter = new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.NO.getCode());
            QFilter boidFilter = new QFilter("boid", "=", (Object)taxFileBoid);
            String status = (String)customParams.get("status");
            QFilter statusFilter = null;
            statusFilter = "C".equals(status) ? new QFilter("status", "=", (Object)"C") : new QFilter("status", "in", (Object)new String[]{"C", "E"});
            QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"2", "1"});
            ArrayList qFilters = Lists.newArrayList((Object[])new QFilter[]{filter, boidFilter, statusFilter, dataStatusFilter});
            DynamicObject[] taxFileDys = taxFileHelper.query("id,personversion,percre,pereduexp,pertsprop,pernontsprop,taxcrdltype", qFilters.toArray(new QFilter[0]), "bsed asc");
            LinkedHashMap filterVidTaxFileMap = Maps.newLinkedHashMapWithExpectedSize((int)taxFileDys.length);
            for (DynamicObject taxFileDy : taxFileDys) {
                StringBuilder allIds = new StringBuilder();
                allIds.append(taxFileDy.getString("personversion.id"));
                allIds.append(taxFileDy.getString("percre.id"));
                allIds.append(taxFileDy.getString("pereduexp.id"));
                allIds.append(taxFileDy.getString("pertsprop.id"));
                allIds.append(taxFileDy.getString("pernontsprop.id"));
                String allIdsStr = allIds.toString();
                filterVidTaxFileMap.putIfAbsent(allIdsStr, taxFileDy);
            }
            LinkedHashMap filterValueTaxFileMap = Maps.newLinkedHashMapWithExpectedSize((int)filterVidTaxFileMap.size());
            for (Map.Entry entry : filterVidTaxFileMap.entrySet()) {
                StringBuilder allValues = new StringBuilder();
                DynamicObject taxFileDy = (DynamicObject)entry.getValue();
                for (Map.Entry propEntry : PROP_MAPPING.entrySet()) {
                    String propKey = (String)propEntry.getValue();
                    allValues.append(taxFileDy.getString(propKey));
                }
                String allValueStr = allValues.toString();
                filterValueTaxFileMap.putIfAbsent(allValueStr, taxFileDy);
            }
            ArrayList allDys = Lists.newArrayListWithCapacity((int)filterValueTaxFileMap.size());
            ArrayList taxFileList = Lists.newArrayList(filterValueTaxFileMap.values());
            long[] ids = DB.genLongIds((String)"T_ITC_TAXFILE", (int)taxFileList.size());
            for (int i = 0; i < taxFileList.size(); ++i) {
                DynamicObject iitPersonDy = BusinessDataServiceHelper.newDynamicObject((String)"iit_person");
                DynamicObject taxFileDy = (DynamicObject)taxFileList.get(i);
                for (Map.Entry propEntry : PROP_MAPPING.entrySet()) {
                    String propName = (String)propEntry.getKey();
                    String propKey = (String)propEntry.getValue();
                    iitPersonDy.set(propName, taxFileDy.get(propKey));
                }
                iitPersonDy.set("versionname", (Object)("V000" + (i + 1)));
                iitPersonDy.set("id", (Object)ids[i]);
                allDys.add(iitPersonDy);
            }
            allDys.forEach(arg_0 -> ((DynamicObjectCollection)dynamicObjects).add(arg_0));
            if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
                dynamicObjects.add((Object)BusinessDataServiceHelper.newDynamicObject((String)"iit_person"));
                return dynamicObjects;
            }
            List showDynamicObjects = dynamicObjects.subList(start, Math.min(start + limit, dynamicObjects.size()));
            DynamicObjectCollection result = new DynamicObjectCollection();
            showDynamicObjects.forEach(arg_0 -> ((DynamicObjectCollection)result).add(arg_0));
            this.getQueryResult().setCollection(dynamicObjects);
            this.getQueryResult().setDataCount(dynamicObjects.size());
            return result;
        }
    }
}

