/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.iit.business.model;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.sit.iit.business.api.IitSitBsService;
import kd.sit.iit.business.model.TaxFileMatchCalContext;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.BizHandler;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BizServiceFactory;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxFileMatchCalHandler
implements BizHandler<Map<Object, Object>, Map<String, Object>, TaxFileMatchCalContext> {
    private static final TaxFileMatchCalHandler INSTANCE = new TaxFileMatchCalHandler();

    public static TaxFileMatchCalHandler getInstance() {
        return INSTANCE;
    }

    public TaxFileMatchCalContext newParam(Map<String, Object> stringObjectMap) {
        return new TaxFileMatchCalContext();
    }

    public Class<TaxFileMatchCalContext> paramClass() {
        return TaxFileMatchCalContext.class;
    }

    public void prepareHead(TaxFileMatchCalContext taxFileMatchCalContext) {
        if (taxFileMatchCalContext.isRegionSingle()) {
            Long country = taxFileMatchCalContext.getCountry();
            BaseResult appInfo = SitDataServiceHelper.findAppInfo((long)country);
            if (!appInfo.isSuccess()) {
                taxFileMatchCalContext.requestFail(appInfo.getMessage(), appInfo.getStatus());
            } else {
                taxFileMatchCalContext.setAppId((String)appInfo.getData());
            }
        }
    }

    public void prepareBody(TaxFileMatchCalContext taxFileMatchCalContext) {
        Map<Long, List<Long>> mapData = taxFileMatchCalContext.taxFileIdsMap();
        Date date = (Date)BaseDataConverter.convert((Object)taxFileMatchCalContext.removeFixParam("date"), Date.class);
        TaxPeriodEntity taxPeriodEntity = new TaxPeriodEntity();
        taxPeriodEntity.setStartDate(date);
        taxPeriodEntity.setEndDate(date);
        if (taxFileMatchCalContext.isCalSense()) {
            IitSitBsService sitBsService = (IitSitBsService)BizServiceFactory.lookup((String)"iitSitBsService");
            Map<Long, DynamicObject> matchPeriods = sitBsService.matchPeriods(mapData.keySet(), date);
            taxFileMatchCalContext.setTaxPeriodMap(Maps.asMap(mapData.keySet(), ele -> {
                DynamicObject period = (DynamicObject)matchPeriods.get(ele);
                return period == null ? taxPeriodEntity : new TaxPeriodEntity(period);
            }));
        } else {
            taxFileMatchCalContext.setTaxPeriodMap(Maps.asMap(mapData.keySet(), ele -> taxPeriodEntity));
        }
    }

    public void dealData(TaxFileMatchCalContext taxFileMatchCalContext) {
    }

    public void recoveryFromCache(TaxFileMatchCalContext taxFileMatchCalContext, Map<String, Object> rawParam) {
    }
}

