/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.iit.business.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.iit.business.api.IitTaxFileService;
import kd.sit.iit.business.api.TaxFileMatchCalParamAdapter;
import kd.sit.iit.business.model.TaxFileMatchCalContext;
import kd.sit.iit.business.model.TaxFileMatchCalHandler;
import kd.sit.iit.business.model.TaxFileMatchCalParamConfig;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.enums.DataEditStatusEnum;
import kd.sit.sitbp.common.model.ParamConfig;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.ParamAdapterFactory;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.commons.collections.MapUtils;

public class IitTaxFileServiceImpl
implements IitTaxFileService {
    private static final Log LOGGER = LogFactory.getLog(IitTaxFileServiceImpl.class);

    @Override
    public Map<String, Object> findTaxFiles(long regionId, List<Long> taxFileIds, Set<String> props, boolean isShowStopTax, boolean useHis) {
        BaseResult appRes = SitDataServiceHelper.findAppInfo((long)regionId);
        if (!appRes.isSuccess()) {
            return appRes.toMap(false);
        }
        String appId = (String)appRes.getData();
        return (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"findTaxFiles", (Object[])new Object[]{taxFileIds, props, isShowStopTax, useHis});
    }

    @Override
    public Map<String, Map<Long, Map<String, Object>>> findPropOfTaxFile(long regionId, Map<String, Set<Long>> idGroup, Map<String, Set<String>> propGroup) {
        BaseResult appRes = SitDataServiceHelper.findAppInfo((long)regionId);
        if (!appRes.isSuccess()) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        String appId = (String)appRes.getData();
        return (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"findPropOfTaxFile", (Object[])new Object[]{idGroup, propGroup});
    }

    @Override
    public Map<String, Object> findTaxFilesOfPerson(long regionId, long personId, Set<String> props, boolean isShowStopTax, Set<Long> excludeFileIds) {
        BaseResult appRes = SitDataServiceHelper.findAppInfo((long)regionId);
        if (!appRes.isSuccess()) {
            return appRes.toMap(false);
        }
        String appId = (String)appRes.getData();
        return (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"findTaxFilesOfPerson", (Object[])new Object[]{personId, props, isShowStopTax, excludeFileIds});
    }

    @Override
    public Map<String, Object> findPropOfTaxFile(Map<String, Object> params) {
        List requestData = (List)params.get("data");
        HashMap groupByRegion = Maps.newHashMapWithExpectedSize((int)requestData.size());
        for (Map datum : requestData) {
            Long regionId = MapUtils.getLong((Map)datum, (Object)"regionId");
            List fileIds = groupByRegion.computeIfAbsent(regionId, ky -> Lists.newArrayListWithExpectedSize((int)requestData.size()));
            fileIds.add(MapUtils.getLong((Map)datum, (Object)"taxFileId"));
        }
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        HashMap responseData = Maps.newHashMapWithExpectedSize((int)requestData.size());
        result.put("success", Boolean.TRUE);
        result.put("data", responseData);
        result.put("status", 200);
        HRBaseServiceHelper countryHelper = new HRBaseServiceHelper("bd_country");
        Object[] countries = countryHelper.query("id,name", new QFilter[]{new QFilter("id", "in", groupByRegion.keySet())});
        HashMap countryNames = Maps.newHashMapWithExpectedSize((int)groupByRegion.size());
        if (!ArrayUtils.isEmpty((Object[])countries)) {
            for (Object country : countries) {
                countryNames.put(country.getLong("id"), country.getString("name"));
            }
        }
        Map appInfoMap = (Map)SITMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getAppInfoOfRegion", (Object[])new Object[]{groupByRegion.keySet()});
        groupByRegion.forEach((taxRegion, value) -> {
            DynamicObject appInfo = (DynamicObject)appInfoMap.get(taxRegion);
            LOGGER.info("by cyh iit findPropOfTaxFile entry.getValue() = {}", value);
            if (appInfo == null) {
                HashMap itemMap = Maps.newHashMapWithExpectedSize((int)4);
                itemMap.put("success", false);
                String countryName = (String)countryNames.get(taxRegion);
                countryName = countryName == null ? taxRegion + "" : countryName;
                itemMap.put("message", ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u4e3a{0}\u5339\u914d\u4e0d\u5230\u5bf9\u5e94\u7684\u4e2a\u7a0e\u5e94\u7528\uff0c\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u3002", (String)"IitTaxFileServiceImpl_3", (String)"sit-iit-business", (Object[])new Object[]{countryName}));
                for (Long fileId : value) {
                    responseData.put(fileId, itemMap);
                }
                return;
            }
            String appId = appInfo.getString("app.number");
            HashMap param = Maps.newHashMap((Map)params);
            param.put("data", value);
            Map saveResult = (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"findPropOfTaxFile", (Object[])new Object[]{param});
            LOGGER.info("by cyh  iit findPropOfTaxFile saveResult = {}", (Object)saveResult);
            boolean success = (Boolean)BaseDataConverter.convert(saveResult.get("success"), Boolean.class, (Object)Boolean.FALSE);
            Map dataTemp = (Map)saveResult.get("data");
            if (success && !CollectionUtils.isEmpty((Map)dataTemp)) {
                responseData.putAll(dataTemp);
            }
        });
        boolean listResult = MapUtils.getBooleanValue(params, (Object)"listResult", (boolean)false);
        if (listResult) {
            result.put("data", Lists.newArrayList(responseData.values()));
        }
        LOGGER.info("by cyh  iit findPropOfTaxFile result = {}", result);
        return result;
    }

    @Override
    public Map<String, Object> matchCalTaxFiles(Map<String, Object> params) {
        Map result;
        BaseResult srcAdapterRes = ParamAdapterFactory.getBySrcType(TaxFileMatchCalParamAdapter.class, params);
        if (!srcAdapterRes.isSuccess()) {
            return srcAdapterRes.toMap(false);
        }
        HashMap res = Maps.newHashMapWithExpectedSize((int)8);
        res.put("success", Boolean.FALSE);
        res.put("status", 400);
        TaxFileMatchCalContext periodContext = (TaxFileMatchCalContext)((TaxFileMatchCalParamAdapter)srcAdapterRes.getData()).adapt((ParamConfig)TaxFileMatchCalParamConfig.getInstance(), params, TaxFileMatchCalHandler.getInstance());
        if (!periodContext.isSuccess()) {
            res.put("status", periodContext.getStatus());
            res.put("message", periodContext.getMessage());
            return res;
        }
        if (periodContext.isRegionSingle()) {
            String appId = periodContext.getAppId();
            Map resBatch = (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"matchCalTaxFiles", (Object[])new Object[]{periodContext.taxFileIdsWhenRegionSingle(), periodContext.taxPeriodEntityWhenRegionSingle(), periodContext.getProps()});
            result = (Map)resBatch.get("data");
            res.put("data", result);
        } else {
            Map<Long, List<Long>> taxFileIdsMap = periodContext.taxFileIdsMap();
            Map appInfoMap = (Map)SITMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getAppInfoOfRegion", (Object[])new Object[]{taxFileIdsMap.keySet().stream().map(ele -> (Long)BaseDataConverter.convert((Object)ele, Long.class)).collect(Collectors.toList())});
            result = new ConcurrentHashMap(8);
            res.put("data", result);
            taxFileIdsMap.forEach((key, value) -> {
                DynamicObject object = (DynamicObject)appInfoMap.get(key);
                if (object == null) {
                    return;
                }
                String appId = object.getString("app.number");
                HashMap param = Maps.newHashMap((Map)params);
                param.put("data", value);
                Map resBatch = (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"matchCalTaxFiles", (Object[])new Object[]{value, periodContext.taxPeriodEntityOf((Long)key), periodContext.getProps()});
                Map batch = (Map)resBatch.get("data");
                result.putAll(batch);
            });
        }
        if (periodContext.isCalSense()) {
            LinkedHashSet boIdSet = Sets.newLinkedHashSetWithExpectedSize((int)result.size());
            result.entrySet().removeIf(next -> !boIdSet.add(((Map)next.getValue()).get("boid")));
        }
        res.put("success", Boolean.TRUE);
        res.put("status", 200);
        return res;
    }

    @Override
    public Map<String, Object> saveTaxFiles(List<Map<String, Object>> taxFileTemps, String actionWay, String action) {
        Map<Long, List<Map>> groupByRegion = taxFileTemps.stream().collect(Collectors.groupingBy(ele -> ((DynamicObject)ele.get("taxregion")).getLong("id")));
        Map appInfoMap = (Map)SITMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getAppInfoOfRegion", (Object[])new Object[]{groupByRegion.keySet()});
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        ArrayList data = Lists.newArrayListWithCapacity((int)taxFileTemps.size());
        result.put("success", Boolean.TRUE);
        result.put("data", data);
        result.put("status", 200);
        groupByRegion.entrySet().stream().forEach(entry -> {
            Long taxRegion = (Long)entry.getKey();
            DynamicObject appInfo = (DynamicObject)appInfoMap.get(taxRegion);
            List value = (List)entry.getValue();
            LOGGER.info("by cyh iit saveTaxFiles entry.getValue() = {}", (Object)value);
            if (appInfo == null) {
                String message = ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a{0}\u6ca1\u6709\u914d\u7f6e\u5e94\u7528\u4fe1\u606f\u3002", (String)"IitTaxFileServiceImpl_0", (String)"sit-iit-business", (Object[])new Object[]{taxRegion});
                for (Map map : value) {
                    map.put("failmsg", message);
                    map.put("failreason", 401);
                    data.add(map);
                }
                return;
            }
            String appId = appInfo.getString("app.number");
            HashMap<String, Object> param = new HashMap<String, Object>(8);
            param.put("ITCFILE_ACTIONWAY", actionWay);
            param.put("action", action);
            param.put("data", value);
            Map saveResult = (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"saveTaxFile", (Object[])new Object[]{param});
            LOGGER.info("by cyh  iit saveTaxFiles saveResult = {}", (Object)saveResult);
            boolean success = (Boolean)BaseDataConverter.convert(saveResult.get("success"), Boolean.class, (Object)Boolean.FALSE);
            List dataTemp = (List)saveResult.get("data");
            if (!success && CollectionUtils.isEmpty((Collection)dataTemp)) {
                String message = BaseDataConverter.toString(saveResult.get("message"));
                for (Map map : value) {
                    map.put("failmsg", message);
                    map.put("failreason", 401);
                    data.add(map);
                }
            } else {
                data.addAll(dataTemp);
            }
        });
        LOGGER.info("by cyh  iit saveTaxFiles result = {}", result);
        return result;
    }

    @Override
    public Map<String, Object> synTaxFileData(List<Map<String, Object>> taxFileTemps, String actionWay, String action, String skipPermCheck) {
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        if (CollectionUtils.isEmpty(taxFileTemps)) {
            result.put("success", Boolean.FALSE);
            result.put("data", taxFileTemps);
            result.put("message", ResManager.loadKDString((String)"\u4e2a\u7a0e\u6863\u6848\u4fe1\u606f\u7f3a\u5931", (String)"IitTaxFileServiceImpl_0", (String)"sit-iit-business", (Object[])new Object[0]));
            result.put("status", 300);
            return result;
        }
        ArrayList data = Lists.newArrayListWithCapacity((int)taxFileTemps.size());
        result.put("success", Boolean.TRUE);
        result.put("data", data);
        result.put("status", 200);
        for (Map<String, Object> info : taxFileTemps) {
            Map taxfile = MapUtils.getMap(info, (Object)"taxfile");
            if (CollectionUtils.isEmpty((Map)taxfile)) {
                result.put("success", Boolean.FALSE);
                result.put("data", taxFileTemps);
                result.put("message", ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u63a5\u53e3\u53c2\u6570\uff1a\u63a5\u53e3\u53c2\u6570\u4e2d\u4e0d\u80fd\u7f3a\u5931\u6863\u6848\u4fe1\u606f", (String)"IitTaxFileServiceImpl_0", (String)"sit-iit-business", (Object[])new Object[0]));
                result.put("status", 300);
                return result;
            }
            if (!Objects.isNull(taxfile.get("taxregion"))) continue;
            result.put("success", Boolean.FALSE);
            result.put("data", taxFileTemps);
            result.put("message", ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u63a5\u53e3\u53c2\u6570\uff1a\u63a5\u53e3\u53c2\u6570\u4e2d\u4e0d\u80fd\u7f3a\u5931\u4e2a\u7a0e\u7ba1\u7406\u5c5e\u5730", (String)"IitTaxFileServiceImpl_0", (String)"sit-iit-business", (Object[])new Object[0]));
            result.put("status", 300);
            return result;
        }
        Map<Long, List<Map>> groupByRegion = taxFileTemps.stream().collect(Collectors.groupingBy(ele -> (Long)((Map)ele.get("taxfile")).get("taxregion")));
        Map appInfoMap = (Map)SITMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getAppInfoOfRegion", (Object[])new Object[]{groupByRegion.keySet()});
        groupByRegion.forEach((taxRegion, value) -> {
            DynamicObject appInfo = (DynamicObject)appInfoMap.get(taxRegion);
            LOGGER.info("by cyh iit synTaxFileData entry.getValue() = {}", value);
            if (appInfo == null) {
                String message = ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a{0}\u6ca1\u6709\u914d\u7f6e\u5e94\u7528\u4fe1\u606f\u3002", (String)"IitTaxFileServiceImpl_0", (String)"sit-iit-business", (Object[])new Object[]{taxRegion});
                for (Map map : value) {
                    this.setResultMap(data, message, map);
                }
                return;
            }
            String appId = appInfo.getString("app.number");
            HashMap<String, Object> param = new HashMap<String, Object>(8);
            param.put("ITCFILE_ACTIONWAY", actionWay);
            param.put("action", action);
            param.put("skippermck", skipPermCheck);
            param.put("data", value);
            Map saveResult = (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"synTaxFileData", (Object[])new Object[]{param});
            LOGGER.info("by cyh  iit synTaxFileData saveResult = {}", (Object)saveResult);
            boolean success = (Boolean)BaseDataConverter.convert(saveResult.get("success"), Boolean.class, (Object)Boolean.FALSE);
            List dataTemp = (List)saveResult.get("data");
            if (!success && CollectionUtils.isEmpty((Collection)dataTemp)) {
                String message = BaseDataConverter.toString(saveResult.get("message"));
                for (Map map : value) {
                    this.setResultMap(data, message, map);
                }
            } else {
                data.addAll(dataTemp);
            }
        });
        LOGGER.info("by cyh  iit synTaxFileData result = {}", result);
        return result;
    }

    private void setResultMap(List<Map<String, Object>> data, String message, Map<String, Object> map) {
        map.put("operationstatus", "0");
        map.put("sourceid", MapUtils.getLong(map, (Object)"sourceid"));
        map.put("errormsg", message);
        map.put("errorcode", "1010");
        map.put("taxfileid", null);
        data.add(map);
    }

    @Override
    public Map<String, Object> validateSalaryTaxFileRel(long regionId, Map<String, Object> params) {
        BaseResult appRes = SitDataServiceHelper.findAppInfo((long)regionId);
        if (!appRes.isSuccess()) {
            return appRes.toMap(false);
        }
        String appId = (String)appRes.getData();
        return (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"validateSalaryTaxFileRel", (Object[])new Object[]{params});
    }

    @Override
    public Map<String, Object> taxFilePreviewFormParameter(long regionId, long taxFileId, int editStatus, long referFileId, String parentPageId) {
        BaseResult appRes = SitDataServiceHelper.findAppInfo((long)regionId);
        if (!appRes.isSuccess()) {
            return appRes.toMap(false);
        }
        String appId = (String)appRes.getData();
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("taxregionid", regionId);
        params.put("businesstype", "10");
        Map pageConfigInfo = (Map)SITMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getPageCfgMapByTaxRegionId", (Object[])new Object[]{params});
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        result.put("success", Boolean.FALSE);
        if (CollectionUtils.isEmpty((Map)pageConfigInfo)) {
            result.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u591a\u89c6\u56fe\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u591a\u89c6\u56fe\u914d\u7f6e", (String)"BaseTaxFileInfoService_0", (String)"sit-itc-business", (Object[])new Object[0]));
            return result;
        }
        if (ObjectUtils.isEmpty(pageConfigInfo.get("cfgid"))) {
            result.put("message", pageConfigInfo.get("resultMsg"));
            return result;
        }
        String entityName = appId + "_taxfile";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        DynamicObject taxFile = serviceHelper.loadSingle((Object)taxFileId);
        int editStatusOld = editStatus;
        String status = taxFile.getString("status");
        if ("B".equals(status) || "E".equals(status)) {
            editStatus = DataEditStatusEnum.READ_ONLY.getCode();
        }
        Map relateFileKeyInfo = (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"loadTaxFileKeyInfo", (Object[])new Object[]{Maps.newHashMapWithExpectedSize((int)16), taxFile, editStatus});
        if (editStatus == DataEditStatusEnum.WRITE.getCode() && referFileId != 0L) {
            DynamicObject referTaxFile = serviceHelper.loadSingle((Object)referFileId);
            Map relateIds = (Map)relateFileKeyInfo.remove("relateIds");
            Map referFileKeyInfo = (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"loadTaxFileKeyInfo", (Object[])new Object[]{relateIds, referTaxFile, editStatus});
            relateFileKeyInfo.put("relateIds", referFileKeyInfo.remove("relateIds"));
            for (Map.Entry entry : referFileKeyInfo.entrySet()) {
                if (((String)entry.getKey()).endsWith(".editStatus")) {
                    relateFileKeyInfo.put(entry.getKey(), entry.getValue());
                    continue;
                }
                relateFileKeyInfo.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        long fileVId = taxFile.getLong("id");
        long taxFileBoid = taxFile.getLong("boid");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId(String.valueOf(pageConfigInfo.get("formid")));
        formShowParameter.setPageId(parentPageId + fileVId);
        formShowParameter.setCustomParam("editStatusOld", (Object)editStatusOld);
        formShowParameter.setCustomParam("editStatus", (Object)editStatus);
        if (DataEditStatusEnum.READ_ONLY.getCode() == editStatus) {
            formShowParameter.setCustomParam("isOnlyView", (Object)"true");
        }
        formShowParameter.setCustomParam("appId", (Object)appId);
        formShowParameter.setAppId(appId);
        formShowParameter.setCustomParam("cfgid", pageConfigInfo.get("cfgid"));
        formShowParameter.setCustomParam("taxfileid", (Object)fileVId);
        formShowParameter.setCustomParam("taxfileboid", (Object)taxFileBoid);
        formShowParameter.setCustomParam("personid", (Object)taxFile.getString("person.id"));
        formShowParameter.setCustomParam("mainDataId", (Object)taxFileBoid);
        formShowParameter.setCustomParam("mainEntityNumber", (Object)"itc_taxfile");
        formShowParameter.setCustomParam("mainStatus", (Object)status);
        String personName = taxFile.getString("person.name");
        formShowParameter.setCustomParam("name", (Object)personName);
        formShowParameter.setCaption(MessageFormat.format(ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848 - {0}", (String)"BaseTaxFileInfoService_2", (String)"sit-iit-business", (Object[])new Object[0]), personName));
        TaxFileInfoServiceFactory.decorateFormShowParameter((FormShowParameter)formShowParameter, (DynamicObject)taxFile, (Map)relateFileKeyInfo);
        new PageCache(formShowParameter.getPageId()).put("relateFileKeyInfo", SerializationUtils.toJsonString((Object)relateFileKeyInfo));
        result.put("data", formShowParameter);
        result.put("success", Boolean.TRUE);
        return result;
    }

    @Override
    public Map<String, Object> taxFilePreviewFormParameterByVid(long regionId, long taxFileId, int editStatus, long taxDataBasicId, String parentPageId) {
        BaseResult appRes = SitDataServiceHelper.findAppInfo((long)regionId);
        if (!appRes.isSuccess()) {
            return appRes.toMap(false);
        }
        String appId = (String)appRes.getData();
        HashMap params = Maps.newHashMapWithExpectedSize((int)2);
        params.put("taxregionid", regionId);
        params.put("businesstype", "10");
        Map pageConfigInfo = (Map)SITMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getPageCfgMapByTaxRegionId", (Object[])new Object[]{params});
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        result.put("success", Boolean.FALSE);
        if (CollectionUtils.isEmpty((Map)pageConfigInfo)) {
            result.put("message", ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7528\u7684\u591a\u89c6\u56fe\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u591a\u89c6\u56fe\u914d\u7f6e", (String)"BaseTaxFileInfoService_0", (String)"sit-itc-business", (Object[])new Object[0]));
            return result;
        }
        if (ObjectUtils.isEmpty(pageConfigInfo.get("cfgid"))) {
            result.put("message", pageConfigInfo.get("resultMsg"));
            return result;
        }
        String entityName = appId + "_taxfile";
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        DynamicObject taxFile = serviceHelper.loadSingle((Object)taxFileId);
        serviceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        DynamicObject basicDy = serviceHelper.loadSingle((Object)taxDataBasicId);
        HashMap relateIds = Maps.newHashMapWithExpectedSize((int)16);
        this.seRelateIds(basicDy, relateIds);
        Map relateFileKeyInfo = (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"loadTaxFileKeyInfoByVid", (Object[])new Object[]{relateIds, taxFile, editStatus});
        long fileVId = taxFile.getLong("id");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setFormId(String.valueOf(pageConfigInfo.get("formid")));
        formShowParameter.setPageId(parentPageId + fileVId);
        formShowParameter.setCustomParam("editStatus", (Object)editStatus);
        if (DataEditStatusEnum.READ_ONLY.getCode() == editStatus) {
            formShowParameter.setCustomParam("isOnlyView", (Object)"true");
        }
        formShowParameter.setCustomParam("appId", (Object)appId);
        formShowParameter.setCustomParam("cfgid", pageConfigInfo.get("cfgid"));
        formShowParameter.setCustomParam("taxfileid", (Object)fileVId);
        formShowParameter.setCustomParam("personid", (Object)taxFile.getString("person.id"));
        formShowParameter.setCustomParam("taxDataBasicId", (Object)taxDataBasicId);
        String personName = taxFile.getString("person.name");
        formShowParameter.setCustomParam("name", (Object)personName);
        formShowParameter.setCaption(MessageFormat.format(ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848 - {0}", (String)"BaseTaxFileInfoService_2", (String)"sit-iit-business", (Object[])new Object[0]), personName));
        TaxFileInfoServiceFactory.decorateFormShowParameter((FormShowParameter)formShowParameter, (DynamicObject)taxFile, (Map)relateFileKeyInfo);
        new PageCache(formShowParameter.getPageId()).put("relateFileKeyInfo", SerializationUtils.toJsonString((Object)relateFileKeyInfo));
        result.put("data", formShowParameter);
        result.put("success", Boolean.TRUE);
        return result;
    }

    private void seRelateIds(DynamicObject basicDy, HashMap<Object, Object> relateIds) {
        relateIds.put("itc_taxfile", basicDy.getLong("taxfile.id"));
        relateIds.put("itc_taxcontact", basicDy.getLong("taxcontact.id"));
        relateIds.put("itc_employment", basicDy.getLong("employment.id"));
        relateIds.put("itc_bankcard", basicDy.getLong("bankcard.id"));
        relateIds.put("itc_investor", basicDy.getLong("investor.id"));
        relateIds.put("itc_overseasperson", basicDy.getLong("overseasperson.id"));
        relateIds.put("itc_specialinfo", basicDy.getLong("specialinfo.id"));
        relateIds.put("iit_person", basicDy.getLong("taxperson.id"));
    }

    @Override
    public Map<String, Object> findTaxFile(long regionId, long taxFileId, Set<String> props, boolean includeStop) {
        BaseResult appRes = SitDataServiceHelper.findAppInfo((long)regionId);
        if (!appRes.isSuccess()) {
            return appRes.toMap(false);
        }
        String appId = (String)appRes.getData();
        return (Map)SITMServiceUtils.invokeSITService((String)appId, (String)(appId + "TaxFileApiService"), (String)"findTaxFile", (Object[])new Object[]{taxFileId, props, includeStop});
    }
}

