/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.iit.business.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.iit.business.service.AbstractPerInfoService;
import kd.sit.sitbp.common.model.DateRange;

public class PerBaseInfoServiceImpl
extends AbstractPerInfoService {
    @Override
    public long getPersonId(DynamicObject dy) {
        return dy.getLong("id");
    }

    @Override
    public DynamicObject[] queryLatest(List<Long> ids, Set<String> props) {
        QFilter qf = new QFilter("id", "in", ids);
        qf.and("iscurrentversion", "=", (Object)"1");
        qf.and("datastatus", "=", (Object)"1");
        return this.query(props, qf);
    }

    @Override
    public DynamicObject[] query(Set<String> props, QFilter filter) {
        DynamicObject[] queryList = new DynamicObject[]{};
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_person");
        if (null != filter) {
            queryList = serviceHelper.query(String.join((CharSequence)",", props) + ",id,boid,modifytime,sourcevid", new QFilter[]{filter});
        }
        return queryList;
    }

    @Override
    public DynamicObject[] queryByDate(long boId, DateRange dateRange, Set<String> props) {
        return this.queryLatest(Collections.singletonList(boId), props);
    }

    @Override
    public HashMap<Long, DynamicObject> queryByDate(Map<Long, Map<String, Object>> personAndDate, Set<String> props) {
        ArrayList personIds = Lists.newArrayListWithCapacity((int)personAndDate.size());
        HashMap map = Maps.newHashMapWithExpectedSize((int)personAndDate.size());
        personAndDate.forEach((taxFileId, personIdAndDate) -> {
            personIds.add((Long)personIdAndDate.get("personId"));
            List list = map.computeIfAbsent((Long)personIdAndDate.get("personId"), ky -> Lists.newArrayListWithExpectedSize((int)4));
            list.add(taxFileId);
        });
        DynamicObject[] dys = this.queryLatest(personIds, props);
        Map<Long, List<DynamicObject>> notsprops = Arrays.stream(dys).collect(Collectors.groupingBy(ele -> ele.getLong("id")));
        HashMap result = Maps.newHashMapWithExpectedSize((int)personAndDate.size());
        map.forEach((personId, taxFileIds) -> {
            for (Long taxFileId : taxFileIds) {
                List list = (List)notsprops.get(personId);
                if (CollectionUtils.isEmpty((Collection)list)) continue;
                result.put(taxFileId, list.get(0));
            }
        });
        return result;
    }
}

