/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.iit.business.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.iit.business.service.AbstractPerInfoService;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.DateRange;
import kd.sit.sitbp.common.util.SitDateUtil;

public class PerTSPropServiceImpl
extends AbstractPerInfoService {
    @Override
    public DynamicObject[] query(Set<String> props, QFilter filter) {
        DynamicObject[] queryList = new DynamicObject[]{};
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_pertsprop");
        if (null != filter) {
            queryList = serviceHelper.query(String.join((CharSequence)",", props) + ",bsed,bsled,person.id,boid,sourcevid", new QFilter[]{filter});
        }
        return queryList;
    }

    @Override
    public DynamicObject[] queryByDate(long boId, DateRange dateRange, Set<String> props) {
        QFilter filter = new QFilter("person.id", "=", (Object)boId);
        filter.and("bsed", "<=", (Object)dateRange.getTo());
        filter.and("bsled", ">=", (Object)dateRange.getFrom());
        filter.and("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_pertsprop");
        DynamicObject[] queryList = serviceHelper.query(String.join((CharSequence)",", props), new QFilter[]{filter}, "boid,modifytime desc");
        return queryList;
    }

    @Override
    public boolean newerThan(DynamicObject firstObj, DynamicObject secondObj) {
        if (firstObj == null || firstObj.getDate("bsed") == null) {
            return false;
        }
        if (secondObj == null || secondObj.getDate("bsed") == null) {
            return true;
        }
        return firstObj.getDate("bsed").before(secondObj.getDate("bsed"));
    }

    @Override
    public HashMap<Long, DynamicObject> queryByDate(Map<Long, Map<String, Object>> personAndDate, Set<String> props) {
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)personAndDate.size());
        HashMap map = Maps.newHashMapWithExpectedSize((int)personAndDate.size());
        personAndDate.forEach((taxFileId, personIdAndDate) -> {
            personIds.add((Long)personIdAndDate.get("personId"));
            List list = map.computeIfAbsent((Long)personIdAndDate.get("personId"), ky -> Lists.newArrayListWithExpectedSize((int)4));
            list.add(taxFileId);
        });
        QFilter filter = new QFilter("person.id", "in", (Object)personIds);
        filter.and("datastatus", "in", (Object)new String[]{"1", "2", "0"});
        filter.and("iscurrentversion", "=", (Object)YesOrNoEnum.NO.getCode());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_pertsprop");
        DynamicObject[] dys = serviceHelper.query(String.join((CharSequence)",", props) + ",bsed,bsled,person.id,boid,sourcevid", new QFilter[]{filter});
        Map<Long, List<DynamicObject>> pertsprops = Arrays.stream(dys).collect(Collectors.groupingBy(ele -> ele.getLong("person.id")));
        HashMap result = Maps.newHashMapWithExpectedSize((int)personAndDate.size());
        HashMap maps = Maps.newHashMapWithExpectedSize((int)personAndDate.size());
        map.forEach((personId, taxFileIds) -> {
            for (Long taxFileId : taxFileIds) {
                List list = (List)pertsprops.get(personId);
                if (list == null) continue;
                maps.put(taxFileId, list);
            }
        });
        maps.forEach((taxFileId, persons) -> {
            if (persons == null) {
                return;
            }
            DateRange dateRange = (DateRange)((Map)personAndDate.get(taxFileId)).get("dateRange");
            for (DynamicObject person : persons) {
                if (!SitDateUtil.isDateRangeOverlap((Date)person.getDate("bsed"), (Date)person.getDate("bsled"), (Date)((Date)dateRange.getFrom()), (Date)((Date)dateRange.getTo()))) continue;
                result.put(taxFileId, person);
                break;
            }
        });
        return result;
    }
}

