/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.iit.business.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.sit.iit.business.api.PersonGatherService;
import kd.sit.iit.business.api.PersonInfoService;
import kd.sit.sitbp.common.model.DateRange;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class PersonGatherServiceImpl
implements PersonGatherService {
    private static final Log LOGGER = LogFactory.getLog(PersonGatherServiceImpl.class);
    private static final Map<String, String> PROP_MAPPING = new HashMap<String, String>(16);

    @Override
    public List<DynamicObject> findByIdList(List<Long> personIds, Set<String> props) {
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)personIds.size());
        for (Long personId : personIds) {
            result.computeIfAbsent(personId, ky -> BusinessDataServiceHelper.newDynamicObject((String)"iit_person"));
        }
        props = CollectionUtils.isEmpty(props) ? PROP_MAPPING.keySet() : props;
        Map<String, Map<String, String>> entityMap = this.generateEntityMap(props);
        for (Map.Entry<String, Map<String, String>> entry : entityMap.entrySet()) {
            Map<String, String> fieldMap = entry.getValue();
            Set<String> specificProps = fieldMap.keySet();
            BaseResult<PersonInfoService> baseResult = PersonInfoService.getPersonService(entry.getKey());
            if (!baseResult.isSuccess()) {
                BaseResult.fail((String)baseResult.getMessage());
                continue;
            }
            PersonInfoService service = (PersonInfoService)baseResult.getData();
            Object[] infoObjs = service.queryLatest(personIds, specificProps);
            LOGGER.debug("  findByIdList : \u67e5\u8be2\u957f\u5ea6 {}", (Object)(null == infoObjs ? 0 : infoObjs.length));
            if (null != infoObjs && infoObjs.length > 0) {
                LOGGER.debug("  findByIdList : \u67e5\u8be2\u957f\u5ea6 {}, infoObjs {}, {}", new Object[]{infoObjs.length, entry.getKey(), DynamicObjectSerializeUtil.serialize((Object[])infoObjs, (DynamicObjectType)infoObjs[0].getDynamicObjectType())});
            }
            if (ArrayUtils.isEmpty((Object[])infoObjs)) continue;
            this.mergePersonInfo(result, fieldMap, service, (DynamicObject[])infoObjs);
        }
        return Lists.newArrayList(result.values());
    }

    @Override
    public DynamicObject findByIdAndDate(long personId, DateRange dateRange, Set<String> props) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>(2);
        result.put(personId, BusinessDataServiceHelper.newDynamicObject((String)"iit_person"));
        Map<String, Map<String, String>> entityMap = this.generateEntityMap(props);
        for (Map.Entry<String, Map<String, String>> entry : entityMap.entrySet()) {
            Map<String, String> fieldMap = entry.getValue();
            Set<String> specificProps = fieldMap.keySet();
            BaseResult<PersonInfoService> baseResult = PersonInfoService.getPersonService(entry.getKey());
            if (!baseResult.isSuccess()) {
                BaseResult.fail((String)baseResult.getMessage());
                continue;
            }
            PersonInfoService service = (PersonInfoService)baseResult.getData();
            DynamicObject[] infoObjs = service.queryByDate(personId, dateRange, specificProps);
            DynamicObject[] latestInfoObjs = this.getLatestVersion(infoObjs);
            this.mergePersonInfo(result, fieldMap, service, latestInfoObjs);
        }
        return (DynamicObject)result.get(personId);
    }

    @Override
    public DynamicObject findById(long personId, Set<String> props) {
        List<DynamicObject> objectList = this.findByIdList(Collections.singletonList(personId), props);
        return objectList.get(0);
    }

    private Map<String, Map<String, String>> generateEntityMap(Set<String> props) {
        HashMap<String, Map<String, String>> entityMap = new HashMap<String, Map<String, String>>(props.size());
        if (CollectionUtils.isEmpty(props)) {
            for (Map.Entry<String, String> entry : PROP_MAPPING.entrySet()) {
                String mappingProp = entry.getValue();
                if (mappingProp == null) continue;
                String[] split = mappingProp.split("\\.");
                entityMap.computeIfAbsent(split[0], key -> new HashMap(4)).put(split[1], entry.getKey());
            }
        } else {
            for (String prop : props) {
                String mappingProp = PROP_MAPPING.get(prop);
                if (mappingProp == null) continue;
                String[] split = mappingProp.split("\\.");
                entityMap.computeIfAbsent(split[0], key -> new HashMap(4)).put(split[1], prop);
            }
        }
        return entityMap;
    }

    private DynamicObject[] getLatestVersion(DynamicObject[] infoObjs) {
        HashMap latestMap = Maps.newHashMapWithExpectedSize((int)infoObjs.length);
        for (DynamicObject info : infoObjs) {
            latestMap.putIfAbsent(info.getLong("boid"), info);
        }
        return new HashSet(latestMap.values()).toArray(new DynamicObject[0]);
    }

    private void mergePersonInfo(Map<Long, DynamicObject> result, Map<String, String> fieldMap, PersonInfoService service, DynamicObject[] infoObjs) {
        HashMap latestMap = Maps.newHashMapWithExpectedSize((int)result.size());
        for (DynamicObject info : infoObjs) {
            long personId = service.getPersonId(info);
            DynamicObject iitPerson = result.get(personId);
            DynamicObject latest = (DynamicObject)latestMap.get(personId);
            if (service.newerThan(latest, info)) continue;
            latestMap.put(personId, info);
            this.setIitPersonField(iitPerson, info, fieldMap);
        }
    }

    private void setIitPersonField(DynamicObject iItPersonObject, DynamicObject personInfoObj, Map<String, String> fieldMap) {
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            String hrpiField = entry.getKey();
            String iitField = entry.getValue();
            iItPersonObject.set(iitField, personInfoObj.get(hrpiField));
        }
        LOGGER.debug("  personInfoObj : {}", (Object)DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{personInfoObj}, (DynamicObjectType)iItPersonObject.getDynamicObjectType()));
        String name = personInfoObj.getDataEntityType().getName();
        if (StringUtils.startsWithIgnoreCase((String)name, (String)"hrpi_")) {
            String field = name.replace("hrpi_", "");
            iItPersonObject.set(field, (Object)personInfoObj);
        }
        LOGGER.debug("  iItPersonObject : {}", (Object)DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{iItPersonObject}, (DynamicObjectType)iItPersonObject.getDynamicObjectType()));
    }

    @Override
    public DynamicObject findById(Map<String, Long> relateIds, Set<String> props) {
        LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize((int)1);
        Long personId = relateIds.get("hrpi_person");
        if (null == personId || 0L >= personId) {
            return null;
        }
        result.computeIfAbsent(personId, ky -> BusinessDataServiceHelper.newDynamicObject((String)"iit_person"));
        props = CollectionUtils.isEmpty(props) ? PROP_MAPPING.keySet() : props;
        Map<String, Map<String, String>> entityMap = this.generateEntityMap(props);
        for (Map.Entry<String, Map<String, String>> entry : entityMap.entrySet()) {
            Map<String, String> fieldMap = entry.getValue();
            Set<String> specificProps = fieldMap.keySet();
            BaseResult<PersonInfoService> baseResult = PersonInfoService.getPersonService(entry.getKey());
            if (!baseResult.isSuccess()) {
                BaseResult.fail((String)baseResult.getMessage());
                continue;
            }
            PersonInfoService service = (PersonInfoService)baseResult.getData();
            Long id = relateIds.get(entry.getKey());
            if (null == id || id <= 0L) continue;
            QFilter filter = new QFilter("id", "=", (Object)id);
            DynamicObject[] infoObjs = service.query(specificProps, filter);
            this.mergePersonInfoByVid(result, fieldMap, personId, infoObjs);
        }
        return (DynamicObject)Lists.newArrayList(result.values()).get(0);
    }

    @Override
    public Map<Long, DynamicObject> findByIdsAndDateRanges(Map<Long, Map<String, Object>> personAndDate, Set<String> props) {
        props = CollectionUtils.isEmpty(props) ? PROP_MAPPING.keySet() : props;
        Map<String, Map<String, String>> entityMap = this.generateEntityMap(props);
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        for (Map.Entry<String, Map<String, String>> entry : entityMap.entrySet()) {
            Map<String, String> fieldMap = entry.getValue();
            Set<String> specificProps = fieldMap.keySet();
            BaseResult<PersonInfoService> baseResult = PersonInfoService.getPersonService(entry.getKey());
            if (!baseResult.isSuccess()) {
                BaseResult.fail((String)baseResult.getMessage());
                continue;
            }
            PersonInfoService service = (PersonInfoService)baseResult.getData();
            HashMap<Long, DynamicObject> map = service.queryByDate(personAndDate, specificProps);
            this.mergePersonInfoByVid(result, fieldMap, map);
        }
        return result;
    }

    @Override
    public Map<String, Map<String, Object>> queryPersonInfosHis(Map<String, Long> hisIdMap, Set<String> props) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)hisIdMap.size());
        Map<String, Map<String, String>> entityMap = this.generateEntityMap(props);
        for (Map.Entry<String, Long> entry : hisIdMap.entrySet()) {
            if (!entityMap.containsKey(entry.getKey())) continue;
            Map<String, String> map = entityMap.get(entry.getKey());
            BaseResult<PersonInfoService> baseResult = PersonInfoService.getPersonService(entry.getKey());
            if (!baseResult.isSuccess()) {
                BaseResult.fail((String)baseResult.getMessage());
                continue;
            }
            PersonInfoService service = (PersonInfoService)baseResult.getData();
            QFilter filter = new QFilter("id", "=", (Object)entry.getValue());
            Object[] infoObjs = service.query(map.keySet(), filter);
            if (null == infoObjs || infoObjs.length <= 0) continue;
            LOGGER.debug("  findByIdList : \u67e5\u8be2\u957f\u5ea6 {}, infoObjs {}, {}", new Object[]{infoObjs.length, entry.getKey(), DynamicObjectSerializeUtil.serialize((Object[])infoObjs, (DynamicObjectType)infoObjs[0].getDynamicObjectType())});
            Object infoObj = infoObjs[0];
            String personIdStr = "";
            personIdStr = entry.getKey().equals("hrpi_person") ? (String)BaseDataConverter.convert((Object)infoObj.getLong("id"), String.class) : (String)BaseDataConverter.convert((Object)infoObj.getLong("person.id"), String.class);
            Map tempMap = result.computeIfAbsent(personIdStr, k1 -> Maps.newHashMapWithExpectedSize((int)props.size()));
            for (Map.Entry<String, String> ent : map.entrySet()) {
                tempMap.put(ent.getValue(), infoObj.get(ent.getKey()));
            }
        }
        return result;
    }

    private void mergePersonInfoByVid(HashMap<Long, DynamicObject> result, Map<String, String> fieldMap, HashMap<Long, DynamicObject> map) {
        map.forEach((taxFileId, person) -> {
            DynamicObject iitPerson = result.computeIfAbsent((Long)taxFileId, ky -> BusinessDataServiceHelper.newDynamicObject((String)"iit_person"));
            this.setIitPersonField(iitPerson, (DynamicObject)person, fieldMap);
        });
    }

    private void mergePersonInfoByVid(Map<Long, DynamicObject> result, Map<String, String> fieldMap, Long personId, DynamicObject[] infoObjs) {
        for (DynamicObject info : infoObjs) {
            DynamicObject iitPerson = result.get(personId);
            this.setIitPersonField(iitPerson, info, fieldMap);
        }
    }

    static {
        PROP_MAPPING.put("id", "hrpi_person.id");
        PROP_MAPPING.put("number", "hrpi_person.number");
        PROP_MAPPING.put("name", "hrpi_person.name");
        PROP_MAPPING.put("credentialstype", "hrpi_percre.credentialstype");
        PROP_MAPPING.put("credentialsnum", "hrpi_percre.number");
        PROP_MAPPING.put("nationality", "hrpi_pernontsprop.nationality");
        PROP_MAPPING.put("birthday", "hrpi_pernontsprop.birthday");
        PROP_MAPPING.put("gender", "hrpi_pernontsprop.gender");
        PROP_MAPPING.put("education", "hrpi_pereduexp.education");
        PROP_MAPPING.put("marriagestatus", "hrpi_pertsprop.marriagestatus");
    }
}

