/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.iit.business.service;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.sit.iit.business.api.TaxBaseDataService;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxBaseDataServiceImpl
implements TaxBaseDataService {
    @Override
    public Map<String, Object> findDataByCountry(Collection<Long> countryIds, List<String> dataProps) {
        BaseResult appRes = SitDataServiceHelper.findAppInfoOfRegions(countryIds);
        if (!appRes.isSuccess()) {
            return BaseResult.packageResult((boolean)false, (int)ResultStatusEnum.ERROR.getCode(), (String)appRes.getMessage(), null);
        }
        Map appIdOfCountry = (Map)appRes.getData();
        HashBasedTable baseData = HashBasedTable.create();
        appIdOfCountry.forEach((countryId, appNumber) -> {
            Map appBaseData = (Map)SITMServiceUtils.invokeSITService((String)appNumber, (String)(appNumber + "BaseDataApiService"), (String)"findBaseData", (Object[])new Object[]{countryId, dataProps});
            Boolean success = (Boolean)BaseDataConverter.convert(appBaseData.get("success"), Boolean.class, (Object)Boolean.FALSE);
            if (!success.booleanValue()) {
                return;
            }
            baseData.putAll((Table)((HashBasedTable)appBaseData.get("data")));
        });
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        result.put("success", Boolean.TRUE);
        result.put("data", baseData);
        result.put("status", 200);
        return result;
    }
}

