/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.accresult;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.enums.DataPrecisionEnum;
import kd.sit.sitbp.common.enums.DataRoundEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SitDateUtil;

public class AccResultHelper {
    private static final Log logger = LogFactory.getLog(AccResultHelper.class);
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMM");
    private static final List<List<Integer>> QUARTERSET = new ArrayList<List<Integer>>(3);

    public static DynamicObject getCurrency(Long currencyId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bd_currency");
        DynamicObject dynamicObject = serviceHelper.queryOne("id,amtprecision", (Object)currencyId);
        if (Objects.nonNull(dynamicObject)) {
            return dynamicObject;
        }
        return null;
    }

    public static int getInstanceNum(Date startDate) {
        if (Objects.isNull(startDate)) {
            return 0;
        }
        return SitDateUtil.toYearMonth((Date)startDate);
    }

    public static void setEndDateAndCurrency(DynamicObject accResultDy, DynamicObject currency) {
        long dataTypeId = accResultDy.getLong("accumulator.datatype.id");
        if (SitDataTypeEnum.AMOUNT == SitDataTypeEnum.getEnumById((long)dataTypeId)) {
            accResultDy.set("currency", (Object)currency);
        } else if (SitDataTypeEnum.NUMBER == SitDataTypeEnum.getEnumById((long)dataTypeId)) {
            accResultDy.set("currency", null);
        }
        String periodType = accResultDy.getString("accumulator.periodtype");
        Date startDate = accResultDy.getDate("startdate");
        LocalDateTime localDateTimeStartDate = startDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDateTime();
        int actualStartDay = accResultDy.getInt("accumulator.startday");
        if ("1".equals(periodType) || "2".equals(periodType)) {
            int year = localDateTimeStartDate.getYear();
            int month = localDateTimeStartDate.getMonthValue();
            int day = localDateTimeStartDate.getDayOfMonth();
            int lastDayOfMonth = LocalDate.of(year, month, 1).with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
            day = Math.min(day, lastDayOfMonth);
            LocalDateTime tmpStartDate = LocalDateTime.of(localDateTimeStartDate.getYear(), month, day, 0, 0, 0);
            LocalDateTime tmpEndDate = "1".equals(periodType) ? AccResultHelper.setYearPeriodTypeAccEndDate(tmpStartDate, actualStartDay) : AccResultHelper.setQuarterPeriodTypeAccEndDate(tmpStartDate, actualStartDay);
            tmpEndDate = tmpEndDate.plusHours(23L).plusMinutes(59L).plusSeconds(59L);
            Date modifyStartDate = Date.from(tmpStartDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
            Date endDate = Date.from(tmpEndDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
            accResultDy.set("startdate", (Object)modifyStartDate);
            accResultDy.set("enddate", (Object)endDate);
        } else if ("3".equals(periodType)) {
            int year = localDateTimeStartDate.getYear();
            int month = localDateTimeStartDate.getMonthValue();
            int day = localDateTimeStartDate.getDayOfMonth();
            int lastDayOfMonth = LocalDate.of(year, month, 1).with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
            day = Math.min(day, lastDayOfMonth);
            LocalDateTime tmpStartDate = LocalDateTime.of(year, month, day, 0, 0, 0);
            LocalDateTime tmpEndDate = AccResultHelper.setMonthPeriodTypeAccEndDate(tmpStartDate, actualStartDay);
            tmpEndDate = tmpEndDate.plusHours(23L).plusMinutes(59L).plusSeconds(59L);
            Date modifyStartDate = Date.from(tmpStartDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
            Date endDate = Date.from(tmpEndDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
            accResultDy.set("startdate", (Object)modifyStartDate);
            accResultDy.set("enddate", (Object)endDate);
        } else {
            LocalDateTime endDate = LocalDateTime.of(2999, 12, 31, 23, 59, 59);
            accResultDy.set("enddate", (Object)Date.from(endDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant()));
        }
    }

    public static void setOtherValue(DynamicObject accResultDy) {
        DynamicObjectCollection accResultEntry = accResultDy.getDynamicObjectCollection("accresultentry");
        if (CollectionUtils.isEmpty((Collection)accResultEntry)) {
            accResultDy.set("ischanged", (Object)YesOrNoEnum.NO.getCode());
        } else {
            accResultDy.set("ischanged", (Object)YesOrNoEnum.YES.getCode());
        }
        boolean fromDatabase = accResultDy.getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            accResultDy.set("datasource", (Object)"1");
        }
    }

    public static DynamicObject[] getDateByTaxFileIdAndAccIdAndInstanceNum(Set<Long> taxFileIdSet, Set<Long> accIdSet, Set<Integer> instanceNumSet) {
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)3);
        qFilters.add(new QFilter("taxfile.id", "in", taxFileIdSet));
        qFilters.add(new QFilter("accumulator.id", "in", accIdSet));
        qFilters.add(new QFilter("instancenum", "in", instanceNumSet));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_accresult");
        return helper.query("id,taxfile,accumulator,instancenum", qFilters.toArray(new QFilter[0]));
    }

    public static void updateChangeValueAndCalculateResultValue(DynamicObject dynamicObject) {
        if (Objects.isNull(dynamicObject)) {
            return;
        }
        int amtPrecision = dynamicObject.getInt("currency.amtprecision");
        long dataTypeId = dynamicObject.getLong("accumulator.datatype.id");
        long dataRoundId = dynamicObject.getLong("accumulator.dataround.id");
        BigDecimal resultValue = dynamicObject.getBigDecimal("resultvalue");
        int precision = -1;
        if (SitDataTypeEnum.AMOUNT == SitDataTypeEnum.getEnumById((long)dataTypeId)) {
            precision = amtPrecision;
        } else if (SitDataTypeEnum.NUMBER == SitDataTypeEnum.getEnumById((long)dataTypeId)) {
            long dataPrecisionId = dynamicObject.getLong("accumulator.dataprecision.id");
            precision = DataPrecisionEnum.scaleById((long)dataPrecisionId);
        }
        BigDecimal initResultValue = resultValue.setScale(precision, RoundingMode.valueOf(DataRoundEnum.roundById((long)dataRoundId)));
        DynamicObjectCollection accResultEntries = dynamicObject.getDynamicObjectCollection("accresultentry");
        for (DynamicObject accResultEntry : accResultEntries) {
            if (accResultEntry.getLong("id") != 0L) continue;
            BigDecimal changeValue = accResultEntry.getBigDecimal("changevalue");
            BigDecimal newChangeValue = changeValue.setScale(precision, RoundingMode.valueOf(DataRoundEnum.roundById((long)dataRoundId)));
            accResultEntry.set("changevalue", (Object)newChangeValue);
            initResultValue = initResultValue.add(newChangeValue);
        }
        dynamicObject.set("resultvalue", (Object)initResultValue);
    }

    public static LocalDate checkInstanceNum(Integer newInstanceNum) throws Exception {
        if (newInstanceNum < 197001 || newInstanceNum > 299912) {
            throw new KDBizException("the range of instanceNum is wrong");
        }
        YearMonth parse = YearMonth.parse(newInstanceNum.toString(), formatter);
        return parse.atDay(1);
    }

    public static BaseResult<String> checkInstanceNum(DynamicObject accResultDy) {
        LocalDate inputStartDate;
        int instanceNum = accResultDy.getInt("instancenum");
        try {
            inputStartDate = AccResultHelper.checkInstanceNum(instanceNum);
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u7d2f\u52a0\u5b9e\u4f8b\u53f7\u7684\u683c\u5f0f\u6709\u8bef\u3002", (String)"AccResultHelper_0", (String)"sit-itc-business", (Object[])new Object[0]);
            return new BaseResult(false, (Object)msg, msg);
        }
        String periodType = accResultDy.getString("accumulator.periodtype");
        if ("1".equals(periodType)) {
            int startMonthVal = accResultDy.getInt("accumulator.startmonthval");
            int inputMonthValue = inputStartDate.getMonthValue();
            if (inputMonthValue != startMonthVal) {
                String msg = ResManager.loadKDString((String)"\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u4e0e\u6240\u9009\u7d2f\u52a0\u5668\u7684\u5f00\u59cb\u6708\u503c\u4e0d\u540c\u3002", (String)"AccResultHelper_1", (String)"sit-itc-business", (Object[])new Object[0]);
                return new BaseResult(false, (Object)msg, msg);
            }
        } else if ("2".equals(periodType)) {
            int inputMonthValue;
            int startMonthVal = accResultDy.getInt("accumulator.startmonthval");
            BaseResult<String> result = AccResultHelper.checkMonthValueInQuarterAcc(startMonthVal, inputMonthValue = inputStartDate.getMonthValue());
            if (!result.isSuccess()) {
                return result;
            }
        } else if ("4".equals(periodType)) {
            Date startDate = accResultDy.getDate("accumulator.startdate");
            LocalDateTime accStartDate = LocalDateTime.ofInstant(startDate.toInstant(), KDDateUtils.getSysTimeZone().toZoneId());
            int accStartDateYear = accStartDate.getYear();
            int accStartDateMonthValue = accStartDate.getMonthValue();
            int inputStartDateYear = inputStartDate.getYear();
            int inputStartDateMonthValue = inputStartDate.getMonthValue();
            if (accStartDateYear != inputStartDateYear || accStartDateMonthValue != inputStartDateMonthValue) {
                String msg = ResManager.loadKDString((String)"\u586b\u5199\u7d2f\u52a0\u5b9e\u4f8b\u53f7\u548c\u7d2f\u52a0\u5668\u7684\u5f00\u59cb\u5e74\u6708\u503c\u4e0d\u540c\u3002", (String)"AccResultHelper_2", (String)"sit-itc-business", (Object[])new Object[0]);
                return new BaseResult(false, (Object)msg, msg);
            }
        }
        if ("1".equals(periodType) || "2".equals(periodType) || "3".equals(periodType)) {
            int startDay = accResultDy.getInt("accumulator.startday");
            int lastDayOfMonth = inputStartDate.with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth();
            startDay = Math.min(startDay, lastDayOfMonth);
            LocalDateTime tmpStartDate = LocalDateTime.of(inputStartDate.getYear(), inputStartDate.getMonthValue(), startDay, 0, 0, 0);
            Date startDate = Date.from(tmpStartDate.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
            accResultDy.set("startdate", (Object)startDate);
        } else if ("4".equals(periodType)) {
            Date startDate = accResultDy.getDate("accumulator.startdate");
            accResultDy.set("startdate", (Object)startDate);
        }
        return new BaseResult(true, (Object)"", "");
    }

    public static BaseResult<String> checkEntry(DynamicObject accResultDy, boolean mustInput) {
        DynamicObjectCollection accResultEntries = accResultDy.getDynamicObjectCollection("accresultentry");
        boolean fromDatabase = accResultDy.getDataEntityState().getFromDatabase();
        if (CollectionUtils.isEmpty((Collection)accResultEntries) && mustInput && fromDatabase) {
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u66f4\u65b0\u6570\u636e\u65f6\uff0c\u8c03\u6574\u503c\u548c\u8c03\u6574\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccResultHelper_3", (String)"sit-itc-business", (Object[])new Object[0]);
            return new BaseResult(false, (Object)msg, msg);
        }
        boolean entryAllFromDB = true;
        for (DynamicObject accResultEntry : accResultEntries) {
            boolean entryFromDB = accResultEntry.getDataEntityState().getFromDatabase();
            if (!entryFromDB) {
                entryAllFromDB = false;
            }
            BigDecimal changeValue = accResultEntry.getBigDecimal("changevalue");
            String changeReason = accResultEntry.getString("changereason");
            if (!Objects.isNull(changeValue) && BigDecimal.ZERO.compareTo(changeValue) != 0 && !Strings.isNullOrEmpty((String)changeReason)) continue;
            String msg = ResManager.loadKDString((String)"\u8c03\u6574\u8bb0\u5f55\u4e2d\uff0c\u8c03\u6574\u503c\u4e0d\u80fd\u4e3a0\u6216\u8c03\u6574\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccResultHelper_4", (String)"sit-itc-business", (Object[])new Object[0]);
            return new BaseResult(false, (Object)msg, msg);
        }
        if (mustInput && fromDatabase && entryAllFromDB) {
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u66f4\u65b0\u6570\u636e\u65f6\uff0c\u8c03\u6574\u503c\u548c\u8c03\u6574\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccResultHelper_5", (String)"sit-itc-business", (Object[])new Object[0]);
            return new BaseResult(false, (Object)msg, msg);
        }
        return new BaseResult(true, (Object)"", "");
    }

    public static BaseResult<String> checkTaxFile(DynamicObject accResultDy, Set<Long> taxFileBoIdSet) {
        String taxStatus = accResultDy.getString("taxfile.taxstatus");
        Long taxRegionId = accResultDy.getLong("taxfile.taxregion.id");
        Long taxFileBoId = accResultDy.getLong("taxfile.id");
        if (YesOrNoEnum.NO.getCode().equals(taxStatus)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6863\u6848\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u4e14\u7b97\u7a0e\u72b6\u6001\u4e3a\u6b63\u5e38\u7b97\u7a0e\u7684\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u7f16\u53f7\u3002", (String)"AccResultHelper_6", (String)"sit-itc-business", (Object[])new Object[0]);
            return new BaseResult(false, (Object)msg, msg);
        }
        if (!taxRegionId.equals(1000001L)) {
            String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u6863\u6848\u7684\u4e2a\u7a0e\u7ba1\u7406\u5c5e\u5730\u5fc5\u987b\u662f\u4e2d\u56fd\u3002", (String)"AccResultHelper_7", (String)"sit-itc-business", (Object[])new Object[0]);
            return new BaseResult(false, (Object)msg, msg);
        }
        if (!CollectionUtils.isEmpty(taxFileBoIdSet)) {
            if (!taxFileBoIdSet.contains(taxFileBoId)) {
                String msg = ResManager.loadKDString((String)"\u8be5\u6863\u6848\u4e0d\u5728\u5f53\u524d\u7528\u6237\u7684\u6743\u9650\u8303\u56f4\u5185\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"AccResultHelper_8", (String)"sit-itc-business", (Object[])new Object[0]);
                return new BaseResult(false, (Object)msg, msg);
            }
        } else {
            String msg = ResManager.loadKDString((String)"\u8be5\u6863\u6848\u4e0d\u5728\u5f53\u524d\u7528\u6237\u7684\u6743\u9650\u8303\u56f4\u5185\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"AccResultHelper_8", (String)"sit-itc-business", (Object[])new Object[0]);
            return new BaseResult(false, (Object)msg, msg);
        }
        return new BaseResult(true, (Object)"", "");
    }

    public static Set<Long> getTaxFileBoIdSetWithPermissionInAccResult(String permissionStatus) {
        QFilter dataRuleForBdProp;
        ArrayList taxFileQFilters = Lists.newArrayList();
        taxFileQFilters.add(new QFilter("status", "=", (Object)"C"));
        taxFileQFilters.add(new QFilter("enable", "=", (Object)"1"));
        taxFileQFilters.add(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        taxFileQFilters.add(new QFilter("taxregion.id", "=", (Object)1000001L));
        HasPermOrgResult permOrgResult = SITPermissionServiceHelper.getPermOrgs((String)"30", (String)"17/+CT1QBPNP", (String)"itc_accresult", (String)"47150e89000000ac");
        if (!permOrgResult.hasAllOrgPerm()) {
            logger.info("AccResultHelper.getTaxFileBoIdSetWithPermissionInAccResult, org.id is {}", (Object)permOrgResult.getHasPermOrgs());
            taxFileQFilters.add(new QFilter("org.id", "in", (Object)permOrgResult.getHasPermOrgs()));
        }
        if ((dataRuleForBdProp = SITPermissionServiceHelper.getDataRuleForBdProp((long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)"itc_accresult", (String)"taxfile", (String)permissionStatus)) != null) {
            taxFileQFilters.add(dataRuleForBdProp);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"AccResultReportListPlugin#verifyQuery", (String)"itc_taxfile", (String)"id", (QFilter[])taxFileQFilters.toArray(new QFilter[0]), (String)"");){
            logger.info("AccResultHelper.getTaxFileBoIdSetWithPermissionInAccResult, taxFileQFilters is {}", (Object)((Object)taxFileQFilters).toString());
            HashSet taxFileBoIdSet = Sets.newHashSet();
            for (Row row : dataSet) {
                Long boid = row.getLong("id");
                taxFileBoIdSet.add(boid);
            }
            logger.info("AccResultHelper.getTaxFileBoIdSetWithPermissionInAccResult, taxFileBoIdSet is {}", (Object)((Object)taxFileBoIdSet).toString());
            HashSet hashSet = taxFileBoIdSet;
            return hashSet;
        }
    }

    public static BaseResult<String> checkAccumulator(DynamicObject accResultDy) {
        Long countryId = accResultDy.getLong("accumulator.country.id");
        if (!countryId.equals(1000001L)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u4e3a\u4e2d\u56fd\uff0c\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\uff0c\u4f7f\u7528\u72b6\u6001\u4e3a\u53ef\u7528\u7684\u7d2f\u52a0\u5668\u7f16\u7801\u3002", (String)"AccResultHelper_9", (String)"sit-itc-business", (Object[])new Object[0]);
            return new BaseResult(false, (Object)msg, msg);
        }
        return new BaseResult(true, (Object)"", "");
    }

    public static BaseResult<String> checkMonthValueInQuarterAcc(int accMonthValue, int monthValue) {
        for (List<Integer> list : QUARTERSET) {
            if (!list.contains(accMonthValue)) continue;
            if (list.contains(monthValue)) {
                return new BaseResult(true, (Object)"", "");
            }
            String msg = ResManager.loadKDString((String)"\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u5bf9\u5e94\u7684\u6708\u4efd\u5fc5\u987b\u5728{0}\u4e2d\u3002", (String)"AccResultHelper_10", (String)"sit-itc-business", (Object[])new Object[]{list.toString()});
            return new BaseResult(false, (Object)msg, msg);
        }
        String msg = ResManager.loadKDString((String)"\u7d2f\u52a0\u5f00\u59cb\u65e5\u671f\u5bf9\u5e94\u7684\u6708\u4efd\uff0c\u8981\u548c\u7d2f\u52a0\u671f\u95f4\u7c7b\u578b\u4e3a\u6309\u5b63\u7d2f\u8ba1\u7684\u7d2f\u52a0\u5668\u7684\u5f00\u59cb\u6708\u503c\u95f4\u9694\u5b63\u5ea6\u7684\u6574\u6570\u500d\u3002", (String)"AccResultHelper_11", (String)"sit-itc-business", (Object[])new Object[0]);
        return new BaseResult(false, (Object)msg, msg);
    }

    public static Set<Long> getUsedAccResultByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        HashSet result = Sets.newHashSetWithExpectedSize((int)ids.size());
        QFilter idFilter = new QFilter("accresult.id", "in", ids);
        QFilter taxDataIdFilter = new QFilter("taxdataid", "!=", (Object)0);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)AccResultHelper.class.getName(), (String)"itc_accdetail", (String)"accresult.id", (QFilter[])new QFilter[]{idFilter, taxDataIdFilter}, (String)"");){
            dataSet.distinct().forEach(dy -> result.add(dy.getLong("accresult.id")));
        }
        return result;
    }

    public static void deleteAccDetailByAccResultIds(Set<Long> accResultIds) {
        if (CollectionUtils.isEmpty(accResultIds)) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_accdetail");
        QFilter qFilter = new QFilter("accresult.id", "in", accResultIds);
        helper.deleteByFilter(new QFilter[]{qFilter});
    }

    public static boolean checkSingleTaxStatus(ListSelectedRowCollection listSelectedData) {
        Object primaryKeyValue = listSelectedData.getPrimaryKeyValues()[0];
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_accresult");
        DynamicObject dynamicObject = helper.queryOne("id,taxfile.taxstatus", primaryKeyValue);
        String taxStatus = dynamicObject.getString("taxfile.taxstatus");
        return YesOrNoEnum.YES.getCode().equals(taxStatus);
    }

    public static LocalDateTime setYearPeriodTypeAccEndDate(LocalDateTime startDate, int actualStartDay) {
        int nextTwelveMonthDays = startDate.plusMonths(12L).toLocalDate().lengthOfMonth();
        LocalDateTime nextTwelveMonthLDT = startDate.plusMonths(12L);
        if (actualStartDay <= nextTwelveMonthDays) {
            int dayOfMonth = actualStartDay - 1;
            if (dayOfMonth == 0) {
                return startDate.plusMonths(11L).with(TemporalAdjusters.lastDayOfMonth());
            }
            return LocalDateTime.of(nextTwelveMonthLDT.getYear(), nextTwelveMonthLDT.getMonthValue(), dayOfMonth, 0, 0, 0);
        }
        return nextTwelveMonthLDT.with(TemporalAdjusters.lastDayOfMonth()).minusDays(1L);
    }

    public static LocalDateTime setQuarterPeriodTypeAccEndDate(LocalDateTime startDate, int actualStartDay) {
        int nextThreeMonthDays = startDate.plusMonths(3L).toLocalDate().lengthOfMonth();
        LocalDateTime nextThreeMonthLDT = startDate.plusMonths(3L);
        if (actualStartDay <= nextThreeMonthDays) {
            int dayOfMonth = actualStartDay - 1;
            if (dayOfMonth == 0) {
                return startDate.plusMonths(2L).with(TemporalAdjusters.lastDayOfMonth());
            }
            return LocalDateTime.of(nextThreeMonthLDT.getYear(), nextThreeMonthLDT.getMonthValue(), dayOfMonth, 0, 0, 0);
        }
        return nextThreeMonthLDT.with(TemporalAdjusters.lastDayOfMonth()).minusDays(1L);
    }

    public static LocalDateTime setMonthPeriodTypeAccEndDate(LocalDateTime startDate, int actualStartDay) {
        int nextMonthDays = startDate.plusMonths(1L).toLocalDate().lengthOfMonth();
        LocalDateTime nextMonthLDT = startDate.plusMonths(1L);
        if (actualStartDay <= nextMonthDays) {
            int dayOfMonth = actualStartDay - 1;
            if (dayOfMonth == 0) {
                return startDate.with(TemporalAdjusters.lastDayOfMonth());
            }
            return LocalDateTime.of(nextMonthLDT.getYear(), nextMonthLDT.getMonthValue(), dayOfMonth, 0, 0, 0);
        }
        return nextMonthLDT.with(TemporalAdjusters.lastDayOfMonth()).minusDays(1L);
    }

    static {
        QUARTERSET.add(Lists.newArrayList((Object[])new Integer[]{1, 4, 7, 10}));
        QUARTERSET.add(Lists.newArrayList((Object[])new Integer[]{2, 5, 8, 11}));
        QUARTERSET.add(Lists.newArrayList((Object[])new Integer[]{3, 6, 9, 12}));
    }
}

