/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.common;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.api.ItcBaseDataService;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import org.apache.commons.collections.CollectionUtils;

public class ItcBaseDataServiceImpl
implements ItcBaseDataService {
    private static final Log LOGGER = LogFactory.getLog(ItcBaseDataServiceImpl.class);
    private static final Map<String, String> PROP_MAPPING = new HashMap<String, String>(16);

    @Override
    public Map<String, Object> findBaseData(long countryId, List<String> dataProps) {
        if (CollectionUtils.isEmpty(dataProps)) {
            String msg = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5b8c\u6574", (String)"HSASService_03", (String)"sit-itc-mservice", (Object[])new Object[0]);
            return BaseResult.packageResult((boolean)false, (int)ResultStatusEnum.ERROR.getCode(), (String)msg, (Object)Maps.newHashMap());
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        HashBasedTable baseData = HashBasedTable.create();
        result.put("success", Boolean.TRUE);
        result.put("data", baseData);
        result.put("status", 200);
        for (String dataProp : dataProps) {
            String entityName = PROP_MAPPING.get(dataProp);
            if (StringUtils.isEmpty((CharSequence)entityName)) continue;
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
            DynamicObject[] query = helper.query("number,name", new QFilter[0], "number asc");
            LinkedHashMap valueMap = (LinkedHashMap)baseData.get((Object)countryId, (Object)dataProp);
            if (valueMap == null) {
                valueMap = Maps.newLinkedHashMap();
            }
            for (DynamicObject object : query) {
                valueMap.put(object.getString("number"), object.getString("name"));
            }
            baseData.put((Object)countryId, (Object)dataProp, (Object)valueMap);
        }
        return result;
    }

    static {
        PROP_MAPPING.put("taxpayertype", "itc_taxpayertype");
        PROP_MAPPING.put("emptype", "itc_emptype");
    }
}

