/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.common;

import com.alibaba.druid.util.StringUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.entity.NetTaxAlgo;
import kd.sit.sitbp.common.entity.TaxCategoryEntity;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.util.GlobalParam;
import org.apache.commons.collections.MapUtils;

public class SitCommonServiceHelper {
    private SitCommonServiceHelper() {
    }

    public static Map<Long, TaxCategoryEntity> loadAllTaxCategories(long countryId, long groupId) {
        String key = "loadAllTaxCategories" + countryId + "_" + groupId;
        HashMap<Long, TaxCategoryEntity> result = (HashMap<Long, TaxCategoryEntity>)GlobalParam.get((String)key);
        if (!CollectionUtils.isEmpty((Map)result)) {
            return result;
        }
        List<QFilter> filters = SitCommonServiceHelper.genCommonFilter(countryId, true);
        if (groupId != 0L) {
            filters.add(new QFilter("group", "=", (Object)groupId));
        }
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)"sitbs_taxcategory", (String[])new String[]{"id", "number", "name", "group", "taxpayertype"});
        DynamicObject[] query = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)info, (QFilter[])filters.toArray(new QFilter[0]));
        result = new HashMap<Long, TaxCategoryEntity>(query.length);
        for (DynamicObject obj : query) {
            TaxCategoryEntity cat = TaxCategoryEntity.newInstance((DynamicObject)obj);
            result.put(cat.getId(), cat);
        }
        GlobalParam.set((String)key, result);
        return result;
    }

    public static Map<Long, TaxItemEntity> loadTaxItems(long countryId, Collection<Long> ids) {
        QFilter filter = new QFilter("id", "in", ids);
        return SitCommonServiceHelper.loadAllTaxItems(countryId, 0L, 0L, filter);
    }

    public static Map<Long, TaxItemEntity> loadAllTaxItems(long countryId, long categoryId, long groupId, QFilter ... preFilter) {
        List<QFilter> filters = SitCommonServiceHelper.genCommonFilter(countryId, false);
        if (preFilter != null) {
            filters.addAll(Arrays.asList(preFilter));
        }
        if (categoryId != 0L) {
            filters.add(new QFilter("taxcategories.fbasedataid_id", "=", (Object)categoryId));
        }
        if (groupId != 0L) {
            filters.add(new QFilter("taxcategories.fbasedataid.group.id", "=", (Object)groupId));
        }
        PropertiesQueryInfo info = PropertiesQueryInfo.special((String)"sitbs_taxitem", (String[])new String[]{"id", "number", "name", "status", "enable", "taxcategories", "dataround", "datatype", "datalength", "caltaxtype", "incomeitem", "taxitemtype"}).subProp("dataprecision", new String[]{"scale"}).subProp("currency", new String[]{"amtprecision"}).subProp("splitalgo", new String[]{"implclasskey"});
        DynamicObject[] query = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)info, (QFilter[])filters.toArray(new QFilter[0]));
        HashMap<Long, TaxItemEntity> result = new HashMap<Long, TaxItemEntity>(query.length);
        for (DynamicObject obj : query) {
            TaxItemEntity item = TaxItemEntity.newInstance((DynamicObject)obj);
            result.put(item.getId(), item);
        }
        return result;
    }

    public static Map<Long, NetTaxAlgo> loadNetTaxAlgo(long taxCategoryId, long taxGroupId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_nettaxalgo");
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        if (taxCategoryId != 0L) {
            filters.add(new QFilter("taxcategory.id", "=", (Object)taxCategoryId));
        }
        if (taxGroupId != 0L) {
            filters.add(new QFilter("taxcategory.group.id", "=", (Object)taxCategoryId));
        }
        DynamicObject[] query = serviceHelper.query("taxcategory,expression,expression_tag", filters.toArray(new QFilter[0]));
        HashMap<Long, NetTaxAlgo> result = new HashMap<Long, NetTaxAlgo>(query.length);
        for (DynamicObject obj : query) {
            result.put(obj.getLong("taxcategory.id"), new NetTaxAlgo(obj));
        }
        return result;
    }

    private static List<QFilter> genCommonFilter(Long countryId, boolean status) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        filters.add(new QFilter("country.id", "=", (Object)countryId));
        if (status) {
            filters.add(new QFilter("status", "=", (Object)"C"));
            filters.add(new QFilter("enable", "=", (Object)"1"));
        }
        return filters;
    }

    public static void addComputeFilter(List<QFilter> allFilters) {
        QFilter computeFilter = new QFilter("taxdatabasic.calstatus", "=", (Object)YesOrNoEnum.YES.getCode());
        allFilters.add(computeFilter);
    }

    public static Map<Long, List<DynamicObject>> getTaxFileEffectRecords(Set<Long> boids) {
        if (CollectionUtils.isEmpty(boids)) {
            return null;
        }
        HRBaseServiceHelper taxFileHelper = new HRBaseServiceHelper("itc_taxfile");
        QFilter fileFilter = new QFilter("boid", "in", boids);
        fileFilter.and("datastatus", "in", (Object)new String[]{"-3", "0", "1", "2"});
        DynamicObject[] fileObjects = taxFileHelper.query("boid,bsed,bsled,taxstatus,status,iscurrentversion", new QFilter[]{fileFilter}, "bsed asc");
        HashMap fileMap = Maps.newHashMapWithExpectedSize((int)boids.size());
        for (DynamicObject fileObject : fileObjects) {
            long taxFileId = fileObject.getLong("boid");
            fileMap.computeIfAbsent(taxFileId, key -> new LinkedList()).add(fileObject);
        }
        return fileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Date> getTaxFileFirstEffectRecords(Set<Long> boids) {
        HashMap fileMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(boids)) {
            return fileMap;
        }
        QFilter fileFilter = new QFilter("boid", "in", boids);
        fileFilter.and("datastatus", "in", (Object)new String[]{"-3", "0", "1", "2"});
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)SitCommonServiceHelper.class.getName(), (String)"itc_taxfile", (String)"boid,bsed", (QFilter[])new QFilter[]{fileFilter}, (String)"");
            GroupbyDataSet groupData = dataSet.groupBy(new String[]{"boid"});
            groupData.min("bsed");
            dataSet = groupData.finish();
            for (Row row : dataSet) {
                fileMap.put(row.getLong("boid"), row.getDate("bsed"));
            }
        }
        return fileMap;
    }

    public static Object setDynamicObj(DynamicObject sourceObj, Map<String, Object> outerInfo, String propertiryName, String entityName) {
        HRBaseServiceHelper taxFileServiceHelper = new HRBaseServiceHelper(entityName);
        if (StringUtils.equals((String)"bd_admindivision", (String)entityName)) {
            Map outerObj = MapUtils.getMap(outerInfo, (Object)propertiryName);
            QFilter filter = new QFilter("status", "=", (Object)"C");
            filter.and("enable", "=", (Object)"1");
            filter.and("id", "=", (Object)(null == outerObj ? MapUtils.getLong(outerInfo, (Object)propertiryName) : outerObj.get("id")));
            DynamicObject query = taxFileServiceHelper.queryOne("id,country.id,fullname,level,longnumber,masterid,name,number,parent.id", new QFilter[]{filter});
            return query;
        }
        DynamicObject obj = taxFileServiceHelper.generateEmptyDynamicObject();
        Long proid = MapUtils.getLong(outerInfo, (Object)propertiryName);
        obj.set("id", (Object)proid);
        return obj;
    }
}

