/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.common.model;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxDataItemWrapper {
    private final String itemValuePropName;
    private final DynamicObject categoryData;
    private final Map<Long, DynamicObject> itemData;

    public TaxDataItemWrapper(DynamicObject categoryData, String itemValuePropName) {
        this.categoryData = categoryData;
        this.itemValuePropName = itemValuePropName;
        if (categoryData.getDataEntityType().getProperties().get((Object)"entryentity") != null) {
            DynamicObjectCollection entryEntity = categoryData.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)entryEntity)) {
                this.itemData = Maps.newHashMapWithExpectedSize((int)entryEntity.size());
                for (DynamicObject entry : entryEntity) {
                    this.itemData.put(entry.getLong("taxitem.id"), entry);
                }
            } else {
                this.itemData = new HashMap<Long, DynamicObject>(0);
            }
        } else {
            this.itemData = new HashMap<Long, DynamicObject>(0);
        }
    }

    public DynamicObject getItemData(Long itemId) {
        return this.itemData.get(itemId);
    }

    public Object getValue(String prop) {
        if (prop.startsWith("it_")) {
            Long itemId = (Long)BaseDataConverter.convert((Object)prop.substring(3), Long.class);
            DynamicObject itemData = this.getItemData(itemId);
            if (itemData != null) {
                return itemData.get(this.itemValuePropName);
            }
            return null;
        }
        return this.categoryData.get(prop);
    }
}

