/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.datasync;

import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.datasync.BaseDataSync;
import kd.sit.sitbp.business.cloudcolla.CloudCollaContextHelper;
import kd.sit.sitbp.business.servicehelper.SITBaseDataHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Sets;

public class ItcTaxFileDataSyncImpl
extends BaseDataSync {
    private static final Log logger = LogFactory.getLog(ItcTaxFileDataSyncImpl.class);
    private static final String BUSINESS_CODE = "ITC_TAXFILE_DATASYNC";
    private static final String BTN_SAVEAFTERAUDIT = "saveafteraudit";
    private static final String OP_AUDIT = "audit";
    private static final String BTN_SAVE = "save";
    private static final String OP_SUBMIT = "submit";
    private static final String OP_UNSUBMIT = "unsubmit";
    private HRBaseServiceHelper fileService = new HRBaseServiceHelper("itc_taxfile");
    private HRBaseServiceHelper employmentService = new HRBaseServiceHelper("itc_employment");
    private String[] employeeProps = new String[]{"taxpayertype", "emptype", "empsituation", "isdeductexps", "empdate", "quitdate", "bsed"};
    private static String originMsg = "ItcTaxFileDataSyncImpl has not handleData,because of flowType value is error !";

    @Override
    public String getBusinessCode() {
        return BUSINESS_CODE;
    }

    @Override
    public boolean match(String businessCode) {
        return StringUtils.isNotBlank((CharSequence)businessCode) && businessCode.equals(BUSINESS_CODE);
    }

    @Override
    public Map<String, Object> handleData(Map<String, Object> params) {
        return null;
    }

    @Override
    public Map<String, Object> handleData(Map<String, Object> commonDataMap, Map<String, Object> taskDataMap) {
        DynamicObject emp;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        resultMap.put("code", 500);
        resultMap.put("errorMsg", originMsg);
        String requestFrom = MapUtils.getString(commonDataMap, (Object)"requestFrom", (String)"hsas");
        resultMap.put("requestFrom", requestFrom);
        Map fieldRuleMap = MapUtils.getMap(taskDataMap, (Object)"fieldRule", Collections.emptyMap());
        DynamicObject data = Optional.ofNullable((List)MapUtils.getObject((Map)fieldRuleMap, (Object)"itc_taxfile")).filter(item -> !CollectionUtils.isEmpty((Collection)item)).map(item -> (DynamicObject)item.get(0)).orElse(null);
        if (data != null) {
            CloudCollaContextHelper.getInstance().parseAndSetCustomizeResultOnlyFlowOutData(data, commonDataMap);
        }
        if ((emp = (DynamicObject)Optional.ofNullable((List)MapUtils.getObject((Map)fieldRuleMap, (Object)"itc_employment")).filter(item -> !CollectionUtils.isEmpty((Collection)item)).map(item -> (DynamicObject)item.get(0)).orElse(null)) != null) {
            CloudCollaContextHelper.getInstance().parseAndSetCustomizeResultOnlyFlowOutData(emp, commonDataMap);
        }
        if (!this.inputParamValidator(commonDataMap, taskDataMap, resultMap).booleanValue() || data == null || emp == null) {
            return resultMap;
        }
        String flowType = (String)commonDataMap.get("flowType");
        Map apiDataMap = (Map)taskDataMap.get("apiDataList");
        List employeeList = (List)apiDataMap.get("hsas_employee");
        List personList = (List)apiDataMap.get("hsas_personhr");
        Set<Long> changeTaxFileIds = this.getChangeTaxFileId(commonDataMap);
        if (CollectionUtils.isEmpty((Collection)employeeList)) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u85aa\u4f01\u4e1a\u4eba\u4fe1\u606f\uff08hsas_employee\uff09\u4e3a\u7a7a\uff01", (String)"ItcTaxFileDataSyncImpl_2", (String)"sit-itc-business", (Object[])new Object[0]));
            return resultMap;
        }
        DynamicObject employee = employeeList.stream().filter(obj -> obj.getBoolean("iscurrentversion")).findFirst().orElse(null);
        if (employee == null || Objects.isNull(employee.get("person")) || CollectionUtils.isEmpty((Collection)personList) || Objects.isNull(personList.get(0))) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u4ece\u8ba1\u85aa\u4f01\u4e1a\u4eba\u4e2d\u83b7\u53d6\u8ba1\u85aa\u4eba\u5458\uff08person\uff09\u4e3a\u7a7a\uff01", (String)"ItcTaxFileDataSyncImpl_3", (String)"sit-itc-business", (Object[])new Object[0]));
            return resultMap;
        }
        Long personId = employee.getLong("person.id");
        logger.info("ItcTaxFileDataSync begin sync person.name is:{},empnumber is:{},person.id is:{}", new Object[]{employee.getString("person.name"), employee.getString("empnumber"), employee.getLong("person.id")});
        HashMap<String, Long> resultData = new HashMap<String, Long>(8);
        resultData.put("personId", personId);
        resultMap.put("data", resultData);
        if (StringUtils.isBlank((CharSequence)flowType) || flowType.equals("2") || flowType.equals("0")) {
            this.outflowDataSync(personId, data, fieldRuleMap, resultMap, employee, commonDataMap);
        } else if (flowType.equals("1")) {
            this.inflowDataSync(personId, data, fieldRuleMap, resultMap, employee, changeTaxFileIds, commonDataMap);
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Long> getChangeTaxFileId(Map<String, Object> commonDataMap) {
        HashSet changeTaxFileIds = Sets.newHashSetWithExpectedSize((int)2);
        HashSet taxFileIds = Sets.newHashSetWithExpectedSize((int)4);
        Map flowOutResult = (Map)commonDataMap.get("flowOutResult");
        if (!CollectionUtils.isEmpty((Map)flowOutResult)) {
            logger.info("kd/sit/itc/business/datasync/ItcTaxFileDataSyncImpl----flowOutResult:---{}", (Object)flowOutResult);
            List itcTaxfiles = (List)flowOutResult.get("itc_taxfile");
            logger.info("kd/sit/itc/business/datasync/ItcTaxFileDataSyncImpl----itcTaxfiles:---{}", (Object)itcTaxfiles);
            if (!CollectionUtils.isEmpty((Collection)itcTaxfiles)) {
                for (Map itcTaxfile : itcTaxfiles) {
                    Long taxFileId = MapUtils.getLong((Map)itcTaxfile, (Object)"dataId");
                    changeTaxFileIds.add(taxFileId);
                }
            }
        }
        if (CollectionUtils.isEmpty((Collection)changeTaxFileIds)) {
            return taxFileIds;
        }
        QFilter idFilter = new QFilter("id", "in", (Object)changeTaxFileIds);
        try (DataSet dataSet = null;){
            dataSet = this.fileService.queryDataSet("QueryServiceHelper", "boid", new QFilter[]{idFilter});
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                taxFileIds.add(row.getLong("boid"));
            }
        }
        logger.info("kd/sit/itc/business/datasync/ItcTaxFileDataSyncImpl.getChangeTaxFileId----taxFileIds:---{}", (Object)taxFileIds);
        return taxFileIds;
    }

    private DynamicObject getHrpiPerson(long personId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_person");
        return serviceHelper.loadSingle((Object)personId);
    }

    private Boolean inputParamValidator(Map<String, Object> commonDataMap, Map<String, Object> taskDataMap, Map<String, Object> resultMap) {
        if (Objects.isNull(commonDataMap)) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u53c2\u6570 commonDataMap \u4e3a\u7a7a\uff01", (String)"ItcTaxFileDataSyncImpl_5", (String)"sit-itc-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (Objects.isNull(taskDataMap) || Objects.isNull(taskDataMap.get("apiDataList"))) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u53c2\u6570 taskDataMap\u6216\u8005apiDataList \u4e3a\u7a7a\uff01", (String)"ItcTaxFileDataSyncImpl_6", (String)"sit-itc-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Map fieldRuleMap = (Map)taskDataMap.get("fieldRule");
        if (Objects.isNull(fieldRuleMap) || Objects.isNull(fieldRuleMap.get("itc_taxfile"))) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u53c2\u6570 fieldRule \u4e3a\u7a7a,\u6216\u8005itc_taxfile\u4e3a\u7a7a\uff01", (String)"ItcTaxFileDataSyncImpl_15", (String)"sit-itc-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        DynamicObject data = Optional.ofNullable((List)fieldRuleMap.get("itc_taxfile")).filter(item -> !CollectionUtils.isEmpty((Collection)item)).map(item -> (DynamicObject)item.get(0)).orElse(null);
        if (Objects.isNull(data)) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u53c2\u6570 itc_taxfile \u4e3a\u7a7a\uff01", (String)"ItcTaxFileDataSyncImpl_4", (String)"sit-itc-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (Objects.isNull(data.get("taxunit"))) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u53c2\u6570: \u7eb3\u7a0e\u5355\u4f4d(taxunit)\u4e3a\u7a7a\uff01", (String)"ItcTaxFileDataSyncImpl_7", (String)"sit-itc-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (Objects.isNull(data.get("org"))) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u53c2\u6570: \u4e2a\u7a0e\u7ba1\u7406\u7ec4\u7ec7(org)\u4e3a\u7a7a\uff01", (String)"ItcTaxFileDataSyncImpl_8", (String)"sit-itc-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (fieldRuleMap.get("itc_employment") == null || CollectionUtils.isEmpty((Collection)((List)fieldRuleMap.get("itc_employment")))) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u53c2\u6570: \u4efb\u804c\u53d7\u96c7\u5b9e\u4f53(itc_employment)\u4e3a\u7a7a\uff01", (String)"ItcTaxFileDataSyncImpl_19", (String)"sit-itc-business", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void inflowDataSync(Long personId, DynamicObject data, Map<String, Object> fieldRuleMap, Map<String, Object> resultMap, DynamicObject employee, Set<Long> changeTaxFileIds, Map<String, Object> commonDataMap) {
        Long taxUnitId = data.getLong("taxunit.id");
        Object[] dynamicObjects = this.getItcTaxFile(personId, taxUnitId);
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            if (data.getString("taxstatus").equals("0")) {
                resultMap.put("errorMsg", ResManager.loadKDString((String)"\u65b0\u589e\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u65f6\uff0c\u201c\u7b97\u7a0e\u72b6\u6001\u201d\u4e0d\u80fd\u662f\u505c\u6b62\u7b97\u7a0e\u3002", (String)"ItcTaxFileDataSyncImpl_14", (String)"sit-itc-business", (Object[])new Object[0]));
                return;
            }
            this.geneNewTaxFile(employee, data, fieldRuleMap, resultMap, commonDataMap);
        } else {
            DynamicObject taxFile = Arrays.stream(dynamicObjects).filter(obj -> obj.getBoolean("iscurrentversion") && obj.getString("status").equals("C")).findFirst().orElse(null);
            if (taxFile == null) {
                DynamicObject person = employee.getDynamicObject("person");
                resultMap.put("errorMsg", MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\u7684\u4e2a\u7a0e\u6863\u6848\uff08{2}\uff09\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d8\u66f4\u3002", (String)"ItcTaxFileDataSyncImpl_1", (String)"sit-itc-business", (Object[])new Object[0]), person.getString("name"), employee.getString("empnumber"), dynamicObjects[0].getString("number")));
                return;
            }
            boolean changeEmpDate = true;
            logger.info("kd/sit/itc/business/datasync/ItcTaxFileDataSyncImpl.java:265---- boid----{}", (Object)taxFile.getLong("boid"));
            if (changeTaxFileIds.contains(taxFile.getLong("boid"))) {
                changeEmpDate = false;
            }
            this.changeTaxFile(employee, data, taxFile, fieldRuleMap, resultMap, changeEmpDate, commonDataMap);
        }
    }

    private void outflowDataSync(Long personId, DynamicObject data, Map<String, Object> fieldRuleMap, Map<String, Object> resultMap, DynamicObject employee, Map<String, Object> commonDataMap) {
        Long taxunitId = data.getLong("taxunit.id");
        Object[] dynamicObjects = this.getItcTaxFile(personId, taxunitId);
        DynamicObject person = employee.getDynamicObject("person");
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            resultMap.put("errorMsg", MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\u672a\u521b\u5efa\u4e2a\u7a0e\u6863\u6848\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d8\u66f4\u3002", (String)"ItcTaxFileDataSyncImpl_0", (String)"sit-itc-business", (Object[])new Object[0]), person.getString("name"), employee.getString("empnumber")));
            return;
        }
        DynamicObject taxFile = Arrays.stream(dynamicObjects).filter(obj -> obj.getBoolean("iscurrentversion") && obj.getString("status").equals("C")).findFirst().orElse(null);
        if (taxFile == null) {
            resultMap.put("errorMsg", MessageFormat.format(ResManager.loadKDString((String)"{0}({1})\u7684\u4e2a\u7a0e\u6863\u6848\uff08{2}\uff09\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d8\u66f4\u3002", (String)"ItcTaxFileDataSyncImpl_1", (String)"sit-itc-business", (Object[])new Object[0]), person.getString("name"), employee.getString("empnumber"), dynamicObjects[0].getString("number")));
            return;
        }
        this.changeTaxFile(employee, data, taxFile, fieldRuleMap, resultMap, false, commonDataMap);
    }

    private void geneNewTaxFile(DynamicObject employee, DynamicObject data, Map<String, Object> fieldRuleMap, Map<String, Object> resultMap, Map<String, Object> commonDataMap) {
        block7: {
            DynamicObject newTaxFile = this.fileService.generateEmptyDynamicObject();
            DynamicObject newEmpObject = this.employmentService.generateEmptyDynamicObject();
            this.assembleTaxFileObj(employee, data, newTaxFile, commonDataMap);
            this.assembleEmploymentObj(newEmpObject, fieldRuleMap, true, commonDataMap);
            DynamicObject bdCountry = new HRBaseServiceHelper("bd_country").generateEmptyDynamicObject();
            bdCountry.set("id", (Object)1000001L);
            newTaxFile.set("taxregion", (Object)bdCountry);
            ORM orm = ORM.create();
            Long fileId = orm.genLongId("itc_taxfile");
            Long employeeId = orm.genLongId("itc_employment");
            newTaxFile.set("id", (Object)fileId);
            newTaxFile.set("status", (Object)"A");
            newTaxFile.set("creator", (Object)RequestContext.get().getCurrUserId());
            newEmpObject.set("id", (Object)employeeId);
            newEmpObject.set("taxfile", (Object)newTaxFile);
            newEmpObject.set("status", (Object)"A");
            newEmpObject.set("creator", (Object)RequestContext.get().getCurrUserId());
            Map resultData = (Map)resultMap.get("data");
            if (ObjectUtils.isNotEmpty(resultData.get("personId"))) {
                HashMap fileRelaMap = new HashMap(8);
                fileRelaMap.put(resultData.get("personId"), fileId);
                resultData.put("fileRelaMap", fileRelaMap);
            }
            resultData.put("itcTaxFileBoId", fileId);
            this.invokeOperate(BTN_SAVE, newTaxFile, newEmpObject, resultMap);
            if (null != resultMap.get("code") && (Integer)resultMap.get("code") == 200) {
                try {
                    Object[] savedDatas = this.fileService.query(SITBaseDataHelper.getSelectProperties((String)"itc_taxfile"), new QFilter[]{new QFilter("id", "=", (Object)fileId), new QFilter("status", "=", (Object)"A")});
                    if (ArrayUtils.isEmpty((Object[])savedDatas)) {
                        logger.info("kd/sit/itc/business/datasync/ItcTaxFileDataSyncImpl.java:302");
                        return;
                    }
                    this.invokeOperate(OP_SUBMIT, (DynamicObject[])savedDatas, resultMap);
                    logger.info("kd/sit/itc/business/datasync/ItcTaxFileDataSyncImpl.java:306 resultMap code:{}", resultMap.get("code"));
                    Object[] submitDatas = this.fileService.query(SITBaseDataHelper.getSelectProperties((String)"itc_taxfile"), new QFilter[]{new QFilter("id", "=", (Object)fileId), new QFilter("status", "=", (Object)"B")});
                    if (ArrayUtils.isEmpty((Object[])submitDatas)) {
                        logger.info("kd/sit/itc/business/datasync/ItcTaxFileDataSyncImpl.java:314 ");
                        return;
                    }
                    boolean auditResult = this.invokeOperate(OP_AUDIT, (DynamicObject[])submitDatas, resultMap);
                    if (!auditResult) {
                        this.invokeOperate(OP_UNSUBMIT, (DynamicObject[])submitDatas, resultMap);
                    }
                }
                catch (Exception ex) {
                    resultMap.put("code", 200);
                    logger.error("ItcTaxFileDataSync.invokeOperate error: ", (Throwable)ex);
                    if (!Objects.isNull(resultMap.get("errorMsg")) && !originMsg.equals(resultMap.get("errorMsg"))) break block7;
                    resultMap.put("errorMsg", ex.getMessage());
                }
            }
        }
    }

    private void changeTaxFile(DynamicObject employee, DynamicObject data, DynamicObject taxFile, Map<String, Object> fieldRuleMap, Map<String, Object> resultMap, boolean changeEmpDate, Map<String, Object> commonDataMap) {
        CloudCollaContextHelper.getInstance().parseAndSetCustomizeResultOnlyExistData(data, commonDataMap, taxFile);
        if (taxFile.getLong("org.id") != data.getLong("org.id")) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u4e2a\u7a0e\u7ba1\u7406\u7ec4\u7ec7\u201d\u7981\u6b62\u4fee\u6539\u3002", (String)"ItcTaxFileDataSyncImpl_22", (String)"sit-itc-business", (Object[])new Object[0]));
            return;
        }
        if (taxFile.getLong("taxunit.id") != data.getLong("taxunit.id")) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u7eb3\u7a0e\u5355\u4f4d\u201d\u7981\u6b62\u4fee\u6539\u3002", (String)"ItcTaxFileDataSyncImpl_23", (String)"sit-itc-business", (Object[])new Object[0]));
            return;
        }
        this.assembleTaxFileObj(employee, data, taxFile, commonDataMap);
        DynamicObject employmentObject = this.getItcTaxEmployment(taxFile.getLong("boid"));
        List employmentList = (List)MapUtils.getObject(fieldRuleMap, (Object)"itc_employment", Collections.emptyList());
        if (!CollectionUtils.isEmpty((Collection)employmentList)) {
            CloudCollaContextHelper.getInstance().parseAndSetCustomizeResultOnlyExistData((DynamicObject)employmentList.get(0), commonDataMap, employmentObject);
        }
        if (ObjectUtils.isEmpty((Object)employmentObject)) {
            resultMap.put("errorMsg", ResManager.loadKDString((String)"\u4e2a\u7a0e\u6863\u6848\u4e2d\u672a\u627e\u5230\u5f53\u524d\u7248\u672c\u751f\u6548\u7684\u4efb\u804c\u53d7\u96c7\u4fe1\u606f\uff01", (String)"ItcTaxFileDataSyncImpl_12", (String)"sit-itc-business", (Object[])new Object[0]));
            return;
        }
        this.assembleEmploymentObj(employmentObject, fieldRuleMap, changeEmpDate, commonDataMap);
        this.invokeOperate(BTN_SAVEAFTERAUDIT, taxFile, employmentObject, resultMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOperate(String operationKey, DynamicObject taxFile, DynamicObject employmentObject, Map<String, Object> resultMap) {
        String requestFrom = MapUtils.getString(resultMap, (Object)"requestFrom", (String)"hsas");
        try (TXHandle tx = "hsas".equalsIgnoreCase(requestFrom) ? TX.requiresNew() : TX.required();){
            String taxStatus = taxFile.getString("taxstatus");
            if ("0".equals(taxStatus)) {
                this.changEmployment(operationKey, employmentObject, resultMap);
                this.changeTaxFile(operationKey, taxFile, resultMap);
            } else {
                this.changeTaxFile(operationKey, taxFile, resultMap);
                this.changEmployment(operationKey, employmentObject, resultMap);
            }
            resultMap.put("errorMsg", null);
            resultMap.put("code", 200);
            logger.info("success resultMap code is:{}, errorMsg is:{}", resultMap.get("code"), resultMap.get("errorMsg"));
        }
    }

    private void changEmployment(String operationKey, DynamicObject employmentObject, Map<String, Object> resultMap) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperationResult empResult = opImpl.localInvokeOperation(operationKey, new DynamicObject[]{employmentObject}, this.createOption());
        logger.info("[colla] start invoke ItcTaxFileDataSyncImpl itcEmployment {} op", (Object)operationKey);
        if (!empResult.isSuccess()) {
            StringBuilder msgSb = new StringBuilder();
            msgSb.append(empResult.getMessage());
            List allErrorOrValidateInfo = empResult.getAllErrorOrValidateInfo();
            if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                allErrorOrValidateInfo.forEach(obj -> {
                    logger.info("[colla] ItcTaxFileDataSync.invokeOperate invoke OP error : operationKey= {},  entityNumber = {},  id = {},  msg =  {}", new Object[]{operationKey, "itc_employment", obj.getPkValue(), obj.getMessage()});
                    msgSb.append(obj.getMessage());
                });
            }
            resultMap.put("errorMsg", msgSb.toString());
            String errorMsg = "itcEmployee save/saveAfterAudit validator error:" + resultMap.get("errorMsg");
            logger.info(errorMsg);
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c employee operation \u6821\u9a8c\u5931\u8d25\uff01", (String)"ItcTaxFileDataSyncImpl_16", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        List dataList = (List)resultMap.computeIfAbsent("executeResult", item -> new ArrayList(10));
        dataList.addAll(this.addExecuteResult(employmentObject.getDataEntityType().getName(), empResult, operationKey));
    }

    private OperateOption createOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("skipCheckDataPermission", "true");
        option.setVariableValue("skipCheckSpecialDataPermission", "true");
        option.setVariableValue("cloudcolla", "true");
        return option;
    }

    private void changeTaxFile(String operationKey, DynamicObject taxFile, Map<String, Object> resultMap) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperationResult fileResult = opImpl.localInvokeOperation(operationKey, new DynamicObject[]{taxFile}, this.createOption());
        logger.info("[colla] invoke ItcTaxFileDataSyncImpl itcTaxFile {} op.", (Object)operationKey);
        if (!fileResult.isSuccess()) {
            StringBuilder msgSb = new StringBuilder();
            msgSb.append(fileResult.getMessage());
            List allErrorOrValidateInfo = fileResult.getAllErrorOrValidateInfo();
            if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                allErrorOrValidateInfo.forEach(obj -> {
                    logger.info("[colla] ItcTaxFileDataSync.invokeOperate invoke OP error : operationKey= {},  entityNumber = {},  id = {},  msg =  {}", new Object[]{operationKey, "itc_taxfile", obj.getPkValue(), obj.getMessage()});
                    msgSb.append(obj.getMessage());
                });
            }
            resultMap.put("errorMsg", msgSb.toString());
            String errorMsg = "itcTaxFile save/saveAfterAudit validator error:" + resultMap.get("errorMsg");
            logger.info(errorMsg);
            throw new KDBizException(ResManager.loadKDString((String)"\u6267\u884c itctaxfile operation \u6821\u9a8c\u5931\u8d25\uff01", (String)"ItcTaxFileDataSyncImpl_17", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        List dataList = (List)resultMap.computeIfAbsent("executeResult", item -> new ArrayList(10));
        dataList.addAll(this.addExecuteResult(taxFile.getDataEntityType().getName(), fileResult, operationKey));
    }

    private List<Map<String, Object>> addExecuteResult(String entityNumber, OperationResult opResult, String type) {
        List successPkIds = opResult.getSuccessPkIds();
        if (CollectionUtils.isEmpty((Collection)successPkIds)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        for (Object successPkId : successPkIds) {
            result.add((Map<String, Object>)ImmutableMap.of((Object)"entityNumber", (Object)entityNumber, (Object)"dataId", successPkId, (Object)"type", (Object)(BTN_SAVEAFTERAUDIT.equals(type) ? "CHANGE" : "NEW")));
        }
        return result;
    }

    private DynamicObject[] getItcTaxFile(Long personId, Long taxunitId) {
        QFilter qFilter = new QFilter("person.id", "=", (Object)personId);
        qFilter.and("taxunit.id", "=", (Object)taxunitId);
        qFilter.and("status", "in", (Object)new String[]{"A", "B", "C"});
        logger.info("kd/sit/itc/business/datasync/ItcTaxFileDataSyncImpl:personId{}---taxunitId:{}", (Object)personId, (Object)taxunitId);
        return this.fileService.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    private DynamicObject getItcTaxEmployment(Long taxfileBoid) {
        QFilter qFilter = new QFilter("taxfile", "=", (Object)taxfileBoid);
        qFilter.and("iscurrentversion", "=", (Object)"1");
        return this.employmentService.loadDynamicObject(new QFilter[]{qFilter});
    }

    private void assembleTaxFileObj(DynamicObject employee, DynamicObject data, DynamicObject taxFile, Map<String, Object> commonMap) {
        CloudCollaContextHelper instance = CloudCollaContextHelper.getInstance();
        instance.copyPropValue(data, taxFile, instance.parseCurrentCollaFields(commonMap, "itc_taxfile"));
        DynamicObject person = this.getHrpiPerson(employee.getLong("person.id"));
        taxFile.set("person", (Object)person);
        logger.info("itctaxfile params,org:{},empgroup:{},taxunit:{},taxstatus:{},bsed:{}", new Object[]{taxFile.getLong("org.id"), taxFile.getLong("empgroup.id"), taxFile.getLong("taxunit.id"), taxFile.getString("taxstatus"), taxFile.getDate("bsed")});
    }

    private void assembleEmploymentObj(DynamicObject empObj, Map<String, Object> fieldRuleMap, boolean changeEmpDate, Map<String, Object> commonDataMap) {
        List empList = (List)MapUtils.getObject(fieldRuleMap, (Object)"itc_employment");
        if (CollectionUtils.isEmpty((Collection)empList)) {
            return;
        }
        this.copyObjProps(empObj, (DynamicObject)empList.get(0), changeEmpDate, commonDataMap);
    }

    private void copyObjProps(DynamicObject newObj, DynamicObject oldObj, boolean changeEmpDate, Map<String, Object> commonDataMap) {
        Set fields = CloudCollaContextHelper.getInstance().parseCurrentCollaFields(commonDataMap, newObj.getDynamicObjectType().getName());
        if (CollectionUtils.isEmpty((Collection)fields)) {
            return;
        }
        fields.forEach(prop -> {
            logger.info("[colla] ItcTaxFileDataSyncImpl.copyObjProps changeEmpDate = {}", (Object)changeEmpDate);
            if (!"empdate".equals(prop) || changeEmpDate) {
                newObj.set(prop, oldObj.get(prop));
                logger.info("[colla] employment params,ItcTaxFileDataSyncImpl prop:{},value:{}", prop, oldObj.get(prop));
            }
        });
    }

    private boolean invokeOperate(String operationKey, DynamicObject[] taxFiles, Map<String, Object> resultMap) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("skipCheckDataPermission", "true");
        option.setVariableValue("skipCheckSpecialDataPermission", "true");
        option.setVariableValue("cloudcolla", "true");
        long startTime = System.currentTimeMillis();
        OperationResult fileResult = opImpl.localInvokeOperation(operationKey, taxFiles, option);
        logger.info("invoke ItcTaxFileDataSyncImpl itcTaxFile op : {}, use time:{}", (Object)operationKey, (Object)(System.currentTimeMillis() - startTime));
        if (!fileResult.isSuccess()) {
            StringBuilder msgSb = new StringBuilder();
            msgSb.append(fileResult.getMessage());
            List allErrorOrValidateInfo = fileResult.getAllErrorOrValidateInfo();
            if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
                allErrorOrValidateInfo.forEach(obj -> {
                    String s1 = "ItcTaxFileDataSync.invokeOperate invoke OP error : operationKey=" + operationKey + " entityNumber = " + "itc_taxfile" + " id = " + obj.getPkValue() + " msg =  " + obj.getMessage();
                    logger.info(s1);
                    msgSb.append(obj.getMessage());
                });
            }
            resultMap.put("errorMsg", msgSb.toString());
            String errorMsg = "itcTaxFile save/saveAfterAudit validator error:" + resultMap.get("errorMsg");
            logger.info(errorMsg);
            return false;
        }
        logger.info("operationKey:{}, success resultMap code is:{}, errorMsg is:{}", new Object[]{operationKey, resultMap.get("code"), resultMap.get("errorMsg")});
        return true;
    }
}

