/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.mq;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class SaveConfMsgConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(SaveConfMsgConsumer.class);
    private static final List<String> BIZAPPIDS = new ArrayList<String>();

    public void onMessage(Object msg, String msgId, boolean resend, MessageAcker acker) {
        try {
            Map body = (Map)msg;
            logger.info("SaveConfMsgConsumer.body:{}", (Object)body.toString());
            String bizAppId = (String)body.get("bizAppId");
            String dataSubjectIdType = (String)body.get("dataSubjectIdType");
            List dataSubjectIds = (List)body.get("dataSubjectIds");
            if (StringUtils.isEmpty((CharSequence)bizAppId) || StringUtils.isEmpty((CharSequence)dataSubjectIdType) || CollectionUtils.isEmpty((Collection)dataSubjectIds)) {
                return;
            }
            RequestContext rc = RequestContext.get();
            logger.info("SaveConfMsgConsumer.TenantId:{},AccountId:{}", (Object)rc.getTenantId(), (Object)rc.getAccountId());
            logger.info("SaveConfMsgConsumer.msgId:{}", (Object)msgId);
            logger.info("SaveConfMsgConsumer.resend:{}", (Object)resend);
            for (String bizApp : BIZAPPIDS) {
                this.onMessageForOneApp(bizApp, dataSubjectIdType, dataSubjectIds);
            }
            acker.ack(msgId);
        }
        catch (Throwable throwable) {
            acker.discard(msgId);
            logger.error("SaveConfMsgConsumer_Exception\uff1a", throwable);
        }
    }

    private void onMessageForOneApp(String bizAppId, String dataSubjectIdType, List dataSubjectIds) {
        DynamicObject[] privacyObjects = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPrivacyService", (String)"getPrivacyRelation", (Object[])new Object[]{bizAppId, dataSubjectIdType});
        if (privacyObjects == null || privacyObjects.length == 0) {
            logger.info("No_Related_Privacy_Save_Config");
            return;
        }
        HashMap<String, Map> ormMap = new HashMap<String, Map>(16);
        for (DynamicObject privacyObject : privacyObjects) {
            DynamicObject anonymousRuleDy = privacyObject.getDynamicObject("anonymousid");
            String params = anonymousRuleDy.getString("params");
            String handleClass = anonymousRuleDy.getString("handleclass");
            Object result = SaveConfMsgConsumer.invoke(handleClass, "getPrivacyRuleResult", params, null);
            DynamicObjectCollection entryCollection = privacyObject.getDynamicObjectCollection("entityentry");
            if (CollectionUtils.isEmpty((Collection)entryCollection)) continue;
            for (DynamicObject entry : entryCollection) {
                DynamicObject entity = entry.getDynamicObject("entity");
                String privacyField = entry.getString("privacyfield");
                String personField = entry.getString("personfield");
                String personFieldIdType = entry.getString("personfieldtype");
                if (Objects.isNull(entity) || StringUtils.isEmpty((CharSequence)privacyField) || StringUtils.isEmpty((CharSequence)personField) || StringUtils.isEmpty((CharSequence)personFieldIdType)) continue;
                String key = this.getMapKey(entity.getString("number"), personField, personFieldIdType);
                Map fieldMap = ormMap.getOrDefault(key, Maps.newHashMapWithExpectedSize((int)16));
                fieldMap.put(privacyField, result);
                ormMap.put(key, fieldMap);
            }
        }
        logger.info("ormMap:{}", (Object)((Object)ormMap).toString());
        for (Map.Entry entry : ormMap.entrySet()) {
            String[] split = ((String)entry.getKey()).split(",");
            HRBaseServiceHelper dataHelper = new HRBaseServiceHelper(split[0]);
            String field = split[1];
            if ("taxfile".equals(split[1])) {
                field = field + ".person";
            }
            List personIds = this.idTransformation(dataSubjectIds, dataSubjectIdType, split[2]);
            QFilter dataFilter = new QFilter(field, "in", (Object)personIds);
            DynamicObject[] handleObjects = dataHelper.loadDynamicObjectArray(new QFilter[]{dataFilter});
            logger.info("handleObjects' length is {}", (Object)handleObjects.length);
            for (DynamicObject handleObject : handleObjects) {
                for (Map.Entry fieldMap : ((Map)entry.getValue()).entrySet()) {
                    String privacyField = (String)fieldMap.getKey();
                    Object result = fieldMap.getValue();
                    if (handleObject.getDataEntityType().getProperties().get((Object)privacyField) instanceof DateTimeProp) {
                        try {
                            Date date = result == null ? null : HRDateTimeUtils.parseDate((String)result.toString());
                            handleObject.set(privacyField, (Object)date);
                        }
                        catch (ParseException exc) {
                            logger.error("setField error:field={},value={}", (Object)field, result);
                        }
                        continue;
                    }
                    if (handleObject.get(privacyField) instanceof OrmLocaleValue) {
                        OrmLocaleValue multiValue = (OrmLocaleValue)handleObject.get(privacyField);
                        for (Map.Entry entry2 : multiValue.entrySet()) {
                            multiValue.put((String)entry2.getKey(), result == null ? null : result.toString());
                        }
                        handleObject.set(privacyField, (Object)multiValue);
                        continue;
                    }
                    handleObject.set(privacyField, result);
                }
            }
            dataHelper.save(handleObjects);
        }
        Object[] pk = (Object[])HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPrivacyService", (String)"setExecStatueCompletedBatch", (Object[])new Object[]{bizAppId, dataSubjectIdType, dataSubjectIds, new Date()});
        if (null != pk && pk.length == dataSubjectIds.size()) {
            logger.info("setExecStatueCompleted_success!");
        } else if (null == pk || 0 == pk.length) {
            logger.error("setExecStatueCompleted_fail!");
        } else {
            logger.error("setExecStatueCompleted_Partial_success!hrcs_retaineddueperson_pk:{}", (Object)Arrays.toString(pk));
        }
    }

    private List idTransformation(List dataSubjectIds, String dataSubjectIdType, String personFieldIdType) {
        if (dataSubjectIdType.equals(personFieldIdType)) {
            return dataSubjectIds;
        }
        return dataSubjectIds;
    }

    protected static Object invoke(String clazzName, String methodName, String params, Object data) {
        String errMsg = "SaveConfMsgConsumer invoke Class error :";
        try {
            Class<?> clazz = Class.forName(clazzName);
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod(methodName, String.class, Object.class);
            return method.invoke(instance, params, data);
        }
        catch (ClassNotFoundException e) {
            logger.error("{} ClassNotFoundException: {}", (Object)errMsg, (Object)e);
        }
        catch (InstantiationException e) {
            logger.error("{} InstantiationException: {}", (Object)errMsg, (Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error("{} IllegalAccessException: {}", (Object)errMsg, (Object)e);
        }
        catch (NoSuchMethodException e) {
            logger.error("{} NoSuchMethodException: {}", (Object)errMsg, (Object)e);
        }
        catch (SecurityException e) {
            logger.error("{} SecurityException: {}", (Object)errMsg, (Object)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("{} IllegalArgumentException: {}", (Object)errMsg, (Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error("{} InvocationTargetException: {}", (Object)errMsg, (Object)e);
        }
        return null;
    }

    private String getMapKey(Object ... args) {
        return String.format(Locale.ROOT, "%s,%s,%s", args);
    }

    static {
        BIZAPPIDS.add("17/+CT1QBPNP");
        BIZAPPIDS.add("2AXKDRPJUQ77");
    }
}

