/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.sdkservice;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sdk.sit.itc.business.tax.data.TaxDataQueryService;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.util.SITStringUtils;

public class TaxDataQueryServiceImpl
implements TaxDataQueryService {
    public static final Map<String, String> FIELDNAME_MAP = new HashMap<String, String>();
    public static final Set<String> BASE_DATASET = Sets.newHashSet((Object[])new String[]{"taxfile", "employment", "investor", "overseasperson", "specialinfo", "taxcontact", "bankcard"});

    public DynamicObjectCollection queryTaxDataList(Collection<String> selectProperties, Collection<QFilter> filters, String orderBy, boolean originalQuery) {
        if (CollectionUtils.isEmpty(filters)) {
            return new DynamicObjectCollection();
        }
        if (CollectionUtils.isEmpty(selectProperties)) {
            selectProperties.add("id");
        }
        if (SITStringUtils.isEmpty((String)orderBy) || "id".equals(orderBy)) {
            if (!selectProperties.contains("id")) {
                selectProperties.add("id");
            }
            orderBy = "id desc";
        }
        String selectPropertiesStr = String.join((CharSequence)",", selectProperties);
        filters.add(new QFilter("status", "!=", (Object)"E"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxdata");
        if (originalQuery) {
            return helper.queryOriginalCollection(selectPropertiesStr, filters.toArray(new QFilter[0]), orderBy);
        }
        DynamicObject[] dys = helper.query(selectPropertiesStr, filters.toArray(new QFilter[0]), orderBy);
        DynamicObjectCollection result = new DynamicObjectCollection();
        result.addAll(Arrays.asList(dys));
        return result;
    }

    public DynamicObjectCollection queryTaxDataListById(Collection<String> selectProperties, Collection<Long> taxDataIds, String orderBy, boolean originalQuery) {
        if (CollectionUtils.isEmpty(taxDataIds)) {
            return new DynamicObjectCollection();
        }
        if (CollectionUtils.isEmpty(selectProperties)) {
            selectProperties.add("id");
        }
        if (SITStringUtils.isEmpty((String)orderBy) || "id".equals(orderBy)) {
            if (!selectProperties.contains("id")) {
                selectProperties.add("id");
            }
            orderBy = "id desc";
        }
        String selectPropertiesStr = String.join((CharSequence)",", selectProperties);
        QFilter filter = new QFilter("id", "in", taxDataIds);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxdata");
        if (originalQuery) {
            return helper.queryOriginalCollection(selectPropertiesStr, new QFilter[]{filter}, orderBy);
        }
        DynamicObject[] dys = helper.query(selectPropertiesStr, new QFilter[]{filter}, orderBy);
        DynamicObjectCollection result = new DynamicObjectCollection();
        result.addAll(Arrays.asList(dys));
        return result;
    }

    public Map<Long, Map<Long, String>> queryTaxDataItems(Collection<Long> taxDataIds, Collection<Long> taxItems, boolean queryItemValue) {
        DynamicObject[] dys;
        HashMap result = Maps.newHashMapWithExpectedSize((int)taxDataIds.size());
        if (CollectionUtils.isEmpty(taxDataIds)) {
            return result;
        }
        QFilter filter = new QFilter("id", "in", taxDataIds);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxdata");
        for (DynamicObject dy : dys = helper.query("id,entryentity.taxitem.id,entryentity.taxitem,entryentity.calvalue,entryentity.itemvalue", new QFilter[]{filter})) {
            long id = dy.getLong("id");
            DynamicObjectCollection entry = dy.getDynamicObjectCollection("entryentity");
            HashMap map = Maps.newHashMapWithExpectedSize((int)entry.size());
            result.put(id, map);
            for (DynamicObject dynamicObject : entry) {
                long taxItemId = dynamicObject.getLong("taxitem.id");
                if (!taxItems.contains(taxItemId)) continue;
                String value = queryItemValue ? dynamicObject.getString("itemvalue") : dynamicObject.getString("calvalue");
                map.put(taxItemId, value);
            }
        }
        return result;
    }

    public Map<Long, Map<String, Object>> queryHisPersonInfos(Collection<Long> taxDataIds, Collection<String> selectProperties) {
        DynamicObject[] basicDataDys;
        HashMap result = Maps.newHashMapWithExpectedSize((int)taxDataIds.size());
        if (CollectionUtils.isEmpty(taxDataIds) || CollectionUtils.isEmpty(selectProperties)) {
            return result;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxdata");
        QFilter filter = new QFilter("id", "in", taxDataIds);
        Object[] dys = helper.queryOriginalArray("id,taxdatabasic.id", new QFilter[]{filter});
        if (ArrayUtils.isEmpty((Object[])dys)) {
            return result;
        }
        Map<Long, List<DynamicObject>> map = Arrays.stream(dys).collect(Collectors.groupingBy(dy -> dy.getLong("taxdatabasic.id")));
        helper = new HRBaseServiceHelper("itc_taxdatabasic");
        String selectPropertiesStr = String.join((CharSequence)",", selectProperties);
        QFilter idsQFilter = new QFilter("id", "in", map.keySet());
        for (DynamicObject basicDataDy : basicDataDys = helper.query(selectPropertiesStr, new QFilter[]{idsQFilter})) {
            long basicId = basicDataDy.getLong("id");
            List<DynamicObject> list = map.get(basicId);
            if (CollectionUtils.isEmpty(list)) continue;
            HashMap personInfoMap = Maps.newHashMapWithExpectedSize((int)selectProperties.size());
            selectProperties.forEach(pro -> personInfoMap.put(pro, basicDataDy.get(pro)));
            list.forEach(taxDataDy -> result.put(taxDataDy.getLong("id"), personInfoMap));
        }
        return result;
    }

    public Map<Long, Map<String, Object>> queryCurrentPersonInfos(Collection<Long> taxFileIds, Collection<String> selectProperties) {
        Object[] taxFileDys;
        HashMap result = Maps.newHashMapWithExpectedSize((int)taxFileIds.size());
        if (CollectionUtils.isEmpty(taxFileIds) || CollectionUtils.isEmpty(selectProperties)) {
            return result;
        }
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)selectProperties.size());
        Map<String, Set<String>> mapProperties = this.getSelectProperties(selectProperties, fieldMap);
        QFilter filter = new QFilter("id", "in", taxFileIds);
        filter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxfile");
        Set<String> taxFilePro = mapProperties.get("itc_taxfile");
        String proper = "personversion,pernontsprop,pertsprop,percre,taxstatus,taxregion,iscurrentversion,id,boid,number,person,taxunit,enable,status,datastatus,bsed,taxcrdltype";
        if (!CollectionUtils.isEmpty(taxFilePro)) {
            proper = proper + "," + String.join((CharSequence)",", taxFilePro);
        }
        if (ArrayUtils.isEmpty((Object[])(taxFileDys = helper.query(proper, new QFilter[]{filter})))) {
            return result;
        }
        HashMap taxBsedFileMap = Maps.newHashMapWithExpectedSize((int)taxFileDys.length);
        HashMap taxFileMap = Maps.newHashMapWithExpectedSize((int)taxFileDys.length);
        Arrays.stream(taxFileDys).forEach(obj -> taxBsedFileMap.put(obj.getLong("id"), obj.getDate("bsed")));
        Arrays.stream(taxFileDys).forEach(obj -> taxFileMap.put(obj.getLong("id"), obj));
        if (!CollectionUtils.isEmpty((Map)((Map)fieldMap.get("itc_taxfile")))) {
            this.setResult(result, taxFileMap, (Map)fieldMap.get("itc_taxfile"));
        }
        Set taxFileBoIds = taxBsedFileMap.keySet();
        for (Map.Entry<String, Set<String>> entry : mapProperties.entrySet()) {
            if ("itc_taxfile".equals(entry.getKey())) continue;
            Set<String> set = entry.getValue();
            set.add("taxfile");
            set.add("boid");
            set.add("status");
            set.add("bsed");
            set.add("bsled");
            set.add("datastatus");
            Map relatedInfo = TaxFileInfoServiceFactory.getRelatedInfo(taxFileBoIds, (Map)taxBsedFileMap, (String)entry.getKey(), set);
            if (CollectionUtils.isEmpty((Map)relatedInfo)) continue;
            this.setResult(result, relatedInfo, (Map)fieldMap.get(entry.getKey()));
        }
        return result;
    }

    private void setResult(HashMap<Long, Map<String, Object>> result, Map<Long, DynamicObject> relatedInfo, Map<String, String> pro) {
        if (CollectionUtils.isEmpty(relatedInfo) || CollectionUtils.isEmpty(pro)) {
            return;
        }
        for (Map.Entry<Long, DynamicObject> entry : relatedInfo.entrySet()) {
            Map map = result.computeIfAbsent(entry.getKey(), key -> Maps.newHashMapWithExpectedSize((int)pro.size()));
            DynamicObject value = entry.getValue();
            for (Map.Entry<String, String> strEnyrt : pro.entrySet()) {
                if (BASE_DATASET.contains(strEnyrt.getKey())) {
                    map.put(strEnyrt.getValue(), value);
                    continue;
                }
                map.put(strEnyrt.getKey(), value.get(strEnyrt.getValue()));
            }
        }
    }

    private Map<String, Set<String>> getSelectProperties(Collection<String> selectProperties, Map<String, Map<String, String>> fieldMap) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"itc_taxdatabasic");
        Map fields = mainEntityType.getFields();
        for (String selectProperty : selectProperties) {
            Set set;
            String entityName;
            if (selectProperty.contains(".")) {
                String str = selectProperty.substring(0, selectProperty.indexOf(46));
                entityName = FIELDNAME_MAP.get(str);
            } else {
                entityName = FIELDNAME_MAP.get(selectProperty);
            }
            Map tempMap = fieldMap.computeIfAbsent(entityName, key -> Maps.newHashMapWithExpectedSize((int)4));
            if (StringUtils.isEmpty((String)entityName)) continue;
            if ("itc_taxfile".equals(entityName) && selectProperty.contains("taxperson")) {
                set = map.computeIfAbsent(entityName, key -> Sets.newHashSetWithExpectedSize((int)8));
                String replace = selectProperty.replace("taxperson", "person");
                set.add(replace);
                tempMap.put(selectProperty, replace);
                continue;
            }
            set = map.computeIfAbsent(entityName, key -> Sets.newHashSetWithExpectedSize((int)8));
            if (selectProperty.contains(".") && BASE_DATASET.contains(selectProperty.substring(0, selectProperty.indexOf(46)))) {
                String substring = selectProperty.substring(selectProperty.indexOf(46) + 1);
                tempMap.put(selectProperty, substring);
                set.add(substring);
                continue;
            }
            if (BASE_DATASET.contains(selectProperty)) {
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)fields.get(selectProperty);
                IDataEntityType complexType = ((BasedataProp)iDataEntityProperty).getComplexType();
                DataEntityPropertyCollection properties = complexType.getProperties();
                for (IDataEntityProperty property : properties) {
                    set.add(property.getName());
                }
                tempMap.put(selectProperty, selectProperty);
                continue;
            }
            set.add(selectProperty);
            tempMap.put(selectProperty, selectProperty);
        }
        return map;
    }

    static {
        FIELDNAME_MAP.put("taxfile", "itc_taxfile");
        FIELDNAME_MAP.put("employment", "itc_employment");
        FIELDNAME_MAP.put("investor", "itc_investor");
        FIELDNAME_MAP.put("overseasperson", "itc_overseasperson");
        FIELDNAME_MAP.put("specialinfo", "itc_specialinfo");
        FIELDNAME_MAP.put("taxcontact", "itc_taxcontact");
        FIELDNAME_MAP.put("bankcard", "itc_bankcard");
        FIELDNAME_MAP.put("taxperson", "itc_taxfile");
        FIELDNAME_MAP.put("percre", "itc_taxfile");
        FIELDNAME_MAP.put("pernontsprop", "itc_taxfile");
        FIELDNAME_MAP.put("pereduexp", "itc_taxfile");
        FIELDNAME_MAP.put("pertsprop", "itc_taxfile");
        FIELDNAME_MAP.put("empposorgrel", "itc_taxfile");
    }
}

