/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.enums.DataStatusEnum;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SitBaseUtil;
import kd.sit.sitbp.common.util.SitDateUtil;

public class TaxCrdlTypeDataUpGrade630Task
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(TaxCrdlTypeDataUpGrade630Task.class);
    private static final Long passportId = 1020L;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List<DynamicObject> insertList;
        QFilter qFilter = new QFilter("apprelatecountry.id", "=", (Object)1000001L);
        HRBaseServiceHelper taxCredentialTypeHelper = new HRBaseServiceHelper("sitbs_taxcrdltype");
        Object[] taxCredentialTypes = taxCredentialTypeHelper.query("number,credentialstype,credentialstype.id,credentialstype.number,nationality,nationalitytype", new QFilter[]{qFilter});
        ArrayList list = Lists.newArrayList((Object[])taxCredentialTypes);
        Map<Long, List<DynamicObject>> taxCredentialTypesMap = Arrays.stream(taxCredentialTypes).collect(Collectors.groupingBy(dy -> dy.getLong("credentialstype.id")));
        if (ArrayUtils.isEmpty((Object[])taxCredentialTypes)) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hbss_credentialstype");
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("id", "not in", taxCredentialTypesMap.keySet());
        DynamicObject[] credentialsTypes = helper.query("id,name,number,status,masterid", new QFilter[]{filter});
        if (credentialsTypes != null && credentialsTypes.length > 0 && !CollectionUtils.isEmpty(insertList = this.createTaxCredentialsTypes(credentialsTypes, taxCredentialTypeHelper))) {
            list.addAll(insertList);
            taxCredentialTypesMap = list.stream().collect(Collectors.groupingBy(dy -> dy.getLong("credentialstype.id")));
        }
        ArrayList taxFIleFilterList = Lists.newArrayListWithExpectedSize((int)4);
        HRBaseServiceHelper taxFileHelper = new HRBaseServiceHelper("itc_taxfile");
        QFilter taxFilter = new QFilter("taxcrdltype", "=", (Object)0L);
        taxFilter.or("taxcrdltype", "is null", null);
        taxFIleFilterList.add(taxFilter);
        QFilter credentialsTypeFilter = new QFilter("percre.credentialstype.id", "in", taxCredentialTypesMap.keySet());
        taxFIleFilterList.add(credentialsTypeFilter);
        Object[] taxFiles = taxFileHelper.query("taxcrdltype,percre.credentialstype.id,pernontsprop.nationality.id", taxFIleFilterList.toArray(new QFilter[0]), "id", 10000);
        ArrayList updateDys = Lists.newArrayListWithExpectedSize((int)16);
        while (!ArrayUtils.isEmpty((Object[])taxFiles)) {
            this.getTaxFileUpdateInfo((DynamicObject[])taxFiles, updateDys, taxCredentialTypesMap);
            if (!CollectionUtils.isEmpty((Collection)updateDys)) {
                taxFileHelper.update(updateDys.toArray(new DynamicObject[0]));
            }
            taxFiles = taxFileHelper.query("taxcrdltype,percre.credentialstype.id,pernontsprop.nationality.id", taxFIleFilterList.toArray(new QFilter[0]), "id", 10000);
        }
        ArrayList overseasPersonUpdateIdsFilterList = Lists.newArrayListWithExpectedSize((int)4);
        QFilter overseasPersonFilter = new QFilter("otheridtype", "=", (Object)passportId);
        overseasPersonFilter.and("taxfile", "!=", (Object)0L);
        overseasPersonUpdateIdsFilterList.add(overseasPersonFilter);
        Date date = SITDateTimeUtils.addSecond((Date)new Date(), (long)-30L);
        QFilter modifyTimeFilter = new QFilter("modifytime", "<", (Object)date);
        overseasPersonUpdateIdsFilterList.add(modifyTimeFilter);
        HRBaseServiceHelper overseasPersonHelper = new HRBaseServiceHelper("itc_overseasperson");
        Object[] overseasPersons = overseasPersonHelper.query("otheridtype,otheridtype.id,taxfile.id,bsed,modifier,modifytime", overseasPersonUpdateIdsFilterList.toArray(new QFilter[0]), "id", 10000);
        while (!ArrayUtils.isEmpty((Object[])overseasPersons)) {
            List<DynamicObject> overseasPersonsUpdateInfo = this.getOverseasPersonsUpdateInfo((DynamicObject[])overseasPersons, taxCredentialTypesMap.get(passportId));
            if (!CollectionUtils.isEmpty(overseasPersonsUpdateInfo)) {
                overseasPersonHelper.update(overseasPersonsUpdateInfo.toArray(new DynamicObject[0]));
            }
            overseasPersons = overseasPersonHelper.query("otheridtype,otheridtype.id,taxfile.id,bsed,modifier,modifytime", overseasPersonUpdateIdsFilterList.toArray(new QFilter[0]), "id", 10000);
        }
        this.disableTask();
    }

    private List<DynamicObject> createTaxCredentialsTypes(DynamicObject[] credentialstypes, HRBaseServiceHelper taxCredentialTypeHelper) {
        ArrayList<DynamicObject> insertDys = new ArrayList<DynamicObject>(credentialstypes.length);
        for (DynamicObject credentialstype : credentialstypes) {
            DynamicObject dynamicObject = taxCredentialTypeHelper.generateEmptyDynamicObject();
            dynamicObject.set("id", (Object)credentialstype.getLong("id"));
            dynamicObject.set("name", (Object)credentialstype.getString("name"));
            dynamicObject.set("number", (Object)credentialstype.getString("number"));
            dynamicObject.set("credentialstype", (Object)credentialstype.getLong("id"));
            dynamicObject.set("nationalitytype", (Object)"0");
            dynamicObject.set("enable", (Object)"0");
            dynamicObject.set("status", (Object)credentialstype.getString("status"));
            dynamicObject.set("masterid", (Object)credentialstype.getLong("masterid"));
            dynamicObject.set("apprelatecountry", (Object)1000001L);
            SitBaseUtil.initSystemProp((DynamicObject)dynamicObject);
            insertDys.add(dynamicObject);
        }
        taxCredentialTypeHelper.save(insertDys.toArray(new DynamicObject[0]));
        return insertDys;
    }

    private void getTaxFileUpdateInfo(DynamicObject[] taxFiles, ArrayList<DynamicObject> updateDys, Map<Long, List<DynamicObject>> taxCredentialTypesMap) {
        for (DynamicObject taxFile : taxFiles) {
            long hrCredentialsTypeId = taxFile.getLong("percre.credentialstype.id");
            List<DynamicObject> list = taxCredentialTypesMap.get(hrCredentialsTypeId);
            if (CollectionUtils.isEmpty(list)) continue;
            if (list.size() == 1) {
                taxFile.set("taxcrdltype", (Object)list.get(0).getLong("id"));
                updateDys.add(taxFile);
                continue;
            }
            long taxCredentialTypeId = 0L;
            for (DynamicObject taxCredentialType : list) {
                if ("1".equals(taxCredentialType.getString("nationalitytype")) && taxCredentialType.getLong("nationality.id") == taxFile.getLong("pernontsprop.nationality.id")) {
                    taxCredentialTypeId = taxCredentialType.getLong("id");
                    break;
                }
                if (!"0".equals(taxCredentialType.getString("nationalitytype"))) continue;
                taxCredentialTypeId = taxCredentialType.getLong("id");
            }
            if (taxCredentialTypeId <= 0L) continue;
            taxFile.set("taxcrdltype", (Object)taxCredentialTypeId);
            updateDys.add(taxFile);
        }
    }

    public List<DynamicObject> getOverseasPersonsUpdateInfo(DynamicObject[] overseasPersons, List<DynamicObject> passports) {
        QFilter boIdFilter;
        Set taxFileBoIds = Arrays.asList(overseasPersons).stream().map(dy -> dy.getLong("taxfile.id")).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{DataStatusEnum.EFFECTING.getCode(), DataStatusEnum.EXPIRED.getCode(), DataStatusEnum.TO_EFFECT.getCode(), DataStatusEnum.DRAFT.getCode()});
        QFilter[] qFilters = new QFilter[]{statusFilter, dataStatusFilter, boIdFilter = new QFilter("boid", "in", taxFileBoIds)};
        DynamicObject[] dys = serviceHelper.query("bsed,bsled,status,pernontsprop.nationality.id,boid", qFilters);
        if (null == dys || dys.length == 0) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList infos = Lists.newArrayListWithExpectedSize((int)dys.length);
        for (DynamicObject dy2 : dys) {
            if (dy2.getLong("id") == dy2.getLong("boid") && !"A".equals(dy2.getString("status")) && !"B".equals(dy2.getString("status"))) continue;
            infos.add(dy2);
        }
        if (CollectionUtils.isEmpty((Collection)infos)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        Map<Long, List<DynamicObject>> map = infos.stream().collect(Collectors.groupingBy(e1 -> e1.getLong("boid")));
        ArrayList result = Lists.newArrayListWithExpectedSize((int)overseasPersons.length);
        for (DynamicObject overseasPerson : overseasPersons) {
            long taxFileBoId = overseasPerson.getLong("taxfile.id");
            List<DynamicObject> list = map.get(taxFileBoId);
            if (CollectionUtils.isEmpty(list)) {
                SitBaseUtil.initSystemProp4Update((DynamicObject)overseasPerson);
                result.add(overseasPerson);
                continue;
            }
            Date minDate = null;
            long minDateNationalityId = 0L;
            long taxCredentialTypeId = 0L;
            for (DynamicObject taxFile : list) {
                Date bsed = taxFile.getDate("bsed");
                Date bsled = taxFile.getDate("bsled");
                Date initDate = overseasPerson.getDate("bsed");
                if (null == bsed || null == bsled || null == initDate) continue;
                if (null == minDate) {
                    minDate = bsed;
                    minDateNationalityId = taxFile.getLong("pernontsprop.nationality.id");
                } else if (Math.abs(SITDateTimeUtils.dateDiff((Date)bsed, (Date)initDate)) < SITDateTimeUtils.dateDiff((Date)minDate, (Date)initDate)) {
                    minDate = bsed;
                    minDateNationalityId = taxFile.getLong("pernontsprop.nationality.id");
                }
                if (!SitDateUtil.isCover((Date)initDate, (Date)bsed, (Date)bsled) || (taxCredentialTypeId = this.getTaxCredentialId(taxFile.getLong("pernontsprop.nationality.id"), passports)) <= 0L) continue;
                break;
            }
            if (taxCredentialTypeId == 0L) {
                taxCredentialTypeId = this.getTaxCredentialId(minDateNationalityId, passports);
            }
            if (taxCredentialTypeId > 0L) {
                overseasPerson.set("otheridtype", (Object)taxCredentialTypeId);
            }
            SitBaseUtil.initSystemProp4Update((DynamicObject)overseasPerson);
            result.add(overseasPerson);
        }
        return result;
    }

    private long getTaxCredentialId(long nationalityId, List<DynamicObject> passports) {
        long taxCredentialTypeId = 0L;
        for (DynamicObject passport : passports) {
            if ("1".equals(passport.getString("nationalitytype")) && passport.getLong("nationality.id") == nationalityId) {
                taxCredentialTypeId = passport.getLong("id");
                break;
            }
            if (!"0".equals(passport.getString("nationalitytype"))) continue;
            taxCredentialTypeId = passport.getLong("id");
        }
        return taxCredentialTypeId;
    }

    private void disableTask() {
        ScheduleManager serviceManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        serviceManager.disableJob(taskInfo.getJobId());
        serviceManager.disableSchedule(taskInfo.getScheduleId());
    }
}

