/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.task;

import com.google.common.collect.Lists;
import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxtask.InitTaxDataBasicHelper;
import kd.sit.itc.business.taxtask.PreTaxDataBasicUnit;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.TaxTaskStatusEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;

public class TaxDataBasicAddNewTaxFileTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(TaxDataBasicAddNewTaxFileTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        List<DynamicObject> unFinishedTaxTask = this.getUnFinishedTaxTask();
        for (DynamicObject taxTaskDy : unFinishedTaxTask) {
            LOGGER.info("TaxDataBasicAddNewTaxFileTask start execute with taxtaskid = {}", (Object)taxTaskDy.getLong("id"));
            TaxTaskEntity taxTaskEntity = new TaxTaskEntity();
            taxTaskEntity.lightWeightInitBy(taxTaskDy);
            Map<Long, Long> initedTaxFileIdMap = InitTaxDataBasicHelper.getInitedTaxFileIdMap(taxTaskEntity);
            List<Long> existedTaxFileBoidList = this.getExistedTaxFileBoidList(taxTaskEntity);
            ArrayList taxFileFidList = Lists.newArrayListWithExpectedSize((int)initedTaxFileIdMap.size());
            if (!CollectionUtils.isEmpty(existedTaxFileBoidList)) {
                for (Map.Entry<Long, Long> entry : initedTaxFileIdMap.entrySet()) {
                    if (existedTaxFileBoidList.contains(entry.getKey())) continue;
                    taxFileFidList.add(entry.getValue());
                }
            } else {
                taxFileFidList = Lists.newArrayList(initedTaxFileIdMap.values());
            }
            Map<Long, PreTaxDataBasicUnit> preTaxDataBasicUnitMap = InitTaxDataBasicHelper.getPreTaxDataBasicUnitMap(taxFileFidList);
            List<DynamicObject> newTaxDataBasic = InitTaxDataBasicHelper.createNewTaxDataBasic(taxTaskEntity, Lists.newArrayList(preTaxDataBasicUnitMap.values()), null);
            HRBaseServiceHelper taxDataBasicHelper = new HRBaseServiceHelper("itc_taxdatabasic");
            HRBaseServiceHelper taxTaskHelper = new HRBaseServiceHelper("itc_taxtask");
            try (TXHandle txHandle = TX.required();){
                taxDataBasicHelper.save(newTaxDataBasic.toArray(new DynamicObject[0]));
                if (!CollectionUtils.isEmpty(newTaxDataBasic)) {
                    DynamicObject taskDy = taxTaskHelper.queryOne("id,taskstatus", new QFilter[]{new QFilter("id", "=", (Object)taxTaskEntity.getId())});
                    taskDy.set("taskstatus", (Object)TaxTaskStatusEnum.INIT_FINISH.getCode());
                    taxTaskHelper.saveOne(taskDy);
                }
                LOGGER.info("TaxDataBasicAddNewTaxFileTask finish execute with size = {}", (Object)newTaxDataBasic.size());
            }
        }
    }

    private List<Long> getExistedTaxFileBoidList(TaxTaskEntity taxTaskEntity) {
        HRBaseServiceHelper taxDataBasicHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        QFilter idFilter = new QFilter("taxtask.id", "=", (Object)taxTaskEntity.getId());
        QFilter statusFilter = new QFilter("status", "not in", Arrays.asList("D", "E"));
        Object[] taxDataBasicDys = taxDataBasicHelper.query("id,taxfile,taxfile.boid", new QFilter[]{idFilter, statusFilter});
        if (ArrayUtils.isEmpty((Object[])taxDataBasicDys)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        return Arrays.stream(taxDataBasicDys).map(dy -> dy.getLong("taxfile.boid")).collect(Collectors.toList());
    }

    private List<DynamicObject> getUnFinishedTaxTask() {
        LocalDate localDate = Instant.now().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
        LocalDate newLocalDate = localDate.plusYears(1L);
        Date newDate = Date.from(newLocalDate.atStartOfDay(KDDateUtils.getSysTimeZone().toZoneId()).toInstant());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxtask");
        QFilter qFilter = new QFilter("endstatus", "=", (Object)YesOrNoEnum.NO.getCode());
        QFilter timeFilter = new QFilter("taxenddate", "<", (Object)newDate);
        Object[] result = helper.query("id,number,name,taxenddate,taskstatus,endstatus,taxtaskcatgentry.taxcategory,taxtaskunitentry.taxunit,taxperiod", new QFilter[]{qFilter, timeFilter});
        return Lists.newArrayList((Object[])result);
    }
}

