/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.itc.business.taxdata.algo.LocalCalImportTaxSplitAlgoHandler;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;

public class TaxDataDiffValueUpdateTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(TaxDataDiffValueUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("TaxDataDiffValueUpdateTask execute ");
        DynamicObject schedule = this.queryDependTask();
        if (schedule == null) {
            return;
        }
        this.dealData();
        this.disableTask();
        LOGGER.info("TaxDataDiffValueUpdateTask end ");
    }

    private DynamicObject queryDependTask() {
        QFilter filter = new QFilter("id", "=", (Object)"2USLUC=CX751");
        filter.and("status", "=", (Object)"0");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sch_schedule");
        return helper.queryOne("id,status", filter);
    }

    private void dealData() {
        int totalTaxData = this.countTaxData();
        LOGGER.info("TaxDataDiffValueUpdateTask totalTaxData: {}", (Object)totalTaxData);
        if (totalTaxData == 0) {
            return;
        }
        int pageSize = 500;
        Map<Long, TaxItemEntity> taxItemMap = SitCommonServiceHelper.loadAllTaxItems(1000001L, 0L, 0L, new QFilter[]{null});
        for (int count = 0; count < totalTaxData; count += pageSize) {
            DynamicObject[] taxDataDyns = this.queryTaxDatas(pageSize);
            if (taxDataDyns == null || taxDataDyns.length == 0) continue;
            DynamicObject[] taxSrcDataDyns = this.queryTaxSrcData(taxDataDyns);
            Map<Long, Map<Long, List<DynamicObject>>> taxDataIdAndSrcDataMap = this.transformToMap(taxSrcDataDyns);
            this.calDifference(taxDataDyns, taxDataIdAndSrcDataMap, taxItemMap);
            this.saveData(taxDataDyns, taxSrcDataDyns);
        }
    }

    public void saveData(DynamicObject[] taxDataDyns, DynamicObject[] taxSrcDataDyns) {
        try (TXHandle txHandle = TX.requiresNew();){
            new HRBaseServiceHelper("itc_taxdata").save(taxDataDyns);
            new HRBaseServiceHelper("itc_taxrawdata").save(taxSrcDataDyns);
        }
    }

    public void calDifference(DynamicObject[] taxDataDyns, Map<Long, Map<Long, List<DynamicObject>>> taxDataIdAndSrcDataMap, Map<Long, TaxItemEntity> taxItemMap) {
        for (DynamicObject taxDataDyn : taxDataDyns) {
            long taxDataId = taxDataDyn.getLong("id");
            Map<Long, List<DynamicObject>> srcItemDataMaps = taxDataIdAndSrcDataMap.get(taxDataId);
            DynamicObjectCollection itemDyns = taxDataDyn.getDynamicObjectCollection("entryentity");
            if (itemDyns == null) continue;
            for (DynamicObject itemDyn : itemDyns) {
                List<DynamicObject> srcItemList;
                long itemId = itemDyn.getLong("taxitem.id");
                TaxItemEntity taxItem = taxItemMap.get(itemId);
                if (!CalTaxTypeEnum.fromTaxById((long)taxItem.getCaltaxtypeId()) || taxItem.isIncomeItem() || !LocalCalImportTaxSplitAlgoHandler.isCalDifference(taxItem)) continue;
                LocalCalImportTaxSplitAlgoHandler.calDifference(itemDyn);
                if (CollectionUtils.isEmpty(srcItemDataMaps) || CollectionUtils.isEmpty(srcItemList = srcItemDataMaps.get(itemId))) continue;
                srcItemList.forEach(obj -> LocalCalImportTaxSplitAlgoHandler.calDifference(obj));
            }
        }
    }

    public int countTaxData() {
        QFilter[] qFilters = this.getTaxDataFilter();
        return new HRBaseServiceHelper("itc_taxdata").count("itc_taxdata", qFilters);
    }

    public Map<Long, Map<Long, List<DynamicObject>>> transformToMap(DynamicObject[] taxSrcDataDyns) {
        if (taxSrcDataDyns == null || taxSrcDataDyns.length == 0) {
            return Maps.newLinkedHashMapWithExpectedSize((int)0);
        }
        HashMap taxDataIdAndSrcDataMap = Maps.newHashMapWithExpectedSize((int)taxSrcDataDyns.length);
        for (DynamicObject taxSrcDataDyn : taxSrcDataDyns) {
            DynamicObjectCollection itemDyns = taxSrcDataDyn.getDynamicObjectCollection("entryentity");
            if (itemDyns == null) continue;
            Map itemMap = taxDataIdAndSrcDataMap.computeIfAbsent(taxSrcDataDyn.getLong("taxdata"), k1 -> Maps.newHashMapWithExpectedSize((int)16));
            for (DynamicObject itemDyn : itemDyns) {
                List itemList = itemMap.computeIfAbsent(itemDyn.getLong("taxitem.id"), k1 -> Lists.newArrayListWithExpectedSize((int)10));
                itemList.add(itemDyn);
            }
        }
        return taxDataIdAndSrcDataMap;
    }

    public DynamicObject[] queryTaxDatas(int pageSize) {
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxdata").subProp("entryentity", new String[]{"entryyearmonth", "taxitem", "taxcategory", "itemvalue", "entrystatus", "entrymodifytime", "calvalue", "diffvalue"}).ignoreProp(new String[]{"modifytime", "modifier"});
        String prop = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, e1 -> !e1.contains("_"));
        QFilter[] qFilters = this.getTaxDataFilter();
        return new HRBaseServiceHelper("itc_taxdata").query(prop, qFilters, "createtime", pageSize);
    }

    public QFilter[] getTaxDataFilter() {
        QFilter defaultFilter = new QFilter("status", "!=", (Object)"E");
        defaultFilter.and("bizstatus", ">=", (Object)"40");
        defaultFilter.and("entryentity.taxitem.id", "not in", LocalCalImportTaxSplitAlgoHandler.noCalDiffItemMap);
        defaultFilter.and("entryentity.taxitem.caltaxtype.id", "=", (Object)CalTaxTypeEnum.RETURN.getId());
        defaultFilter.and("entryentity.taxitem.incomeitem", "!=", (Object)"1");
        defaultFilter.and("entryentity.taxitem.datatype.id", "in", LocalCalImportTaxSplitAlgoHandler.numberTypeIds);
        QFilter itemValFilter = new QFilter("entryentity.itemvalue", "=", (Object)" ");
        itemValFilter.or("entryentity.itemvalue", "is null", (Object)"");
        QFilter diffValFilter = new QFilter("entryentity.diffvalue", "=", (Object)" ");
        diffValFilter.or("entryentity.diffvalue", "is null", (Object)"");
        QFilter calValFilter = new QFilter("entryentity.calvalue", "!=", (Object)" ");
        calValFilter.and("entryentity.diffvalue", "is not null", (Object)"");
        return new QFilter[]{defaultFilter, itemValFilter, diffValFilter, calValFilter};
    }

    public DynamicObject[] queryTaxSrcData(DynamicObject[] taxDataDyns) {
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxrawdata").subProp("entryentity", new String[]{"datadirect", "entryyearmonth", "taxitem", "taxitem.datatype", "taxitem.currency", "taxitem.dataprecision", "itemvalue", "calvalue", "diffvalue"}).ignoreProp(new String[]{"modifytime", "modifier"});
        Set taxDataIds = Arrays.stream(taxDataDyns).map(obj -> obj.getLong("id")).collect(Collectors.toSet());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("taxdata", "in", taxDataIds));
        qFilters.add(new QFilter("status", "!=", (Object)"E"));
        return SitDataServiceHelper.commonQuery((PropertiesQueryInfo)info, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
    }

    private void disableTask() {
        ScheduleManager serviceManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        serviceManager.disableJob(taskInfo.getJobId());
        serviceManager.disableSchedule(taskInfo.getScheduleId());
    }
}

