/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.task;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.sit.itc.business.api.TaxFileAndDataUpgrade221128Service;
import kd.sit.itc.business.task.impl.BankCardUpgradeService;
import kd.sit.itc.business.task.impl.ContactUpgradeService;
import kd.sit.itc.business.task.impl.EmploymentUpgradeService;
import kd.sit.itc.business.task.impl.InvestorUpgradeService;
import kd.sit.itc.business.task.impl.OverseaPersonUpgradeService;
import kd.sit.itc.business.task.impl.PersonDecUpgradeService;
import kd.sit.itc.business.task.impl.SpecialInfoUpgradeService;
import kd.sit.itc.business.task.impl.TaxDataBasicFileSubUpgradeService;
import kd.sit.itc.business.task.impl.TaxDataBasicFileUpgradeService;
import kd.sit.itc.business.task.impl.TaxDataBasicFillUpgradeService;
import kd.sit.itc.business.task.impl.TaxDataBasicOther1UpgradeService;
import kd.sit.itc.business.task.impl.TaxDataBasicOther2UpgradeService;
import kd.sit.itc.business.task.impl.TaxDataBasicOther3UpgradeService;
import kd.sit.itc.business.task.impl.TaxDataUpgradeService;
import kd.sit.itc.business.task.impl.TaxFileUpgradeService;
import kd.sit.itc.business.task.impl.TaxRawDataBasicUpgradeService;
import kd.sit.itc.business.task.impl.TaxRawDataUpgradeService;
import kd.sit.itc.business.task.impl.TaxTaskUpgradeService;
import kd.sit.sitbp.business.upgrade.TaxDataUpgradeHelper;
import kd.sit.sitbp.common.constants.SITBaseConstants;

public class TaxFileAndDataUpGrade221128Task
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(TaxFileAndDataUpGrade221128Task.class);
    private static final String TASK_RANGE_SQL = "insert into t_itc_dataupgrade (fid,fbatchkey,ftablename,fdataid) select a.fid - 1600000000000000000, '20221128', 't_itc_taxtask', a.fid from t_itc_taxtask a left join t_itc_dataupgrade b on b.fbatchkey = '20221128' and b.ftablename = 't_itc_taxtask' and a.fid = b.fdataid where (a.fisneeddeclare is null or a.fisneeddeclare = ' ') and b.fid is null";
    private static final String FILE_RANGE_SQL = "insert into t_itc_dataupgrade (fid,fbatchkey,ftablename,fdataid) select a.fid - 1500000000000000000, case when a.fstatus != 'A' then '20221128' else '20221128.1' end, 't_itc_taxfile', a.fid from t_itc_taxfile a left join t_itc_dataupgrade b on b.fbatchkey like '20221128%' and b.ftablename = 't_itc_taxfile' and a.fid = b.fdataid where (a.fboid = 0 or a.fboid is null) and b.fid is null";
    private static final String EMPLOY_RANGE_SQL = "insert into t_itc_dataupgrade (fid,fbatchkey,ftablename,fdataid) select a.fid - 1400000000000000000, case when a.fstatus != 'A' then '20221128' else '20221128.1' end, 't_itc_employment', a.fid from t_itc_employment a left join t_itc_dataupgrade b on b.fbatchkey like '20221128%' and b.ftablename = 't_itc_employment' and a.fid = b.fdataid where (a.fboid = 0 or a.fboid is null) and b.fid is null";
    private static final String OVERSEA_RANGE_SQL = "insert into t_itc_dataupgrade (fid,fbatchkey,ftablename,fdataid) select a.fid - 1300000000000000000, case when a.fstatus != 'A' then '20221128' else '20221128.1' end, 't_itc_overseasperson', a.fid from t_itc_overseasperson a left join t_itc_dataupgrade b on b.fbatchkey like '20221128%' and b.ftablename = 't_itc_overseasperson' and a.fid = b.fdataid where (a.fboid = 0 or a.fboid is null) and b.fid is null";
    private static final String SPECIAL_RANGE_SQL = "insert into t_itc_dataupgrade (fid,fbatchkey,ftablename,fdataid) select a.fid - 1200000000000000000, case when a.fstatus != 'A' then '20221128' else '20221128.1' end, 't_itc_specialinfo', a.fid from t_itc_specialinfo a left join t_itc_dataupgrade b on b.fbatchkey like '20221128%' and b.ftablename = 't_itc_specialinfo' and a.fid = b.fdataid where (a.fboid = 0 or a.fboid is null) and b.fid is null";
    private static final String TAX_DATA_BASIC_RANGE_SQL = "insert into t_itc_dataupgrade (fid,fbatchkey,ftablename,fdataid) select a.fid - 1100000000000000000, '20221128', 't_itc_taxdatabasic', a.fid from t_itc_taxdatabasic a left join t_itc_dataupgrade b on b.fbatchkey = '20221128' and b.ftablename = 't_itc_taxdatabasic' and a.fid = b.fdataid where (a.ftaxfileboid = 0 or a.ftaxfileboid is null or a.ftaxfileboid = a.ftaxfileid) and b.fid is null";
    private static final String RAW_DATA_BASIC_RANGE_SQL = "insert into t_itc_dataupgrade (fid,fbatchkey,ftablename,fdataid) select a.fid - 1000000000000000000, '20221128', 't_itc_taxrawdatabasic', a.fid from t_itc_taxrawdatabasic a join t_itc_taxfile a1 on a.ftaxfileid = a1.fid and (a.ftaxfileid = a1.fboid or a1.fboid is null or a1.fboid = 0) left join t_itc_dataupgrade b on b.fbatchkey = '20221128' and b.ftablename = 't_itc_taxrawdatabasic' and a.fid = b.fdataid where b.fid is null";
    private static final String INVESTOR_RANGE_SQL = "insert into t_itc_dataupgrade (fid,fbatchkey,ftablename,fdataid) select a.fid - 900000000000000000, case when a.fstatus != 'A' then '20221128' else '20221128.1' end, 't_itc_investor', a.fid from t_itc_investor a left join t_itc_dataupgrade b on b.fbatchkey like '20221128%' and b.ftablename = 't_itc_investor' and a.fid = b.fdataid where (a.fboid = 0 or a.fboid is null) and b.fid is null";
    private static final String BANK_CARD_RANGE_SQL = "insert into t_itc_dataupgrade (fid,fbatchkey,ftablename,fdataid) select a.fid - 800000000000000000, case when a.fstatus != 'A' then '20221128' else '20221128.1' end, 't_itc_bankcard', a.fid from t_itc_bankcard a left join t_itc_dataupgrade b on b.fbatchkey like '20221128%' and b.ftablename = 't_itc_bankcard' and a.fid = b.fdataid where (a.fboid = 0 or a.fboid is null) and b.fid is null";
    private final List<TaxFileAndDataUpgrade221128Service> services = Lists.newArrayListWithCapacity((int)20);
    private final List<String> rangeSqlList = Lists.newArrayListWithExpectedSize((int)10);

    public TaxFileAndDataUpGrade221128Task() {
        this.rangeSqlList.add(TASK_RANGE_SQL);
        this.rangeSqlList.add(FILE_RANGE_SQL);
        this.rangeSqlList.add(EMPLOY_RANGE_SQL);
        this.rangeSqlList.add(OVERSEA_RANGE_SQL);
        this.rangeSqlList.add(SPECIAL_RANGE_SQL);
        this.rangeSqlList.add(TAX_DATA_BASIC_RANGE_SQL);
        this.rangeSqlList.add(RAW_DATA_BASIC_RANGE_SQL);
        this.rangeSqlList.add(INVESTOR_RANGE_SQL);
        this.rangeSqlList.add(BANK_CARD_RANGE_SQL);
        this.services.add(new TaxTaskUpgradeService());
        this.services.add(new TaxFileUpgradeService());
        this.services.add(new EmploymentUpgradeService());
        this.services.add(new OverseaPersonUpgradeService());
        this.services.add(new SpecialInfoUpgradeService());
        this.services.add(new InvestorUpgradeService());
        this.services.add(new ContactUpgradeService());
        this.services.add(new BankCardUpgradeService());
        this.services.add(new TaxDataBasicFileUpgradeService());
        this.services.add(new TaxDataBasicFillUpgradeService());
        this.services.add(new TaxDataBasicFileSubUpgradeService());
        this.services.add(new TaxDataUpgradeService());
        this.services.add(new TaxRawDataUpgradeService());
        this.services.add(new TaxRawDataBasicUpgradeService());
        this.services.add(new TaxDataBasicOther1UpgradeService());
        this.services.add(new TaxDataBasicOther2UpgradeService());
        this.services.add(new TaxDataBasicOther3UpgradeService());
        this.services.add(new PersonDecUpgradeService());
        this.services.sort(Comparator.comparingInt(TaxFileAndDataUpgrade221128Service::order));
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (this.judgeIsNeedUpgrade()) {
            for (TaxFileAndDataUpgrade221128Service service : this.services) {
                LOGGER.info("TaxFileAndDataUpGrade221128Task.execute sub service {}", (Object)service.getClass().getSimpleName());
                service.execute();
            }
        }
        this.disableTask();
    }

    private boolean judgeIsNeedUpgrade() {
        long isNeedUpgrade = -2L;
        String insertSql = "insert into t_itc_dataupgrade(fid,fbatchkey,ftablename,fdataid)values(?,?,?,?)";
        TXHandle required = null;
        DataSet rows = null;
        try {
            Object hasEncryptKeyField2;
            required = TX.requiresNew();
            rows = HRDBUtil.queryDataSet((String)"TaxFileAndDataUpGrade221128Task.isNeedUpgrade", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)"select fdataid from t_itc_dataupgrade where fid = ?", (Object[])new Object[]{20221128L});
            if (rows.hasNext()) {
                isNeedUpgrade = rows.next().getLong("fdataid");
            }
            if (isNeedUpgrade <= 0L) {
                isNeedUpgrade = this.isNeedUpgrade() ? 1L : 0L;
            }
            if (isNeedUpgrade > 0L && (hasEncryptKeyField2 = TaxDataUpgradeHelper.checkEncryptFields()).isSuccess()) {
                isNeedUpgrade = -1L;
            }
            for (String sql : this.rangeSqlList) {
                HRDBUtil.execute((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)sql, (Object[])new Object[0]);
            }
            HRDBUtil.execute((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)"delete from t_itc_dataupgrade where fid = ?", (Object[])new Object[]{20221128L});
            HRDBUtil.execute((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)insertSql, (Object[])new Object[]{20221128L, "20221128", "isNeedUpgrade", isNeedUpgrade});
            if (isNeedUpgrade < 0L) {
                LOGGER.error("TaxFileAndDataUpGrade221128Task.execute fails for isNeedUpgrade = {}", (Object)isNeedUpgrade);
                boolean hasEncryptKeyField2 = false;
                return hasEncryptKeyField2;
            }
            if (isNeedUpgrade == 0L) {
                LOGGER.info("TaxFileAndDataUpGrade221128Task.execute has no data hinted");
                boolean hasEncryptKeyField2 = false;
                return hasEncryptKeyField2;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurs when TaxFileAndDataUpGrade221128Task.execute isNeedUpgrade", (Throwable)e);
            if (required != null) {
                required.markRollback();
            }
            throw e;
        }
        finally {
            if (rows != null) {
                rows.close();
            }
            if (required != null) {
                required.close();
            }
        }
        return true;
    }

    private boolean isNeedUpgrade() {
        String sql = "select top 1 fid from t_itc_taxfile where fboid is null or fboid = 0";
        Long id = this.queryOneId(sql, new Object[0]);
        if (id != null && id != 0L) {
            return true;
        }
        sql = "select top 1 a.fid from t_itc_taxdatabasic a where a.ftaxfileboid is null or a.ftaxfileboid = 0 or a.ftaxfileid = a.ftaxfileboid";
        id = this.queryOneId(sql, new Object[0]);
        if (id != null && id != 0L) {
            return true;
        }
        sql = "select top 1 a.fid from t_itc_taxrawdatabasic a join t_itc_taxfile b on a.ftaxfileid = b.fboid";
        id = this.queryOneId(sql, new Object[0]);
        return id != null && id != 0L;
    }

    /*
     * Loose catch block
     */
    private Long queryOneId(String sql, Object[] params) {
        try (DataSet rows = null;){
            try (TXHandle ignored = TX.requiresNew();){
                rows = HRDBUtil.queryDataSet((String)"UpgradeDataRange1128Service.beforeExecuteSqlWithResult", (DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)sql, (Object[])params);
                Long result = null;
                if (rows.hasNext()) {
                    Row row = rows.next();
                    result = row.getLong("fid");
                }
                Long l = result;
                return l;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private void disableTask() {
        try (TXHandle handle = TX.requiresNew();){
            HRBaseServiceHelper helper = new HRBaseServiceHelper("sch_schedule");
            DynamicObject schedule = helper.queryOne("id,status", new QFilter[]{new QFilter("number", "=", (Object)"itc_TaxFileAndDataUpGrade221128Task_SKDP_S")});
            if (schedule != null) {
                schedule.set("status", (Object)"0");
                helper.updateOne(schedule);
            }
        }
    }
}

