/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.task.impl;

import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.sit.itc.business.api.TaxFileAndDataUpgrade221128Service;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.model.EffectLogger;

public abstract class AbstractUpgradeService
implements TaxFileAndDataUpgrade221128Service {
    private static final Log LOGGER = LogFactory.getLog(AbstractUpgradeService.class);
    protected final EffectLogger effectLogger = new EffectLogger("TaxFileAndDataUpgrade221128Service." + this.getClass().getSimpleName(), Thread.currentThread().getId() + "", LOGGER);
    protected static final String STATUS_UPDATE_SQL = " a set fstatus = (select fstatus from t_itc_taxfile b where a.ftaxfileid = b.fid) where a.fstatus != 'E' and exists (select 1 from t_itc_taxfile b where a.ftaxfileid = b.fid) and exists (select 1 from t_itc_dataupgrade b where a.ftaxfileid = b.fdataid and b.ftablename = 't_itc_taxfile' and b.fbatchkey like '20221128%')";

    @Override
    public void execute() {
        try (TXHandle handle = TX.requiresNew();){
            String s1 = this.getClass().getSimpleName() + ".execute";
            this.effectLogger.start(s1);
            this.updateStatus();
            this.doExecute();
            this.effectLogger.end(s1);
        }
    }

    private void updateStatus() {
        String tableName = this.statusTableName();
        if (StringUtils.isEmpty((Object)tableName)) {
            return;
        }
        try (TXHandle handle = TX.requiresNew();){
            HRDBUtil.execute((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)("UPDATE " + tableName + STATUS_UPDATE_SQL), (Object[])new Object[0]);
        }
    }

    protected String statusTableName() {
        return null;
    }

    protected void executeSqlWithoutParams(String ... sql) {
        for (String str : sql) {
            this.effectLogger.start(str);
            try (TXHandle handle = TX.requiresNew();){
                HRDBUtil.execute((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)str, (Object[])new Object[0]);
            }
            this.effectLogger.end(str);
        }
    }

    protected abstract void doExecute();
}

