/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.task.impl;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.sit.itc.business.task.impl.AbstractUpgradeService;
import kd.sit.itc.common.update.SubCardUpdateServiceHelper;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.util.SITDbUtil;

public class ContactUpgradeService
extends AbstractUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(ContactUpgradeService.class);
    private static final String ALL_COLUMNS = "t1.fid,t1.fnumber,t1.fname,t1.fstatus,t1.fcreatorid,t1.fmodifierid,t1.fenable,t1.fcreatetime,t1.fmodifytime,t1.fmasterid,t1.fsimplename,t1.fdescription,t1.findex,t1.fissyspreset,t1.fdisablerid,t1.fdisabledate,t1.fboid,t1.fiscurrentversion,t1.fdatastatus,t1.fsourcevid,t1.fchangedescription,t1.fhisversion,t1.fismodify,t1.ftaxpayernum,t1.fphone,t1.femail,t1.fregpermresid,t1.fregpermrescityid,t1.fregpermrescountyid,t1.fregpermresinfo,t1.fhabitresid,t1.fhabitrescityid,t1.fhabitrescountyid,t1.fhabitresinfo,t1.ftaxfileid";
    private static final String COLUMNS = "fnumber,fname,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fsimplename,fregpermrescityid,fdescription,findex,fissyspreset,fdisablerid,fdisabledate,ftaxpayernum,fphone,femail,fregpermresid,fregpermrescountyid,fregpermresinfo,fhabitresid,fhabitrescityid,fhabitrescountyid,fhabitresinfo,ftaxfileid";
    private static final String LOOP_SQL = "select top 1 fid from t_itc_taxperson a where not exists (select 1 from t_itc_taxcontact b where a.fid = b.fid)";
    private static final String LOOP_SQL2 = " select top 1 t1.fid from t_itc_taxcontact t1, t_itc_taxperson t2 where t1.fid = t2.fid and (t1.fboid is null or t1.fboid = 0)";

    @Override
    public int order() {
        return 70;
    }

    @Override
    protected String statusTableName() {
        return "T_ITC_TAXPERSON";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        this.updateContactStatus();
        int loopIndex = 1;
        this.effectLogger.start("ContactUpgradeService.copyTaxPersonToContract");
        DataSet rows = HRDBUtil.queryDataSet((String)"ContactUpgradeService.copyTaxPersonToContact", (DBRoute)SITConstants.SIT_ROUTE, (String)LOOP_SQL, (Object[])new Object[0]);
        while (rows.hasNext()) {
            String point = "ContactUpgradeService.copyTaxPersonToContact loop " + loopIndex++;
            this.effectLogger.start(point);
            TXHandle txCopy = TX.requiresNew();
            try {
                String copySQL = this.copyTaxPersonToContact();
                HRDBUtil.execute((DBRoute)SITConstants.SIT_ROUTE, (String)copySQL, (Object[])new Object[0]);
            }
            catch (Exception ex) {
                txCopy.markRollback();
                throw ex;
            }
            finally {
                rows.close();
                txCopy.close();
            }
            this.effectLogger.end(point);
            rows = HRDBUtil.queryDataSet((String)"ContactUpgradeService.copyTaxPersonToContact", (DBRoute)SITConstants.SIT_ROUTE, (String)LOOP_SQL, (Object[])new Object[0]);
        }
        rows.close();
        this.effectLogger.end("ContactUpgradeService.copyTaxPersonToContact");
        String querySql = "select top 3000 t1.fid,t1.fnumber,t1.fname,t1.fstatus,t1.fcreatorid,t1.fmodifierid,t1.fenable,t1.fcreatetime,t1.fmodifytime,t1.fmasterid,t1.fsimplename,t1.fdescription,t1.findex,t1.fissyspreset,t1.fdisablerid,t1.fdisabledate,t1.fboid,t1.fiscurrentversion,t1.fdatastatus,t1.fsourcevid,t1.fchangedescription,t1.fhisversion,t1.fismodify,t1.ftaxpayernum,t1.fphone,t1.femail,t1.fregpermresid,t1.fregpermrescityid,t1.fregpermrescountyid,t1.fregpermresinfo,t1.fhabitresid,t1.fhabitrescityid,t1.fhabitrescountyid,t1.fhabitresinfo,t1.ftaxfileid from t_itc_taxcontact t1, t_itc_taxperson t2 where t1.fid = t2.fid and (t1.fboid is null or t1.fboid = 0)";
        try (DataSet dataSet = null;){
            dataSet = SITDbUtil.queryDataSet((String)"ItcTaxContact", (DBRoute)SITConstants.SIT_ROUTE, (String)querySql, null);
            loopIndex = 1;
            while (dataSet.hasNext()) {
                try (TXHandle tx = TX.requiresNew();){
                    ArrayList updateParams = new ArrayList(100);
                    ArrayList insertparams = new ArrayList(100);
                    String point = "ContactUpgradeService.queryTaxContactInfo loop " + loopIndex++;
                    this.effectLogger.start(point);
                    this.effectLogger.start(point + " geneInsertParams");
                    SubCardUpdateServiceHelper.geneInsertParams((DataSet)dataSet, updateParams, insertparams, (String)"t_itc_taxcontact", (String)COLUMNS);
                    this.effectLogger.end(point + " geneInsertParams");
                    this.effectLogger.start(point + " updateParams");
                    if (!CollectionUtils.isEmpty(updateParams)) {
                        String updateSql = "UPDATE t_itc_taxcontact  SET fboid = ? ,fiscurrentversion = ?, fdatastatus = ?,fsourcevid = ?,fhisversion = ?,fismodify = ?,fchangedescription = ?,fstatus = ?  WHERE fid = ? ";
                        SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)updateSql, updateParams);
                        LOGGER.info("ContactUpdateService update data size {}", (Object)updateParams.size());
                    }
                    this.effectLogger.end(point + " updateParams");
                    this.effectLogger.start(point + " insertparams");
                    if (!CollectionUtils.isEmpty(insertparams)) {
                        String insertSql = " insert into t_itc_taxcontact  ( fnumber,fname,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fsimplename,fregpermrescityid,fdescription,findex,fissyspreset,fdisablerid,fdisabledate,ftaxpayernum,fphone,femail,fregpermresid,fregpermrescountyid,fregpermresinfo,fhabitresid,fhabitrescityid,fhabitrescountyid,fhabitresinfo,ftaxfileid  ,fid,fstatus,fmasterid,fboid,fiscurrentversion,fdatastatus,fsourcevid,fchangedescription,fhisversion,fismodify )  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
                        SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)insertSql, insertparams);
                        LOGGER.info("ContactUpdateService insert data size {}", (Object)insertparams.size());
                    }
                    this.effectLogger.end(point + " insertparams");
                    this.effectLogger.end(point);
                }
                dataSet = SITDbUtil.queryDataSet((String)"ItcTaxContact", (DBRoute)SITConstants.SIT_ROUTE, (String)querySql, null);
            }
        }
    }

    private String copyTaxPersonToContact() {
        return " INSERT into t_itc_taxcontact (fid,fnumber,fname,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,ftaxfileid,         fsimplename,fdescription,findex,fissyspreset,fdisablerid,fdisabledate,ftaxpayernum,fphone,fhabitresinfo,        femail,fregpermresid,fregpermrescityid,fregpermrescountyid,fregpermresinfo,fhabitresid,fhabitrescityid,fhabitrescountyid)  select top 3000 fid,fnumber,fname,fstatus,fcreatorid,fmodifierid,fenable,fcreatetime,fmodifytime,fmasterid,ftaxfileid,         fsimplename,fdescription,findex,fissyspreset,fdisablerid,fdisabledate,ftaxpayernum,fphone,fhabitresinfo,         femail,fregpermresid,fregpermrescityid,fregpermrescountyid,fregpermresinfo,fhabitresid,fhabitrescityid,fhabitrescountyid  from t_itc_taxperson a  where not exists (select 1 from t_itc_taxcontact b where a.fid = b.fid)";
    }

    private void updateContactStatus() {
        try (TXHandle handle = TX.requiresNew();){
            HRDBUtil.execute((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)"UPDATE T_ITC_TAXCONTACT a set fstatus = (select fstatus from t_itc_taxfile b where a.ftaxfileid = b.fid) where a.fstatus != 'E' and exists (select 1 from t_itc_taxfile b where a.ftaxfileid = b.fid) and exists (select 1 from t_itc_dataupgrade b where a.ftaxfileid = b.fdataid and b.ftablename = 't_itc_taxfile' and b.fbatchkey like '20221128%')", (Object[])new Object[0]);
        }
    }
}

