/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.task.impl;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.task.impl.AbstractUpgradeService;
import kd.sit.itc.common.update.SubCardUpdateServiceHelper;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.util.SITDbUtil;

public class InvestorUpgradeService
extends AbstractUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(InvestorUpgradeService.class);
    private String allColumns = "fid,fnumber,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fenable,findex,fstatus,fdisablerid,fdisabledate,fissyspreset,fmasterid,fbsed,fbsled,fname,fsimplename,fdescription,finvesttotal,fdutyid,finvestratio,ftaxfileid,fboid,fiscurrentversion,fdatastatus,fsourcevid,fhisversion,fismodify,fchangedescription";
    private String columns = "fnumber,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fenable,findex,fdisablerid,fdisabledate,fissyspreset,fbsed,fbsled,fname,fsimplename,fdescription,finvesttotal,fdutyid,finvestratio,ftaxfileid";

    @Override
    public int order() {
        return 60;
    }

    @Override
    protected String statusTableName() {
        return "T_ITC_INVESTOR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        try (DataSet dataSet = null;){
            dataSet = this.queryData();
            while (dataSet.hasNext()) {
                ArrayList updateParams = new ArrayList(3000);
                ArrayList insertparams = new ArrayList(3000);
                SubCardUpdateServiceHelper.geneInsertParams((DataSet)dataSet, updateParams, insertparams, (String)"t_itc_investor", (String)this.columns);
                if (!CollectionUtils.isEmpty(updateParams)) {
                    String updateSql = "UPDATE t_itc_investor  SET fboid = ? ,fiscurrentversion = ?, fdatastatus = ?,fsourcevid = ?,fhisversion = ?,fismodify = ?,fchangedescription = ?,fstatus = ?  WHERE fid = ? ";
                    SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)updateSql, updateParams);
                    LOGGER.info("InvestorUpdateService update data size {}", (Object)updateParams.size());
                }
                if (!CollectionUtils.isEmpty(insertparams)) {
                    StringBuilder insertSql = new StringBuilder();
                    insertSql.append(" insert into t_itc_investor ");
                    insertSql.append(" ( ").append(this.columns);
                    insertSql.append("  ,fid,fstatus,fmasterid,fboid,fiscurrentversion,fdatastatus,fsourcevid,fchangedescription,fhisversion,fismodify ) ");
                    insertSql.append(" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
                    SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)insertSql.toString(), insertparams);
                    LOGGER.info("InvestorUpdateService insert data size {}", (Object)insertparams.size());
                }
                dataSet = this.queryData();
            }
        }
    }

    private DataSet queryData() {
        String querySql = " select top 3000 " + this.allColumns + " from t_itc_investor where fboid is null or fboid = 0 ";
        return SITDbUtil.queryDataSet((String)"ItcInvestor", (DBRoute)SITConstants.SIT_ROUTE, (String)querySql, null);
    }
}

