/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.task.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.sit.itc.business.task.impl.AbstractUpgradeService;
import kd.sit.itc.common.update.PersonDecUpdateDO;
import kd.sit.sitbp.common.constants.SITBaseConstants;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.util.SITDbUtil;

public class PersonDecUpgradeService
extends AbstractUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(PersonDecUpgradeService.class);

    @Override
    public int order() {
        return 360;
    }

    @Override
    protected void doExecute() {
        List<PersonDecUpdateDO> list = this.selectData();
        LOGGER.info("PersonDecUpdateService select data size:{}", (Object)list.size());
        while (!CollectionUtils.isEmpty(list)) {
            try (TXHandle handle = TX.requiresNew();){
                ArrayList<Object[]> params = new ArrayList<Object[]>(list.size());
                this.getInsertParam(params, list);
                if (!CollectionUtils.isEmpty(params)) {
                    SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)this.insertSQL(), params);
                }
            }
            list = this.selectData();
        }
        this.updateBoid();
    }

    private void updateBoid() {
        String upSql = " update t_itc_perdeclrecord tp set ftaxfileid = (select tf.fboid from t_itc_taxfile tf where tf.fid = tp.ftaxfileid)  where exists (select 1 from t_itc_taxfile tf where tf.fid = tp.ftaxfileid) ";
        try (TXHandle handle = TX.requiresNew();){
            HRDBUtil.execute((DBRoute)SITBaseConstants.DB_ROUTE_SIT, (String)upSql, (Object[])new Object[0]);
        }
    }

    private List<PersonDecUpdateDO> selectData() {
        ArrayList<PersonDecUpdateDO> result = new ArrayList<PersonDecUpdateDO>(5000);
        String querySql = " select top 5000 t1.fcreatorid,t1.fcreatetime,t1.fmodifierid,t1.fmodifytime,         t1.fchangetype,t2.ftaxstartdate,t1.fdeclarestatus,         t1.fpersonstatus,t1.ftaxfileboid,t1.fid   from t_itc_taxdatabasic t1  left join t_itc_taxtask t2  on t2.fid = t1.ftaxtaskid  left join t_itc_perdeclrecord t3 on t3.ftaxdatabasicid = t1.fid  where t1.fdeclarestatus = '1' and t1.fchangetype in ('1','2','3') and t3.ftaxdatabasicid is null ";
        try (DataSet dataSet = SITDbUtil.queryDataSet((String)"ItcTaxPerson", (DBRoute)SITConstants.SIT_ROUTE, (String)querySql, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                PersonDecUpdateDO been = new PersonDecUpdateDO();
                been.setFcreatorid(row.getLong("fcreatorid"));
                been.setFcreatetime(row.getDate("fcreatetime"));
                been.setFmodifierid(row.getLong("fmodifierid"));
                been.setFmodifytime(row.getDate("fmodifytime"));
                been.setFchangetype(row.getString("fchangetype"));
                been.setFdeclaremonth(row.getDate("ftaxstartdate"));
                been.setFdeclarestatus(row.getString("fdeclarestatus"));
                been.setFpersonstatus(row.getString("fpersonstatus"));
                been.setFtaxfileid(row.getLong("ftaxfileboid"));
                been.setFtaxdatabasicid(row.getLong("fid"));
                result.add(been);
            }
        }
        return result;
    }

    private String insertSQL() {
        return "insert into t_itc_perdeclrecord  (fid,fcreatorid,fcreatetime,fmodifierid,fmodifytime,   fdescription,fchangetype,fdeclaremonth,fdeclarestatus,fdeclareway,  fpersonstatus,ftaxfileid,ftaxdatabasicid)   values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }

    private void getInsertParam(List<Object[]> params, List<PersonDecUpdateDO> list) {
        long[] ids = DB.genLongIds((String)"t_itc_perdeclrecord", (int)list.size());
        int index = 0;
        for (PersonDecUpdateDO obj : list) {
            Object[] param = new Object[]{ids[index], obj.getFcreatorid(), obj.getFcreatetime(), obj.getFmodifierid(), obj.getFmodifytime(), " ", obj.getFchangetype(), obj.getFdeclaremonth(), obj.getFdeclarestatus(), "0", obj.getFpersonstatus(), obj.getFtaxfileid(), obj.getFtaxdatabasicid()};
            ++index;
            params.add(param);
        }
    }
}

