/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.task.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.task.impl.AbstractUpgradeService;
import kd.sit.itc.common.update.TaxFileAUpdateDO;
import kd.sit.itc.common.update.TaxFileMainUpdateDO;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.history.model.SITHisBaseConstants;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITDbUtil;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxFileUpgradeService
extends AbstractUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(TaxFileUpgradeService.class);
    private static final String DELETE_DIRTY_DATA = "DELETE FROM T_ITC_TAXFILE_A a WHERE NOT EXISTS (SELECT 1 FROM t_itc_taxfile b WHERE a.fid = b.fid) OR EXISTS (SELECT 1 FROM t_itc_taxfile b WHERE a.fid = b.fid and b.fboid = 0);";

    @Override
    public int order() {
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        LOGGER.info("TaxFileUpdateService begin.");
        this.cleanDirtyData();
        String queryTaxFileSQL = "SELECT TOP 10000 FID,FNUMBER,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FENABLE,FINDEX,FSTATUS,FDISABLERID,FDISABLEDATE,FISSYSPRESET,FMASTERID,FBSED,FBSLED,FNAME,FSIMPLENAME,FDESCRIPTION,FPERSONID,FORGID,FTAXREGIONID,FDEPCYTYPEID,FADMINORGID,FATTACHADMINORGID,FEMPGROUPID,FTAXUNITID,FADMINDIVISIONID,FSTARTTAXDATE,FISESCROWSTAFF,FTAXPERSONID,FPOSITIONID,FCOMPANYID,FDEPARTMENTID,FEMPLOYMENTID,FEMPPOSINFOENTID,FTMPID,FDECLARESTATUS,FDECLAREWAY,FDECLAREMONTH,FREPORTSTATUS,FLOCKSTATUS,FTAXFILEMODIFYTIME,FCHANGETYPE,FJOBID,FEMPPOSINFOID,FTAXSTATUS,FBOID,FISCURRENTVERSION,FDATASTATUS FROM T_ITC_TAXFILE WHERE FBOID = 0 OR FBOID IS NULL";
        try (DataSet dateSet = null;){
            dateSet = SITDbUtil.queryDataSet((String)"queryTaxFileSQL", (DBRoute)SITConstants.SIT_ROUTE, (String)queryTaxFileSQL, (Object[])new Object[0]);
            while (dateSet.hasNext()) {
                HashMap taxFileMainDoMap = Maps.newHashMapWithExpectedSize((int)100000);
                TaxFileMainUpdateDO.Builder taxFileMainBuilder = new TaxFileMainUpdateDO.Builder();
                TaxFileAUpdateDO.Builder taxFileABuilder = new TaxFileAUpdateDO.Builder();
                this.getTaxFileMainDoMap(dateSet, taxFileMainDoMap, taxFileMainBuilder);
                if (taxFileMainDoMap.size() == 0) {
                    return;
                }
                HashMap taxFileADOMap = Maps.newHashMapWithExpectedSize((int)taxFileMainDoMap.size());
                this.getTaxFileADOMap(taxFileMainDoMap, taxFileABuilder, taxFileADOMap);
                HashMap taxFileMainDoHisVersionMap = Maps.newHashMapWithExpectedSize((int)taxFileMainDoMap.size());
                HashMap taxFileADoHisVersionMap = Maps.newHashMapWithExpectedSize((int)taxFileMainDoMap.size());
                LOGGER.info("begin to generate hisversion");
                HashMap taxFileHisVersionId1Maps = Maps.newHashMapWithExpectedSize((int)taxFileMainDoMap.size());
                this.fullIdsToMap(taxFileMainDoMap, taxFileHisVersionId1Maps);
                HashMap taxFileHisVersionId2Maps = Maps.newHashMapWithExpectedSize((int)taxFileMainDoMap.size());
                this.fullIdsToMap(taxFileMainDoMap, taxFileHisVersionId2Maps);
                for (Map.Entry entry : taxFileMainDoMap.entrySet()) {
                    Long taxFileBoid = (Long)entry.getKey();
                    TaxFileMainUpdateDO taxFileMainUpdateDO = (TaxFileMainUpdateDO)entry.getValue();
                    TaxFileAUpdateDO taxFileAUpdateDO = (TaxFileAUpdateDO)taxFileADOMap.get(taxFileBoid);
                    if ("A".equals(taxFileMainUpdateDO.getFSTATUS())) continue;
                    long taxFileHisVersionId1 = (Long)taxFileHisVersionId1Maps.get(taxFileBoid);
                    TaxFileMainUpdateDO taxFileMainHisVersion1 = taxFileMainUpdateDO.copy();
                    TaxFileAUpdateDO taxFileAUpdateDO2 = taxFileAUpdateDO.copy();
                    taxFileAUpdateDO.setFSOURCEVID(Long.valueOf(taxFileHisVersionId1));
                    taxFileMainHisVersion1.setFID(Long.valueOf(taxFileHisVersionId1));
                    taxFileMainHisVersion1.setFMASTERID(Long.valueOf(taxFileHisVersionId1));
                    taxFileAUpdateDO2.setFID(Long.valueOf(taxFileHisVersionId1));
                    taxFileMainHisVersion1.setFISCURRENTVERSION(YesOrNoEnum.NO.getCode());
                    taxFileAUpdateDO2.setFSOURCEVID(Long.valueOf(0L));
                    taxFileAUpdateDO2.setFFIRSTBSED(null);
                    taxFileAUpdateDO2.setFHISVERSION("V0001");
                    Date fbsled = taxFileMainUpdateDO.getFBSLED();
                    Instant fbsledInstant = fbsled.toInstant();
                    Instant oldBsledInstant = SITHisBaseConstants.OLD_BSLED.toInstant();
                    Instant newBsledInstant = SITHisBaseConstants.NEW_BSLED.toInstant();
                    if (!fbsledInstant.equals(oldBsledInstant) && !fbsledInstant.equals(newBsledInstant)) {
                        TaxFileMainUpdateDO taxFileMainHisVersion2 = taxFileMainHisVersion1.copy();
                        TaxFileAUpdateDO taxFileAHisVersion2 = taxFileAUpdateDO2.copy();
                        long taxFileHisVersionId2 = (Long)taxFileHisVersionId2Maps.get(taxFileBoid);
                        taxFileMainHisVersion2.setFID(Long.valueOf(taxFileHisVersionId2));
                        taxFileMainHisVersion2.setFMASTERID(Long.valueOf(taxFileHisVersionId2));
                        taxFileAHisVersion2.setFID(Long.valueOf(taxFileHisVersionId2));
                        taxFileAHisVersion2.setFSOURCEVID(Long.valueOf(taxFileHisVersionId1));
                        taxFileAHisVersion2.setFHISVERSION("V0002");
                        Date lastDateOfMonth = SitDateUtil.lastDateOfMonth((Date)fbsled);
                        Date beginStopTaxDate = SITDateTimeUtils.addDay((Date)lastDateOfMonth, (long)1L);
                        taxFileMainUpdateDO.setFBSLED((Date)new Timestamp(lastDateOfMonth.getTime()));
                        taxFileMainHisVersion1.setFBSLED((Date)new Timestamp(lastDateOfMonth.getTime()));
                        taxFileMainHisVersion2.setFBSED((Date)new Timestamp(beginStopTaxDate.getTime()));
                        taxFileMainHisVersion2.setFBSLED((Date)new Timestamp(SITHisBaseConstants.NEW_BSLED.getTime()));
                        taxFileMainHisVersion2.setFTAXSTATUS(YesOrNoEnum.NO.getCode());
                        taxFileMainHisVersion2.setFDATASTATUS("0");
                        if (!beginStopTaxDate.after(SitDateUtil.ceil((Object)new Date()))) {
                            taxFileMainUpdateDO.setFTAXSTATUS(taxFileMainHisVersion2.getFTAXSTATUS());
                            taxFileMainUpdateDO.setFBSED(taxFileMainHisVersion2.getFBSED());
                            taxFileMainUpdateDO.setFBSLED(taxFileMainHisVersion2.getFBSLED());
                            taxFileAUpdateDO.setFSOURCEVID(taxFileMainHisVersion2.getFID());
                            taxFileMainUpdateDO.setFDATASTATUS("1");
                            taxFileMainHisVersion2.setFDATASTATUS("1");
                            taxFileMainHisVersion1.setFDATASTATUS("2");
                        }
                        taxFileMainDoHisVersionMap.put(taxFileHisVersionId2, taxFileMainHisVersion2);
                        taxFileADoHisVersionMap.put(taxFileHisVersionId2, taxFileAHisVersion2);
                    }
                    taxFileMainDoHisVersionMap.put(taxFileHisVersionId1, taxFileMainHisVersion1);
                    taxFileADoHisVersionMap.put(taxFileHisVersionId1, taxFileAUpdateDO2);
                }
                LOGGER.info("taxFileMainDoHisVersionMap size is {}", (Object)taxFileMainDoHisVersionMap.size());
                LOGGER.info("taxFileADoHisVersionMap size is {}", (Object)taxFileADoHisVersionMap.size());
                String updateTaxFileMainSql = "UPDATE T_ITC_TAXFILE SET FNUMBER  = ? ,FCREATORID = ? ,FCREATETIME = ? ,FMODIFIERID = ? ,FMODIFYTIME = ? ,FENABLE = ? ,FINDEX = ? ,FSTATUS = ? ,FDISABLERID = ? ,FDISABLEDATE = ? ,FISSYSPRESET = ? ,FMASTERID = ? ,FBSED = ? ,FBSLED = ? ,FNAME = ? ,FSIMPLENAME = ? ,FDESCRIPTION = ? ,FPERSONID = ? ,FORGID = ? ,FTAXREGIONID = ? ,FDEPCYTYPEID = ? ,FADMINORGID = ? ,FATTACHADMINORGID = ? ,FEMPGROUPID = ? ,FTAXUNITID = ? ,FADMINDIVISIONID = ? ,FSTARTTAXDATE = ? ,FISESCROWSTAFF = ? ,FTAXPERSONID = ? ,FPOSITIONID = ? ,FCOMPANYID = ? ,FDEPARTMENTID = ? ,FEMPLOYMENTID = ? ,FTMPID = ? ,FDECLARESTATUS = ? ,FDECLAREWAY = ? ,FDECLAREMONTH = ? ,FREPORTSTATUS = ? ,FLOCKSTATUS = ? ,FTAXFILEMODIFYTIME = ? ,FCHANGETYPE = ? ,FJOBID = ? ,FEMPPOSINFOID = ? ,FTAXSTATUS = ? ,FBOID = ? ,FISCURRENTVERSION = ? ,FDATASTATUS = ? WHERE FID = ?";
                String insertTaxFileMainSql = "INSERT INTO T_ITC_TAXFILE(FID,FNUMBER,FCREATORID,FCREATETIME,FMODIFIERID,FMODIFYTIME,FENABLE,FINDEX,FSTATUS,FDISABLERID,FDISABLEDATE,FISSYSPRESET,FMASTERID,FBSED,FBSLED,FNAME,FSIMPLENAME,FDESCRIPTION,FPERSONID,FORGID,FTAXREGIONID,FDEPCYTYPEID,FADMINORGID,FATTACHADMINORGID,FEMPGROUPID,FTAXUNITID,FADMINDIVISIONID,FSTARTTAXDATE,FISESCROWSTAFF,FTAXPERSONID,FPOSITIONID,FCOMPANYID,FDEPARTMENTID,FEMPLOYMENTID,FTMPID,FDECLARESTATUS,FDECLAREWAY,FDECLAREMONTH,FREPORTSTATUS,FLOCKSTATUS,FTAXFILEMODIFYTIME,FCHANGETYPE,FJOBID,FEMPPOSINFOID,FTAXSTATUS,FBOID,FISCURRENTVERSION,FDATASTATUS) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                String insertTaxFileASql = "INSERT INTO T_ITC_TAXFILE_A(FID,FSOURCEVID,FFIRSTBSED,FCHANGEBSED,FBRED,FBRLED,FBRFD,FHISVERSION,FISMODIFY,FPERCREID,FPEREDUEXPID,FPERTSPROPID,FPERNONTSPROPID,FEMPPOSORGRELID,FPERSONVID) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                ArrayList taxFileMainUpdateParamList = Lists.newArrayListWithExpectedSize((int)taxFileMainDoMap.size());
                ArrayList taxFileAUpdateParamList = Lists.newArrayListWithExpectedSize((int)taxFileADOMap.size());
                ArrayList insertTaxFileMainHisParamList = Lists.newArrayListWithExpectedSize((int)taxFileMainDoHisVersionMap.size());
                ArrayList insertTaxFileAHisParamList = Lists.newArrayListWithExpectedSize((int)taxFileADoHisVersionMap.size());
                for (Map.Entry entry : taxFileMainDoMap.entrySet()) {
                    TaxFileMainUpdateDO taxFileMainUpdateDO = (TaxFileMainUpdateDO)entry.getValue();
                    taxFileMainUpdateParamList.add(new Object[]{taxFileMainUpdateDO.getFNUMBER(), taxFileMainUpdateDO.getFCREATORID(), taxFileMainUpdateDO.getFCREATETIME(), taxFileMainUpdateDO.getFMODIFIERID(), taxFileMainUpdateDO.getFMODIFYTIME(), taxFileMainUpdateDO.getFENABLE(), taxFileMainUpdateDO.getFINDEX(), taxFileMainUpdateDO.getFSTATUS(), taxFileMainUpdateDO.getFDISABLERID(), taxFileMainUpdateDO.getFDISABLEDATE(), taxFileMainUpdateDO.getFISSYSPRESET(), taxFileMainUpdateDO.getFMASTERID(), taxFileMainUpdateDO.getFBSED(), taxFileMainUpdateDO.getFBSLED(), taxFileMainUpdateDO.getFNAME(), taxFileMainUpdateDO.getFSIMPLENAME(), taxFileMainUpdateDO.getFDESCRIPTION(), taxFileMainUpdateDO.getFPERSONID(), taxFileMainUpdateDO.getFORGID(), taxFileMainUpdateDO.getFTAXREGIONID(), taxFileMainUpdateDO.getFDEPCYTYPEID(), taxFileMainUpdateDO.getFADMINORGID(), taxFileMainUpdateDO.getFATTACHADMINORGID(), taxFileMainUpdateDO.getFEMPGROUPID(), taxFileMainUpdateDO.getFTAXUNITID(), taxFileMainUpdateDO.getFADMINDIVISIONID(), taxFileMainUpdateDO.getFSTARTTAXDATE(), taxFileMainUpdateDO.getFISESCROWSTAFF(), taxFileMainUpdateDO.getFTAXPERSONID(), taxFileMainUpdateDO.getFPOSITIONID(), taxFileMainUpdateDO.getFCOMPANYID(), taxFileMainUpdateDO.getFDEPARTMENTID(), taxFileMainUpdateDO.getFEMPLOYMENTID(), taxFileMainUpdateDO.getFTMPID(), taxFileMainUpdateDO.getFDECLARESTATUS(), taxFileMainUpdateDO.getFDECLAREWAY(), taxFileMainUpdateDO.getFDECLAREMONTH(), taxFileMainUpdateDO.getFREPORTSTATUS(), taxFileMainUpdateDO.getFLOCKSTATUS(), taxFileMainUpdateDO.getFTAXFILEMODIFYTIME(), taxFileMainUpdateDO.getFCHANGETYPE(), taxFileMainUpdateDO.getFJOBID(), taxFileMainUpdateDO.getFEMPPOSINFOID(), taxFileMainUpdateDO.getFTAXSTATUS(), taxFileMainUpdateDO.getFBOID(), taxFileMainUpdateDO.getFISCURRENTVERSION(), taxFileMainUpdateDO.getFDATASTATUS(), taxFileMainUpdateDO.getFID()});
                }
                for (Map.Entry entry : taxFileADOMap.entrySet()) {
                    TaxFileAUpdateDO taxFileAUpdateDO = (TaxFileAUpdateDO)entry.getValue();
                    taxFileAUpdateParamList.add(new Object[]{taxFileAUpdateDO.getFID(), taxFileAUpdateDO.getFSOURCEVID(), taxFileAUpdateDO.getFFIRSTBSED(), taxFileAUpdateDO.getFCHANGEBSED(), taxFileAUpdateDO.getFBRED(), taxFileAUpdateDO.getFBRLED(), taxFileAUpdateDO.getFBRFD(), taxFileAUpdateDO.getFHISVERSION(), taxFileAUpdateDO.getFISMODIFY(), taxFileAUpdateDO.getFPERCREID(), taxFileAUpdateDO.getFPEREDUEXPID(), taxFileAUpdateDO.getFPERTSPROPID(), taxFileAUpdateDO.getFPERNONTSPROPID(), taxFileAUpdateDO.getFEMPPOSORGRELID(), taxFileAUpdateDO.getFPERSONVID()});
                }
                for (Map.Entry entry : taxFileMainDoHisVersionMap.entrySet()) {
                    TaxFileMainUpdateDO taxFileMainUpdateHisDO = (TaxFileMainUpdateDO)entry.getValue();
                    insertTaxFileMainHisParamList.add(new Object[]{taxFileMainUpdateHisDO.getFID(), taxFileMainUpdateHisDO.getFNUMBER(), taxFileMainUpdateHisDO.getFCREATORID(), taxFileMainUpdateHisDO.getFCREATETIME(), taxFileMainUpdateHisDO.getFMODIFIERID(), taxFileMainUpdateHisDO.getFMODIFYTIME(), taxFileMainUpdateHisDO.getFENABLE(), taxFileMainUpdateHisDO.getFINDEX(), taxFileMainUpdateHisDO.getFSTATUS(), taxFileMainUpdateHisDO.getFDISABLERID(), taxFileMainUpdateHisDO.getFDISABLEDATE(), taxFileMainUpdateHisDO.getFISSYSPRESET(), taxFileMainUpdateHisDO.getFMASTERID(), taxFileMainUpdateHisDO.getFBSED(), taxFileMainUpdateHisDO.getFBSLED(), taxFileMainUpdateHisDO.getFNAME(), taxFileMainUpdateHisDO.getFSIMPLENAME(), taxFileMainUpdateHisDO.getFDESCRIPTION(), taxFileMainUpdateHisDO.getFPERSONID(), taxFileMainUpdateHisDO.getFORGID(), taxFileMainUpdateHisDO.getFTAXREGIONID(), taxFileMainUpdateHisDO.getFDEPCYTYPEID(), taxFileMainUpdateHisDO.getFADMINORGID(), taxFileMainUpdateHisDO.getFATTACHADMINORGID(), taxFileMainUpdateHisDO.getFEMPGROUPID(), taxFileMainUpdateHisDO.getFTAXUNITID(), taxFileMainUpdateHisDO.getFADMINDIVISIONID(), taxFileMainUpdateHisDO.getFSTARTTAXDATE(), taxFileMainUpdateHisDO.getFISESCROWSTAFF(), taxFileMainUpdateHisDO.getFTAXPERSONID(), taxFileMainUpdateHisDO.getFPOSITIONID(), taxFileMainUpdateHisDO.getFCOMPANYID(), taxFileMainUpdateHisDO.getFDEPARTMENTID(), taxFileMainUpdateHisDO.getFEMPLOYMENTID(), taxFileMainUpdateHisDO.getFTMPID(), taxFileMainUpdateHisDO.getFDECLARESTATUS(), taxFileMainUpdateHisDO.getFDECLAREWAY(), taxFileMainUpdateHisDO.getFDECLAREMONTH(), taxFileMainUpdateHisDO.getFREPORTSTATUS(), taxFileMainUpdateHisDO.getFLOCKSTATUS(), taxFileMainUpdateHisDO.getFTAXFILEMODIFYTIME(), taxFileMainUpdateHisDO.getFCHANGETYPE(), taxFileMainUpdateHisDO.getFJOBID(), taxFileMainUpdateHisDO.getFEMPPOSINFOID(), taxFileMainUpdateHisDO.getFTAXSTATUS(), taxFileMainUpdateHisDO.getFBOID(), taxFileMainUpdateHisDO.getFISCURRENTVERSION(), taxFileMainUpdateHisDO.getFDATASTATUS()});
                }
                for (Map.Entry entry : taxFileADoHisVersionMap.entrySet()) {
                    TaxFileAUpdateDO taxFileAUpdateHisDO = (TaxFileAUpdateDO)entry.getValue();
                    insertTaxFileAHisParamList.add(new Object[]{taxFileAUpdateHisDO.getFID(), taxFileAUpdateHisDO.getFSOURCEVID(), taxFileAUpdateHisDO.getFFIRSTBSED(), taxFileAUpdateHisDO.getFCHANGEBSED(), taxFileAUpdateHisDO.getFBRED(), taxFileAUpdateHisDO.getFBRLED(), taxFileAUpdateHisDO.getFBRFD(), taxFileAUpdateHisDO.getFHISVERSION(), taxFileAUpdateHisDO.getFISMODIFY(), taxFileAUpdateHisDO.getFPERCREID(), taxFileAUpdateHisDO.getFPEREDUEXPID(), taxFileAUpdateHisDO.getFPERTSPROPID(), taxFileAUpdateHisDO.getFPERNONTSPROPID(), taxFileAUpdateHisDO.getFEMPPOSORGRELID(), taxFileAUpdateHisDO.getFPERSONVID()});
                }
                try (TXHandle txHandle = TX.requiresNew();){
                    if (!CollectionUtils.isEmpty((Collection)taxFileMainUpdateParamList)) {
                        SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)updateTaxFileMainSql, (List)taxFileMainUpdateParamList);
                    }
                    if (!CollectionUtils.isEmpty((Collection)taxFileAUpdateParamList)) {
                        SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)insertTaxFileASql, (List)taxFileAUpdateParamList);
                    }
                    if (!CollectionUtils.isEmpty((Collection)insertTaxFileMainHisParamList)) {
                        SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)insertTaxFileMainSql, (List)insertTaxFileMainHisParamList);
                    }
                    if (!CollectionUtils.isEmpty((Collection)insertTaxFileAHisParamList)) {
                        SITDbUtil.executeBatch((DBRoute)SITConstants.SIT_ROUTE, (String)insertTaxFileASql, (List)insertTaxFileAHisParamList);
                    }
                    LOGGER.info("TaxFileUpdateService end");
                }
                dateSet = SITDbUtil.queryDataSet((String)"queryTaxFileSQL", (DBRoute)SITConstants.SIT_ROUTE, (String)queryTaxFileSQL, (Object[])new Object[0]);
            }
        }
    }

    private void cleanDirtyData() {
        try (TXHandle handle = TX.requiresNew();){
            this.executeSqlWithoutParams(DELETE_DIRTY_DATA);
        }
    }

    private void fullIdsToMap(Map<Long, TaxFileMainUpdateDO> taxFileMainDoMap, Map<Long, Long> taxFileHisVersionId1Maps) {
        long[] taxFileHisVersionIds = DB.genLongIds((String)"T_ITC_TAXFILE", (int)taxFileMainDoMap.size());
        int num = 0;
        for (Map.Entry<Long, TaxFileMainUpdateDO> entry : taxFileMainDoMap.entrySet()) {
            taxFileHisVersionId1Maps.put(entry.getKey(), taxFileHisVersionIds[num++]);
        }
    }

    private void getTaxFileADOMap(Map<Long, TaxFileMainUpdateDO> taxFileMainDoMap, TaxFileAUpdateDO.Builder taxFileABuilder, Map<Long, TaxFileAUpdateDO> taxFileADOMap) {
        List<Long> personIds = taxFileMainDoMap.values().stream().map(TaxFileMainUpdateDO::getFPERSONID).collect(Collectors.toList());
        Map<Long, Long> personVidMap = this.getHrpiPersonVidMap(personIds);
        Map<Long, Long> percreVidMap = this.getHrpiPercreVidMap(personIds);
        Map<Long, Long> pernontspropVidMap = this.getHrpiPernontspropVidMap(personIds);
        Map<Long, Long> pereduexpVidMap = this.getHrpiPereduexpVidMap(personIds);
        Map<Long, Long> pertspropVidMap = this.getHrpiPertspropVidMap(personIds);
        Table<Long, String, Long> empposorgrelIdMap = this.getHrpiEmpposorgrelIdMap(personIds);
        LOGGER.info("personVidMap is {}", personVidMap);
        LOGGER.info("percreVidMap is {}", percreVidMap);
        LOGGER.info("pernontspropVidMap is {}", pernontspropVidMap);
        LOGGER.info("pereduexpVidMap is {}", pereduexpVidMap);
        LOGGER.info("pertspropVidMap is {}", pertspropVidMap);
        LOGGER.info("empposorgrelIdMap is {}", empposorgrelIdMap);
        for (Map.Entry<Long, TaxFileMainUpdateDO> entry : taxFileMainDoMap.entrySet()) {
            Long taxFileBoid = entry.getKey();
            TaxFileMainUpdateDO taxFileMainUpdateDO = entry.getValue();
            Long personBoid = taxFileMainUpdateDO.getFPERSONID();
            Long defId = (Long)BaseDataConverter.convert((Object)"0", Long.class);
            taxFileADOMap.put(taxFileBoid, taxFileABuilder.fid(taxFileMainUpdateDO.getFID()).fsourcevid(Long.valueOf(0L)).ffirstbsed("A".equals(taxFileMainUpdateDO.getFSTATUS()) ? null : taxFileMainUpdateDO.getFBSED()).fchangebsed(null).fbred(null).fbrled(null).fbrfd(null).fchangedescription(null).fhisversion(" ").fismodify("0").fpercreid(percreVidMap.get(personBoid) == null ? defId : percreVidMap.get(personBoid)).fpereduexpid(pereduexpVidMap.get(personBoid) == null ? defId : pereduexpVidMap.get(personBoid)).fpertspropid(pertspropVidMap.get(personBoid) == null ? defId : pertspropVidMap.get(personBoid)).fpernontspropid(pernontspropVidMap.get(personBoid) == null ? defId : pernontspropVidMap.get(personBoid)).fempposorgrelid(empposorgrelIdMap.get((Object)personBoid, (Object)"vid") == null ? defId : (Long)empposorgrelIdMap.get((Object)personBoid, (Object)"vid")).fpersonvid(personVidMap.get(personBoid) == null ? defId : personVidMap.get(personBoid)).build());
            taxFileMainUpdateDO.setFEMPLOYMENTID(empposorgrelIdMap.get((Object)personBoid, (Object)"boid") == null ? defId : (Long)empposorgrelIdMap.get((Object)personBoid, (Object)"boid"));
        }
        LOGGER.info("taxFileAUpdateDOMap size is {}", (Object)taxFileADOMap.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTaxFileMainDoMap(DataSet dateSet, Map<Long, TaxFileMainUpdateDO> taxFileMainDoMap, TaxFileMainUpdateDO.Builder taxFileMainBuilder) {
        try {
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                taxFileMainDoMap.put(row.getLong("FID"), taxFileMainBuilder.fid(row.getLong("FID")).fnumber(row.getString("FNUMBER")).fcreatorid(row.getLong("FCREATORID")).fcreatetime(row.getDate("FCREATETIME")).fmodifierid(row.getLong("FMODIFIERID")).fmodifytime(row.getDate("FMODIFYTIME")).fenable(row.getString("FENABLE")).findex(row.getInteger("FINDEX")).fstatus(this.getStatus(row.getString("FSTATUS"))).fdisablerid(row.getLong("FDISABLERID")).fdisabledate(row.getDate("FDISABLEDATE")).fissyspreset("0").fmasterid(row.getLong("FID")).fbsed(row.getDate("FBSED")).fbsled(row.getDate("FBSLED") != null ? row.getDate("FBSLED") : new Timestamp(SITHisBaseConstants.NEW_BSLED.getTime())).fname(row.getString("FNAME")).fsimplename(row.getString("FSIMPLENAME")).fdescription(row.getString("FDESCRIPTION")).fpersonid(row.getLong("FPERSONID")).forgid(row.getLong("FORGID")).ftaxregionid(row.getLong("FTAXREGIONID")).fdepcytypeid(row.getLong("FDEPCYTYPEID")).fadminorgid(Long.valueOf(0L)).fattachadminorgid(Long.valueOf(0L)).fempgroupid(row.getLong("FEMPGROUPID")).ftaxunitid(row.getLong("FTAXUNITID")).fadmindivisionid(row.getLong("FADMINDIVISIONID")).fstarttaxdate(null).fisescrowstaff(row.getString("FISESCROWSTAFF")).ftaxpersonid(Long.valueOf(0L)).fpositionid(Long.valueOf(0L)).fcompanyid(Long.valueOf(0L)).fdepartmentid(Long.valueOf(0L)).femploymentid(row.getLong("FEMPPOSINFOID")).ftmpid(row.getLong("FTMPID")).fdeclarestatus(row.getString("FDECLARESTATUS")).fdeclaremonth(row.getDate("FDECLAREMONTH")).fdeclareway("0").freportstatus(row.getString("FREPORTSTATUS")).flockstatus(row.getString("FLOCKSTATUS")).ftaxfilemodifytime(null).fchangetype("1").fjobid(Long.valueOf(0L)).fempposinfoid(Long.valueOf(0L)).ftaxstatus(YesOrNoEnum.YES.getCode()).fboid(row.getLong("FID")).fiscurrentversion(YesOrNoEnum.YES.getCode()).fdatastatus(this.getDataStatus(row.getString("FSTATUS"), row.getDate("FBSED"), row.getDate("FBSLED"))).build());
            }
        }
        finally {
            dateSet.close();
        }
        LOGGER.info("taxFileMainDoMap size is {}", (Object)taxFileMainDoMap.size());
    }

    private Table<Long, String, Long> getHrpiEmpposorgrelIdMap(List<Long> personIds) {
        HashBasedTable empposorgrelIdMap = HashBasedTable.create();
        if (CollectionUtils.isEmpty(personIds)) {
            return empposorgrelIdMap;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT FID,FSOURCEVID,FPERSONID,FBOID FROM T_HRPI_EMPPOSORGREL WHERE FISCURRENTVERSION = '1' AND FDATASTATUS = '1' AND FBUSINESSSTATUS = '1' AND FISPRIMARY = '1' AND FPERSONID IN (");
        sqlBuilder.append(Joiner.on((String)",").join(personIds)).append(')');
        try (DataSet dateSet = SITDbUtil.queryDataSet((String)"queryEmpposorgrelVid", (DBRoute)new DBRoute("hr"), (String)sqlBuilder.toString(), (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long personBoid = row.getLong("FPERSONID");
                Long empposorgrelVid = row.getLong("FSOURCEVID");
                Long empposorgrelBoid = row.getLong("FBOID");
                empposorgrelIdMap.put((Object)personBoid, (Object)"vid", (Object)empposorgrelVid);
                empposorgrelIdMap.put((Object)personBoid, (Object)"boid", (Object)empposorgrelBoid);
            }
        }
        return empposorgrelIdMap;
    }

    private Map<Long, Long> getHrpiPertspropVidMap(List<Long> personIds) {
        HashMap pertspropVidMap = Maps.newHashMapWithExpectedSize((int)personIds.size());
        if (CollectionUtils.isEmpty(personIds)) {
            return pertspropVidMap;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT FID,FSOURCEVID,FPERSONID FROM T_HRPI_PERTSPROP WHERE FISCURRENTVERSION = '1' AND FDATASTATUS = '1' AND FPERSONID IN (");
        sqlBuilder.append(Joiner.on((String)",").join(personIds)).append(')');
        try (DataSet dateSet = SITDbUtil.queryDataSet((String)"queryPertspropVid", (DBRoute)new DBRoute("hr"), (String)sqlBuilder.toString(), (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long personBoid = row.getLong("FPERSONID");
                Long pertspropVid = row.getLong("FSOURCEVID");
                pertspropVidMap.put(personBoid, pertspropVid);
            }
        }
        return pertspropVidMap;
    }

    private Map<Long, Long> getHrpiPereduexpVidMap(List<Long> personIds) {
        HashMap pereduexpVidMap = Maps.newHashMapWithExpectedSize((int)personIds.size());
        if (CollectionUtils.isEmpty(personIds)) {
            return pereduexpVidMap;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT FID,FSOURCEVID,FPERSONID FROM T_HRPI_PEREDUEXP WHERE FISCURRENTVERSION = '1' AND FISHIGHESTDEGREE = '1' AND FDATASTATUS = '1' AND FPERSONID IN (");
        sqlBuilder.append(Joiner.on((String)",").join(personIds)).append(')');
        try (DataSet dateSet = SITDbUtil.queryDataSet((String)"queryPereduexpVid", (DBRoute)new DBRoute("hr"), (String)sqlBuilder.toString(), (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long personBoid = row.getLong("FPERSONID");
                Long pereduexpVid = row.getLong("FSOURCEVID");
                pereduexpVidMap.put(personBoid, pereduexpVid);
            }
        }
        return pereduexpVidMap;
    }

    private Map<Long, Long> getHrpiPernontspropVidMap(List<Long> personIds) {
        HashMap pernontspropVidMap = Maps.newHashMapWithExpectedSize((int)personIds.size());
        if (CollectionUtils.isEmpty(personIds)) {
            return pernontspropVidMap;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT FID,FSOURCEVID,FPERSONID FROM T_HRPI_PERNONTSPROP WHERE FISCURRENTVERSION = '1' AND FDATASTATUS = '1' AND FPERSONID IN (");
        sqlBuilder.append(Joiner.on((String)",").join(personIds)).append(')');
        try (DataSet dateSet = SITDbUtil.queryDataSet((String)"queryPernontspropVid", (DBRoute)new DBRoute("hr"), (String)sqlBuilder.toString(), (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long personBoid = row.getLong("FPERSONID");
                Long pernontspropVid = row.getLong("FSOURCEVID");
                pernontspropVidMap.put(personBoid, pernontspropVid);
            }
        }
        return pernontspropVidMap;
    }

    private Map<Long, Long> getHrpiPercreVidMap(List<Long> personIds) {
        HashMap percreVidMap = Maps.newHashMapWithExpectedSize((int)personIds.size());
        if (CollectionUtils.isEmpty(personIds)) {
            return percreVidMap;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT FID,FSOURCEVID,FPERSONID FROM T_HRPI_PERCRE WHERE FISCURRENTVERSION = '1' AND FDATASTATUS = '1' AND FISMAJOR = '1' AND FPERSONID IN (");
        sqlBuilder.append(Joiner.on((String)",").join(personIds)).append(')');
        try (DataSet dateSet = SITDbUtil.queryDataSet((String)"queryPercreVid", (DBRoute)new DBRoute("hr"), (String)sqlBuilder.toString(), (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long personBoid = row.getLong("FPERSONID");
                Long percreVid = row.getLong("FSOURCEVID");
                percreVidMap.put(personBoid, percreVid);
            }
        }
        return percreVidMap;
    }

    private Map<Long, Long> getHrpiPersonVidMap(List<Long> personIds) {
        HashMap personVidMap = Maps.newHashMapWithExpectedSize((int)personIds.size());
        if (CollectionUtils.isEmpty(personIds)) {
            return personVidMap;
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT FID,FSOURCEVID,FBOID FROM T_HRPI_PERSON WHERE FISCURRENTVERSION = '1' AND FDATASTATUS = '1' AND FBOID IN (");
        sqlBuilder.append(Joiner.on((String)",").join(personIds)).append(')');
        try (DataSet dateSet = SITDbUtil.queryDataSet((String)"queryPersonVid", (DBRoute)new DBRoute("hr"), (String)sqlBuilder.toString(), (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long personBoid = row.getLong("FBOID");
                Long personVid = row.getLong("FSOURCEVID");
                personVidMap.put(personBoid, personVid);
            }
        }
        return personVidMap;
    }

    private String getStatus(String fstatus) {
        if ("E".equals(fstatus)) {
            return "E";
        }
        if ("A".equals(fstatus)) {
            return "A";
        }
        return "C";
    }

    private String getDataStatus(String fstatus, Date rowBsed, Date rowBsled) {
        Date bsled;
        if ("A".equals(fstatus)) {
            return "-3";
        }
        Date now = new Date();
        Date bsed = rowBsed;
        Date date = bsled = rowBsled == null ? SITHisBaseConstants.NEW_BSLED : rowBsled;
        if (bsed == null || now.before(bsed)) {
            return "0";
        }
        if (!now.before(bsed) && !now.after(bsled)) {
            return "1";
        }
        return "2";
    }
}

