/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxdata;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxdata.model.TaxDataMergeAlgorithmParamInitializer;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.listener.TaxTaskGuideOpListenerFactory;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.CustomFunction;
import kd.sit.sitbp.common.api.DataFilter;
import kd.sit.sitbp.common.api.MergeAlgorithm;
import kd.sit.sitbp.common.api.MergeAlgorithmParamInitializer;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxDataWrapper;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.SitBaseUtil;

public class TaxDataServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(TaxDataServiceHelper.class);

    public static void updateTaxDataFromRawDataV2(TaxTaskEntity taxTaskEntity, DynamicObject taxData, Collection<DynamicObject> srcDataList) {
        HashMap<String, Object> itemParam = new HashMap<String, Object>();
        HashMap<Long, DynamicObject> oldValues = new HashMap<Long, DynamicObject>();
        itemParam.put("oldValues", oldValues);
        DynamicObjectCollection entryEntity = taxData.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : entryEntity) {
            oldValues.put(object.getLong("taxitem.id"), object);
        }
        entryEntity.clear();
        int yearMonth = taxTaskEntity.yearMonth();
        TaxTaskGuideOpEnum.initStatus((DynamicObject)taxData);
        HashMap entryMap = Maps.newHashMapWithExpectedSize((int)entryEntity.size());
        for (DynamicObject srcData : srcDataList) {
            DynamicObjectCollection srcEntryEntity = srcData.getDynamicObjectCollection("entryentity");
            for (DynamicObject srcItem : srcEntryEntity) {
                DynamicObject item = entryMap.computeIfAbsent(srcItem.getLong("taxitem.id"), ky -> {
                    DynamicObject itemTemp = entryEntity.addNew();
                    itemTemp.set("entryyearmonth", (Object)yearMonth);
                    itemTemp.set("taxitem", srcItem.get("taxitem"));
                    return itemTemp;
                });
                TaxDataServiceHelper.mergeItemValue(taxTaskEntity, item, srcItem, itemParam);
            }
        }
    }

    public static void updateTaxDataFromRawData(TaxTaskEntity taxTaskEntity, TaxDataWrapper taxData, Collection<TaxDataWrapper> srcDataList, List<DynamicObject> oldList, List<DynamicObject> newList, List<DynamicObject> srcDataListAll, HRBaseServiceHelper dataServiceHelper) {
        Map categoryMap = taxData.getCategoryData();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)categoryMap.size());
        for (Map.Entry entry : categoryMap.entrySet()) {
            DynamicObject category = (DynamicObject)entry.getValue();
            oldList.add(category);
            HashMap itemParam = new HashMap();
            paramMap.put(entry.getKey(), itemParam);
            HashMap<Long, DynamicObject> oldValues = new HashMap<Long, DynamicObject>();
            itemParam.put("oldValues", oldValues);
            DynamicObjectCollection entryEntity = category.getDynamicObjectCollection("entryentity");
            for (DynamicObject object : entryEntity) {
                oldValues.put(object.getLong("taxitem.id"), object);
            }
        }
        taxData.clearItems();
        ORM orm = ORM.create();
        int size = TaxDataServiceHelper.newSize(taxData, srcDataList);
        long[] ids = orm.genLongIds("itc_taxdata", size);
        int index = 0;
        DynamicObject taxTask = (DynamicObject)taxData.getBasicProp("taxtask");
        int yearMonth = taxTaskEntity.yearMonth();
        for (TaxDataWrapper srcData : srcDataList) {
            Map categoryData = srcData.getCategoryData();
            for (Map.Entry entry : categoryData.entrySet()) {
                DynamicObject src = (DynamicObject)entry.getValue();
                srcDataListAll.add(src);
                if ("D".equals(src.getString("status")) || TaxDataBizStatusEnum.TO_DEL.getCode().equals(src.getString("bizstatus"))) {
                    src.set("status", (Object)"E");
                    continue;
                }
                DynamicObject category = taxData.getCategory((Long)entry.getKey());
                Map param = paramMap.computeIfAbsent(entry.getKey(), k1 -> new HashMap(4));
                if (category == null) {
                    DynamicObject basicData = taxData.getBasicData();
                    category = dataServiceHelper.generateEmptyDynamicObject();
                    category.set("id", (Object)ids[index++]);
                    category.set("taxdatabasic", (Object)basicData);
                    category.set("yearmonth", taxData.getBasicProp("yearmonth"));
                    category.set("taxTask", (Object)taxTask);
                    category.set("taxcategory", ((DynamicObject)entry.getValue()).get("taxcategory"));
                    category.set("bizstatus", (Object)TaxDataBizStatusEnum.REFER.getCode());
                    category.set("taxunit", (Object)src.getLong("taxfile.taxunit.id"));
                    category.set("taxfile", src.get("taxfile"));
                    category.set("employment", src.get("employment"));
                    category.set("taxperson", src.get("taxperson"));
                    category.set("percre", basicData.get("percre"));
                    category.set("pernontsprop", basicData.get("pernontsprop"));
                    category.set("empposorgrel", basicData.get("empposorgrel"));
                    category.set("company", basicData.get("company"));
                    taxData.addCategoryData(category);
                    newList.add(category);
                }
                category.set("status", (Object)"C");
                if (!TaxTaskGuideOpEnum.isYes((String)src.getString("refoprecord.optype"))) {
                    TaxTaskGuideOpEnum.initStatus((DynamicObject)category);
                }
                src.set("taxtask", (Object)taxTask);
                src.set("taxdata", category.get("id"));
                DynamicObjectCollection srcEntryEntity = src.getDynamicObjectCollection("entryentity");
                DynamicObjectCollection entryEntity = category.getDynamicObjectCollection("entryentity");
                for (DynamicObject srcItem : srcEntryEntity) {
                    DynamicObject item = taxData.getItem(Long.valueOf(srcItem.getLong("taxitem.id")), (Long)entry.getKey());
                    if (item == null) {
                        item = entryEntity.addNew();
                        item.set("entryyearmonth", (Object)yearMonth);
                        item.set("taxitem", srcItem.get("taxitem"));
                        taxData.addItem(item, (Long)entry.getKey());
                    }
                    TaxDataServiceHelper.mergeItemValue(taxTaskEntity, item, srcItem, param);
                }
            }
        }
    }

    public static int newSize(TaxDataWrapper taxData, Collection<TaxDataWrapper> srcDataList) {
        HashSet keys = new HashSet(srcDataList.size() * 4);
        for (TaxDataWrapper srcData : srcDataList) {
            if (srcData.getCategoryData() == null) continue;
            keys.addAll(srcData.getCategoryData().keySet());
        }
        Map categoryData = taxData.getCategoryData();
        if (categoryData == null) {
            return keys.size();
        }
        keys.removeAll(categoryData.keySet());
        return keys.size();
    }

    public static BaseResult<?> mergeItemValue(TaxTaskEntity taxTaskEntity, DynamicObject item, DynamicObject srcItem, Map<String, Object> param) {
        String dataDirect = srcItem.getString("datadirect");
        if (!taxTaskEntity.isLocalCal() && !CalTaxTypeEnum.SUBMIT.getCode().equals(dataDirect)) {
            DynamicObject oldObject;
            Map oldValues = (Map)param.get("oldValues");
            if (oldValues != null && (oldObject = (DynamicObject)oldValues.get(srcItem.getLong("taxitem.id"))) != null) {
                item.set("itemvalue", oldObject.get("itemvalue"));
                item.set("calvalue", oldObject.get("calvalue"));
            }
            return BaseResult.success((Object)item);
        }
        BaseResult algorithmRes = MergeAlgorithm.genMergeAlgorithm((TaxTaskEntity)taxTaskEntity, (String)dataDirect, (long)((DynamicObject)srcItem.getParent()).getLong("taxcategory.id"), (long)srcItem.getLong("taxitem.id"), param);
        if (!algorithmRes.isSuccess()) {
            return algorithmRes;
        }
        ((MergeAlgorithm)algorithmRes.getData()).genParams((Object)item, (Object)srcItem, param, (MergeAlgorithmParamInitializer)TaxDataMergeAlgorithmParamInitializer.INSTANCE);
        return ((MergeAlgorithm)algorithmRes.getData()).merge((Object)item, (Object)srcItem, param);
    }

    public static void updateTaxDataBasicFromRawDataBasic(DynamicObject taxDataBasic, TaxDataWrapper taxSrcDataWrapper, TaxTaskEntity taxTaskEntity) {
        taxDataBasic.set("yearmonth", (Object)taxTaskEntity.yearMonth());
        taxDataBasic.set("taxtask", (Object)taxTaskEntity.taxTask());
        DynamicObject taxSrcData = taxSrcDataWrapper.getBasicData();
        taxDataBasic.set("taxfile", (Object)taxSrcData.getDynamicObject("taxfile"));
        taxDataBasic.set("company", (Object)taxSrcData.getDynamicObject("company"));
        taxDataBasic.set("calstatus", (Object)"1");
        taxDataBasic.set("taxunit", (Object)taxSrcData.getLong("taxfile.taxunit.id"));
        SitBaseUtil.initSystemProp((DynamicObject)taxDataBasic);
    }

    public static DynamicObject[] queryTaxSrcData(TaxTaskEntity taxTaskEntity, Object[] dataIds, String props) {
        QFilter yearMonthFilter = new QFilter("yearmonth", "=", (Object)taxTaskEntity.yearMonth());
        QFilter dataFilter = new QFilter("taxdata", "in", (Object)dataIds);
        QFilter bizStatusFilter = new QFilter("bizstatus", ">=", (Object)TaxDataBizStatusEnum.TO_DEL.getCode());
        QFilter basicStatusFilter = new QFilter("taxdatabasic.status", "!=", (Object)"E");
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        if (StringUtils.isEmpty((CharSequence)props)) {
            PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxrawdata").subProp("entryentity", new String[]{"seq", "entryyearmonth", "taxitem", "taxcategory", "itemvalue", "datadirect", "calvalue", "diffvalue"});
            props = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, (DataFilter)SitDataServiceHelper.DEFAULT_FILTER);
        }
        HRBaseServiceHelper srcDataServiceHelper = new HRBaseServiceHelper("itc_taxrawdata");
        return srcDataServiceHelper.query(props, new QFilter[]{yearMonthFilter, dataFilter, bizStatusFilter, basicStatusFilter, statusFilter});
    }

    public static BatchResult<DynamicObject> saveTaxData(BatchResult<DynamicObject> taxDataResult, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum, boolean newTx, CustomFunction ... customs) {
        BaseResult<DynamicObject> taxTaskRecord = TaxTaskGuideServiceHelper.createTaxTaskRecord(taxTaskEntity, stepCaseInfo, opEnum, null);
        return TaxDataServiceHelper.saveTaxData(taxDataResult, taxTaskEntity, stepCaseInfo, (DynamicObject)taxTaskRecord.getData(), newTx, customs);
    }

    public static BatchResult<DynamicObject> saveTaxData(BatchResult<DynamicObject> taxDataResult, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, DynamicObject taxTaskOpRecord, boolean newTx, CustomFunction ... customs) {
        Map<Object, Object> srcDataMap = (HashMap)GlobalParam.get((String)"srcDataToBeRefer");
        if (srcDataMap == null) {
            List successResult = taxDataResult.successResult();
            Object[] ids = successResult.stream().map(e1 -> e1.get("id")).toArray();
            Object[] srcData = TaxDataServiceHelper.queryTaxSrcData(taxTaskEntity, ids, null);
            srcDataMap = ArrayUtils.isNotEmpty((Object[])srcData) ? Arrays.asList(srcData).stream().filter(e1 -> e1.getLong("id") != 0L && e1.getLong("taxfile.id") != 0L).collect(Collectors.groupingBy(e1 -> e1.getLong("taxdata"))) : new HashMap(0);
        }
        return TaxDataServiceHelper.saveTaxData(taxDataResult, taxTaskEntity, stepCaseInfo, taxTaskOpRecord, (Map<Long, List<DynamicObject>>)srcDataMap, newTx, customs);
    }

    public static BatchResult<DynamicObject> saveTaxData(BatchResult<DynamicObject> taxDataResult, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum, Map<Long, List<DynamicObject>> srcDataMap, boolean newTx, CustomFunction ... customs) {
        LOGGER.info("Trace By Quinn, {} - {} - {}", new Object[]{"saveTaxData start", "", ""});
        BaseResult<DynamicObject> taxTaskRecord = TaxTaskGuideServiceHelper.createTaxTaskRecord(taxTaskEntity, stepCaseInfo, opEnum, null);
        LOGGER.info("Trace By Quinn, {} - {} - {}", (Object)"saveTaxData createTaxTaskRecord", (Object)"");
        TaxDataServiceHelper.saveTaxData(taxDataResult, taxTaskEntity, stepCaseInfo, (DynamicObject)taxTaskRecord.getData(), srcDataMap, newTx, customs);
        LOGGER.info("Trace By Quinn, {} - {} - {}", new Object[]{"saveTaxData end", taxDataResult.isSuccess(), taxDataResult.getMessage()});
        return taxDataResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<DynamicObject> saveTaxData(BatchResult<DynamicObject> taxDataResult, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, DynamicObject taxTaskRecord, Map<Long, List<DynamicObject>> srcDataMap, boolean newTx, CustomFunction ... customs) {
        String opType = taxTaskRecord.getString("optype");
        TaxTaskGuideOpEnum opEnum = TaxTaskGuideOpEnum.of((String)opType);
        LOGGER.info("Trace By Quinn, {} - {} - {}", new Object[]{"saveTaxData TaxTaskGuideOpEnum", opEnum, ""});
        List srcDataList = opEnum.handleBatch(taxDataResult, srcDataMap, taxTaskRecord, taxTaskEntity);
        LOGGER.info("Trace By Quinn, {} - {} - {}", new Object[]{"saveTaxData handleBatch", srcDataList.size(), ""});
        List successResult = taxDataResult.successResult();
        ArrayList deleteList = Lists.newArrayListWithExpectedSize((int)successResult.size());
        ArrayList updateList = Lists.newArrayListWithExpectedSize((int)successResult.size());
        for (DynamicObject object : successResult) {
            if (TaxDataBizStatusEnum.NEW.isGreaterThan(object.getString("bizstatus"))) {
                object.set("status", (Object)"E");
                updateList.add(object);
                continue;
            }
            updateList.add(object);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdata");
        try (TXHandle required = newTx ? TX.requiresNew() : TX.required();){
            for (CustomFunction function : customs) {
                LOGGER.info("Trace By Quinn, {} - {} - {}", new Object[]{"saveTaxData function.apply()", function.toString(), ""});
                function.apply();
            }
            if (!CollectionUtils.isEmpty((Collection)deleteList)) {
                LOGGER.info("Trace By Quinn, {} - {} - {}", new Object[]{"saveTaxData function.apply()", "deleteList", ""});
                serviceHelper.delete((Object[])deleteList.toArray(new Long[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)updateList)) {
                LOGGER.info("Trace By Quinn, {} - {} - {}", new Object[]{"saveTaxData function.apply()", "updateList", ""});
                serviceHelper.save(updateList.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty((Collection)srcDataList)) {
                LOGGER.info("Trace By Quinn, {} - {} - {}", new Object[]{"saveTaxData function.apply()", "srcDataList", ""});
                serviceHelper.save(srcDataList.toArray(new DynamicObject[0]));
            }
        }
        LOGGER.info("Trace By Quinn, {} - {} - {}", new Object[]{"saveTaxData beforeBatchOperation", taxDataResult.isSuccess(), taxDataResult.getMessage()});
        if (taxDataResult.isSuccess()) {
            TaxTaskGuideOpListenerFactory.afterBatchOperation(taxDataResult, srcDataMap, taxTaskRecord, taxTaskEntity, stepCaseInfo);
        }
        LOGGER.info("Trace By Quinn, {} - {} - {}", new Object[]{"saveTaxData afterBatchOperation", taxDataResult.isSuccess(), taxDataResult.getMessage()});
        return taxDataResult;
    }
}

