/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxdata.algo;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.sit.itc.business.taxdata.model.TaxDataMergeAlgorithmParamInitializer;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.sitbp.business.algo.TaxDataMergerAlgoHandler;
import kd.sit.sitbp.common.api.MergeAlgorithmParamInitializer;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.enums.SrcStatus;
import kd.sit.sitbp.common.model.algo.TaxDataDynObjWrapper;
import kd.sit.sitbp.common.util.GlobalParam;

public class DeleteTaxMergerAlgoHandler
extends TaxDataMergerAlgoHandler {
    protected boolean isValidSrcData(TaxDataDynObjWrapper srcDataWrapper) {
        DynamicObject srcData = srcDataWrapper.getData();
        Long rawCalTaskId = (Long)GlobalParam.get((String)"feedbackRollback_rawCalTaskId");
        return SrcStatus.RECEIVED.isGreaterThan(srcData.getString("taxdatabasic.srcstatus")) && (rawCalTaskId == null || rawCalTaskId == 0L || srcData.getLong("taxdatabasic.rawcaltask.id") == rawCalTaskId.longValue());
    }

    protected boolean isValidDataItem(DynamicObject taxDataItem, TaxItemEntity taxItem) {
        String option = (String)GlobalParam.get((String)"feedbackRollback_option");
        return StringUtils.equals((CharSequence)"2", (CharSequence)option) || !StringUtils.isEmpty((CharSequence)taxDataItem.getString("itemvalue")) && CalTaxTypeEnum.fromTaxById((long)taxItem.getCaltaxtypeId()) && !taxItem.isIncomeItem();
    }

    protected MergeAlgorithmParamInitializer getAlgoParamInitializer() {
        return TaxDataMergeAlgorithmParamInitializer.INSTANCE;
    }

    protected Map<Long, String> getNetTaxAlgoMap(Map<String, Object> param, TaxTaskEntity taxTaskEntity) {
        return TaxTaskServiceHelper.loadNetTaxAlgoMap(taxTaskEntity);
    }

    protected void dealValidData(DynamicObject taxDataItem, List<DynamicObject> validSrcDataItems, TaxItemEntity taxItem) {
        taxDataItem.set("itemvalue", null);
        taxDataItem.set("calvalue", null);
        if (CalTaxTypeEnum.fromTaxById((long)taxItem.getCaltaxtypeId())) {
            validSrcDataItems.forEach(obj -> obj.set("itemvalue", null));
            validSrcDataItems.forEach(obj -> obj.set("calvalue", null));
        }
    }
}

