/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxdata.algo;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.taxdata.model.ImportTaxDataSplitAlgoParamInitializer;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.sitbp.business.algo.TaxDataSplitAlgoHandler;
import kd.sit.sitbp.common.api.algo.SplitAlgoParamInitializer;
import kd.sit.sitbp.common.cal.api.CalNode;
import kd.sit.sitbp.common.cal.factory.CalResolverFactory;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.AlgoHandleResultEnum;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.enums.DataRoundEnum;
import kd.sit.sitbp.common.enums.SrcStatus;
import kd.sit.sitbp.common.model.algo.SplitInfo;
import kd.sit.sitbp.common.model.algo.TaxDataDynObjWrapper;
import kd.sit.sitbp.common.util.SitMathUtil;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class ImportTaxSplitAlgoHandler
extends TaxDataSplitAlgoHandler {
    protected Map<Long, String> getNetTaxAlgoMap(Map<String, Object> param, TaxTaskEntity taxTaskEntity) {
        return TaxTaskServiceHelper.loadNetTaxAlgoMap(taxTaskEntity);
    }

    protected boolean isValidSrcData(TaxDataDynObjWrapper srcDataWrapper) {
        DynamicObject srcData = srcDataWrapper.getData();
        return SrcStatus.RECEIVED.isGreaterThan(srcData.getString("taxdatabasic.srcstatus"));
    }

    protected boolean isValidDataItem(DynamicObject taxDataItem, TaxItemEntity taxItem) {
        return CalTaxTypeEnum.fromTaxById((long)taxItem.getCaltaxtypeId()) && !taxItem.isIncomeItem();
    }

    protected void afterValueIsNull(DynamicObject taxDataItem, List<DynamicObject> validSrcDataItems, TaxItemEntity taxItem) {
        taxDataItem.set("itemvalue", null);
        taxDataItem.set("calvalue", null);
        validSrcDataItems.forEach(obj -> {
            obj.set("itemvalue", null);
            obj.set("calvalue", null);
        });
    }

    protected SplitInfo buildSplitInfo(TaxItemEntity taxItem, TaxDataDynObjWrapper taxDataWrapper, List<TaxDataDynObjWrapper> validSrcDataWrappers, List<TaxDataDynObjWrapper> invalidSrcDataWrappers) {
        SplitInfo splitInfo = taxDataWrapper.getSplitInfo();
        if (splitInfo != null) {
            return splitInfo;
        }
        DynamicObject taxData = taxDataWrapper.getData();
        String netTaxAlgo = taxDataWrapper.getNetTaxAlgo();
        if (netTaxAlgo == null) {
            String msg = AlgoHandleResultEnum.NETTAX_CONFIG_FAIL.loadKDString(new Object[]{taxData.get("taxfile.number"), taxData.get("taxfile.person.name"), taxData.getString("taxcategory.name")});
            throw new KDBizException(msg);
        }
        HashMap<Long, Map<Long, DynamicObject>> srcDataEntryMap = new HashMap<Long, Map<Long, DynamicObject>>(validSrcDataWrappers.size());
        validSrcDataWrappers.forEach(obj -> srcDataEntryMap.put(obj.getData().getLong("id"), obj.getEntryMap()));
        Map<String, BigDecimal> proportionMap = this.resolveParam(srcDataEntryMap, netTaxAlgo);
        if (CollectionUtils.isEmpty(proportionMap)) {
            String msg = AlgoHandleResultEnum.NETTAX_ALGO_FAIL.loadKDString(new Object[]{taxData.get("taxfile.number"), taxData.get("taxfile.person.name")});
            throw new KDBizException(msg);
        }
        Long taxItemId = taxItem.getId();
        BigDecimal itemValue = taxDataWrapper.getEntry(taxItemId).getBigDecimal("itemvalue");
        if (!CollectionUtils.isEmpty(invalidSrcDataWrappers)) {
            for (TaxDataDynObjWrapper invalidSrcDataWrapper : invalidSrcDataWrappers) {
                DynamicObject srcTaxDataItem = invalidSrcDataWrapper.getEntry(taxItemId);
                if (srcTaxDataItem == null) continue;
                BigDecimal invalidItemValue = StringUtils.isEmpty((CharSequence)srcTaxDataItem.getString("itemvalue")) ? BigDecimal.ZERO : srcTaxDataItem.getBigDecimal("itemvalue");
                itemValue = itemValue.subtract(invalidItemValue);
            }
        }
        splitInfo = new SplitInfo();
        splitInfo.setTotalValue(itemValue);
        splitInfo.setRatioDenominator(proportionMap.get("total"));
        splitInfo.setRatioNumeratorMap(proportionMap);
        splitInfo.setScale(taxItem.getDataPrecisionScale());
        splitInfo.setDataRound(DataRoundEnum.roundById((long)taxItem.getDataRoundId()));
        taxDataWrapper.setSplitInfo(splitInfo);
        return splitInfo;
    }

    protected SplitAlgoParamInitializer getAlgoParamInitializer() {
        return ImportTaxDataSplitAlgoParamInitializer.INSTANCE;
    }

    private Map<String, BigDecimal> resolveParam(Map<Long, Map<Long, DynamicObject>> srcDataEntryMap, String netTaxAlgo) {
        HashMap<String, BigDecimal> totalMap = new HashMap<String, BigDecimal>(srcDataEntryMap.size());
        BigDecimal total = BigDecimal.ZERO;
        for (Map.Entry<Long, Map<Long, DynamicObject>> srcDataEntry : srcDataEntryMap.entrySet()) {
            Long srcId = srcDataEntry.getKey();
            Map<Long, DynamicObject> srcDataEntrys = srcDataEntry.getValue();
            HashMap<String, Object> paramMap = new HashMap<String, Object>(srcDataEntrys.size());
            for (Map.Entry<Long, DynamicObject> taxItemEntry : srcDataEntrys.entrySet()) {
                DynamicObject taxItem = taxItemEntry.getValue();
                paramMap.put(taxItem.getString("taxitem.id"), taxItem.get("itemvalue"));
            }
            HashMap<String, HashMap<String, Object>> params = new HashMap<String, HashMap<String, Object>>(2);
            params.put("TP", paramMap);
            CalNode calNode = CalResolverFactory.resolve((String)netTaxAlgo);
            BigDecimal result = (BigDecimal)BaseDataConverter.convert((Object)calNode.result(params), BigDecimal.class);
            totalMap.put(String.valueOf(srcId), result);
            if (result == null || result.compareTo(BigDecimal.ZERO) == 0) continue;
            total = SitMathUtil.nullSafeAdd((BigDecimal)total, (BigDecimal)result);
        }
        totalMap.put("total", total);
        return totalMap;
    }
}

