/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxdata.algo;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.sit.itc.business.taxdata.model.TaxDataSplitAlgoParamInitializer;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.sitbp.business.algo.TaxDataSplitAlgoHandler;
import kd.sit.sitbp.common.api.algo.SplitAlgoParamInitializer;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.enums.DataRoundEnum;
import kd.sit.sitbp.common.enums.SrcStatus;
import kd.sit.sitbp.common.model.algo.SplitInfo;
import kd.sit.sitbp.common.model.algo.TaxDataDynObjWrapper;
import kd.sit.sitbp.common.util.BaseResult;

public class LocalCalImportTaxSplitAlgoHandler
extends TaxDataSplitAlgoHandler {
    public static final Set<Long> noCalDiffItemMap = Sets.newHashSet((Object[])new Long[]{1123912110976296960L, 1123912111093736448L, 1123912112880510976L});
    public static final Set<Long> numberTypeIds = Sets.newHashSet((Object[])new Long[]{1010L, 1020L, 1040L});

    protected Map<Long, String> getNetTaxAlgoMap(Map<String, Object> param, TaxTaskEntity taxTaskEntity) {
        return TaxTaskServiceHelper.loadNetTaxAlgoMap(taxTaskEntity);
    }

    protected boolean isValidSrcData(TaxDataDynObjWrapper srcDataWrapper) {
        DynamicObject srcData = srcDataWrapper.getData();
        return SrcStatus.RECEIVED.isLessEqThan(srcData.getString("taxdatabasic.srcstatus"));
    }

    protected boolean isValidDataItem(DynamicObject taxDataItem, TaxItemEntity taxItem) {
        return CalTaxTypeEnum.fromTaxById((long)taxItem.getCaltaxtypeId()) && !taxItem.isIncomeItem();
    }

    protected void beforeLoopTaxDataItem(TaxDataDynObjWrapper taxDataWrapper, List<TaxDataDynObjWrapper> validSrcDataWrappers, List<TaxDataDynObjWrapper> invalidSrcDataWrappers) {
        DynamicObject data = taxDataWrapper.getData();
        data.set("hasdifference", (Object)"0");
        validSrcDataWrappers.forEach(obj -> obj.getData().set("hasdifference", (Object)"0"));
    }

    protected void afterValueIsNull(DynamicObject taxDataItem, List<DynamicObject> validSrcDataItems, TaxItemEntity taxItem) {
        taxDataItem.set("itemvalue", null);
        boolean calDifference = LocalCalImportTaxSplitAlgoHandler.isCalDifference(taxItem);
        if (calDifference) {
            LocalCalImportTaxSplitAlgoHandler.calDifference(taxDataItem);
        }
        validSrcDataItems.forEach(obj -> {
            obj.set("itemvalue", null);
            if (calDifference) {
                LocalCalImportTaxSplitAlgoHandler.calDifference(obj);
            }
        });
    }

    protected SplitInfo buildSplitInfo(TaxItemEntity taxItem, TaxDataDynObjWrapper taxDataWrapper, List<TaxDataDynObjWrapper> validSrcDataWrappers, List<TaxDataDynObjWrapper> invalidSrcDataWrappers) {
        SplitInfo splitInfo = taxDataWrapper.getSplitInfo();
        if (splitInfo != null) {
            return splitInfo;
        }
        Long taxItemId = taxItem.getId();
        DynamicObject taxDataItem = taxDataWrapper.getEntry(taxItemId);
        BigDecimal ratioDenominator = BigDecimal.ZERO;
        HashMap<String, BigDecimal> ratioNumeratorMap = new HashMap<String, BigDecimal>(validSrcDataWrappers.size());
        for (TaxDataDynObjWrapper validSrcDataWrapper : validSrcDataWrappers) {
            DynamicObject validSrcDataItem = validSrcDataWrapper.getEntry(taxItemId);
            BigDecimal ratioNumerator = StringUtils.isEmpty((String)validSrcDataItem.getString("calvalue")) ? BigDecimal.ZERO : validSrcDataItem.getBigDecimal("calvalue");
            ratioDenominator = ratioDenominator.add(ratioNumerator);
            Long srcDataId = validSrcDataWrapper.getData().getLong("id");
            ratioNumeratorMap.put(String.valueOf(srcDataId), ratioNumerator);
        }
        splitInfo = new SplitInfo();
        splitInfo.setTotalValue(taxDataItem.getBigDecimal("itemvalue"));
        splitInfo.setRatioDenominator(ratioDenominator);
        splitInfo.setRatioNumeratorMap(ratioNumeratorMap);
        splitInfo.setScale(taxItem.getDataPrecisionScale());
        splitInfo.setDataRound(DataRoundEnum.roundById((long)taxItem.getDataRoundId()));
        taxDataWrapper.setSplitInfo(splitInfo);
        return splitInfo;
    }

    protected SplitAlgoParamInitializer getAlgoParamInitializer() {
        return TaxDataSplitAlgoParamInitializer.INSTANCE;
    }

    protected BaseResult<DynamicObject> doAlgo(DynamicObject taxDataItem, List<DynamicObject> validSrcDataItems, TaxDataDynObjWrapper taxDataWrapper, List<TaxDataDynObjWrapper> validSrcDataWrappers, List<TaxDataDynObjWrapper> invalidSrcDataWrappers, TaxItemEntity taxItem, String splitAlgoCode) {
        BaseResult baseResult = super.doAlgo(taxDataItem, validSrcDataItems, taxDataWrapper, validSrcDataWrappers, invalidSrcDataWrappers, taxItem, splitAlgoCode);
        if (baseResult != null && baseResult.isSuccess() && LocalCalImportTaxSplitAlgoHandler.isCalDifference(taxItem)) {
            LocalCalImportTaxSplitAlgoHandler.calDifference(taxDataItem);
            this.calDifference(validSrcDataItems);
        }
        return baseResult;
    }

    public static boolean isCalDifference(TaxItemEntity taxItem) {
        return !noCalDiffItemMap.contains(taxItem.getId()) && numberTypeIds.contains(taxItem.getDatatypeId());
    }

    private void calDifference(List<DynamicObject> validSrcDataItems) {
        validSrcDataItems.forEach(obj -> LocalCalImportTaxSplitAlgoHandler.calDifference(obj));
    }

    public static void calDifference(DynamicObject taxDataItem) {
        boolean calValIsNull = StringUtils.isEmpty((String)taxDataItem.getString("calvalue"));
        boolean importValIsNull = StringUtils.isEmpty((String)taxDataItem.getString("itemvalue"));
        if (calValIsNull && importValIsNull) {
            taxDataItem.set("diffvalue", null);
            return;
        }
        BigDecimal calVal = calValIsNull ? BigDecimal.ZERO : taxDataItem.getBigDecimal("calvalue");
        BigDecimal importVal = importValIsNull ? BigDecimal.ZERO : taxDataItem.getBigDecimal("itemvalue");
        BigDecimal diffValue = importVal.subtract(calVal);
        taxDataItem.set("diffvalue", (Object)diffValue);
        if (diffValue.compareTo(BigDecimal.ZERO) != 0) {
            ((DynamicObject)taxDataItem.getParent()).set("hasdifference", (Object)"1");
        }
    }
}

