/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxdata.model;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.sit.sitbp.common.api.MergeAlgorithmParamInitializer;
import kd.sit.sitbp.common.api.MergeLatestBy;
import kd.sit.sitbp.common.api.MergeValueHandler;
import kd.sit.sitbp.common.util.dataround.BaseDataRoundHandler;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxDataMergeAlgorithmParamInitializer
implements MergeAlgorithmParamInitializer<DynamicObject> {
    public static final TaxDataMergeAlgorithmParamInitializer INSTANCE = new TaxDataMergeAlgorithmParamInitializer();

    public MergeValueHandler<DynamicObject, Object> mergeValueHandler() {
        return TaxDataMergeValueHandler.INSTANCE;
    }

    public MergeLatestBy<DynamicObject, Date> mergeLatestBy() {
        return TaxDataMergeLatestBy.INSTANCE;
    }

    public String mergeAppendSplit() {
        return ",";
    }

    static class TaxDataMergeLatestBy
    implements MergeLatestBy<DynamicObject, Date> {
        public static final TaxDataMergeLatestBy INSTANCE = new TaxDataMergeLatestBy();

        TaxDataMergeLatestBy() {
        }

        public Date getSrc(DynamicObject targetData, Map<String, Object> param) {
            Object parent = targetData.getParent();
            if (parent instanceof DynamicObject) {
                return ((DynamicObject)parent).getDate("modifytime");
            }
            return null;
        }

        public Date getTarget(DynamicObject targetData, Map<String, Object> param) {
            Map latestTime = (Map)param.computeIfAbsent("latestTime", k1 -> new HashMap(16));
            long itemId = targetData.getLong("taxitem.id");
            return (Date)latestTime.get(itemId);
        }

        public void setTarget(DynamicObject targetData, Date value, Map<String, Object> param) {
            Map latestTime = (Map)param.computeIfAbsent("latestTime", k1 -> new HashMap(16));
            long itemId = targetData.getLong("taxitem.id");
            latestTime.put(itemId, value);
        }
    }

    static class TaxDataMergeValueHandler
    implements MergeValueHandler<DynamicObject, Object> {
        public static final TaxDataMergeValueHandler INSTANCE = new TaxDataMergeValueHandler();

        TaxDataMergeValueHandler() {
        }

        public Object get(DynamicObject targetData) {
            return targetData.get("calvalue");
        }

        public void set(DynamicObject targetData, Object value, Map<String, Object> param) {
            if (value instanceof Number) {
                Number result = (Number)value;
                String dataRound = BaseDataConverter.toString((Object)param.get("dataRound"));
                Integer scale = (Integer)BaseDataConverter.convert((Object)param.get("scale"), Integer.class);
                if (!StringUtils.isEmpty((CharSequence)dataRound) || scale != null) {
                    value = BaseDataRoundHandler.handle((Number)result, (String)dataRound, (int)scale);
                }
            }
            targetData.set("calvalue", value);
            targetData.set("itemvalue", value);
        }
    }
}

