/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.api.ItcTaxFileService;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.Supplier;
import kd.sit.sitbp.common.api.TaxFileInfoService;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.enums.CredentialsTypeEnum;
import kd.sit.sitbp.common.enums.DataStatusEnum;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ItcTaxFileServiceImpl
implements ItcTaxFileService {
    private static final Log LOGGER = LogFactory.getLog(ItcTaxFileServiceImpl.class);
    private static final String SIT_ITC_M_SERVICE = "sit-itc-mservice";
    public static final String TMP_ID = "tmpid";

    @Override
    public Map<String, Object> saveTaxFile(Map<String, Object> params) {
        String actionWay = MapUtils.getString(params, (Object)"ITCFILE_ACTIONWAY");
        String action = MapUtils.getString(params, (Object)"action");
        List dataList = (List)params.get("data");
        if (dataList == null) {
            String msg = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5b8c\u6574", (String)"HSASService_03", (String)SIT_ITC_M_SERVICE, (Object[])new Object[0]);
            return BaseResult.packageResult((boolean)false, (int)ResultStatusEnum.ERROR.getCode(), (String)msg, null);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        int size = dataList.size();
        ArrayList<Map<String, Object>> resData = new ArrayList<Map<String, Object>>(size);
        result.put("data", resData);
        result.put("success", Boolean.TRUE);
        result.put("status", 200);
        ArrayList<DynamicObject> allData = new ArrayList<DynamicObject>(size);
        Map<String, Map<String, DynamicObject>> baseDataMap = TaxFileServiceHelper.getBaseDataMap(Lists.newArrayList((Object[])new String[]{"itc_taxpayertype", "itc_emptype"}));
        for (Map map : dataList) {
            allData.add(this.packageData(map, baseDataMap));
        }
        this.validateAndSave(resData, allData, actionWay, action);
        LOGGER.info("by cyh saveTaxFile result = {}", result);
        return result;
    }

    @Override
    public Map<String, Object> synTaxFileData(Map<String, Object> params) {
        String actionWay = MapUtils.getString(params, (Object)"ITCFILE_ACTIONWAY");
        String action = MapUtils.getString(params, (Object)"action");
        String skipPermCheck = MapUtils.getString(params, (Object)"skippermck");
        List dataList = (List)params.get("data");
        if (dataList == null) {
            String msg = ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5b8c\u6574", (String)"HSASService_03", (String)SIT_ITC_M_SERVICE, (Object[])new Object[0]);
            return BaseResult.packageResult((boolean)false, (int)ResultStatusEnum.ERROR.getCode(), (String)msg, null);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(8);
        ArrayList<Map<String, Object>> resData = new ArrayList<Map<String, Object>>(8);
        result.put("data", resData);
        result.put("success", Boolean.TRUE);
        result.put("status", 200);
        HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)8);
        Map<Integer, List<Map<String, Object>>> batchMap = this.groupByUniqueKey(dataList, resData);
        for (Map.Entry<Integer, List<Map<String, Object>>> entry : batchMap.entrySet()) {
            this.businessDeal(baseDataMap, entry.getValue(), resData, action, actionWay, skipPermCheck);
        }
        LOGGER.info("by cyh synTaxFileData result = {}", result);
        return result;
    }

    private Map<Integer, List<Map<String, Object>>> groupByUniqueKey(List<Map<String, Object>> dataList, List<Map<String, Object>> resData) {
        dataList.sort((o1, o2) -> {
            if (o1 != null && o2 != null && o1.get("bsed") != null && o2.get("bsed") != null) {
                return ((Date)o1.get("bsed")).compareTo((Date)o2.get("bsed"));
            }
            return 0;
        });
        HashMap<Integer, List<Map<String, Object>>> batchDyMap = new HashMap<Integer, List<Map<String, Object>>>(8);
        HashMap<String, Integer> batchRls = new HashMap<String, Integer>(8);
        for (Map<String, Object> info : dataList) {
            String validateMsg = this.validateTaxFileUniqueKey(info, null);
            if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
                this.setResultMapValfail(info, validateMsg, resData);
                continue;
            }
            String uniqueKey = this.bizKeyByInfo(info);
            Integer batch = (Integer)batchRls.get(uniqueKey);
            if (batch == null) {
                batch = -1;
            }
            Integer n = batch;
            Integer n2 = batch = Integer.valueOf(batch + 1);
            batchRls.put(uniqueKey, batch);
            ArrayList<Map<String, Object>> dys = (ArrayList<Map<String, Object>>)batchDyMap.get(batch);
            if (dys == null) {
                dys = new ArrayList<Map<String, Object>>(10);
            }
            dys.add(info);
            batchDyMap.put(batch, dys);
        }
        return batchDyMap;
    }

    private void businessDeal(Map<String, Map<Long, DynamicObject>> baseDataMap, List<Map<String, Object>> dataList, List<Map<String, Object>> resData, String action, String actionWay, String skipPermCheck) {
        HashMap groupMap = Maps.newHashMapWithExpectedSize((int)8);
        List<Long> personIdList = dataList.stream().map(e1 -> (Long)MapUtils.getMap((Map)e1, (Object)"taxfile").get("employee")).collect(Collectors.toList());
        Map<Long, DynamicObject> personMap = this.queryPersonInfo(personIdList);
        Map<String, DynamicObject> taxFileMap = this.queryTaxFileByPlist(personIdList);
        HashMap outerInfo = Maps.newHashMapWithExpectedSize((int)8);
        for (Map<String, Object> info : dataList) {
            String validateMsg = this.validateData(info, personMap, baseDataMap, taxFileMap);
            if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
                this.setResultMapValfail(info, validateMsg, resData);
                continue;
            }
            String errorMsg = this.GroupByCondition(groupMap, taxFileMap, info);
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                this.setResultMapValfail(info, errorMsg, resData);
                continue;
            }
            outerInfo.put(this.bizKeyByInfo(info), info);
        }
        Map<String, List<DynamicObject>> opMap = this.buildGroupData2Entity(groupMap, taxFileMap);
        opMap.forEach((key, value) -> value.forEach(taxFile -> {
            DynamicObject queryPerson;
            DynamicObject person = taxFile.getDynamicObject("person");
            if (person != null && (queryPerson = (DynamicObject)personMap.get(person.getLong("id"))) != null) {
                person.set("number", queryPerson.get("number"));
            }
        }));
        this.opTaxFileEntity(resData, opMap, action, actionWay, skipPermCheck, outerInfo);
    }

    private void setResultMapValfail(Map<String, Object> info, String errorMsg, List<Map<String, Object>> resData) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)8);
        resultMap.put("operationstatus", "0");
        resultMap.put("sourceid", MapUtils.getLong(info, (Object)"sourceid"));
        resultMap.put("errorcode", "1020");
        resultMap.put("errormsg", errorMsg);
        resultMap.put("taxfileid", null);
        resData.add(resultMap);
    }

    private void opTaxFileEntity(List<Map<String, Object>> resData, Map<String, List<DynamicObject>> opMap, String action, String actionway, String skipPermCheck, Map<String, Object> outerInfo) {
        String jsonString = SerializationUtils.toJsonString(outerInfo);
        OperateOption option = OperateOption.create();
        option.setVariableValue("src", "SYNAPI");
        option.setVariableValue("outerInfo", jsonString);
        option.setVariableValue("ITCFILE_ACTIONWAY", actionway);
        option.setVariableValue("action", action);
        if ("1".equals(skipPermCheck)) {
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("skipCheckDataPermission", "true");
            option.setVariableValue("skipCheckSpecialDataPermission", "true");
        }
        opMap.forEach((key, val) -> {
            String dataOp;
            String string = dataOp = StringUtils.equals((CharSequence)key, (CharSequence)"saveAfterAuditOp") ? "saveafteraudit" : "save";
            if (StringUtils.equals((CharSequence)key, (CharSequence)"savaOp")) {
                option.setVariableValue("status", "");
            } else {
                option.setVariableValue("status", "C");
            }
            LOGGER.info("Trace By Quinn opTaxFileEntity: {} - {}", key, (Object)dataOp);
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperationResult opRes = opImpl.localInvokeOperation(dataOp, val.toArray(new DynamicObject[0]), option);
            List errorOrValidateInfo = opRes.getAllErrorOrValidateInfo();
            if (CollectionUtils.isEmpty((Collection)errorOrValidateInfo)) {
                for (DynamicObject obj : val) {
                    this.setResultMapValByResult(obj, outerInfo, resData, "", "1");
                }
            } else {
                HashMap errorMap = Maps.newHashMapWithExpectedSize((int)errorOrValidateInfo.size());
                for (IOperateInfo info : errorOrValidateInfo) {
                    OperateErrorInfo errorInfo = (OperateErrorInfo)info;
                    int ri = errorInfo.getDataEntityIndex();
                    errorMap.put(ri, errorInfo.getMessage());
                }
                for (int index = 0; index < val.size(); ++index) {
                    DynamicObject taxFileInfo = (DynamicObject)val.get(index);
                    String message = (String)errorMap.get(index);
                    if (StringUtils.isNotEmpty((CharSequence)message)) {
                        this.setResultMapValByResult(taxFileInfo, outerInfo, resData, message, "0");
                        continue;
                    }
                    this.setResultMapValByResult(taxFileInfo, outerInfo, resData, "", "1");
                }
            }
        });
    }

    private void setResultMapValByResult(DynamicObject taxFileInfo, Map<String, Object> outerInfos, List<Map<String, Object>> resData, String ... resultParams) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)8);
        Map outerinfo = MapUtils.getMap(outerInfos, (Object)this.bizKey(taxFileInfo));
        resultMap.put("operationstatus", resultParams[1]);
        resultMap.put("sourceid", MapUtils.getLong((Map)outerinfo, (Object)"sourceid"));
        resultMap.put("errorcode", StringUtils.equals((CharSequence)resultParams[1], (CharSequence)"0") ? "1040" : "");
        resultMap.put("errormsg", resultParams[0]);
        resultMap.put("taxfileid", taxFileInfo.get("id"));
        resData.add(resultMap);
    }

    private Map<String, List<DynamicObject>> buildGroupData2Entity(Map<String, List<Map<String, Object>>> groupMap, Map<String, DynamicObject> taxFileMap) {
        HashMap opMap = Maps.newHashMapWithExpectedSize((int)3);
        if (CollectionUtils.isEmpty(groupMap)) {
            return opMap;
        }
        groupMap.forEach((key, value) -> value.forEach(info -> {
            DynamicObject taxFile = this.requireEntityInfo((String)key, (Map<String, Object>)info, taxFileMap);
            this.setInfo2TaxFile((Map<String, Object>)info, taxFile);
            this.setTaxFile2OpMap(taxFile, opMap, (String)key);
        }));
        return opMap;
    }

    private void setInfo2TaxFile(Map<String, Object> info, DynamicObject taxFile) {
        Map taxFileinfo = MapUtils.getMap(info, (Object)"taxfile");
        Map employment = MapUtils.getMap(info, (Object)"employment");
        String status = MapUtils.getString((Map)taxFileinfo, (Object)"status");
        if (StringUtils.endsWithIgnoreCase((CharSequence)status, (CharSequence)"C")) {
            taxFile.set("status", (Object)status);
        }
        taxFile.set("person", SitCommonServiceHelper.setDynamicObj(taxFile, taxFileinfo, "employee", "hrpi_person"));
        taxFile.set("org", SitCommonServiceHelper.setDynamicObj(taxFile, taxFileinfo, "org", "bos_org"));
        taxFile.set("taxunit", SitCommonServiceHelper.setDynamicObj(taxFile, taxFileinfo, "taxunit", "hbss_taxunit"));
        taxFile.set("taxregion", SitCommonServiceHelper.setDynamicObj(taxFile, taxFileinfo, "taxregion", "bd_country"));
        taxFile.set("empgroup", SitCommonServiceHelper.setDynamicObj(taxFile, taxFileinfo, "empgroup", "hbss_empgroup"));
        taxFile.set("taxstatus", (Object)MapUtils.getString((Map)taxFileinfo, (Object)"taxstatus"));
        String number = MapUtils.getString((Map)taxFileinfo, (Object)"number");
        if (StringUtils.isNotEmpty((CharSequence)number) && StringUtils.isEmpty((CharSequence)taxFile.getString("number"))) {
            taxFile.set("number", (Object)number);
        }
        taxFile.set("bsed", MapUtils.getObject((Map)taxFileinfo, (Object)"bsed"));
        taxFile.set("bsled", null);
        taxFile.set("isescrowstaff", (Object)MapUtils.getString((Map)taxFileinfo, (Object)"isescrowstaff"));
        taxFile.set("taxpayertypetmp", SitCommonServiceHelper.setDynamicObj(taxFile, employment, "taxpayertype", "itc_taxpayertype"));
        taxFile.set("emptypetmp", employment.get("emptype"));
        taxFile.set("empdatetmp", MapUtils.getObject((Map)employment, (Object)"empdate"));
        taxFile.set("empsituationtmp", (Object)MapUtils.getString((Map)employment, (Object)"empsituation"));
        taxFile.set("isdeductexpstmp", (Object)MapUtils.getString((Map)employment, (Object)"isdeductexps"));
    }

    private void setTaxFile2OpMap(DynamicObject taxFile, Map<String, List<DynamicObject>> opMap, String groupType) {
        List taxFileList = null;
        taxFileList = StringUtils.equals((CharSequence)groupType, (CharSequence)"auditedTaxFile") ? opMap.computeIfAbsent("saveAfterAuditOp", key -> Lists.newArrayListWithCapacity((int)8)) : (StringUtils.equals((CharSequence)groupType, (CharSequence)"addAndCTaxFile") || StringUtils.equals((CharSequence)groupType, (CharSequence)"updateAndCTaxFile") ? opMap.computeIfAbsent("saveAndCOp", key -> Lists.newArrayListWithCapacity((int)8)) : opMap.computeIfAbsent("savaOp", key -> Lists.newArrayListWithCapacity((int)8)));
        taxFileList.add(taxFile);
    }

    private DynamicObject requireEntityInfo(String groupType, Map<String, Object> info, Map<String, DynamicObject> taxFileMap) {
        if (StringUtils.equals((CharSequence)groupType, (CharSequence)"auditedTaxFile") || StringUtils.equals((CharSequence)groupType, (CharSequence)"updateTaxFile") || StringUtils.equals((CharSequence)groupType, (CharSequence)"updateAndCTaxFile")) {
            return taxFileMap.get(this.bizKeyByInfo(info));
        }
        HRBaseServiceHelper taxFileServiceHelper = new HRBaseServiceHelper("itc_taxfile");
        return taxFileServiceHelper.generateEmptyDynamicObject();
    }

    private Map<String, DynamicObject> queryTaxFileByPlist(List<Long> personIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
        QFilter personFilter = new QFilter("person.id", "in", personIdList);
        QFilter defaultFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        defaultFilter.and(new QFilter("status", "!=", (Object)"E"));
        DynamicObject[] existTaxFiles = serviceHelper.loadDynamicObjectArray("itc_taxfile", new QFilter[]{personFilter, defaultFilter});
        HashMap existsBizKeyMap = Maps.newHashMapWithExpectedSize((int)existTaxFiles.length);
        Arrays.stream(existTaxFiles).forEach(obj -> existsBizKeyMap.put(this.bizKey((DynamicObject)obj), obj));
        return existsBizKeyMap;
    }

    private String bizKey(DynamicObject obj) {
        return String.format("%s_%s_%s", obj.getString("person.id"), obj.getString("taxregion.id"), obj.getString("taxunit.id"));
    }

    private String bizKeyByInfo(Map<String, Object> info) {
        Map taxfile = MapUtils.getMap(info, (Object)"taxfile");
        return String.format("%s_%s_%s", MapUtils.getString((Map)taxfile, (Object)"employee"), MapUtils.getString((Map)taxfile, (Object)"taxregion"), MapUtils.getString((Map)taxfile, (Object)"taxunit"));
    }

    private Map<Long, DynamicObject> queryPersonInfo(List<Long> personIdList) {
        List personList = (List)SITMServiceUtils.invokeSITService((String)"iit", (String)"IitPersonService", (String)"findByIdList", (Object[])new Object[]{personIdList, null});
        Map<Long, DynamicObject> personMap = personList.stream().collect(Collectors.toMap(person -> person.getLong("id"), person -> person));
        return personMap;
    }

    private String GroupByCondition(Map<String, List<Map<String, Object>>> groupMap, Map<String, DynamicObject> taxFileMap, Map<String, Object> info) {
        DynamicObject taxFile = taxFileMap.get(this.bizKeyByInfo(info));
        String status = MapUtils.getString((Map)MapUtils.getMap(info, (Object)"taxfile"), (Object)"status");
        if (Objects.isNull(taxFile) && StringUtils.isNotEmpty((CharSequence)status) && StringUtils.equals((CharSequence)status, (CharSequence)"C")) {
            this.setInfo2GroupMap(groupMap, info, "addAndCTaxFile");
            return "";
        }
        if (Objects.isNull(taxFile)) {
            this.setInfo2GroupMap(groupMap, info, "addTaxFile");
            return "";
        }
        if (StringUtils.equals((CharSequence)taxFile.getString("status"), (CharSequence)"A") && StringUtils.isNotEmpty((CharSequence)status) && StringUtils.equals((CharSequence)status, (CharSequence)"C")) {
            this.setInfo2GroupMap(groupMap, info, "updateAndCTaxFile");
            return "";
        }
        if (StringUtils.equals((CharSequence)taxFile.getString("status"), (CharSequence)"B")) {
            return ResManager.loadKDString((String)"\u4e2a\u7a0e\u6863\u6848\u72b6\u6001\u4e3a\u5df2\u63d0\u4ea4,\u64cd\u4f5c\u5931\u8d25\u3002", (String)"ItcTaxFileServiceImpl_30", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        if (StringUtils.equals((CharSequence)taxFile.getString("status"), (CharSequence)"C")) {
            this.setInfo2GroupMap(groupMap, info, "auditedTaxFile");
            return "";
        }
        if (StringUtils.equals((CharSequence)taxFile.getString("status"), (CharSequence)"A")) {
            this.setInfo2GroupMap(groupMap, info, "updateTaxFile");
            return "";
        }
        return "";
    }

    private void setInfo2GroupMap(Map<String, List<Map<String, Object>>> groupMap, Map<String, Object> info, String keyStr) {
        List<Map<String, Object>> taxFile = groupMap.get(keyStr);
        if (Objects.isNull(taxFile)) {
            taxFile = new ArrayList<Map<String, Object>>();
            groupMap.put(keyStr, taxFile);
        }
        taxFile.add(info);
    }

    private String validateData(Map<String, Object> info, Map<Long, DynamicObject> personMap, Map<String, Map<Long, DynamicObject>> baseDataMap, Map<String, DynamicObject> taxFileMap) {
        String validateMsg = this.validateTaxFile(info, personMap, baseDataMap, taxFileMap);
        if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
            return validateMsg;
        }
        validateMsg = this.validateTaxcontact(info, baseDataMap);
        if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
            return validateMsg;
        }
        validateMsg = this.validateEmployment(info, personMap, baseDataMap);
        if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
            return validateMsg;
        }
        validateMsg = this.validateOverseasperson(info, personMap, baseDataMap);
        if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
            return validateMsg;
        }
        validateMsg = this.validateInvestor(info);
        if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
            return validateMsg;
        }
        validateMsg = this.validateBankcard(info, baseDataMap);
        if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
            return validateMsg;
        }
        validateMsg = this.validateSpecialinfo(info);
        return validateMsg;
    }

    private String validateSpecialinfo(Map<String, Object> info) {
        Map specialinfo = MapUtils.getMap(info, (Object)"specialinfo");
        if (CollectionUtils.isEmpty((Map)specialinfo)) {
            return "";
        }
        String disability = MapUtils.getString((Map)specialinfo, (Object)"disability");
        if (StringUtils.isNotEmpty((CharSequence)disability) && StringUtils.equals((CharSequence)disability, (CharSequence)"1") && StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)specialinfo, (Object)"disabilitynum"))) {
            return ResManager.loadKDString((String)"\u6b8b\u75be\u9009\u62e9\u4e3a\u662f , \u53c2\u6570 \u6b8b\u75be\u8bc1\u53f7\uff08disabilitynum\uff09\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_28", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        String martyrsfamily = MapUtils.getString((Map)specialinfo, (Object)"martyrsfamily");
        if (StringUtils.isNotEmpty((CharSequence)martyrsfamily) && StringUtils.equals((CharSequence)martyrsfamily, (CharSequence)"1") && StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)specialinfo, (Object)"martyrsfamilynum"))) {
            return ResManager.loadKDString((String)"\u70c8\u5c5e\u9009\u62e9\u4e3a\u662f , \u53c2\u6570 \u70c8\u5c5e\u8bc1\u53f7\uff08martyrsfamilynum\uff09\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_29", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        return "";
    }

    private String validateBankcard(Map<String, Object> info, Map<String, Map<Long, DynamicObject>> baseDataMap) {
        Map bankcard = MapUtils.getMap(info, (Object)"bankcard");
        if (CollectionUtils.isEmpty((Map)bankcard)) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)bankcard, (Object)"username"))) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u5f00\u6237\u4eba\uff08username\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_37", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        Long perbankcard = MapUtils.getLong((Map)bankcard, (Object)"perbankcard");
        if (Objects.isNull(perbankcard)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u5f00\u6237\u94f6\u884c\uff08perbankcard\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_38", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        DynamicObject perbankcardObj = TaxFileServiceHelper.getBaseDataById("hrpi_perbankcard", perbankcard, baseDataMap);
        if (Objects.isNull(perbankcardObj)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u5f00\u6237\u94f6\u884c\uff08perbankcard\uff09\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6709\u6548\u72b6\u6001\u3002", (String)"ItcTaxFileServiceImpl_36", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        return "";
    }

    private String validateInvestor(Map<String, Object> info) {
        Map investor = MapUtils.getMap(info, (Object)"investor");
        if (CollectionUtils.isEmpty((Map)investor)) {
            return "";
        }
        if (Objects.isNull(investor.get("investtotal"))) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u4e2a\u4eba\u6295\u8d44\u603b\u989d\uff08investtotal\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_39", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        if (Objects.isNull(investor.get("investratio"))) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u4e2a\u4eba\u6295\u8d44\u6bd4\u4f8b\uff08investratio\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_40", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        return "";
    }

    private String validateOverseasperson(Map<String, Object> info, Map<Long, DynamicObject> personMap, Map<String, Map<Long, DynamicObject>> baseDataMap) {
        String status = MapUtils.getString((Map)MapUtils.getMap(info, (Object)"taxfile"), (Object)"status");
        DynamicObject person = this.getPersonByTaxFile(info, personMap);
        Map overseasperson = MapUtils.getMap(info, (Object)"overseasperson");
        if (CollectionUtils.isEmpty((Map)overseasperson) && CredentialsTypeEnum.isId1010((long)person.getLong("credentialstype.id"))) {
            return "";
        }
        if (CollectionUtils.isEmpty((Map)overseasperson) && !StringUtils.equals((CharSequence)status, (CharSequence)"C")) {
            return "";
        }
        if (CollectionUtils.isEmpty((Map)overseasperson)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u5883\u5916\u4eba\u5458\u4fe1\u606f\uff08overseasperson\uff09 \u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_41", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        if (Objects.isNull(overseasperson.get("taxreason"))) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u6d89\u7a0e\u4e8b\u7531\uff08taxreason\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_42", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        if (Objects.isNull(overseasperson.get("otheridtype")) && StringUtils.isNotEmpty((CharSequence)MapUtils.getString((Map)overseasperson, (Object)"otheridnumber"))) {
            return ResManager.loadKDString((String)"\u5176\u4ed6\u8bc1\u4ef6\u53f7\u7801\uff08otheridnumber\uff09\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u53c2\u6570 \u5176\u4ed6\u8bc1\u4ef6\u7c7b\u578b\uff08otheridtype\uff09\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_43", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        if (Objects.isNull(overseasperson.get("birthplace"))) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u51fa\u751f\u5730\uff08\u7a0e\u5c40\uff09\uff08birthplace\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_44", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        if (Objects.isNull(overseasperson.get("firstentrydate"))) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u9996\u6b21\u5165\u5883\u65e5\u671f\uff08firstentrydate\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_45", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        this.setAreaInfoToInfo(overseasperson, baseDataMap, "address");
        this.setAreaInfoToInfo(overseasperson, baseDataMap, "addresscity");
        this.setAreaInfoToInfo(overseasperson, baseDataMap, "addresscounty");
        return "";
    }

    private String validateEmployment(Map<String, Object> info, Map<Long, DynamicObject> personMap, Map<String, Map<Long, DynamicObject>> baseDataMap) {
        Map employment = MapUtils.getMap(info, (Object)"employment");
        if (CollectionUtils.isEmpty((Map)employment)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u4efb\u804c\u53d7\u96c7\u4ece\u4e1a\u4fe1\u606f\uff08employment\uff09 \u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_46", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        Long taxpayertype = (Long)employment.get("taxpayertype");
        if (Objects.isNull(taxpayertype)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u7eb3\u7a0e\u4eba\u7c7b\u578b\uff08taxpayertype\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_47", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        DynamicObject taxpayertypeObj = TaxFileServiceHelper.getBaseDataById("itc_taxpayertype", taxpayertype, baseDataMap);
        if (Objects.isNull(taxpayertypeObj)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u7eb3\u7a0e\u4eba\u7c7b\u578b\uff08taxpayertype\uff09\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6709\u6548\u72b6\u6001\u3002", (String)"ItcTaxFileServiceImpl_48", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        Long emptype = (Long)employment.get("emptype");
        if (Objects.isNull(emptype)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u4efb\u804c\u53d7\u96c7\u4ece\u4e1a\u7c7b\u578b\uff08emptype\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_49", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        DynamicObject emptypeObj = TaxFileServiceHelper.getBaseDataById("itc_emptype", emptype, baseDataMap);
        if (Objects.isNull(emptypeObj)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u4efb\u804c\u53d7\u96c7\u4ece\u4e1a\u7c7b\u578b\uff08emptype\uff09\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6709\u6548\u72b6\u6001\u3002", (String)"ItcTaxFileServiceImpl_50", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        employment.put("emptype", emptypeObj);
        return "";
    }

    private DynamicObject getPersonByTaxFile(Map<String, Object> info, Map<Long, DynamicObject> personMap) {
        Map taxfile = MapUtils.getMap(info, (Object)"taxfile");
        return personMap.get(MapUtils.getLong((Map)taxfile, (Object)"employee"));
    }

    private String validatePersonByTaxFile(Map<String, Object> info, Map<Long, DynamicObject> personMap) {
        Map taxfile = MapUtils.getMap(info, (Object)"taxfile");
        DynamicObject person = personMap.get(MapUtils.getLong((Map)taxfile, (Object)"employee"));
        if (Objects.isNull(person)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u4f01\u4e1a\u4eba\uff08emptype\uff09\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5339\u914d\u7684\u4eba\u5458\u3002", (String)"ItcTaxFileServiceImpl_13", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        return "";
    }

    private String validateTaxcontact(Map<String, Object> info, Map<String, Map<Long, DynamicObject>> baseDataMap) {
        Map taxContact = MapUtils.getMap(info, (Object)"taxcontact");
        if (CollectionUtils.isEmpty((Map)taxContact)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u8054\u7cfb\u4fe1\u606f\u5bf9\u8c61\uff08taxcontact\uff09 \u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_8", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)taxContact, (Object)"taxpayernum"))) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff08taxpayernum\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_9", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        this.setAreaInfoToInfo(taxContact, baseDataMap, "regpermres");
        this.setAreaInfoToInfo(taxContact, baseDataMap, "regpermrescity");
        this.setAreaInfoToInfo(taxContact, baseDataMap, "regpermrescounty");
        this.setAreaInfoToInfo(taxContact, baseDataMap, "habitres");
        this.setAreaInfoToInfo(taxContact, baseDataMap, "habitrescity");
        this.setAreaInfoToInfo(taxContact, baseDataMap, "habitrescounty");
        return "";
    }

    private void setAreaInfoToInfo(Map<String, Object> subInfo, Map<String, Map<Long, DynamicObject>> baseDataMap, String propertyName) {
        DynamicObject areaObj;
        Long areaPk = MapUtils.getLong(subInfo, (Object)propertyName);
        if (!Objects.isNull(areaPk) && !Objects.isNull(areaObj = TaxFileServiceHelper.getAreaInfo("bd_admindivision", areaPk, baseDataMap))) {
            subInfo.put(propertyName, areaObj);
        }
    }

    private String validateTaxFileUniqueKey(Map<String, Object> info, Map<String, Map<Long, DynamicObject>> baseDataMap) {
        Map taxFile = MapUtils.getMap(info, (Object)"taxfile");
        if (CollectionUtils.isEmpty((Map)taxFile)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u4e2a\u7a0e\u6863\u6848\u57fa\u672c\u4fe1\u606f\uff08taxfile\uff09 \u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_51", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        if (Objects.isNull(taxFile.get("employee"))) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u4f01\u4e1a\u4eba\uff08employee\uff09 \u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_52", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        if (Objects.isNull(taxFile.get("taxregion"))) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u4e2a\u7a0e\u7ba1\u7406\u5c5e\u5730\uff08taxregion\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_53", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        Long taxunit = (Long)taxFile.get("taxunit");
        if (Objects.isNull(taxunit)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u7eb3\u7a0e\u5355\u4f4d\uff08taxunit\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_31", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        if (null == baseDataMap) {
            return "";
        }
        DynamicObject taxUnitObj = TaxFileServiceHelper.getBaseDataById("hbss_taxunit", taxunit, baseDataMap);
        if (Objects.isNull(taxUnitObj)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u7eb3\u7a0e\u5355\u4f4d\uff08taxunit\uff09\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6709\u6548\u72b6\u6001\u3002", (String)"ItcTaxFileServiceImpl_33", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        return "";
    }

    private String validateTaxFile(Map<String, Object> info, Map<Long, DynamicObject> personMap, Map<String, Map<Long, DynamicObject>> baseDataMap, Map<String, DynamicObject> taxFileMap) {
        Map taxFile = MapUtils.getMap(info, (Object)"taxfile");
        String validateMsg = this.validateTaxFileUniqueKey(info, baseDataMap);
        if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
            return validateMsg;
        }
        validateMsg = this.validatePersonByTaxFile(info, personMap);
        if (StringUtils.isNotEmpty((CharSequence)validateMsg)) {
            return validateMsg;
        }
        Long org = (Long)taxFile.get("org");
        if (Objects.isNull(org)) {
            return ResManager.loadKDString((String)"{\u4e2a\u7a0e\u7ba1\u7406\u7ec4\u7ec7\uff08org\uff09}\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_54", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        DynamicObject taxFileObj = taxFileMap.get(this.bizKeyByInfo(info));
        if (!Objects.isNull(taxFileObj) && !taxFileObj.get("org.id").equals(org)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u4e2a\u7a0e\u7ba1\u7406\u7ec4\u7ec7\uff08org\uff09\u4e0d\u80fd\u88ab\u4fee\u6539\u3002", (String)"ItcTaxFileServiceImpl_35", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        Long empgroup = (Long)taxFile.get("empgroup");
        if (Objects.isNull(empgroup)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u4e2a\u7a0e\u4eba\u5458\u7ec4\uff08empgroup\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_5", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        DynamicObject empgroupObj = TaxFileServiceHelper.getBaseDataById("hbss_empgroup", empgroup, baseDataMap);
        if (Objects.isNull(empgroupObj)) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u4e2a\u7a0e\u4eba\u5458\u7ec4\uff08empgroup\uff09\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6709\u6548\u72b6\u6001\u3002", (String)"ItcTaxFileServiceImpl_34", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)MapUtils.getString((Map)taxFile, (Object)"taxstatus"))) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u7b97\u7a0e\u72b6\u6001\uff08taxstatus\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_6", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        if (Objects.isNull(taxFile.get("bsed"))) {
            return ResManager.loadKDString((String)"\u53c2\u6570 \u751f\u6548\u65e5\u671f\uff08bsed\uff09\u4e3a\u7a7a\u3002", (String)"ItcTaxFileServiceImpl_7", (String)"sit-itc-business", (Object[])new Object[0]);
        }
        return "";
    }

    @Override
    public Map<String, Object> findTaxFiles(List<Long> taxFileIds, Set<String> props, boolean includeStop, boolean useHis) {
        return this.findTaxFilesBy(props, includeStop, (Supplier<List<QFilter>>)((Supplier)() -> {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("status", "not in", (Object)new String[]{"E"}));
            if (useHis) {
                filters.add(new QFilter("boid", "in", (Object)taxFileIds));
            } else {
                filters.add(new QFilter("id", "in", (Object)taxFileIds));
            }
            return filters;
        }), "bsed desc", null);
    }

    @Override
    public Map<String, Object> findTaxFilesOfPerson(Long personId, Set<String> props, boolean includeStop, Set<Long> excludeFiles) {
        return this.findTaxFilesBy(props, includeStop, (Supplier<List<QFilter>>)((Supplier)() -> {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("status", "not in", (Object)new String[]{"E"}));
            filters.add(new QFilter("person.id", "=", (Object)personId));
            filters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
            if (!CollectionUtils.isEmpty((Collection)excludeFiles)) {
                filters.add(new QFilter("id", "not in", (Object)excludeFiles));
            }
            return filters;
        }), "bsed desc", null);
    }

    @Override
    public Map<String, Object> findPropOfTaxFile(Map<String, Object> params) {
        HashSet props = Sets.newHashSet((Iterable)((Collection)params.get("props")));
        HashSet fileIds = Sets.newHashSet((Iterable)((Collection)params.get("data")));
        boolean includeStop = MapUtils.getBooleanValue(params, (Object)"includeStop", (boolean)false);
        int useHis = MapUtils.getIntValue(params, (Object)"useHis", (int)0);
        int dataStatus = MapUtils.getIntValue(params, (Object)"dataStatus", (int)1);
        int includeAbandon = MapUtils.getIntValue(params, (Object)"includeAbandon", (int)0);
        return this.findTaxFilesBy(props, includeStop, (Supplier<List<QFilter>>)((Supplier)() -> {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            if (includeAbandon == 0) {
                filters.add(new QFilter("status", "not in", (Object)new String[]{"E"}));
            }
            if (useHis == 0) {
                filters.add(new QFilter("boid", "in", (Object)fileIds));
            } else if (useHis == 1) {
                filters.add(new QFilter("id", "in", (Object)fileIds));
            } else if (useHis == -1) {
                filters.add(new QFilter("boid", "in", (Object)fileIds));
                filters.add(new QFilter("iscurrentversion", "=", (Object)"0"));
            } else if (useHis == -2) {
                filters.add(new QFilter("boid", "in", (Object)fileIds));
                filters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
            }
            if (dataStatus == 1) {
                filters.add(new QFilter("datastatus", "in", (Object)new String[]{DataStatusEnum.EFFECTING.getCode(), DataStatusEnum.EXPIRED.getCode(), DataStatusEnum.TO_EFFECT.getCode()}));
            } else if (dataStatus == 2) {
                filters.add(new QFilter("datastatus", "not in", (Object)new String[]{DataStatusEnum.DELETE.getCode(), DataStatusEnum.INVALID.getCode()}));
            }
            return filters;
        }), "bsed desc", null, false);
    }

    @Override
    public Map<String, Object> validateSalaryTaxFileRel(Map<String, Object> params) {
        Set oldTaxFileIds = (Set)params.get("oldTaxFileIds");
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        result.put("success", Boolean.TRUE);
        result.put("status", 200);
        if (CollectionUtils.isEmpty((Collection)oldTaxFileIds)) {
            return result;
        }
        boolean addById = true;
        Long newTaxFileId = (Long)BaseDataConverter.convert((Object)params.get("newTaxFileId"), Long.class);
        Date newTaxFileBsed = null;
        if (newTaxFileId != null && newTaxFileId != 0L) {
            oldTaxFileIds.add(newTaxFileId);
        } else {
            newTaxFileBsed = (Date)BaseDataConverter.convert((Object)params.get("newTaxFileBsed"), Date.class);
            if (newTaxFileBsed == null) {
                result.put("success", Boolean.FALSE);
                result.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u5b8c\u6574\u3002", (String)"ItcTaxFileServiceImpl_0", (String)"sit-itc-business", (Object[])new Object[0]));
                result.put("status", 400);
                return result;
            }
            addById = false;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
        Object[] query = serviceHelper.query("id,boid,bsed,bsled", new QFilter[]{new QFilter("boid", "in", (Object)oldTaxFileIds), new QFilter("status", "not in", (Object)new String[]{"E"}), new QFilter("taxstatus", "=", (Object)"1"), new QFilter("datastatus", "not in", (Object)new String[]{"-1", "-2"})}, "bsed");
        if (ArrayUtils.isEmpty((Object[])query)) {
            return result;
        }
        if (addById) {
            ArrayList oldList = Lists.newArrayListWithExpectedSize((int)query.length);
            ArrayList newList = Lists.newArrayListWithExpectedSize((int)query.length);
            for (Object object : query) {
                if (newTaxFileId.equals(object.getLong("boid"))) {
                    newList.add(object);
                    continue;
                }
                oldList.add(object);
            }
            for (DynamicObject newData : newList) {
                for (DynamicObject oldData : oldList) {
                    if (!SitDateUtil.isDateRangeOverlap((Date)newData.getDate("bsed"), (Date)newData.getDate("bsled"), (Date)oldData.getDate("bsed"), (Date)oldData.getDate("bsled"))) continue;
                    result.put("success", Boolean.FALSE);
                    result.put("message", ResManager.loadKDString((String)"\u5728\u540c\u4e00\u65f6\u95f4\u6bb5\u5185\u5df2\u5173\u8054\u6b63\u5e38\u7b97\u7a0e\u7684\u4e2a\u7a0e\u6863\u6848{0}\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ItcTaxFileServiceImpl_1", (String)"sit-itc-business", (Object[])new Object[]{oldData.getString("number")}));
                    result.put("status", 400);
                    return result;
                }
            }
        } else {
            for (Object oldData : query) {
                if (!SitDateUtil.isDateRangeOverlap((Date)newTaxFileBsed, null, (Date)oldData.getDate("bsed"), (Date)oldData.getDate("bsled"))) continue;
                result.put("success", Boolean.FALSE);
                result.put("message", ResManager.loadKDString((String)"\u5728\u540c\u4e00\u65f6\u95f4\u6bb5\u5185\u5df2\u5173\u8054\u6b63\u5e38\u7b97\u7a0e\u7684\u4e2a\u7a0e\u6863\u6848{0}\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ItcTaxFileServiceImpl_1", (String)"sit-itc-business", (Object[])new Object[]{oldData.getString("number")}));
                result.put("status", 400);
                return result;
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> matchCalTaxFiles(List<Long> taxFileIds, TaxPeriodEntity taxPeriodEntity, Set<String> props) {
        HashSet propsTemp = Sets.newHashSet(props);
        propsTemp.add("person");
        propsTemp.add("iscurrentversion");
        propsTemp.add("taxunit");
        propsTemp.add("boid");
        propsTemp.add("bsed");
        propsTemp.add("bsled");
        boolean calSense = !taxPeriodEntity.getStartDate().equals(taxPeriodEntity.getEndDate());
        return this.findTaxFilesBy(propsTemp, !calSense, (Supplier<List<QFilter>>)((Supplier)() -> {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("boid", "in", (Object)taxFileIds));
            if (calSense) {
                filters.add(new QFilter("status", "=", (Object)"C"));
                filters.add(new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.NO.getCode()));
            } else {
                filters.add(new QFilter("status", "not in", (Object)new String[]{"E"}));
            }
            filters.add(new QFilter("datastatus", "not in", (Object)new String[]{"-1", "-2"}));
            return filters;
        }), "bsed desc", taxPeriodEntity);
    }

    @Override
    public Map<String, Object> loadTaxFileKeyInfo(Map<String, Object> relateIds, DynamicObject taxFile, int editStatus) {
        return TaxFileInfoServiceFactory.loadTaxFileKeyInfo(relateIds, (DynamicObject)taxFile, (int)editStatus);
    }

    @Override
    public Map<String, Map<Long, Map<String, Object>>> findPropOfTaxFile(Map<String, Set<Long>> idGroup, Map<String, Set<String>> propGroup) {
        return TaxFileInfoServiceFactory.findPropOfTaxFile((String)"itc", idGroup, propGroup);
    }

    private Map<String, Object> findTaxFilesBy(Set<String> props, boolean includeStop, Supplier<List<QFilter>> filterSupplier, String orderBy, TaxPeriodEntity taxPeriodEntity) {
        return this.findTaxFilesBy(props, includeStop, filterSupplier, orderBy, taxPeriodEntity, true);
    }

    private Map<String, Object> findTaxFilesBy(Set<String> props, boolean includeStop, Supplier<List<QFilter>> filterSupplier, String orderBy, TaxPeriodEntity taxPeriodEntity, boolean useBoId) {
        Object[] taxFiles;
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        result.put("success", Boolean.TRUE);
        result.put("status", 200);
        Map groupProps = TaxFileInfoServiceFactory.propGroup(props, (String)"itc");
        Map fileProps = (Map)groupProps.get("itc_taxfile");
        fileProps.put("boid", "boid");
        fileProps.put("iscurrentversion", "iscurrentversion");
        fileProps.put("bsed", "bsed");
        fileProps.put("bsled", "bsled");
        PropertiesQueryInfo queryInfo = PropertiesQueryInfo.special((String)"itc_taxfile", (String[])fileProps.values().toArray(new String[0]));
        List filters = (List)filterSupplier.supply();
        if (!includeStop) {
            filters.add(new QFilter("taxstatus", "=", (Object)"1"));
        }
        if (taxPeriodEntity != null) {
            filters.add(new QFilter("bsed", "<=", (Object)taxPeriodEntity.getEndDate()));
            filters.add(new QFilter("bsled", ">=", (Object)taxPeriodEntity.getStartDate()).or("bsled", "is null", null));
        }
        if (ArrayUtils.isEmpty((Object[])(taxFiles = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)queryInfo, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBy)))) {
            result.put("data", Collections.emptyMap());
            return result;
        }
        HashMap taxFileGroupByBo = Maps.newHashMapWithExpectedSize((int)taxFiles.length);
        HashMap data = Maps.newHashMapWithExpectedSize((int)taxFiles.length);
        for (Object taxFile : taxFiles) {
            long boId = taxFile.getLong("boid");
            List objects = taxFileGroupByBo.computeIfAbsent(boId, ky -> Lists.newArrayListWithExpectedSize((int)4));
            objects.add(taxFile);
            HashMap map = Maps.newHashMapWithExpectedSize((int)props.size());
            long id = taxFile.getLong("id");
            map.put("id", id);
            map.put("boid", boId);
            map.put("bsed", taxFile.getDate("bsed"));
            map.put("bsled", taxFile.getDate("bsled"));
            map.put("iscurrentversion", taxFile.getBoolean("iscurrentversion"));
            if (useBoId) {
                data.put(boId, map);
                continue;
            }
            data.put(id, map);
        }
        for (Map.Entry entry : taxFileGroupByBo.entrySet()) {
            ((List)entry.getValue()).sort(Comparator.comparing(dy -> dy.getDate("bsed")));
        }
        for (Map.Entry entry : groupProps.entrySet()) {
            try {
                TaxFileInfoService infoService = TaxFileInfoServiceFactory.byEntityNumber((String)((String)entry.getKey()));
                infoService.gatherInfoOf((Map)data, (Map)taxFileGroupByBo, (Map)entry.getValue(), taxPeriodEntity, useBoId);
            }
            catch (Exception e) {
                LOGGER.error("gatherInfo error by ns:", (Throwable)e);
            }
        }
        result.put("data", data);
        return result;
    }

    private void validateAndSave(List<Map<String, Object>> resData, List<DynamicObject> allData, String actionWay, String action) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("src", "API");
        option.setVariableValue("ITCFILE_ACTIONWAY", actionWay);
        option.setVariableValue("action", action);
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("skipCheckDataPermission", "true");
        option.setVariableValue("skipCheckSpecialDataPermission", "true");
        OperationResult opRes = OperationServiceHelper.executeOperate((String)"save", (String)"itc_taxfile", (DynamicObject[])allData.toArray(new DynamicObject[0]), (OperateOption)option);
        List errorOrValidateInfo = opRes.getAllErrorOrValidateInfo();
        if (errorOrValidateInfo.isEmpty()) {
            List successPkIds = opRes.getSuccessPkIds();
            for (int i = 0; i < allData.size(); ++i) {
                Map itemRes = BaseResult.packageResult((boolean)true, (int)ResultStatusEnum.INFO.getCode(), null, null);
                if (!CollectionUtils.isEmpty((Collection)successPkIds)) {
                    itemRes.put("id", successPkIds.get(i));
                } else if ("1".equals(actionWay)) {
                    itemRes.put("id", -1);
                }
                itemRes.put(TMP_ID, allData.get(i).getLong(TMP_ID));
                resData.add(itemRes);
            }
        } else {
            HashMap<Integer, StringBuilder> queryMap = new HashMap<Integer, StringBuilder>(errorOrValidateInfo.size());
            String fieldTipsSplit = "\uff0c";
            for (IOperateInfo info : errorOrValidateInfo) {
                OperateErrorInfo errorInfo = (OperateErrorInfo)info;
                int ri = errorInfo.getDataEntityIndex();
                StringBuilder query = queryMap.computeIfAbsent(ri, v1 -> new StringBuilder());
                query.append(errorInfo.getMessage()).append(fieldTipsSplit);
                String s1 = "by cyh validateAndSave key = " + info.getPkValue() + " msg = " + info.getMessage();
                LOGGER.info(s1);
            }
            for (int i = 0; i < allData.size(); ++i) {
                StringBuilder message = (StringBuilder)queryMap.get(i);
                if (message != null && message.length() > 0) {
                    message.delete(message.length() - fieldTipsSplit.length(), message.length());
                }
                boolean success = message == null;
                Map itemRes = BaseResult.packageResult((boolean)success, (int)ResultStatusEnum.ERROR.getCode(), (String)(success ? null : message.toString()), null);
                itemRes.put(TMP_ID, allData.get(i).getLong(TMP_ID));
                itemRes.put("id", allData.get(i).getLong("id"));
                resData.add(itemRes);
                LOGGER.info("by cyh validateAndSave itemRes = {}", (Object)itemRes);
            }
        }
    }

    private DynamicObject packageData(Map<String, Object> data, Map<String, Map<String, DynamicObject>> baseDataMap) {
        HRBaseServiceHelper taxFileServiceHelper = new HRBaseServiceHelper("itc_taxfile");
        SitDateUtil.convertDate(data, (String[])new String[]{"bsed", "createtime", "modifytime"});
        DynamicObject result = taxFileServiceHelper.generateEmptyDynamicObject();
        result.set("number", data.get("number"));
        result.set("person", data.get("person"));
        result.set("org", data.get("org"));
        result.set("taxregion", data.get("taxregion"));
        result.set("empgroup", data.get("empgroup"));
        result.set("taxunit", data.get("taxunit"));
        result.set("bsed", data.get("bsed"));
        result.set("isescrowstaff", data.get("isescrowstaff"));
        DynamicObject taxPayerType = baseDataMap.get("itc_taxpayertype").get(String.valueOf(data.get("taxpayertype")));
        DynamicObject empType = baseDataMap.get("itc_emptype").get(String.valueOf(data.get("emptype")));
        result.set("taxpayertypetmp", (Object)taxPayerType);
        result.set("emptypetmp", (Object)empType);
        result.set("empdatetmp", data.get("empdate"));
        result.set("empsituationtmp", data.get("empsituation"));
        result.set("isdeductexpstmp", data.get("isdeductexps"));
        result.set("createtime", data.get("createtime"));
        result.set("modifytime", data.get("modifytime"));
        result.set("creator", data.get("creator"));
        result.set("modifier", data.get("modifier"));
        result.set(TMP_ID, data.get(TMP_ID));
        result.set("enable", (Object)1);
        result.set("declarestatus", (Object)"0");
        result.set("reportstatus", (Object)"0");
        result.set("taxstatus", (Object)"1");
        result.set("status", (Object)"A");
        return result;
    }

    @Override
    public Map<String, Object> loadTaxFileKeyInfoByVid(Map<String, Object> relateIds, DynamicObject taxFile, int editStatus) {
        return TaxFileInfoServiceFactory.loadTaxFileKeyInfoByVid(relateIds, (DynamicObject)taxFile, (int)editStatus);
    }

    @Override
    public Map<String, Object> findTaxFile(long taxFileId, Set<String> props, boolean includeStop) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        result.put("success", Boolean.TRUE);
        result.put("status", 200);
        if (0L == taxFileId) {
            result.put("data", Collections.emptyMap());
            return result;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("boid", "=", (Object)taxFileId));
        filters.add(new QFilter("status", "!=", (Object)"E"));
        filters.add(new QFilter("iscurrentversion", "!=", (Object)"1"));
        filters.add(new QFilter("datastatus", "not in", (Object)new String[]{"-1", "-2"}));
        if (!includeStop) {
            filters.add(new QFilter("taxstatus", "=", (Object)"1"));
        }
        if (props == null) {
            props = Sets.newHashSet(props);
        }
        props.add("boid");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxfile");
        Object[] taxFiles = helper.query(String.join((CharSequence)",", props), filters.toArray(new QFilter[0]));
        if (ArrayUtils.isEmpty((Object[])taxFiles)) {
            result.put("data", Collections.emptyMap());
            return result;
        }
        HashMap data = Maps.newHashMapWithExpectedSize((int)taxFiles.length);
        HashMap map2 = Maps.newHashMapWithExpectedSize((int)props.size());
        for (Object dy : taxFiles) {
            HashMap map1 = Maps.newHashMapWithExpectedSize((int)props.size());
            for (String prop : props) {
                map1.put(prop, dy.get(prop));
            }
            map2.put(dy.getLong("id"), map1);
            data.put(dy.getLong("boid"), map2);
        }
        result.put("data", data);
        return result;
    }
}

