/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.SITMServiceUtils;

public class TaxFileImportInfo {
    public static final String KEY_ISSUPERUSER = "taxfileinfo_issuperuser";
    public static final String KEY_ORG = "taxfileinfo_org";
    public static final String KEY_ADMINORG = "taxfileinfo_adminorg";
    public static final String KEY_EMPGROUP = "taxfileinfo_empgroup";
    public static final String KEY_APPEMPGROUP = "taxfileinfo_appempgroup";
    public static final String KEY_COUNTRYID = "taxfileinfo_countryid";
    public static final String KEY_TAXUNIT = "TAXFILEINFO_TAXUNIT";
    private String appId = "17/+CT1QBPNP";
    private String appNumber = "itc";
    private final Map<String, Object> cacheInfoMap = new HashMap<String, Object>(16);
    public TaxFileOpContext taxFileOpContext = new TaxFileOpContext();

    public TaxFileOpContext getTaxFileOpContext() {
        return this.taxFileOpContext;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppNumber() {
        return this.appNumber;
    }

    public void setAppNumber(String appNumber) {
        this.appNumber = appNumber;
    }

    public Boolean isSuperUser() {
        Boolean isSuperUser = (Boolean)this.cacheInfoMap.get(KEY_ISSUPERUSER);
        if (isSuperUser == null && !this.cacheInfoMap.containsKey(KEY_ISSUPERUSER)) {
            isSuperUser = SITPermissionServiceHelper.isSuperUser();
            this.cacheInfoMap.put(KEY_ISSUPERUSER, isSuperUser);
        }
        return isSuperUser;
    }

    public Set<Long> getOrgIds() {
        Set orgSet = (Set)this.cacheInfoMap.get(KEY_ORG);
        if (CollectionUtils.isEmpty((Collection)orgSet) && !this.cacheInfoMap.containsKey(KEY_ORG)) {
            HasPermOrgResult permOrgs = SITPermissionServiceHelper.getPermOrgs((String)this.getAppId(), (String)"itc_taxfile");
            if (permOrgs != null) {
                orgSet = permOrgs.getHasPermOrgs().stream().collect(Collectors.toSet());
            }
            this.cacheInfoMap.put(KEY_ORG, orgSet);
        }
        return orgSet;
    }

    public Set<Long> getAdminOrgIds() {
        Set adminOrgSetByPermItem = (Set)this.cacheInfoMap.get(KEY_ADMINORG);
        if (CollectionUtils.isEmpty((Collection)adminOrgSetByPermItem) && !this.cacheInfoMap.containsKey(KEY_ADMINORG)) {
            adminOrgSetByPermItem = SITPermissionServiceHelper.getAdminOrgSetByPermItem((String)this.getAppId(), (String)"itc_taxfile", (String)"47150e89000000ac", (String)"adminorg");
            this.cacheInfoMap.put(KEY_ADMINORG, adminOrgSetByPermItem);
        }
        return adminOrgSetByPermItem;
    }

    public Set<Long> getEmpGroupIds() {
        Set<Long> empGroupSet = (Set<Long>)this.cacheInfoMap.get(KEY_EMPGROUP);
        if (CollectionUtils.isEmpty((Collection)empGroupSet) && !this.cacheInfoMap.containsKey(KEY_EMPGROUP)) {
            Set<Long> appEmpGroupIdSet = this.getAppEmpGroupIds();
            if (appEmpGroupIdSet != null) {
                empGroupSet = SITPermissionServiceHelper.getEmpgrpSetByPermItem((String)this.getAppId(), (String)"itc_taxfile", (String)"47150e89000000ac");
                empGroupSet = empGroupSet == null ? appEmpGroupIdSet : empGroupSet.stream().filter(id -> appEmpGroupIdSet.contains(id)).collect(Collectors.toSet());
            }
            this.cacheInfoMap.put(KEY_EMPGROUP, empGroupSet);
        }
        return empGroupSet;
    }

    public Set<Long> getAppEmpGroupIds() {
        Set appEmpGroupSet = (Set)this.cacheInfoMap.get(KEY_APPEMPGROUP);
        if (CollectionUtils.isEmpty((Collection)appEmpGroupSet) && !this.cacheInfoMap.containsKey(KEY_APPEMPGROUP)) {
            List appEmpGroupIdList = SITPermissionServiceHelper.getEmpgroupByAppNumber((String)this.getAppNumber());
            if (!CollectionUtils.isEmpty((Collection)appEmpGroupIdList)) {
                appEmpGroupSet = Sets.newHashSet((Iterable)appEmpGroupIdList);
            }
            this.cacheInfoMap.put(KEY_APPEMPGROUP, appEmpGroupSet);
        }
        return appEmpGroupSet;
    }

    public Set<Long> getTaxUnitIds() {
        Set taxUnitSet = (Set)this.cacheInfoMap.get(KEY_TAXUNIT);
        if (CollectionUtils.isEmpty((Collection)taxUnitSet) && !this.cacheInfoMap.containsKey(KEY_TAXUNIT)) {
            taxUnitSet = SITPermissionServiceHelper.getTaxUnitSetByPermItem((String)this.getAppId(), (String)"itc_taxfile", (String)"47150e89000000ac");
            this.cacheInfoMap.put(KEY_TAXUNIT, taxUnitSet);
        }
        return taxUnitSet;
    }

    public DynamicObject getCountryDyn() {
        DynamicObject countryDyn = (DynamicObject)this.cacheInfoMap.get(KEY_COUNTRYID);
        if (countryDyn == null && !this.cacheInfoMap.containsKey(KEY_COUNTRYID)) {
            String countryId = (String)SITMServiceUtils.invokeSITService((String)"sitbs", (String)"ISITBSService", (String)"getCountryIdByServiceAppId", (Object[])new Object[]{this.getAppNumber()});
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("bd_country");
            countryDyn = baseServiceHelper.queryOne((Object)Long.valueOf(countryId));
            this.cacheInfoMap.put(KEY_COUNTRYID, countryDyn);
        }
        return countryDyn;
    }
}

