/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.history.BaseDataHisHelper;
import kd.sit.sitbp.common.util.DynamicTransformUtil;

public class TaxFileQueryServiceHelper {
    private static final Log LOG = LogFactory.getLog(TaxFileQueryServiceHelper.class);
    private static final HRBaseServiceHelper FILE_HELPER = new HRBaseServiceHelper("itc_taxfile");
    private static final List<String> IGNOR_ELIST = Arrays.asList("enable", "simplename", "index", "issyspreset", "disabler", "disabledate", "boid", "iscurrentversion", "datastatus", "bred", "brled", "bsed", "bsled", "ismodify", "salaryfile");

    public static Map<String, Object> queryTaxFileBoByEmp(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            TaxFileQueryServiceHelper.validateParam(param, result);
            if (result.containsKey("success")) {
                return result;
            }
            List<Map<String, Object>> datas = TaxFileQueryServiceHelper.queryFileBoByEmpCore(param);
            result.put("success", Boolean.TRUE);
            result.put("data", datas);
        }
        catch (Exception ex) {
            LOG.error("FileQueryServiceHelper...queryFile.error\uff1a", (Throwable)ex);
            String errorMsg = ex.getMessage();
            if (errorMsg != null && errorMsg.length() >= 100) {
                errorMsg = errorMsg.substring(0, 100) + "...";
            }
            result.put("message", errorMsg);
            result.put("success", Boolean.FALSE);
        }
        return result;
    }

    private static void validateParam(Map<String, Object> param, Map<String, Object> result) {
        try {
            if (!(param.get("employees") instanceof List) || ((List)param.get("employees")).size() == 0) {
                result.put("success", Boolean.FALSE);
                result.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\u3002", (String)"TaxFileQueryServiceHelper_1", (String)"sit-itc-business", (Object[])new Object[0]));
                return;
            }
            List employees = (List)param.get("employees");
            ArrayList<Long> employeesNew = new ArrayList<Long>(10);
            for (Object empId : employees) {
                employeesNew.add(Long.parseLong(String.valueOf(empId)));
            }
            param.put("employees", employeesNew);
            List status = (List)param.get("status");
            String string = (String)param.get("selectProperties");
        }
        catch (Exception ex) {
            LOG.error("FileQueryServiceHelper...validateParam.error\uff1a", (Throwable)ex);
            result.put("success", Boolean.FALSE);
            result.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\u3002", (String)"TaxFileQueryServiceHelper_1", (String)"sit-itc-business", (Object[])new Object[0]));
            return;
        }
    }

    private static List<Map<String, Object>> queryFileBoByEmpCore(Map<String, Object> param) {
        String selectProperties;
        ArrayList<String> status;
        HRBaseServiceHelper empHelper = new HRBaseServiceHelper("hrpi_employee");
        QFilter empIdFilter = new QFilter("id", "in", param.get("employees"));
        DynamicObject[] empDys = empHelper.query("person.id", new QFilter[]{empIdFilter});
        Map<Long, Long> empIdMap = Arrays.stream(empDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("person.id"), (dy1, dy2) -> dy1));
        Map<Long, DynamicObject> empIdAndEmpDyMap = Arrays.stream(empDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (dy1, dy2) -> dy1));
        QFilter fileIdFilter = BaseDataHisHelper.getHisCurrFilter();
        fileIdFilter.and("person.id", "in", empIdMap.values());
        ArrayList<String> arrayList = status = param.get("status") == null ? null : (ArrayList<String>)param.get("status");
        if (status == null) {
            status = new ArrayList<String>(1);
            status.add("C");
        }
        fileIdFilter.and("status", "in", status);
        List<String> needKeys = null;
        String string = selectProperties = param.get("selectProperties") == null ? null : String.valueOf(param.get("selectProperties"));
        if (selectProperties == null || "".equals(selectProperties)) {
            selectProperties = BaseDataHisHelper.getSelectProperties((String)FILE_HELPER.getEntityName());
        } else {
            if (!selectProperties.contains("employee.id")) {
                selectProperties = selectProperties + ",employee.id";
            }
            needKeys = Arrays.asList(selectProperties.replace(" ", "").replace('.', '_').split(","));
            if (!selectProperties.contains("person.id")) {
                selectProperties = selectProperties + ",person.id";
            }
        }
        DynamicObject[] fileDys = FILE_HELPER.query(selectProperties, new QFilter[]{fileIdFilter});
        Map<Long, List<DynamicObject>> personFileDyMap = Arrays.stream(fileDys).collect(Collectors.groupingBy(dy -> dy.getLong("person.id")));
        HashSet<String> ignoreKey = new HashSet<String>(16);
        ignoreKey.addAll(IGNOR_ELIST);
        ArrayList<Map<String, Object>> fileMaps = new ArrayList<Map<String, Object>>(10);
        for (Map.Entry<Long, Long> entry : empIdMap.entrySet()) {
            Long empId = entry.getKey();
            Long personId = entry.getValue();
            List<DynamicObject> tmpFileDys = personFileDyMap.get(personId);
            if (tmpFileDys == null) continue;
            for (DynamicObject fileDy : tmpFileDys) {
                fileDy.set("employee", (Object)empIdAndEmpDyMap.get(empId));
                Map fileMap = DynamicTransformUtil.dynamicObjectToMap((DynamicObject)fileDy, ignoreKey, needKeys);
                fileMaps.add(fileMap);
            }
        }
        return fileMaps;
    }
}

