/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.itc.business.taxfile.impl.gather.AbstractInfoGather;
import kd.sit.itc.common.enums.SrcRefNumEnums;
import kd.sit.sitbp.business.servicehelper.MutexServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITCertCommonHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.DataFilter;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.MutexLockInfo;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import kd.sit.sitbp.common.util.SITStringUtils;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxFileServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(TaxFileServiceHelper.class);

    public static DynamicObject findLatestOldFileOfPerson(long personId, long excludeTaxFileId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("id", "!=", (Object)excludeTaxFileId));
        qFilters.add(new QFilter("person.id", "=", (Object)personId));
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode()));
        qFilters.add(new QFilter("datastatus", "=", (Object)"1"));
        PropertiesQueryInfo propertiesQueryInfo = new PropertiesQueryInfo("itc_taxfile");
        String props = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)propertiesQueryInfo, (DataFilter)SitDataServiceHelper.DEFAULT_FILTER);
        Object[] taxfiles = serviceHelper.query(props, qFilters.toArray(new QFilter[0]), "bsed desc");
        return ArrayUtils.isEmpty((Object[])taxfiles) ? null : taxfiles[0];
    }

    private static void updateAfterModifyDyobjs(String entityId, List<Long> ids, String fieldKey, String value) {
        DynamicObject[] dyobjs;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityId);
        QFilter qFilter = new QFilter("id", "in", ids);
        for (DynamicObject dyobj : dyobjs = serviceHelper.query(fieldKey, new QFilter[]{qFilter})) {
            dyobj.set(fieldKey, (Object)value);
        }
        serviceHelper.update(dyobjs);
    }

    public static BatchResult<DynamicObject> gatherExtraInfo(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext) {
        if (CollectionUtils.isEmpty(taxFiles)) {
            return new BatchResult(true, null);
        }
        taxFileOpContext.addExtraInfo(taxFiles.toArray(new DynamicObject[0]), e1 -> e1.getLong("id"));
        return AbstractInfoGather.gatherExtraInfo(taxFiles, taxFileOpContext);
    }

    public static int getLevelByField(String flag) {
        int level = 0;
        switch (flag) {
            case "regpermres": 
            case "habitres": 
            case "address": 
            case "province": {
                level = 1;
                break;
            }
            case "regpermrescity": 
            case "habitrescity": 
            case "addresscity": {
                level = 2;
                break;
            }
            case "habitrescounty": 
            case "regpermrescounty": 
            case "addresscounty": {
                level = 3;
                break;
            }
        }
        return level;
    }

    public static boolean validateIsBelongToChina(String flag, long countryId) {
        boolean isChina = false;
        switch (flag) {
            case "regpermres": 
            case "habitres": 
            case "address": {
                if (1000001L != countryId) break;
                isChina = true;
                break;
            }
        }
        return isChina;
    }

    public static boolean validateAdmindivisionIsEmpty(String field, IFormView formView) {
        DynamicObject dataEntity = formView.getModel().getDataEntity();
        boolean flag = true;
        switch (field) {
            case "regpermrescity": {
                if (null != dataEntity.get("regpermres")) break;
                flag = false;
                formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6237\u7c4d\u6240\u5728\u5730\uff08\u7701\uff09\u3002", (String)"TaxFileServiceHelper_3", (String)"sit-itc-business", (Object[])new Object[0]));
                break;
            }
            case "regpermrescounty": {
                if (null != dataEntity.get("regpermrescity")) break;
                flag = false;
                formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6237\u7c4d\u6240\u5728\u5730\uff08\u5e02\uff09\u3002", (String)"TaxFileServiceHelper_4", (String)"sit-itc-business", (Object[])new Object[0]));
                break;
            }
            case "habitrescity": {
                if (null != dataEntity.get("habitres")) break;
                flag = false;
                formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ecf\u5e38\u5c45\u4f4f\u5730\uff08\u7701\uff09\u3002", (String)"TaxFileServiceHelper_5", (String)"sit-itc-business", (Object[])new Object[0]));
                break;
            }
            case "habitrescounty": {
                if (null != dataEntity.get("habitrescity")) break;
                flag = false;
                formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ecf\u5e38\u5c45\u4f4f\u5730\uff08\u5e02\uff09\u3002", (String)"TaxFileServiceHelper_6", (String)"sit-itc-business", (Object[])new Object[0]));
                break;
            }
            case "addresscity": {
                if (null != dataEntity.get("address")) break;
                flag = false;
                formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8054\u7cfb\u5730\u5740\uff08\u7701\uff09\u3002", (String)"TaxFileServiceHelper_7", (String)"sit-itc-business", (Object[])new Object[0]));
                break;
            }
            case "addresscounty": {
                if (null != dataEntity.get("addresscity")) break;
                flag = false;
                formView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8054\u7cfb\u5730\u5740\uff08\u5e02\uff09\u3002", (String)"TaxFileServiceHelper_8", (String)"sit-itc-business", (Object[])new Object[0]));
                break;
            }
        }
        return flag;
    }

    public static QFilter getQFilterByFlag(String flag, int level, IFormView formView) {
        QFilter qFilter = new QFilter("level", "=", (Object)level);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject dataEntity = formView.getModel().getDataEntity();
        switch (flag) {
            case "regpermrescity": 
            case "regpermrescounty": 
            case "habitrescity": 
            case "habitrescounty": 
            case "addresscity": 
            case "addresscounty": {
                qFilter.and(TaxFileServiceHelper.getQFilterByFlag(flag, dataEntity));
                break;
            }
        }
        return qFilter;
    }

    public static QFilter getQFilterByFlag(String flag, DynamicObject dataEntity) {
        HashMap<String, String> filterMap = new HashMap<String, String>(16);
        filterMap.put("regpermrescity", "regpermres.id");
        filterMap.put("regpermrescounty", "regpermrescity.id");
        filterMap.put("habitrescity", "habitres.id");
        filterMap.put("habitrescounty", "habitrescity.id");
        filterMap.put("addresscity", "address.id");
        filterMap.put("addresscounty", "addresscity.id");
        return new QFilter("parent.id", "=", (Object)dataEntity.getLong((String)filterMap.get(flag)));
    }

    public static boolean validateTaxDataStatus(long taxFileId, QFilter qFilter) {
        boolean flag = false;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdata");
        QFilter filter = new QFilter("taxfile", "=", (Object)taxFileId);
        if (null != qFilter) {
            filter.and(qFilter);
        }
        DynamicObject[] taxDataDyObj = serviceHelper.query("taxtask.id", new QFilter[]{filter});
        HashSet<Long> taxTaskIdsSet = new HashSet<Long>(16);
        for (DynamicObject dynamicObject : taxDataDyObj) {
            long taxTaskId = dynamicObject.getLong("taxtask.id");
            taxTaskIdsSet.add(taxTaskId);
        }
        if (!taxTaskIdsSet.isEmpty()) {
            DynamicObject[] taxTaskDyObj;
            HRBaseServiceHelper taxTaskHelper = new HRBaseServiceHelper("itc_taxtask");
            QFilter taskFilter = new QFilter("id", "in", taxTaskIdsSet);
            for (DynamicObject dynamicObject : taxTaskDyObj = taxTaskHelper.query("id,taskstatus", new QFilter[]{taskFilter})) {
                if (!HRStringUtils.equals((String)"0", (String)dynamicObject.getString("taskstatus"))) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static DynamicObject queryRealteDynamicObject(String pageNum, long taxFileId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(pageNum);
        QFilter filter = new QFilter("taxfile", "=", (Object)taxFileId);
        return serviceHelper.loadDynamicObject(filter);
    }

    public static Map<String, IFormView> getChildFormView(IFormView view) {
        HRPageCache pageCache = new HRPageCache(view);
        Map pageIds = (Map)pageCache.get("pageids", Map.class);
        HashMap<String, IFormView> childViewMap = new HashMap<String, IFormView>(16);
        LOGGER.info("pageIds is {}", (Object)pageIds.toString());
        for (Map.Entry pageNumber : pageIds.entrySet()) {
            IFormView baseView = view.getViewNoPlugin((String)pageIds.get(pageNumber.getKey()));
            if (baseView == null) continue;
            childViewMap.put((String)pageNumber.getKey(), baseView);
        }
        return childViewMap;
    }

    public static void openAdmindivision(BeforeF7SelectEvent event, IFormView view, String fieldKey) {
        ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
        param.setBillFormId("bd_admindivision");
        param.setCustomParam("id", (Object)1000001L);
        param.setCustomParam("countryId", (Object)1000001L);
        ListFilterParameter listFilterParameter = param.getListFilterParameter();
        int level = TaxFileServiceHelper.getLevelByField(fieldKey);
        QFilter qFilter = TaxFileServiceHelper.getQFilterByFlag(fieldKey, level, view);
        qFilter.and(new QFilter("country.id", "=", (Object)1000001L));
        listFilterParameter.setFilter(qFilter);
        view.showForm((FormShowParameter)param);
    }

    public static Map<Long, Long> getPersonIdOrPIDs(String property, List<Long> params) {
        Map<Long, Long> map = null;
        HRBaseServiceHelper service = new HRBaseServiceHelper("hrpi_person");
        QFilter qFilter = new QFilter(property, "in", params);
        qFilter.and("iscurrentversion", "=", (Object)"1");
        Object[] dys = service.query("id,personindexid", new QFilter[]{qFilter});
        if (ArrayUtils.isNotEmpty((Object[])dys)) {
            map = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("personindexid"), (k1, k2) -> k1));
        }
        return map;
    }

    public static DynamicObject[] findPersonInfo(List<Long> taxFileIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
        QFilter qFilter = new QFilter("id", "in", taxFileIds);
        qFilter.and("taxregion.id", "=", (Object)1000001L);
        return serviceHelper.query("id,number,person,person.id,person.personindexid", new QFilter[]{qFilter});
    }

    public static List<Long> getApplyPids(List<Long> taxFileIds) {
        Object[] dys = TaxFileServiceHelper.findPersonInfo(taxFileIds);
        if (ArrayUtils.isEmpty((Object[])dys)) {
            return null;
        }
        Set pids = Arrays.stream(dys).map(dy -> dy.getLong("person.personindexid")).collect(Collectors.toSet());
        return new ArrayList<Long>(pids);
    }

    public static List<Long> getReleasePids(List<Long> taxFileIds, Long countryId) {
        Object[] dys = TaxFileServiceHelper.findPersonInfo(taxFileIds);
        if (ArrayUtils.isEmpty((Object[])dys)) {
            return Collections.emptyList();
        }
        Set pids = Arrays.stream(dys).map(dy -> dy.getLong("person.personindexid")).collect(Collectors.toSet());
        List<String> numbers = Arrays.stream(dys).map(dy -> dy.getString("number")).collect(Collectors.toList());
        Map<Long, Long> map = TaxFileServiceHelper.getPersonIdOrPIDs("personindexid", new ArrayList<Long>(pids));
        if (map != null) {
            ArrayList<Long> allPersonids = new ArrayList<Long>(map.keySet());
            LOGGER.info("TaxFileServiceHelper.getPersonIdOrPIDs allPersonids is {}", allPersonids);
            List<Long> dellist = TaxFileServiceHelper.getCurFileEffectPersonIds(taxFileIds, allPersonids, numbers, countryId);
            if (dellist != null && !dellist.isEmpty()) {
                LOGGER.info("query other personid dellist is {}", dellist);
                dellist.forEach(id -> {
                    if (pids.contains(map.get(id))) {
                        pids.remove(map.get(id));
                    }
                });
            }
        }
        return new ArrayList<Long>(pids);
    }

    public static List<Long> getCurFileEffectPersonIds(List<Long> taxFileIds, List<Long> personIds, List<String> numbers, Long countryId) {
        List resultList = null;
        Date today = SITDateTimeUtils.getTodayDateWithoutTime();
        HRBaseServiceHelper fileService = new HRBaseServiceHelper("itc_taxfile");
        QFilter filter = new QFilter("person.id", "in", personIds);
        filter.and(new QFilter("number", "not in", numbers));
        filter.and(new QFilter("taxregion.id", "=", (Object)countryId));
        filter.and(new QFilter("taxstatus", "=", (Object)"1"));
        filter.and(new QFilter("status", "=", (Object)"C"));
        QFilter qfilter = new QFilter("id", "not in", taxFileIds);
        qfilter.and(new QFilter("number", "in", numbers));
        qfilter.and(new QFilter("taxregion.id", "=", (Object)countryId));
        qfilter.and(new QFilter("taxstatus", "=", (Object)"1"));
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        Object[] fileDys = fileService.query("id,person,person.id,iscurrentversion,bsed,datastatus", new QFilter[]{filter.or(qfilter)});
        if (ArrayUtils.isNotEmpty((Object[])fileDys)) {
            resultList = Arrays.stream(fileDys).filter(dy -> {
                Boolean iscurrentversion = dy.getBoolean("iscurrentversion");
                Date bsed = dy.getDate("bsed");
                String datastatus = dy.getString("datastatus");
                return iscurrentversion != false || iscurrentversion == false && bsed.after(today) && datastatus.equals("0");
            }).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        }
        return resultList;
    }

    public static List<Long> getApplyOrReleasePids(List<Long> taxFileIds, Long countryId) {
        return TaxFileServiceHelper.getApplyPids(taxFileIds);
    }

    public static void applyPersonCert(List<Long> taxFileIds) {
        LOGGER.info("TaxFileServiceHelper.applyPersonCert taxFileIds is {}", taxFileIds);
        List<Long> pids = TaxFileServiceHelper.getApplyPids(taxFileIds);
        if (!CollectionUtils.isEmpty(pids)) {
            LOGGER.info("TaxFileServiceHelper.applyPersonCert pids is {}", pids);
            Long conytryId = 1000001L;
            DynamicObject appInfo = SITCertCommonHelper.queryAppInfoByCountryId((Long)conytryId);
            SITCertCommonHelper.updateCert((String)appInfo.getString("app.id"), (String)"itc_taxfile", pids);
        }
    }

    public static void releasePersonCert(List<Long> taxFileIds) {
        LOGGER.info("TaxFileServiceHelper.releasePersonCert taxFileIds {}", taxFileIds);
        Long countryId = 1000001L;
        List<Long> pids = TaxFileServiceHelper.getReleasePids(taxFileIds, countryId);
        if (!CollectionUtils.isEmpty(pids)) {
            LOGGER.info("TaxFileServiceHelper.releasePersonCert pids {}", pids);
            DynamicObject appInfo = SITCertCommonHelper.queryAppInfoByCountryId((Long)countryId);
            SITCertCommonHelper.releaseCert((String)appInfo.getString("app.id"), (String)"itc_taxfile", pids);
        }
    }

    public static void calEffectingTaxFileCertByTaxFileId(List<Long> taxFileIdList) {
        if (CollectionUtils.isEmpty(taxFileIdList)) {
            return;
        }
        HRBaseServiceHelper taxFileHelper = new HRBaseServiceHelper("itc_taxfile");
        QFilter filter = new QFilter("id", "in", taxFileIdList);
        DynamicObject[] dynamicObjects = taxFileHelper.query("id,taxstatus,number,employment,employment.boid,employment.sourcevid", new QFilter[]{filter});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            ArrayList stopTaxIds = Lists.newArrayListWithCapacity((int)dynamicObjects.length);
            ArrayList normalTaxIds = Lists.newArrayListWithCapacity((int)dynamicObjects.length);
            Arrays.stream(dynamicObjects).forEach(obj -> {
                if ("0".equals(obj.getString("taxstatus"))) {
                    stopTaxIds.add(obj.getLong("id"));
                } else {
                    normalTaxIds.add(obj.getLong("id"));
                }
            });
            try (TXHandle tx = TX.required();){
                LOGGER.info("TaxFileCertUpdateTask update cert,release cert fileids:{0} -  apply person cert fileids:{1} ", (Object)stopTaxIds, (Object)normalTaxIds);
                TaxFileServiceHelper.releasePersonCert(stopTaxIds);
                TaxFileServiceHelper.applyPersonCert(normalTaxIds);
            }
        }
    }

    public static Map<String, Object> verifyCertForTaxFileFromBasic(BillList billList, boolean isExportAll, List<Long> selectIds) {
        List basicFilters;
        if (isExportAll) {
            FilterParameter para = billList.generalFilterParameter();
            basicFilters = para.getQFilters();
        } else {
            basicFilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "in", selectIds)});
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        DynamicObject[] basicQuery = serviceHelper.query("id,taxfile.id,taxfile.taxstatus", basicFilters.toArray(new QFilter[0]));
        List<Long> fileIds = Arrays.stream(basicQuery).filter(obj -> obj.getBoolean("taxfile.taxstatus")).map(obj -> obj.getLong("taxfile.id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(fileIds)) {
            return null;
        }
        return TaxFileServiceHelper.verifyCertForTaxFile(fileIds);
    }

    public static Map<String, Object> verifyCertForTaxFile(List<Long> selectIds) {
        QFilter fileFilter = new QFilter("id", "in", selectIds);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
        DynamicObject[] dys = serviceHelper.query("id,person.personindexid,status", new QFilter[]{fileFilter});
        ArrayList<Long> releasePersonIndexIds = new ArrayList<Long>(dys.length);
        for (DynamicObject dy : dys) {
            if (!"C".equals(dy.getString("status"))) continue;
            releasePersonIndexIds.add(dy.getLong("person.personindexid"));
        }
        if (CollectionUtils.isEmpty(releasePersonIndexIds)) {
            return null;
        }
        DynamicObject appInfo = SITCertCommonHelper.queryAppInfoByCountryId((Long)1000001L);
        if (appInfo == null) {
            return null;
        }
        return SITCertCommonHelper.verifyCert((String)appInfo.getString("app.id"), (String)"itc_taxfile", releasePersonIndexIds);
    }

    public static String validatePersonMustInput(DynamicObject iitPerson, String dataSource) {
        StringBuilder fieldsName = new StringBuilder();
        String split = ResManager.loadKDString((String)"\u3001", (String)"TaxFilePlugin_17", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        for (IDataEntityProperty property : iitPerson.getDataEntityType().getProperties()) {
            if ("taxcrdltype".equals(property.getName()) || !TaxFileServiceHelper.isMustInput(property) || iitPerson.get(property) != null && !"".equals(iitPerson.get(property))) continue;
            fieldsName.append(property.getDisplayName()).append(split);
        }
        String failMsg = "";
        if (!Strings.isNullOrEmpty((String)fieldsName.toString())) {
            int length = fieldsName.length();
            fieldsName.delete(length - split.length(), length);
            if (StringUtils.equals((CharSequence)dataSource, (CharSequence)"0")) {
                failMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7{1}\uff09\u7684\u4eba\u5458\u4fe1\u606f\u201c{2}\u201d\u672a\u7ef4\u62a4\uff0c\u65e0\u6cd5\u9009\u4e2d\u3002", (String)"TaxFileServiceHelper_9", (String)"sit-itc-business", (Object[])new Object[0]), iitPerson.getString("name"), iitPerson.getString("number"), fieldsName);
            } else if (StringUtils.equals((CharSequence)dataSource, (CharSequence)"-1")) {
                failMsg = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff08\u5de5\u53f7{1}\uff09\u7684\u4eba\u5458\u4fe1\u606f\u201c{2}\u201d\u672a\u7ef4\u62a4\u3002", (String)"TaxFileServiceHelper_10", (String)"sit-itc-business", (Object[])new Object[0]), iitPerson.getString("name"), iitPerson.getString("number"), fieldsName);
            }
        }
        return failMsg;
    }

    private static boolean isMustInput(IDataEntityProperty property) {
        if (property instanceof FieldProp) {
            return ((FieldProp)property).isMustInput();
        }
        return property instanceof BasedataProp && ((BasedataProp)property).isMustInput();
    }

    public static BaseResult<?> deleteTaxFileSubInfo(Long taxFileId, String entityName, String displayName) {
        QFilter taxFileFilter;
        HRBaseServiceHelper helper;
        DynamicObject taxFile;
        if ("itc_overseasperson".equals(entityName) && null != (taxFile = (helper = new HRBaseServiceHelper("itc_taxfile")).queryOne("status,pernontsprop.nationality.id,pernontsprop.nationality.name", new QFilter[]{taxFileFilter = new QFilter("boid", "=", (Object)taxFileId)})) && 1010L != taxFile.getLong("pernontsprop.nationality.id")) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u56fd\u7c4d\uff08\u5730\u533a\uff09\u662f{0}\uff0c\u4e0d\u80fd\u6e05\u7a7a\u5883\u5916\u4eba\u5458\u4fe1\u606f\u3002", (String)"TaxFileServiceHelper_21", (String)"sit-itc-business", (Object[])new Object[]{taxFile.getString("pernontsprop.nationality.name")}));
        }
        helper = new HRBaseServiceHelper(entityName);
        QFilter filter = new QFilter("taxfile.boid", "=", (Object)taxFileId);
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        BaseResult dys = helper.query("boid,id,status,taxfile.pernontsprop.nationality", new QFilter[]{filter, statusFilter});
        if (null == dys || 0 == ((DynamicObject[])dys).length) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u4fe1\u606f\u53ef\u80fd\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaxFileServiceHelper_22", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        Set<Long> pIds = Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        String status = dys[0].getString("status");
        if ("B".equals(status)) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u7684\u6570\u636e\u4e0d\u53ef\u5220\u9664\u3002", (String)"TaxFileServiceHelper_13", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        DynamicObject[] taxDataBasics = new DynamicObject[]{};
        if ("C".equals(status)) {
            BaseResult<DynamicObject[]> result = TaxFileServiceHelper.getSubInfoUsedByTask(pIds, taxFileId, entityName, displayName);
            if (!result.isSuccess()) {
                return BaseResult.fail((String)result.getMessage());
            }
            taxDataBasics = (DynamicObject[])result.getData();
        }
        try (TXHandle txHandle = TX.requiresNew();){
            if ("A".equals(status)) {
                helper.deleteByFilter(new QFilter[]{new QFilter("id", "in", pIds)});
            } else {
                for (DynamicObject entry : dys) {
                    entry.set("status", (Object)"E");
                }
                helper.save((DynamicObject[])dys);
                if (null != taxDataBasics && taxDataBasics.length > 0) {
                    helper = new HRBaseServiceHelper("itc_taxdatabasic");
                    helper.save(taxDataBasics);
                }
            }
            BaseResult baseResult = BaseResult.success(null);
            return baseResult;
        }
    }

    private static BaseResult<DynamicObject[]> getSubInfoUsedByTask(Set<Long> pIds, Long taxFileId, String entityName, String displayName) {
        QFilter filter = null;
        String propertis = null;
        switch (entityName) {
            case "itc_investor": {
                filter = new QFilter("investor", "in", pIds);
                propertis = "investor";
                break;
            }
            case "itc_overseasperson": {
                filter = new QFilter("overseasperson", "in", pIds);
                propertis = "overseasperson";
                break;
            }
            case "itc_bankcard": {
                filter = new QFilter("bankcard", "in", pIds);
                propertis = "bankcard";
                break;
            }
            case "itc_specialinfo": {
                filter = new QFilter("specialinfo", "in", pIds);
                propertis = "specialinfo";
                break;
            }
        }
        if (null == filter) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u6863\u6848\u4fe1\u606f\u53ef\u80fd\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaxFileServiceHelper_11", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxdatabasic");
        DynamicObject[] taxDataBasics = helper.query("id,srcrefnum,declarestatus," + propertis, new QFilter[]{filter, statusFilter});
        if (null == taxDataBasics || taxDataBasics.length == 0) {
            return BaseResult.success((Object)new DynamicObject[0]);
        }
        if (TaxFileServiceHelper.checkCalStatus(taxDataBasics) || TaxFileServiceHelper.checkPersonDeclare(taxDataBasics)) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"{0}\u5df2\u88ab\u4e2a\u7a0e\u4efb\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u6e05\u7a7a\u3002", (String)"TaxFileServiceHelper_15", (String)"sit-itc-business", (Object[])new Object[]{displayName}));
        }
        for (DynamicObject taxDataBasic : taxDataBasics) {
            taxDataBasic.set(propertis, (Object)0L);
        }
        return BaseResult.success((Object)taxDataBasics);
    }

    private static boolean checkCalStatus(DynamicObject[] taxDataBasics) {
        boolean result = false;
        for (DynamicObject dynamicObject : taxDataBasics) {
            if (SrcRefNumEnums.NO_REF.getCode().equals(dynamicObject.getString("srcrefnum"))) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean checkPersonDeclare(DynamicObject[] taxDataBasics) {
        boolean result = false;
        for (DynamicObject dynamicObject : taxDataBasics) {
            if (!YesOrNoEnum.YES.getCode().equals(dynamicObject.getString("declarestatus"))) continue;
            result = true;
            break;
        }
        return result;
    }

    public static Map<String, Map<String, DynamicObject>> getBaseDataMap(List<String> entities) {
        HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)entities.size());
        for (String entity : entities) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entity);
            QFilter filter = new QFilter("status", "=", (Object)"C");
            filter.and("enable", "=", (Object)"1");
            DynamicObject[] query = helper.query("id,number", new QFilter[]{filter});
            Map objectMap = baseDataMap.computeIfAbsent(entity, k1 -> Maps.newHashMapWithExpectedSize((int)query.length));
            for (DynamicObject object : query) {
                objectMap.put(object.getString("number"), object);
            }
        }
        return baseDataMap;
    }

    public static DynamicObject[] getDynamicObject(HRBaseServiceHelper serviceHelper, String selectProperties, QFilter[] filters) {
        return serviceHelper.query(selectProperties, filters);
    }

    public static DynamicObject getBaseDataById(String entity, Long pk, Map<String, Map<Long, DynamicObject>> baseDataMap) {
        Map entityMap = baseDataMap.get(entity);
        if (CollectionUtils.isEmpty(entityMap)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entity);
            QFilter filter = new QFilter("status", "=", (Object)"C");
            filter.and("enable", "=", (Object)"1");
            if (StringUtils.equals((CharSequence)"hbss_empgroup", (CharSequence)entity)) {
                filter.and("bussinessfield.id", "=", (Object)107030L);
            }
            if (StringUtils.equals((CharSequence)"hrpi_perbankcard", (CharSequence)entity)) {
                filter.and("isdelete", "=", (Object)"0");
            }
            DynamicObject[] query = helper.query("id,number", new QFilter[]{filter});
            entityMap = baseDataMap.computeIfAbsent(entity, k1 -> Maps.newHashMapWithExpectedSize((int)query.length));
            for (DynamicObject object : query) {
                entityMap.put(object.getLong("id"), object);
            }
        }
        return entityMap.get(pk);
    }

    public static DynamicObject getAreaInfo(String entity, Long pk, Map<String, Map<Long, DynamicObject>> baseDataMap) {
        Map entityMap = baseDataMap.get(entity);
        if (CollectionUtils.isEmpty(entityMap)) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entity);
            QFilter filter = new QFilter("status", "=", (Object)"C");
            filter.and("enable", "=", (Object)"1");
            DynamicObject[] query = helper.query("id,country.id,fullname,level,longnumber,masterid,name,number,parent.id", new QFilter[]{filter});
            entityMap = baseDataMap.computeIfAbsent(entity, k1 -> Maps.newHashMapWithExpectedSize((int)query.length));
            for (DynamicObject object : query) {
                entityMap.put(object.getLong("id"), object);
            }
        }
        return entityMap.get(pk);
    }

    public static Date convert(Object obj) {
        Date empDate = null;
        try {
            empDate = SITDateTimeUtils.formatDateToDate((Date)((Date)BaseDataConverter.convert((Object)obj, Date.class)), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            empDate = null;
        }
        catch (Exception e1) {
            empDate = null;
        }
        return empDate;
    }

    public static Map<String, List<DynamicObject>> getEmpposorgrelByPersonNumber(Set<String> personNumbers) {
        Object map = null;
        return TaxFileServiceHelper.getExperiences(personNumbers);
    }

    private static Map<String, List<DynamicObject>> getExperiences(Set<String> personNumber) {
        Object[] personExperiencesFromDB;
        try {
            String selectFields = "id,number,employee,person,businessstatus,islatestrecord,startdate,enddate,createtime";
            QFilter qFilter = TaxFileServiceHelper.getQFilter(personNumber);
            personExperiencesFromDB = (DynamicObject[])SITMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonSyncService", (String)"listFieldsFilterInfo", (Object[])new Object[]{selectFields, qFilter, "hrpi_empposorgrel"});
        }
        catch (KDBizException exception) {
            LOGGER.error(MessageFormat.format("axFileServiceHelper-getExperiences listFieldsFilterInfo exception:{0}", new Object[]{exception}));
            throw new KDBizException((Throwable)exception, new ErrorCode("", exception.getMessage()), new Object[0]);
        }
        if (ArrayUtils.isEmpty((Object[])personExperiencesFromDB)) {
            return new HashMap<String, List<DynamicObject>>(1);
        }
        Map<String, List<DynamicObject>> personExperiencesMap = Arrays.stream(personExperiencesFromDB).collect(Collectors.groupingBy(personExperience -> personExperience.getString("employee.empnumber")));
        return personExperiencesMap;
    }

    private static QFilter getQFilter(Set<String> personNumber) {
        QFilter defaultFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        defaultFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        defaultFilter.and(new QFilter("islatestrecord", "=", (Object)"1"));
        if (CollectionUtils.isEmpty(personNumber)) {
            defaultFilter.and(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
        } else {
            defaultFilter.and(new QFilter("empnumber", "in", personNumber));
        }
        HRBaseServiceHelper empHelper = new HRBaseServiceHelper("hrpi_employee");
        Object[] dys = empHelper.query("id,empnumber", new QFilter[]{defaultFilter});
        if (ArrayUtils.isEmpty((Object[])dys)) {
            return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
        }
        Set employeeIds = Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        QFilter empFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        empFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        empFilter.and(new QFilter("isprimary", "=", (Object)"1"));
        empFilter.and(new QFilter("employee.id", "in", employeeIds));
        return empFilter;
    }

    public static DynamicObject getLastEmpPosorgrel(List<DynamicObject> empposorgrelDys) {
        if (CollectionUtils.isEmpty(empposorgrelDys)) {
            return null;
        }
        DynamicObject resultDy = null;
        ArrayList lastDys = Lists.newArrayListWithExpectedSize((int)2);
        DynamicObject effectDy = null;
        for (DynamicObject empposorgrelDy : empposorgrelDys) {
            if ("1".equals(empposorgrelDy.getString("businessstatus"))) {
                resultDy = empposorgrelDy;
                effectDy = empposorgrelDy;
                break;
            }
            LOGGER.info("getLastEmpPosorgrel - islatestrecord: {}", (Object)empposorgrelDy.getString("islatestrecord"));
            if (empposorgrelDy.getBoolean("islatestrecord")) {
                lastDys.add(empposorgrelDy);
                continue;
            }
            if (null != resultDy && !empposorgrelDy.getDate("startdate").after(resultDy.getDate("startdate"))) continue;
            resultDy = empposorgrelDy;
        }
        if (lastDys.size() > 0 && null == effectDy) {
            LOGGER.info("getLastEmpPosorgrel - lastDys entered");
            DynamicObject lastDy = null;
            for (DynamicObject dy : lastDys) {
                if (null != lastDy && !dy.getDate("startdate").after(lastDy.getDate("startdate"))) continue;
                lastDy = dy;
            }
            resultDy = lastDy;
        }
        if (resultDy != null) {
            LOGGER.info("getLastEmpPosorgrel - resultDy is {}", (Object)resultDy.getLong("id"));
        }
        return resultDy;
    }

    public static BaseResult<MutexLockInfo> muTextLock(Long taxFileId, String entityName) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        QFilter filter = new QFilter("taxfile.boid", "=", (Object)taxFileId);
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter isCurrentVersionQFilter = new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode());
        DynamicObject dy = helper.queryOne("id", new QFilter[]{filter, statusFilter, isCurrentVersionQFilter});
        if (null == dy) {
            return BaseResult.fail((String)"data is null");
        }
        return MutexServiceHelper.getMutexLockInfo((String)entityName, (String)dy.getString("id"), (String)"modify");
    }

    public static void showMutexNotification(IFormView view, MutexLockInfo lockInfo) {
        if (null != lockInfo) {
            Map userInfo;
            String userId = lockInfo.getUserId();
            String operateKey = lockInfo.getOpKey();
            if (!SITStringUtils.isEmpty((String)userId) && SITStringUtils.equals((String)operateKey, (String)"modify") && null != (userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(userId)))) {
                String userName = (String)userInfo.get("name");
                if (!SITStringUtils.isEmpty((String)userName)) {
                    view.showTipNotification(ResManager.loadKDString((String)"{0}\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u3002", (String)"TaxFileServiceHelper_18", (String)"sit-itc-business", (Object[])new Object[]{userName}));
                } else {
                    view.showTipNotification(ResManager.loadKDString((String)"\u7f51\u7edc\u4e92\u65a5\u68c0\u6d4b\u51fa\u6709\u4eba\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u3002", (String)"TaxFileServiceHelper_19", (String)"sit-itc-business", (Object[])new Object[0]));
                }
            }
        }
    }

    public static DynamicObject[] getExperiencesByPersonId(Long personId) {
        String entityName = "hrpi_empposorgrel";
        String selectFields = "id,person,startdate,createtime,businessstatus,islatestrecord,sourcevid";
        QFilter defaultFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        QFilter personFilter = new QFilter("person", "=", (Object)personId);
        QFilter primaryFilter = new QFilter("isprimary", "=", (Object)"1");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        return serviceHelper.query(selectFields, new QFilter[]{defaultFilter, personFilter, dataStatusFilter, primaryFilter}, "startdate desc");
    }

    public static Map<String, Long> getPersonIdOrPIDsByNumber(Set<String> params) {
        Map<String, Long> map = null;
        HRBaseServiceHelper service = new HRBaseServiceHelper("hrpi_person");
        QFilter qFilter = new QFilter("number", "in", params);
        qFilter.and("iscurrentversion", "=", (Object)"1");
        Object[] dys = service.query("id,personindexid,number", new QFilter[]{qFilter});
        if (ArrayUtils.isNotEmpty((Object[])dys)) {
            map = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy.getLong("id"), (k1, k2) -> k1));
        }
        return map;
    }
}

