/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.export;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.sitbp.business.helper.excel.model.HeadCellBar;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.SheetInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;

public class WorkbookPersonDeclareExport
implements WorkbookInfoGenerator {
    protected static final Log logger = LogFactory.getLog(WorkbookPersonDeclareExport.class);

    public WorkbookInfo generate(Map<String, Object> param) {
        logger.info("\u5f00\u59cb\u751f\u6210\u4eba\u5458\u7533\u62a5\u8868workbook");
        String taxUnitName = (String)param.get("name");
        DynamicObject exportTemplate = (DynamicObject)param.get("template");
        String fileName = this.getFullFileName(taxUnitName);
        Map dynamicPropertyMap = (Map)param.get("dyn_property");
        WorkbookInfo workbookInfo = new WorkbookInfo();
        workbookInfo.setNeedTemplate(false);
        workbookInfo.setFileName(fileName);
        SheetInfo sheetInfo = new SheetInfo();
        sheetInfo.setName(ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f", (String)"WorkbookPersonDeclareExport_0", (String)"sit-itc-business", (Object[])new Object[0]));
        sheetInfo.setNeedFillHead(true);
        sheetInfo.setBodyRow(1);
        HeadCellBar headCellBar = new HeadCellBar();
        String position = exportTemplate.getString("asteriskposition");
        DynamicObjectCollection entryEntity = exportTemplate.getDynamicObjectCollection("entryentity");
        for (DynamicObject entity : entryEntity) {
            if (!entity.getBoolean("isexport")) continue;
            String fieldKey = entity.getString("fieldkey");
            boolean isMustInput = entity.getBoolean("ismustinput");
            String defaultDesc = entity.getString("exportfield");
            if (isMustInput) {
                defaultDesc = "1".equals(position) ? "*" + defaultDesc : defaultDesc + "*";
            }
            HeadCellInfo cellInfo = new HeadCellInfo(fieldKey);
            cellInfo.setDefaultDesc(defaultDesc);
            cellInfo.setRequired(isMustInput);
            cellInfo.setWidth(256 * (8 + cellInfo.getDefaultDesc().getBytes(StandardCharsets.UTF_8).length));
            if (dynamicPropertyMap != null) {
                DynamicProperty dynProperty = (DynamicProperty)dynamicPropertyMap.get(fieldKey);
                this.setStyleInfo(cellInfo, dynProperty);
            }
            headCellBar.addHeadCellInfos(new HeadCellInfo[]{cellInfo});
        }
        sheetInfo.setHeadCellBar(headCellBar);
        sheetInfo.setDataKey(taxUnitName);
        workbookInfo.setSheetInfoList(Collections.singletonList(sheetInfo));
        workbookInfo.ready();
        logger.info("\u751f\u6210\u4eba\u5458\u7533\u62a5\u8868workbook\u7ed3\u675f");
        return workbookInfo;
    }

    private void setStyleInfo(HeadCellInfo cellInfo, DynamicProperty dynProperty) {
        if (dynProperty == null) {
            return;
        }
        if (dynProperty instanceof DateTimeProp || dynProperty instanceof TimeProp) {
            cellInfo.setBaseFormat("yyyy-MM-dd");
        } else if (dynProperty instanceof DecimalProp) {
            int scale = ((DecimalProp)dynProperty).getScale();
            String styleStr = "0";
            StringBuilder sb = new StringBuilder(styleStr);
            if (scale > 0) {
                sb.append('.');
                for (int i = 0; i < scale; ++i) {
                    sb.append('0');
                }
            }
            cellInfo.setBaseFormat(sb.toString());
            cellInfo.setDataType("DOUBLE");
        }
    }

    private String getFullFileName(String taxUnitName) {
        LocalDate now = LocalDate.now();
        String date = String.format(Locale.ROOT, "%04d", now.getYear()) + String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        String fileName = ResManager.loadKDString((String)"\u4eba\u5458\u4fe1\u606f_%1$s_%2$s", (String)"WorkbookPersonDeclareExport_1", (String)"sit-itc-business", (Object[])new Object[]{taxUnitName, date});
        return fileName;
    }
}

