/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.export;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.service.KDDateUtils;
import kd.sit.itc.business.taxfile.exportDTO.TaxReportExportDTO;
import kd.sit.sitbp.business.helper.excel.model.HeadCellBar;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.SheetInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;

public class WorkbookTaxReportExport
implements WorkbookInfoGenerator {
    public WorkbookInfo generate(Map<String, Object> param) {
        String taxUnitName = (String)param.get("name");
        DynamicObject exportTemplate = (DynamicObject)param.get("template");
        TaxReportExportDTO taxReportExportDTO = (TaxReportExportDTO)param.get("DTO");
        Map nameMap = (Map)param.get("nameMap");
        String fileName = this.getFullFileName(taxUnitName, nameMap);
        WorkbookInfo workbookInfo = new WorkbookInfo();
        workbookInfo.setNeedTemplate(false);
        workbookInfo.setFileName(fileName);
        SheetInfo sheetInfo = new SheetInfo();
        sheetInfo.setName(ResManager.loadKDString((String)"\u4e2a\u7a0e\u7533\u62a5\u8868", (String)"WorkbookTaxReportExport_0", (String)"sit-itc-business", (Object[])new Object[0]));
        sheetInfo.setNeedFillHead(true);
        sheetInfo.setBodyRow(1);
        HeadCellBar headCellBar = new HeadCellBar();
        String position = exportTemplate.getString("asteriskposition");
        DynamicObjectCollection entryEntity = exportTemplate.getDynamicObjectCollection("entryentity");
        for (DynamicObject entity : entryEntity) {
            if (!entity.getBoolean("isexport")) continue;
            String fieldKey = entity.getString("fieldkey");
            boolean isMustInput = entity.getBoolean("ismustinput");
            String defaultDesc = entity.getString("exportfield");
            if (isMustInput) {
                defaultDesc = "1".equals(position) ? "*" + defaultDesc : defaultDesc + "*";
            }
            if (fieldKey.equals("")) {
                fieldKey = entity.getString("taxitem.id");
            }
            HeadCellInfo cellInfo = new HeadCellInfo(fieldKey);
            cellInfo.setDefaultDesc(defaultDesc);
            cellInfo.setRequired(isMustInput);
            cellInfo.setWidth(256 * (8 + cellInfo.getDefaultDesc().getBytes(StandardCharsets.UTF_8).length));
            if (taxReportExportDTO.getDynamicPropertyMap() != null) {
                DynamicProperty dynProperty = taxReportExportDTO.getDynamicPropertyMap().get(fieldKey);
                this.setStyleInfo(cellInfo, dynProperty);
            }
            headCellBar.addHeadCellInfos(new HeadCellInfo[]{cellInfo});
        }
        sheetInfo.setHeadCellBar(headCellBar);
        sheetInfo.setDataKey(taxUnitName);
        workbookInfo.setSheetInfoList(Collections.singletonList(sheetInfo));
        workbookInfo.ready();
        return workbookInfo;
    }

    private void setStyleInfo(HeadCellInfo cellInfo, DynamicProperty dynProperty) {
        if (dynProperty == null) {
            return;
        }
        if (dynProperty instanceof DateTimeProp || dynProperty instanceof TimeProp) {
            cellInfo.setBaseFormat("yyyy-MM-dd");
        } else if (dynProperty instanceof DecimalProp) {
            int scale = ((DecimalProp)dynProperty).getScale();
            String styleStr = "0";
            StringBuilder sb = new StringBuilder(styleStr);
            if (scale > 0) {
                sb.append('.');
                for (int i = 0; i < scale; ++i) {
                    sb.append('0');
                }
            }
            cellInfo.setBaseFormat(sb.toString());
            cellInfo.setDataType("DOUBLE");
        }
    }

    private String getFullFileName(String taxUnitName, Map<String, Object> nameMap) {
        Date taxStartDate = (Date)nameMap.get("taxstartdate");
        Date taxEndDate = (Date)nameMap.get("taxenddate");
        String taxcategoryName = (String)nameMap.get("taxcategoryname");
        LocalDate taxStartDate1 = taxStartDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
        LocalDate taxEndDate1 = taxEndDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
        String taxStartDate2 = String.format(Locale.ROOT, "%04d", taxStartDate1.getYear()) + String.format(Locale.ROOT, "%02d", taxStartDate1.getMonthValue()) + String.format(Locale.ROOT, "%02d", taxStartDate1.getDayOfMonth());
        String taxEndDate2 = String.format(Locale.ROOT, "%04d", taxEndDate1.getYear()) + String.format(Locale.ROOT, "%02d", taxEndDate1.getMonthValue()) + String.format(Locale.ROOT, "%02d", taxEndDate1.getDayOfMonth());
        String fileName = String.format("%s_%s_%s-%s", taxcategoryName, taxUnitName, taxStartDate2, taxEndDate2);
        return fileName;
    }
}

