/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.gather;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.api.TaxFileInfoGather;
import kd.sit.sitbp.common.api.TaxFileInfoService;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public abstract class AbstractInfoGather<K, T>
implements TaxFileInfoGather {
    private static final Log LOGGER = LogFactory.getLog(AbstractInfoGather.class);
    protected static final Map<String, String> QUERY_PROPS = new HashMap<String, String>(16);
    private static final List<TaxFileInfoGather> GATHER_LIST = new ArrayList<TaxFileInfoGather>(16);

    @Override
    public int priority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public BatchResult<DynamicObject> gather(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext) {
        String outerInfoStr = taxFileOpContext.getOptionPara("outerInfo");
        Map outerInfos = Maps.newHashMapWithExpectedSize((int)8);
        if (!StringUtils.isEmpty((CharSequence)outerInfoStr)) {
            outerInfos = (Map)SerializationUtils.fromJsonString((String)outerInfoStr, Map.class);
        }
        Map<Long, DynamicObject> localInfoMap = this.findOrCreateLocalInfo(taxFiles, taxFileOpContext, outerInfos);
        Map<K, T> extraInfoMap = this.extraInfos(taxFiles, taxFileOpContext, outerInfos);
        BatchResult batchResult = new BatchResult(true, new ArrayList(taxFiles.size()));
        for (DynamicObject taxFile : taxFiles) {
            DynamicObject localInfo = localInfoMap.get(taxFile.getLong("id"));
            Map outerInfo = MapUtils.getMap((Map)outerInfos, (Object)this.bizKey(taxFile));
            T extraInfo = extraInfoMap.get(this.extraKeyFromTaxFile(taxFile, outerInfo));
            batchResult.addBaseResult(this.setValue(taxFile, localInfo, extraInfo, outerInfo));
        }
        return batchResult;
    }

    protected String bizKey(DynamicObject obj) {
        return String.format("%s_%s_%s", obj.getString("person.id"), obj.getString("taxregion.id"), obj.getString("taxunit.id"));
    }

    protected Map<Long, DynamicObject> findOrCreateLocalInfo(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext, Map<String, Object> outerInfos) {
        if (CollectionUtils.isEmpty(taxFiles)) {
            return Maps.newHashMap();
        }
        String extraKey = this.extraInfoEntity();
        LOGGER.info("by cyh findOrCreateLocalInfo :extraKey = {}", (Object)extraKey);
        Map<Long, DynamicObject> extraInfo = taxFileOpContext.getInfo(extraKey);
        if (extraInfo != null) {
            LOGGER.info("by cyh findOrCreateLocalInfo : {},  size = {}", (Object)extraKey, (Object)extraInfo.size());
            return extraInfo;
        }
        extraInfo = this.queryLocalInfo(taxFiles, extraKey, outerInfos);
        taxFileOpContext.addExtraInfo(extraKey, extraInfo);
        LOGGER.info("by cyh findOrCreateLocalInfo : {}, size = {}", (Object)extraKey, (Object)extraInfo.size());
        return extraInfo;
    }

    protected Map<Long, DynamicObject> queryLocalInfo(List<DynamicObject> taxFiles, String extraKey, Map<String, Object> outerInfos) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(extraKey);
        Object[] taxFileIds = (Long[])taxFiles.stream().map(dy -> dy.getLong("boid")).filter(dy -> dy != 0L).toArray(Long[]::new);
        Map<Long, DynamicObject> taxfileMap = taxFiles.stream().collect(Collectors.toMap(taxFileInfo -> taxFileInfo.getLong("id"), taxFileInfo -> taxFileInfo));
        DynamicObjectType dynamicObjectType = null;
        HashMap<Long, DynamicObject> extraInfo = new HashMap<Long, DynamicObject>(taxFiles.size());
        TaxFileInfoService infoService = TaxFileInfoServiceFactory.byEntityNumber((String)extraKey);
        if (!ArrayUtils.isEmpty((Object[])taxFileIds) && infoService != null) {
            QFilter filter = new QFilter("taxfile.id", "in", (Object)taxFileIds);
            filter.and("iscurrentversion", "=", (Object)"1");
            filter.and("status", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "C"}));
            DynamicObject[] query = serviceHelper.loadDynamicObjectArray(extraKey, new QFilter[]{filter});
            if (query != null && query.length != 0) {
                for (DynamicObject obj : query) {
                    if (!this.whetherSetInfoToExtraInfo(taxfileMap.get(obj.getLong("taxfile.id")), outerInfos)) continue;
                    extraInfo.put(obj.getLong("taxfile.id"), obj);
                }
                dynamicObjectType = query[0].getDynamicObjectType();
            }
        }
        if (taxFiles.size() != extraInfo.size()) {
            ORM orm = ORM.create();
            long[] pkIds = orm.genLongIds(extraKey, taxFiles.size() - extraInfo.size());
            AtomicInteger index = new AtomicInteger(0);
            for (DynamicObject taxFile : taxFiles) {
                long fileId;
                if (!this.whetherSetInfoToExtraInfo(taxFile, outerInfos) || extraInfo.containsKey(fileId = taxFile.getLong("id"))) continue;
                DynamicObject object = dynamicObjectType != null ? (DynamicObject)dynamicObjectType.createInstance() : serviceHelper.generateEmptyDynamicObject();
                DynamicObject taxFileEmpty = serviceHelper.generateEmptyDynamicObject("itc_taxfile");
                taxFileEmpty.set("id", (Object)taxFile.getLong("id"));
                taxFileEmpty.set("bsed", taxFile.get("bsed"));
                LOGGER.info("by cyh queryLocalInfo taxFile.id = {} , extraKey = {}", (Object)taxFile.getLong("id"), (Object)extraKey);
                long pkId = pkIds[index.getAndIncrement()];
                object.set("id", (Object)pkId);
                object.set("taxfile", (Object)taxFileEmpty);
                LOGGER.info("by cyh queryLocalInfo object.taxFile.id = {}, extraKey = {}", (Object)object.getLong("taxfile.id"), (Object)extraKey);
                extraInfo.put(fileId, object);
            }
        }
        return extraInfo;
    }

    protected boolean whetherSetInfoToExtraInfo(DynamicObject taxFile, Map<String, Object> outerInfos) {
        return true;
    }

    protected abstract Map<K, T> extraInfos(List<DynamicObject> var1, TaxFileOpContext var2, Map<String, Object> var3);

    protected abstract Object extraKeyFromTaxFile(DynamicObject var1, Map<String, Object> var2);

    protected abstract BaseResult<DynamicObject> setValue(DynamicObject var1, DynamicObject var2, T var3, Map<String, Object> var4);

    public static BatchResult<DynamicObject> gatherExtraInfo(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext) {
        BatchResult batchResult = new BatchResult(true, taxFiles);
        for (TaxFileInfoGather gather : GATHER_LIST) {
            List successResult = batchResult.getSuccessResult();
            if (CollectionUtils.isEmpty((Collection)successResult)) {
                return batchResult;
            }
            BatchResult<DynamicObject> result = gather.gather(successResult, taxFileOpContext);
            if (!result.isSuccess()) {
                return result;
            }
            List failResultOriginal = result.getFailResultOriginal();
            if (CollectionUtils.isEmpty((Collection)failResultOriginal)) continue;
            failResultOriginal.forEach(obj -> batchResult.successItemToFail(obj.getData(), obj.getMessage()));
        }
        return batchResult;
    }

    static {
        ServiceLoader<TaxFileInfoGather> serviceLoader = ServiceLoader.load(TaxFileInfoGather.class);
        Iterator<TaxFileInfoGather> iterator = serviceLoader.iterator();
        HashMap<String, Set> propsSet = new HashMap<String, Set>(16);
        while (iterator.hasNext()) {
            TaxFileInfoGather next = iterator.next();
            GATHER_LIST.add(next);
            String entity = next.extraInfoEntity();
            Set<String> props = next.extraInfoProps();
            Set query = propsSet.computeIfAbsent(entity, k1 -> Sets.newHashSet((Object[])new String[]{"taxfile.id"}));
            query.addAll(props);
        }
        for (Map.Entry entry : propsSet.entrySet()) {
            QUERY_PROPS.put((String)entry.getKey(), StringUtils.join((Object[])((Set)entry.getValue()).toArray(), (String)","));
        }
        GATHER_LIST.sort(Comparator.comparingInt(TaxFileInfoGather::priority));
    }
}

