/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.gather;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.impl.gather.AbstractInfoGather;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class BankcardGather
extends AbstractInfoGather<Long, DynamicObject> {
    private static final Log LOGGER = LogFactory.getLog(BankcardGather.class);

    @Override
    protected boolean whetherSetInfoToExtraInfo(DynamicObject taxFile, Map<String, Object> outerInfos) {
        if (CollectionUtils.isEmpty(outerInfos)) {
            return false;
        }
        Map info = MapUtils.getMap(outerInfos, (Object)this.bizKey(taxFile));
        if (CollectionUtils.isEmpty((Map)info)) {
            return false;
        }
        Map subInfo = MapUtils.getMap((Map)info, (Object)"bankcard");
        return !CollectionUtils.isEmpty((Map)subInfo);
    }

    @Override
    protected Map<Long, DynamicObject> extraInfos(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext, Map<String, Object> outerInfos) {
        DynamicObject[] query;
        HashMap extraInfoMap = Maps.newHashMapWithExpectedSize((int)outerInfos.size());
        if (CollectionUtils.isEmpty(outerInfos)) {
            return extraInfoMap;
        }
        ArrayList perbankcardIds = Lists.newArrayListWithExpectedSize((int)8);
        outerInfos.forEach((key, val) -> {
            Object perbankcardId;
            Map outerInfo = val == null ? null : (Map)val;
            Object object = perbankcardId = CollectionUtils.isEmpty((Map)MapUtils.getMap((Map)outerInfo, (Object)"bankcard")) ? null : this.extraKeyFromTaxFile(null, outerInfo);
            if (!Objects.isNull(perbankcardId)) {
                perbankcardIds.add(perbankcardId);
            }
        });
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_perbankcard");
        for (DynamicObject obj : query = helper.query("id,person.number,boid,person.id,username", new QFilter[]{new QFilter("id", "in", (Object)perbankcardIds)})) {
            extraInfoMap.put(obj.getLong("id"), obj);
        }
        return extraInfoMap;
    }

    @Override
    protected Object extraKeyFromTaxFile(DynamicObject taxFile, Map<String, Object> outerInfo) {
        if (CollectionUtils.isEmpty(outerInfo)) {
            return taxFile.getLong("id");
        }
        Map bankcard = MapUtils.getMap(outerInfo, (Object)"bankcard");
        if (CollectionUtils.isEmpty((Map)bankcard)) {
            return taxFile.getLong("id");
        }
        return MapUtils.getLong((Map)bankcard, (Object)"perbankcard");
    }

    @Override
    protected BaseResult<DynamicObject> setValue(DynamicObject taxFile, DynamicObject localValue, DynamicObject extraValue, Map<String, Object> outerInfo) {
        if (!Objects.isNull(localValue) && !Objects.isNull(extraValue)) {
            String status;
            localValue.set("perbankcard", (Object)extraValue);
            DynamicObject taxFileEmpty = (DynamicObject)localValue.get("taxfile");
            if (!Objects.isNull(taxFileEmpty)) {
                taxFileEmpty.set("person", taxFile.get("person"));
            }
            if (StringUtils.isNotEmpty((CharSequence)(status = taxFile.getString("status"))) && StringUtils.equals((CharSequence)status, (CharSequence)"C")) {
                localValue.set("status", (Object)status);
            } else {
                localValue.set("status", (Object)"A");
            }
        }
        return BaseResult.success((Object)taxFile);
    }

    @Override
    public String extraInfoEntity() {
        return "itc_bankcard";
    }

    @Override
    public Set<String> extraInfoProps() {
        return Sets.newHashSet();
    }
}

