/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.gather;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.business.taxfile.impl.gather.AbstractInfoGather;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import org.apache.commons.collections4.CollectionUtils;

public class EmpPosOrgRelGather
extends AbstractInfoGather<Object, DynamicObject> {
    @Override
    public int priority() {
        return 10;
    }

    @Override
    public String extraInfoEntity() {
        return "itc_taxfile";
    }

    @Override
    public Set<String> extraInfoProps() {
        return Sets.newHashSet((Object[])new String[]{"employment"});
    }

    @Override
    protected Map<Long, DynamicObject> findOrCreateLocalInfo(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext, Map<String, Object> outerInfos) {
        if (CollectionUtils.isEmpty(taxFiles)) {
            return null;
        }
        String extraKey = this.extraInfoEntity();
        HashMap info = taxFileOpContext.getInfo(extraKey);
        if (info == null) {
            info = new HashMap(0);
        }
        return info;
    }

    @Override
    protected Map<Object, DynamicObject> extraInfos(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext, Map<String, Object> outerInfos) {
        HashMap extraInfoMap = Maps.newHashMapWithExpectedSize((int)taxFiles.size());
        List personIds = taxFiles.stream().map(obj -> (Long)this.extraKeyFromTaxFile((DynamicObject)obj, null)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(personIds)) {
            return extraInfoMap;
        }
        QFilter empFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        empFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        empFilter.and(new QFilter("islatestrecord", "=", (Object)"1"));
        empFilter.and(new QFilter("person.id", "in", personIds));
        HRBaseServiceHelper empHelper = new HRBaseServiceHelper("hrpi_employee");
        Object[] dys = empHelper.query("id", new QFilter[]{empFilter});
        if (ArrayUtils.isEmpty((Object[])dys)) {
            return extraInfoMap;
        }
        Set employeeIds = Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        String entityName = "hrpi_empposorgrel";
        String selectFields = "id,person,startdate,createtime,businessstatus,islatestrecord,sourcevid";
        QFilter defaultFilter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        defaultFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        QFilter personFilter = new QFilter("person", "in", personIds);
        personFilter.and(new QFilter("isprimary", "=", (Object)"1"));
        personFilter.and(new QFilter("employee.id", "in", employeeIds));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        DynamicObject[] query = serviceHelper.query(selectFields, new QFilter[]{defaultFilter, personFilter}, "startdate desc");
        if (query != null && query.length > 0) {
            Map<Long, List<DynamicObject>> personExperiencesMap = Arrays.stream(query).collect(Collectors.groupingBy(personExperience -> personExperience.getLong("person.id")));
            for (Map.Entry<Long, List<DynamicObject>> entry : personExperiencesMap.entrySet()) {
                DynamicObject empposorgrelDy = TaxFileServiceHelper.getLastEmpPosorgrel(entry.getValue());
                extraInfoMap.put(entry.getKey(), empposorgrelDy);
            }
        }
        return extraInfoMap;
    }

    @Override
    protected Object extraKeyFromTaxFile(DynamicObject taxFile, Map<String, Object> outerInfo) {
        Object person = taxFile.get("person");
        if (person instanceof DynamicObject) {
            return ((DynamicObject)person).get("id");
        }
        return person;
    }

    @Override
    protected BaseResult<DynamicObject> setValue(DynamicObject taxFile, DynamicObject localValue, DynamicObject extraValue, Map<String, Object> outerInfo) {
        if (localValue == null || extraValue == null || !StringUtils.equals((CharSequence)taxFile.getString("taxstatus"), (CharSequence)"1")) {
            return BaseResult.success((Object)taxFile);
        }
        localValue.set("employment", (Object)extraValue);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_empposorgrel");
        DynamicObject empPosorgRel = serviceHelper.generateEmptyDynamicObject();
        empPosorgRel.set("id", (Object)extraValue.getLong("sourcevid"));
        localValue.set("empposorgrel", (Object)empPosorgRel);
        return BaseResult.success((Object)taxFile);
    }
}

