/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.gather;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.taxfile.TaxFileServiceHelper;
import kd.sit.itc.business.taxfile.impl.gather.AbstractInfoGather;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class EmploymentGather
extends AbstractInfoGather<Object, Map<String, Object>> {
    @Override
    public int priority() {
        return 10;
    }

    @Override
    protected Map<Long, DynamicObject> findOrCreateLocalInfo(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext, Map<String, Object> outerInfos) {
        List<DynamicObject> taxFiles4Emp = taxFiles.stream().filter(taxFile -> {
            DataEntityPropertyCollection properties = taxFile.getDataEntityType().getProperties();
            return properties.containsKey((Object)"taxpayertypetmp") && properties.containsKey((Object)"emptypetmp") && properties.containsKey((Object)"empdatetmp") && properties.containsKey((Object)"empsituationtmp") && (taxFile.get("taxpayertypetmp") != null || taxFile.get("emptypetmp") != null || taxFile.get("empdatetmp") != null || taxFile.get("empsituationtmp") != null);
        }).collect(Collectors.toList());
        return super.findOrCreateLocalInfo(taxFiles4Emp, taxFileOpContext, outerInfos);
    }

    @Override
    public String extraInfoEntity() {
        return "itc_employment";
    }

    @Override
    public Set<String> extraInfoProps() {
        return Sets.newHashSet((Object[])new String[]{"taxpayertype", "emptype", "empdate", "empsituation", "isdeductexps"});
    }

    @Override
    protected Map<Object, Map<String, Object>> extraInfos(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext, Map<String, Object> outerInfos) {
        return Maps.newHashMap();
    }

    @Override
    protected Object extraKeyFromTaxFile(DynamicObject taxFile, Map<String, Object> outerInfo) {
        return taxFile.getLong("id");
    }

    @Override
    protected BaseResult<DynamicObject> setValue(DynamicObject taxFile, DynamicObject localValue, Map<String, Object> extraValue, Map<String, Object> outerInfo) {
        String status;
        Map employment = MapUtils.getMap(outerInfo, (Object)"employment");
        if (localValue == null || taxFile == null || !StringUtils.equals((CharSequence)taxFile.getString("taxstatus"), (CharSequence)"1") && CollectionUtils.isEmpty((Map)employment)) {
            return BaseResult.success((Object)taxFile);
        }
        if (localValue.get("taxpayertype") == null) {
            localValue.set("taxpayertype", taxFile.get("taxpayertypetmp"));
        }
        if (localValue.get("emptype") == null) {
            localValue.set("emptype", taxFile.get("emptypetmp"));
        }
        if (localValue.get("empdate") == null) {
            localValue.set("empdate", taxFile.get("empdatetmp"));
        }
        if (localValue.get("empsituation") == null) {
            localValue.set("empsituation", taxFile.get("empsituationtmp"));
        }
        if (localValue.get("isdeductexps") == null || !localValue.get("isdeductexps").equals(taxFile.get("isdeductexpstmp"))) {
            localValue.set("isdeductexps", taxFile.get("isdeductexpstmp"));
        }
        if (localValue.get("bsed") == null) {
            localValue.set("bsed", taxFile.get("bsed"));
        }
        if (!Objects.isNull(taxFile.get("bsed")) && !CollectionUtils.isEmpty((Map)employment)) {
            if (taxFile.get("taxpayertypetmp") != null) {
                localValue.set("taxpayertype", taxFile.get("taxpayertypetmp"));
            }
            if (taxFile.get("emptypetmp") != null) {
                localValue.set("emptype", taxFile.get("emptypetmp"));
            }
            if (taxFile.get("empdatetmp") != null) {
                localValue.set("empdate", (Object)TaxFileServiceHelper.convert(taxFile.get("empdatetmp")));
            }
            if (taxFile.get("empsituationtmp") != null) {
                localValue.set("empsituation", taxFile.get("empsituationtmp"));
            }
            if (taxFile.get("isdeductexpstmp") != null) {
                localValue.set("isdeductexps", taxFile.get("isdeductexpstmp"));
            }
            localValue.set("bsed", taxFile.get("bsed"));
            localValue.set("quitdate", BaseDataConverter.convert((Object)MapUtils.getObject((Map)employment, (Object)"quitdate"), Date.class));
        }
        if (StringUtils.isNotEmpty((CharSequence)(status = taxFile.getString("status"))) && StringUtils.equals((CharSequence)status, (CharSequence)"C")) {
            localValue.set("status", (Object)status);
        }
        return BaseResult.success((Object)taxFile);
    }
}

