/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.gather;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.taxfile.impl.gather.AbstractInfoGather;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITMServiceUtils;

public class IitPersonGather
extends AbstractInfoGather<Long, DynamicObject> {
    private static final Log LOGGER = LogFactory.getLog(IitPersonGather.class);

    @Override
    public int priority() {
        return 20;
    }

    @Override
    public String extraInfoEntity() {
        return "itc_taxcontact";
    }

    @Override
    public Set<String> extraInfoProps() {
        return Sets.newHashSet((Object[])new String[]{"taxpayernum"});
    }

    @Override
    protected Map<Long, DynamicObject> extraInfos(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext, Map<String, Object> outerInfos) {
        String entityName = "iit_person";
        Map taxPersonToFileMap = taxFileOpContext.getInfo(entityName);
        if (CollectionUtils.isEmpty((Map)taxPersonToFileMap)) {
            taxPersonToFileMap = Maps.newHashMapWithExpectedSize((int)taxFiles.size());
            ArrayList personIds = Lists.newArrayListWithCapacity((int)taxFiles.size());
            taxFiles.forEach(obj -> personIds.add(obj.getLong("person.id")));
            List personList = (List)SITMServiceUtils.invokeSITService((String)"iit", (String)"IitPersonService", (String)"findByIdList", (Object[])new Object[]{personIds, null});
            HashMap taxPersonMap = Maps.newHashMapWithExpectedSize((int)personList.size());
            personList.forEach(obj -> taxPersonMap.put(obj.getLong("id"), obj));
            for (DynamicObject taxFile : taxFiles) {
                long personId = taxFile.getLong("person.id");
                DynamicObject dynamicObject = (DynamicObject)taxPersonMap.get(personId);
                if (dynamicObject == null) continue;
                taxPersonToFileMap.put(taxFile.getLong("id"), dynamicObject);
            }
            taxFileOpContext.addExtraInfo(entityName, taxPersonToFileMap);
        }
        LOGGER.info("by cyh extraInfos : entityName {}, size = {}", (Object)entityName, (Object)taxPersonToFileMap.size());
        return taxPersonToFileMap;
    }

    @Override
    protected Object extraKeyFromTaxFile(DynamicObject taxFile, Map<String, Object> outerInfo) {
        return taxFile.getLong("id");
    }

    @Override
    protected BaseResult<DynamicObject> setValue(DynamicObject taxFile, DynamicObject localInfo, DynamicObject extraValue, Map<String, Object> outerInfo) {
        if (localInfo == null || extraValue == null || !StringUtils.equals((CharSequence)taxFile.getString("taxstatus"), (CharSequence)"1")) {
            return BaseResult.success((Object)taxFile);
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)localInfo.getString("taxpayernum"))) {
            localInfo.set("taxpayernum", extraValue.get("credentialsnum"));
        }
        return BaseResult.success((Object)taxFile);
    }
}

