/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.gather;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.itc.business.taxfile.impl.gather.AbstractInfoGather;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class InvestorGather
extends AbstractInfoGather<Object, Map<String, Object>> {
    private static final Log LOGGER = LogFactory.getLog(AbstractInfoGather.class);

    @Override
    protected boolean whetherSetInfoToExtraInfo(DynamicObject taxFile, Map<String, Object> outerInfos) {
        if (CollectionUtils.isEmpty(outerInfos)) {
            return false;
        }
        Map info = MapUtils.getMap(outerInfos, (Object)this.bizKey(taxFile));
        if (CollectionUtils.isEmpty((Map)info)) {
            return false;
        }
        Map subInfo = MapUtils.getMap((Map)info, (Object)"investor");
        return !CollectionUtils.isEmpty((Map)subInfo);
    }

    @Override
    protected Map<Object, Map<String, Object>> extraInfos(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext, Map<String, Object> outerInfos) {
        return Maps.newHashMap();
    }

    @Override
    protected Object extraKeyFromTaxFile(DynamicObject taxFile, Map<String, Object> outerInfo) {
        return taxFile.getLong("id");
    }

    @Override
    protected BaseResult<DynamicObject> setValue(DynamicObject taxFile, DynamicObject localValue, Map<String, Object> extraValue, Map<String, Object> outerInfo) {
        Map investor = MapUtils.getMap(outerInfo, (Object)"investor");
        if (!Objects.isNull(localValue) && !CollectionUtils.isEmpty((Map)investor)) {
            String status;
            String description;
            Long duty;
            Object investratio;
            Object investtotal = MapUtils.getObject((Map)MapUtils.getMap(outerInfo, (Object)"investor"), (Object)"investtotal");
            if (!Objects.isNull(investtotal)) {
                localValue.set("investtotal", investtotal);
            }
            if (!Objects.isNull(investratio = MapUtils.getObject((Map)MapUtils.getMap(outerInfo, (Object)"investor"), (Object)"investratio"))) {
                localValue.set("investratio", investratio);
            }
            if (!Objects.isNull(duty = MapUtils.getLong((Map)MapUtils.getMap(outerInfo, (Object)"investor"), (Object)"duty"))) {
                localValue.set("duty", SitCommonServiceHelper.setDynamicObj(localValue, investor, "duty", "itc_duty"));
            }
            if (!kd.bos.orm.util.StringUtils.isEmpty((Object)(description = MapUtils.getString((Map)MapUtils.getMap(outerInfo, (Object)"investor"), (Object)"description")))) {
                localValue.set("description", (Object)description);
            }
            if (!kd.bos.orm.util.StringUtils.isEmpty((Object)(status = taxFile.getString("status"))) && StringUtils.equals((CharSequence)status, (CharSequence)"C")) {
                localValue.set("status", (Object)status);
            } else {
                localValue.set("status", (Object)"A");
            }
        }
        return BaseResult.success((Object)taxFile);
    }

    @Override
    public String extraInfoEntity() {
        return "itc_investor";
    }

    @Override
    public Set<String> extraInfoProps() {
        return Sets.newHashSet();
    }
}

