/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.gather;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.itc.business.taxfile.impl.gather.AbstractInfoGather;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class OverseaspersonGather
extends AbstractInfoGather<Object, Map<String, Object>> {
    private static final Log LOGGER = LogFactory.getLog(OverseaspersonGather.class);

    @Override
    protected boolean whetherSetInfoToExtraInfo(DynamicObject taxFile, Map<String, Object> outerInfos) {
        if (CollectionUtils.isEmpty(outerInfos)) {
            return false;
        }
        Map info = MapUtils.getMap(outerInfos, (Object)this.bizKey(taxFile));
        if (CollectionUtils.isEmpty((Map)info)) {
            return false;
        }
        Map subInfo = MapUtils.getMap((Map)info, (Object)"overseasperson");
        return !CollectionUtils.isEmpty((Map)subInfo);
    }

    @Override
    protected Map<Object, Map<String, Object>> extraInfos(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext, Map<String, Object> outerInfos) {
        return Maps.newHashMap();
    }

    @Override
    protected Object extraKeyFromTaxFile(DynamicObject taxFile, Map<String, Object> outerInfo) {
        return taxFile.getLong("id");
    }

    @Override
    protected BaseResult<DynamicObject> setValue(DynamicObject taxFile, DynamicObject localValue, Map<String, Object> extraValue, Map<String, Object> outerInfo) {
        Map overseasperson = MapUtils.getMap(outerInfo, (Object)"overseasperson");
        String chinesename = MapUtils.getString((Map)overseasperson, (Object)"chinesename");
        if (StringUtils.isNotEmpty((CharSequence)chinesename)) {
            localValue.set("chinesename", (Object)chinesename);
        }
        if (!Objects.isNull(localValue) && !CollectionUtils.isEmpty((Map)overseasperson)) {
            String status;
            Object bsed;
            String addressinfo;
            Object addresscounty;
            Object addresscity;
            Object address;
            Object departdate;
            Object firstentrydate;
            Long birthplace;
            String otheridnumber;
            Long taxreason = MapUtils.getLong((Map)overseasperson, (Object)"taxreason");
            if (!Objects.isNull(taxreason)) {
                localValue.set("taxreason", SitCommonServiceHelper.setDynamicObj(localValue, overseasperson, "taxreason", "itc_taxreason"));
            }
            Long otheridtype = MapUtils.getLong((Map)overseasperson, (Object)"otheridtype");
            if (!Objects.isNull(taxreason)) {
                localValue.set("otheridtype", SitCommonServiceHelper.setDynamicObj(localValue, overseasperson, "otheridtype", "sitbs_taxcrdltype"));
            }
            if (StringUtils.isNotEmpty((CharSequence)(otheridnumber = MapUtils.getString((Map)overseasperson, (Object)"otheridnumber")))) {
                localValue.set("otheridnumber", (Object)otheridnumber);
            }
            if (!Objects.isNull(birthplace = MapUtils.getLong((Map)overseasperson, (Object)"birthplace"))) {
                localValue.set("birthplace", SitCommonServiceHelper.setDynamicObj(localValue, overseasperson, "birthplace", "hbss_nationality"));
            }
            if (!Objects.isNull(firstentrydate = MapUtils.getObject((Map)overseasperson, (Object)"firstentrydate"))) {
                localValue.set("firstentrydate", BaseDataConverter.convert((Object)firstentrydate, Date.class));
            }
            if (!Objects.isNull(departdate = MapUtils.getObject((Map)overseasperson, (Object)"departdate"))) {
                localValue.set("departdate", BaseDataConverter.convert((Object)departdate, Date.class));
            }
            if (!Objects.isNull(address = MapUtils.getObject((Map)overseasperson, (Object)"address"))) {
                localValue.set("address", SitCommonServiceHelper.setDynamicObj(localValue, overseasperson, "address", "bd_admindivision"));
            }
            if (!Objects.isNull(addresscity = MapUtils.getObject((Map)overseasperson, (Object)"addresscity"))) {
                localValue.set("addresscity", SitCommonServiceHelper.setDynamicObj(localValue, overseasperson, "addresscity", "bd_admindivision"));
            }
            if (!Objects.isNull(addresscounty = MapUtils.getObject((Map)overseasperson, (Object)"addresscounty"))) {
                localValue.set("addresscounty", SitCommonServiceHelper.setDynamicObj(localValue, overseasperson, "addresscounty", "bd_admindivision"));
            }
            if (StringUtils.isNotEmpty((CharSequence)(addressinfo = MapUtils.getString((Map)overseasperson, (Object)"addressinfo")))) {
                localValue.set("addressinfo", (Object)addressinfo);
            }
            if (!Objects.isNull(bsed = taxFile.get("bsed"))) {
                localValue.set("bsed", bsed);
            }
            if (StringUtils.isNotEmpty((CharSequence)(status = taxFile.getString("status"))) && StringUtils.equals((CharSequence)status, (CharSequence)"C")) {
                localValue.set("status", (Object)status);
            } else {
                localValue.set("status", (Object)"A");
            }
        }
        return BaseResult.success((Object)taxFile);
    }

    @Override
    public String extraInfoEntity() {
        return "itc_overseasperson";
    }

    @Override
    public Set<String> extraInfoProps() {
        return Sets.newHashSet();
    }
}

