/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.gather;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.itc.business.taxfile.impl.gather.AbstractInfoGather;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.SITFormatUtils;
import kd.sit.sitbp.common.util.SITMServiceUtils;
import org.apache.commons.collections.MapUtils;

public class PerContactGather
extends AbstractInfoGather<Object, Map<String, Object>> {
    @Override
    public int priority() {
        return 10;
    }

    @Override
    public String extraInfoEntity() {
        return "itc_taxcontact";
    }

    @Override
    public Set<String> extraInfoProps() {
        return Sets.newHashSet((Object[])new String[]{"phone", "email"});
    }

    @Override
    protected Map<Object, Map<String, Object>> extraInfos(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext, Map<String, Object> outerInfos) {
        HashMap extraInfoMap = Maps.newHashMapWithExpectedSize((int)taxFiles.size());
        List personIds = taxFiles.stream().map(obj -> (Long)this.extraKeyFromTaxFile((DynamicObject)obj, null)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(personIds)) {
            return extraInfoMap;
        }
        String attachEntityName = "hrpi_percontact";
        String selectFields = "person,phone,peremail";
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE);
        filter.and(new QFilter("datastatus", "=", (Object)"1"));
        List query = (List)SITMServiceUtils.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listBatchPropPersonAttachs", (Object[])new Object[]{personIds, selectFields, filter, attachEntityName});
        query.forEach(obj -> extraInfoMap.put(obj.get("person"), obj));
        return extraInfoMap;
    }

    @Override
    protected Object extraKeyFromTaxFile(DynamicObject taxFile, Map<String, Object> outerInfo) {
        Object person = taxFile.get("person");
        if (person instanceof DynamicObject) {
            return ((DynamicObject)person).get("id");
        }
        return person;
    }

    @Override
    protected BaseResult<DynamicObject> setValue(DynamicObject taxFile, DynamicObject localValue, Map<String, Object> extraValue, Map<String, Object> outerInfo) {
        String habitresinfo;
        Object habitrescounty;
        Object habitrescity;
        Object habitres;
        String regpermresinfo;
        Object regpermrescounty;
        Object regpermrescity;
        Object regpermres;
        String email;
        String phone;
        Object phone2;
        Map taxContact = MapUtils.getMap(outerInfo, (Object)"taxcontact");
        if (localValue == null || extraValue == null || taxContact == null && !StringUtils.equals((CharSequence)taxFile.getString("taxstatus"), (CharSequence)"1")) {
            return BaseResult.success((Object)taxFile);
        }
        if (StringUtils.isEmpty((CharSequence)localValue.getString("phone")) && !StringUtils.isEmpty((CharSequence)MapUtils.getString(extraValue, (Object)"phone")) && (phone2 = extraValue.get("phone")) != null) {
            String phoneStr = ((String)phone2).trim();
            if (phoneStr.startsWith("+86-")) {
                phoneStr = phoneStr.substring(4);
            }
            if (SITFormatUtils.checkPhone((String)phoneStr)) {
                localValue.set("phone", (Object)phoneStr);
            }
        }
        if (StringUtils.isEmpty((CharSequence)localValue.getString("email")) && !StringUtils.isEmpty((CharSequence)MapUtils.getString(extraValue, (Object)"peremail"))) {
            localValue.set("email", extraValue.get("peremail"));
        }
        if (taxContact == null) {
            return BaseResult.success((Object)taxFile);
        }
        String status = taxFile.getString("status");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)status) && org.apache.commons.lang3.StringUtils.equals((CharSequence)status, (CharSequence)"C")) {
            localValue.set("status", (Object)status);
        } else {
            localValue.set("status", (Object)"A");
        }
        String taxpayernum = MapUtils.getString((Map)taxContact, (Object)"taxpayernum");
        if (StringUtils.isNotEmpty((CharSequence)taxpayernum)) {
            localValue.set("taxpayernum", (Object)taxpayernum);
        }
        if (StringUtils.isNotEmpty((CharSequence)(phone = MapUtils.getString((Map)taxContact, (Object)"phone")))) {
            localValue.set("phone", (Object)phone);
        }
        if (StringUtils.isNotEmpty((CharSequence)(email = MapUtils.getString((Map)taxContact, (Object)"email")))) {
            localValue.set("email", (Object)email);
        }
        if (!Objects.isNull(regpermres = MapUtils.getObject((Map)taxContact, (Object)"regpermres"))) {
            localValue.set("regpermres", SitCommonServiceHelper.setDynamicObj(localValue, taxContact, "regpermres", "bd_admindivision"));
        }
        if (!Objects.isNull(regpermrescity = MapUtils.getObject((Map)taxContact, (Object)"regpermrescity"))) {
            localValue.set("regpermrescity", SitCommonServiceHelper.setDynamicObj(localValue, taxContact, "regpermrescity", "bd_admindivision"));
        }
        if (!Objects.isNull(regpermrescounty = MapUtils.getObject((Map)taxContact, (Object)"regpermrescounty"))) {
            localValue.set("regpermrescounty", SitCommonServiceHelper.setDynamicObj(localValue, taxContact, "regpermrescounty", "bd_admindivision"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(regpermresinfo = MapUtils.getString((Map)taxContact, (Object)"regpermresinfo")))) {
            localValue.set("regpermresinfo", (Object)regpermresinfo);
        }
        if (!Objects.isNull(habitres = MapUtils.getObject((Map)taxContact, (Object)"habitres"))) {
            localValue.set("habitres", SitCommonServiceHelper.setDynamicObj(localValue, taxContact, "habitres", "bd_admindivision"));
        }
        if (!Objects.isNull(habitrescity = MapUtils.getObject((Map)taxContact, (Object)"habitrescity"))) {
            localValue.set("habitrescity", SitCommonServiceHelper.setDynamicObj(localValue, taxContact, "habitrescity", "bd_admindivision"));
        }
        if (!Objects.isNull(habitrescounty = MapUtils.getObject((Map)taxContact, (Object)"habitrescounty"))) {
            localValue.set("habitrescounty", SitCommonServiceHelper.setDynamicObj(localValue, taxContact, "habitrescounty", "bd_admindivision"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(habitresinfo = MapUtils.getString((Map)taxContact, (Object)"habitresinfo")))) {
            localValue.set("habitresinfo", (Object)habitresinfo);
        }
        return BaseResult.success((Object)taxFile);
    }
}

