/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.gather;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.impl.gather.IitPersonGather;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BaseResult;
import org.apache.commons.collections4.CollectionUtils;

public class PersonInfoVersionGather
extends IitPersonGather {
    @Override
    public String extraInfoEntity() {
        return "itc_taxfile";
    }

    @Override
    public Set<String> extraInfoProps() {
        return Sets.newHashSet((Object[])new String[]{"pereduexp", "percre", "pertsprop", "pernontsprop", "personversion"});
    }

    @Override
    public int priority() {
        return 20;
    }

    @Override
    protected Map<Long, DynamicObject> findOrCreateLocalInfo(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext, Map<String, Object> outerInfos) {
        HashMap fileMap = Maps.newHashMapWithExpectedSize((int)taxFiles.size());
        taxFileOpContext.addExtraInfo(this.extraInfoEntity(), (Map)fileMap);
        if (CollectionUtils.isEmpty(taxFiles)) {
            return fileMap;
        }
        for (DynamicObject taxFile : taxFiles) {
            fileMap.put((Long)this.extraKeyFromTaxFile(taxFile, null), taxFile);
        }
        return fileMap;
    }

    @Override
    protected BaseResult<DynamicObject> setValue(DynamicObject taxFile, DynamicObject localValue, DynamicObject extraValue, Map<String, Object> outerInfo) {
        DynamicObject perTsPropExt;
        if (localValue == null || extraValue == null || !StringUtils.equals((CharSequence)taxFile.getString("taxstatus"), (CharSequence)"1")) {
            return BaseResult.success((Object)taxFile);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_pereduexp");
        DynamicObject perEduExp = serviceHelper.generateEmptyDynamicObject();
        if (null != extraValue.get("pereduexp")) {
            perEduExp.set("id", (Object)extraValue.getLong("pereduexp.sourcevid"));
            perEduExp.set("education", (Object)extraValue.getDynamicObject("pereduexp.education"));
            localValue.set("pereduexp", (Object)perEduExp);
        }
        if (null != extraValue.get("percre")) {
            DynamicObject perCre = serviceHelper.generateEmptyDynamicObject("hrpi_percre");
            perCre.set("id", (Object)extraValue.getLong("percre.sourcevid"));
            perCre.set("number", (Object)extraValue.getString("percre.number"));
            perCre.set("credentialstype", (Object)extraValue.getDynamicObject("percre.credentialstype"));
            localValue.set("percre", (Object)perCre);
        }
        if (null != (perTsPropExt = extraValue.getDynamicObject("pertsprop"))) {
            DynamicObject pertsProp = serviceHelper.generateEmptyDynamicObject("hrpi_pertsprop");
            long id = perTsPropExt.getLong("id");
            long boId = perTsPropExt.getLong("boid");
            long sourceVid = perTsPropExt.getLong("sourcevid");
            if (id == boId && sourceVid != 0L) {
                pertsProp.set("id", (Object)sourceVid);
            } else {
                pertsProp.set("id", (Object)id);
            }
            localValue.set("pertsprop", (Object)pertsProp);
        }
        if (null != extraValue.get("pernontsprop")) {
            DynamicObject perNontsProp = serviceHelper.generateEmptyDynamicObject("hrpi_pernontsprop");
            perNontsProp.set("id", (Object)extraValue.getLong("pernontsprop.sourcevid"));
            perNontsProp.set("gender", (Object)extraValue.getDynamicObject("pernontsprop.gender"));
            perNontsProp.set("birthday", (Object)extraValue.getDate("pernontsprop.birthday"));
            perNontsProp.set("nationality", (Object)extraValue.getDynamicObject("pernontsprop.nationality"));
            localValue.set("pernontsprop", (Object)perNontsProp);
        }
        if (null != extraValue.get("person")) {
            DynamicObject person = serviceHelper.generateEmptyDynamicObject("hrpi_person");
            person.set("id", (Object)extraValue.getLong("person.sourcevid"));
            person.set("name", (Object)extraValue.getString("person.name"));
            person.set("number", (Object)extraValue.getString("person.number"));
            localValue.set("personversion", (Object)person);
        }
        return BaseResult.success((Object)taxFile);
    }
}

