/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.info;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.service.TaxFileInfoServiceImpl;
import kd.sit.sitbp.common.enums.DataStatusEnum;
import kd.sit.sitbp.common.model.DateRange;
import kd.sit.sitbp.common.util.SitDateUtil;

public class TaxFileServiceImpl
extends TaxFileInfoServiceImpl {
    public TaxFileServiceImpl() {
        super((Set)Sets.newHashSet((Object[])new String[]{"id", "boid", "number", "person", "taxunit", "enable", "status", "datastatus", "bsed", "taxcrdltype"}), Maps.asMap((Set)Sets.newHashSet((Object[])new String[]{"id", "boid", "number", "person", "taxunit", "org", "taxregion", "empgroup", "employment", "isescrowstaff", "declarestatus", "taxstatus", "enable", "status", "datastatus", "iscurrentversion", "bsed", "bsled", "sourcevid", "pernontsprop", "pereduexp", "percre", "personversion", "pertsprop", "empposorgrel", "personversion.name", "personversion.number", "percre.number", "percre.credentialstype", "pernontsprop.gender", "pernontsprop.birthday", "pernontsprop.nationality", "pereduexp.education", "declaremonth", "taxcrdltype"}), e1 -> e1));
    }

    public String generaName() {
        return "taxfile";
    }

    public String entityNumber() {
        return "itc_taxfile";
    }

    public Map<String, Set<String>> relatedEntityNumber() {
        return Maps.newHashMapWithExpectedSize((int)0);
    }

    public String supportAppId() {
        return "itc";
    }

    protected Map<Long, Long> findLatestVersionByFileBoIdsAndDate(List<Long> taxFileBoids, DateRange dateRange) {
        return Maps.newHashMapWithExpectedSize((int)0);
    }

    public Map<Long, DynamicObject> getRelatedInfo(Set<Long> taxFileBoIds, Map<Long, Date> taxFileBoIdAndBsed, Set<String> props) {
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{DataStatusEnum.EFFECTING.getCode(), DataStatusEnum.EXPIRED.getCode(), DataStatusEnum.TO_EFFECT.getCode(), DataStatusEnum.DRAFT.getCode()});
        QFilter boIdFilter = new QFilter("boid", "in", taxFileBoIds);
        QFilter[] qFilters = new QFilter[]{statusFilter, dataStatusFilter, boIdFilter};
        if (CollectionUtils.isEmpty(props)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.entityNumber());
        DynamicObject[] dys = serviceHelper.query(String.join((CharSequence)",", props), qFilters);
        if (null == dys || dys.length == 0) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        ArrayList infos = Lists.newArrayListWithExpectedSize((int)dys.length);
        for (DynamicObject dy : dys) {
            if (dy.getLong("id") == dy.getLong("boid") && !"A".equals(dy.getString("status"))) continue;
            infos.add(dy);
        }
        if (CollectionUtils.isEmpty((Collection)infos)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        Map<Long, List<DynamicObject>> map = infos.stream().collect(Collectors.groupingBy(e1 -> e1.getLong("boid")));
        HashMap result = Maps.newHashMapWithExpectedSize((int)taxFileBoIds.size());
        map.forEach((taxFileBoId, list) -> {
            for (DynamicObject dy : list) {
                Date bsled;
                Date bsed;
                Date date = (Date)taxFileBoIdAndBsed.get(taxFileBoId);
                if (!SitDateUtil.isCover((Date)date, (Date)(bsed = dy.getDate("bsed")), (Date)(bsled = dy.getDate("bsled"))) && !date.equals(bsed) && !date.equals(bsled)) continue;
                result.put(taxFileBoId, dy);
            }
        });
        return result;
    }
}

