/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.splitter;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.sit.itc.business.taxfile.api.BillSplitter;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.ResultItem;

public abstract class AbstractBillSplitter
implements BillSplitter {
    protected Set<String> breakFields = Sets.newHashSet((Object[])new String[]{"id", "seq", "multilanguagetext"});
    protected String fixStr = "_id";
    private static final List<BillSplitter> SPLITTER_LIST = new ArrayList<BillSplitter>(16);

    public static BatchResult<DynamicObject> doSplitBills(List<DynamicObject> taxFiles, TaxFileOpContext taxFileOpContext) {
        Map entityMap = taxFileOpContext.getExtraInfo();
        if (CollectionUtils.isEmpty(taxFiles) || CollectionUtils.isEmpty((Map)entityMap)) {
            return new BatchResult(true, null);
        }
        HashMap errorMsgs = Maps.newHashMapWithExpectedSize((int)taxFiles.size());
        Map<String, Map<String, Set<String>>> fileNullFieldMap = AbstractBillSplitter.getNullFieldMap();
        for (BillSplitter splitter : SPLITTER_LIST) {
            BatchResult<DynamicObject> result = splitter.splitBills(taxFiles, taxFileOpContext, fileNullFieldMap);
            if (!result.isSuccess()) {
                return result;
            }
            List failResultOriginal = result.getFailResultOriginal();
            if (CollectionUtils.isEmpty((Collection)failResultOriginal)) continue;
            for (ResultItem resultItem : failResultOriginal) {
                DynamicObject data = (DynamicObject)resultItem.getData();
                String msg = (String)errorMsgs.get(data);
                msg = StringUtils.isEmpty((CharSequence)msg) ? resultItem.getMessage() : msg + resultItem.getMessage();
                errorMsgs.put(data, msg);
            }
        }
        BatchResult batchResult = new BatchResult(true, taxFiles);
        for (Map.Entry entry : errorMsgs.entrySet()) {
            batchResult.successItemToFail(entry.getKey(), (String)entry.getValue());
        }
        return batchResult;
    }

    @Override
    public BatchResult<DynamicObject> splitBills(List<DynamicObject> bills, TaxFileOpContext taxFileOpContext, Map<String, Map<String, Set<String>>> fileNullFieldMap) {
        BatchResult batchResult = new BatchResult(true, new ArrayList(bills.size()));
        ArrayList<DynamicObject> exsitEntityBills = new ArrayList<DynamicObject>(bills.size());
        Map<Long, DynamicObject> extractFromBillMap = this.extractFromBill(bills, exsitEntityBills);
        this.validateBillValue(exsitEntityBills, extractFromBillMap, batchResult);
        if (CollectionUtils.isEmpty(extractFromBillMap)) {
            return batchResult;
        }
        Map<Long, DynamicObject> localInfoMap = this.findOrCreateLocalObj(bills, extractFromBillMap, taxFileOpContext);
        Map<String, String> importFields = this.getImportFields();
        for (DynamicObject bill : bills) {
            Map<String, Set<String>> nullFieldMap;
            Long key = this.linkKeyFromBill(bill);
            DynamicObject extraInfo = extractFromBillMap.get(key);
            DynamicObject localInfo = localInfoMap.get(key);
            if (extraInfo == null || localInfo == null) continue;
            Set<String> nullFieldSet = null;
            if (!CollectionUtils.isEmpty(fileNullFieldMap) && !CollectionUtils.isEmpty(nullFieldMap = fileNullFieldMap.get(bill.getString("number")))) {
                nullFieldSet = nullFieldMap.get(this.getEntityCode());
            }
            try {
                this.setValue(extraInfo, localInfo, importFields, nullFieldSet, taxFileOpContext);
            }
            catch (Exception e) {
                batchResult.addFailItem((Object)bill, "error on BillSplitter setValue : " + e.getMessage());
            }
            batchResult.addSuccessResult((Object)bill);
        }
        return batchResult;
    }

    protected List<DynamicObject> validateBillValue(List<DynamicObject> exsitEntityBills, Map<Long, DynamicObject> extractFromBillMap, BatchResult batchResult) {
        return exsitEntityBills;
    }

    protected abstract String getEntityCode();

    protected String getFieldCodes() {
        PropertiesQueryInfo info = new PropertiesQueryInfo(this.getEntityCode());
        String properties = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, null);
        HashSet errorFileds = Sets.newHashSet((Object[])new String[]{"multilanguagetext,"});
        for (String errorFiled : errorFileds) {
            properties = properties.replace(errorFiled, "");
        }
        return properties;
    }

    protected Long linkKeyFromBill(DynamicObject bill) {
        return bill.getLong("id");
    }

    protected abstract Map<Long, DynamicObject> extractFromBill(List<DynamicObject> var1, List<DynamicObject> var2);

    protected abstract Map<Long, DynamicObject> findOrCreateLocalObj(List<DynamicObject> var1, Map<Long, DynamicObject> var2, TaxFileOpContext var3);

    protected void setValue(DynamicObject extraValue, DynamicObject localValue, Map<String, String> importFields, Set<String> nullFieldSet, TaxFileOpContext taxFileOpContext) {
        if (CollectionUtils.isEmpty(nullFieldSet)) {
            nullFieldSet = new HashSet<String>(0);
        }
        for (Map.Entry<String, String> fieldEntry : importFields.entrySet()) {
            String billFieldCode = fieldEntry.getKey();
            if (!nullFieldSet.contains(billFieldCode) && StringUtils.isEmpty((CharSequence)extraValue.getString(billFieldCode))) continue;
            localValue.set(fieldEntry.getValue(), extraValue.get(billFieldCode));
        }
    }

    protected Map<String, String> getImportFields() {
        HashMap<String, String> importFields = new HashMap<String, String>(16);
        String entityCode = this.getEntityCode();
        String fixPre = entityCode + '-';
        MainEntityType taxFileBillType = EntityMetadataCache.getDataEntityType((String)"itc_taxfilebill");
        DataEntityPropertyCollection taxFileBillProps = taxFileBillType.getProperties();
        EntryProp entryType = (EntryProp)taxFileBillProps.get((Object)entityCode);
        DataEntityPropertyCollection entryProps = entryType.getDynamicCollectionItemPropertyType().getProperties();
        for (IDataEntityProperty prop : entryProps) {
            String propName = prop.getName();
            if (this.breakFields.contains(propName) || propName.endsWith(this.fixStr) || propName.startsWith("entryboid")) continue;
            importFields.put(propName, propName.replace(fixPre, ""));
        }
        return importFields;
    }

    private static Map<String, Map<String, Set<String>>> getNullFieldMap() {
        IHRAppCache cache = HRAppCache.get((String)"itc");
        Long userId = RequestContext.get().getCurrUserId();
        String str = (String)cache.get(String.format(Locale.ROOT, "ItcTaxFileImport_%s_NullFieldMap", userId), String.class);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        return (Map)SerializationUtils.deSerializeFromBase64((String)str);
    }

    static {
        ServiceLoader<BillSplitter> serviceLoader = ServiceLoader.load(BillSplitter.class);
        for (BillSplitter next : serviceLoader) {
            SPLITTER_LIST.add(next);
        }
        SPLITTER_LIST.sort(Comparator.comparingInt(BillSplitter::priority));
    }
}

