/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.splitter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.impl.splitter.TaxFileBillAbstractSplitter;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BatchResult;

public class BankCardSplitter
extends TaxFileBillAbstractSplitter {
    @Override
    protected String getEntityCode() {
        return "itc_bankcard";
    }

    @Override
    protected List<DynamicObject> validateBillValue(List<DynamicObject> exsitEntityBills, Map<Long, DynamicObject> extractFromBillMap, BatchResult batchResult) {
        if (CollectionUtils.isEmpty(exsitEntityBills)) {
            return exsitEntityBills;
        }
        Set personIds = exsitEntityBills.stream().map(obj -> obj.getLong("person.id")).collect(Collectors.toSet());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_perbankcard");
        String fields = "person,person.id,person.number,id,bankcardnum,status,enable,boid,bankdeposit.province.id,sourcevid";
        QFilter filter = new QFilter("person", "in", personIds);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and("isdelete", "!=", (Object)"1");
        DynamicObject[] query = serviceHelper.query(fields, new QFilter[]{filter});
        HashMap personBankCardMap = Maps.newHashMapWithExpectedSize((int)personIds.size());
        if (query != null && query.length != 0) {
            for (DynamicObject bankCard : query) {
                long personId = bankCard.getLong("person.id");
                List cards = personBankCardMap.computeIfAbsent(personId, k1 -> Lists.newArrayListWithCapacity((int)6));
                cards.add(bankCard);
            }
        }
        ArrayList successBills = Lists.newArrayListWithCapacity((int)exsitEntityBills.size());
        for (DynamicObject bill : exsitEntityBills) {
            Long key = this.linkKeyFromBill(bill);
            DynamicObject subEntityDyn = extractFromBillMap.get(key);
            String bankCardNum = subEntityDyn.getString("bankcardnum");
            long personId = bill.getLong("person.id");
            List bankCards = (List)personBankCardMap.get(personId);
            if (CollectionUtils.isEmpty((Collection)bankCards)) {
                batchResult.addFailItem((Object)bill, MessageFormat.format(ResManager.loadKDString((String)"\u4e2a\u7a0e\u4eba\u5458\u201c{0}\u201d\u94f6\u884c\u8d26\u53f7\u4e3a\u201c{1}\u201d\u7684\u94f6\u884c\u5361\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"BankCardSplitter_0", (String)"sit-itc-business", (Object[])new Object[0]), bill.getString("person.number"), bankCardNum));
                continue;
            }
            ArrayList importBankCards = Lists.newArrayListWithCapacity((int)bankCards.size());
            for (DynamicObject bankCard : bankCards) {
                if (!StringUtils.equals((CharSequence)bankCardNum, (CharSequence)bankCard.getString("bankcardnum"))) continue;
                importBankCards.add(bankCard);
            }
            if (CollectionUtils.isEmpty((Collection)importBankCards)) {
                batchResult.addFailItem((Object)bill, MessageFormat.format(ResManager.loadKDString((String)"\u4e2a\u7a0e\u4eba\u5458\u201c{0}\u201d\u94f6\u884c\u8d26\u53f7\u4e3a\u201c{1}\u201d\u7684\u94f6\u884c\u5361\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"BankCardSplitter_0", (String)"sit-itc-business", (Object[])new Object[0]), bill.getString("person.number"), bankCardNum));
                continue;
            }
            if (importBankCards.size() > 1) {
                batchResult.addFailItem((Object)bill, MessageFormat.format(ResManager.loadKDString((String)"\u4e2a\u7a0e\u4eba\u5458\u201c{0}\u201d\u5b58\u5728\u591a\u5f20\u94f6\u884c\u8d26\u53f7\u4e3a\u201c{1}\u201d\u7684\u94f6\u884c\u5361\u3002", (String)"BankCardSplitter_1", (String)"sit-itc-business", (Object[])new Object[0]), bill.getString("person.number"), bankCardNum));
                continue;
            }
            DynamicObject bankCard = (DynamicObject)importBankCards.get(0);
            subEntityDyn.set("perbankcard", (Object)bankCard);
            successBills.add(bill);
        }
        return successBills;
    }

    @Override
    protected Map<String, String> getImportFields() {
        Map<String, String> importFields = super.getImportFields();
        importFields.remove("bankcardnum");
        return importFields;
    }

    @Override
    protected void setValue(DynamicObject extraValue, DynamicObject localValue, Map<String, String> importFields, Set<String> nullFieldSet, TaxFileOpContext taxFileOpContext) {
        super.setValue(extraValue, localValue, importFields, nullFieldSet, taxFileOpContext);
        localValue.set("perbankcardvid", (Object)localValue.getLong("perbankcard.sourcevid"));
        localValue.set("province", (Object)localValue.getLong("perbankcard.bankdeposit.province.id"));
    }
}

