/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.splitter;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.taxfile.impl.splitter.TaxFileBillAbstractSplitter;
import kd.sit.sitbp.common.enums.CredentialsTypeEnum;
import kd.sit.sitbp.common.model.TaxFileOpContext;

public class TaxContactSplitter
extends TaxFileBillAbstractSplitter {
    private final Set<String> dynamicForbidUpdateFields = Sets.newHashSet((Object[])new String[]{"idnumber", "idtype", "taxpayernum"});

    @Override
    protected String getEntityCode() {
        return "itc_taxcontact";
    }

    @Override
    protected void setValue(DynamicObject extraValue, DynamicObject localValue, Map<String, String> importFields, Set<String> nullFieldSet, TaxFileOpContext taxFileOpContext) {
        boolean isUpdate = true;
        if (!localValue.getDataEntityState().getFromDatabase()) {
            isUpdate = false;
        }
        if (CollectionUtils.isEmpty(nullFieldSet)) {
            nullFieldSet = new HashSet<String>(0);
        }
        for (Map.Entry<String, String> fieldEntry : importFields.entrySet()) {
            String billFieldCode;
            String fieldCode = fieldEntry.getValue();
            if (isUpdate && this.isIdentityCard(taxFileOpContext, localValue) && this.dynamicForbidUpdateFields.contains(fieldCode) || !nullFieldSet.contains(billFieldCode = fieldEntry.getKey()) && StringUtils.isEmpty((CharSequence)extraValue.getString(billFieldCode))) continue;
            localValue.set(fieldCode, extraValue.get(billFieldCode));
        }
    }

    private boolean isIdentityCard(TaxFileOpContext taxFileOpContext, DynamicObject localValue) {
        DynamicObject person;
        boolean isIdentityCard = false;
        Map personDyns = taxFileOpContext.getInfo("iit_person");
        if (!CollectionUtils.isEmpty((Map)personDyns) && (person = (DynamicObject)personDyns.get(localValue.getLong("taxfile.id"))) != null) {
            isIdentityCard = person.getLong("credentialstype.id") == CredentialsTypeEnum.IDENTITY_1010.getId();
        }
        return isIdentityCard;
    }
}

